/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep;

import com.tangosol.internal.sleepycat.je.config.ConfigParam;
import com.tangosol.internal.sleepycat.je.dbi.DbConfigManager;
import com.tangosol.internal.sleepycat.je.rep.ReplicationBasicConfig;
import com.tangosol.internal.sleepycat.je.rep.ReplicationSSLConfig;
import com.tangosol.internal.sleepycat.je.rep.impl.RepParams;
import com.tangosol.internal.sleepycat.je.rep.utilint.RepUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class ReplicationNetworkConfig
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CHANNEL_TYPE = "je.rep.channelType";
    public static final String CHANNEL_FACTORY_CLASS = "je.rep.channelFactoryClass";
    public static final String CHANNEL_FACTORY_PARAMS = "je.rep.channelFactoryParams";
    public static final String CHANNEL_LOG_NAME = "je.rep.channelLogName";
    private static Set<String> repNetLocalProperties = new HashSet<String>();
    private static Set<String> repNetAllProperties;
    protected final Properties props = new Properties();
    protected final boolean validateParams = true;

    public static ReplicationNetworkConfig create(File propFile) throws IllegalArgumentException, FileNotFoundException {
        return ReplicationNetworkConfig.create(ReplicationNetworkConfig.readProperties(propFile));
    }

    public static ReplicationNetworkConfig create(Properties properties) throws IllegalArgumentException {
        String channelType = DbConfigManager.getVal(properties, RepParams.CHANNEL_TYPE);
        if ("basic".equals(channelType)) {
            return new ReplicationBasicConfig(properties);
        }
        if ("ssl".equals(channelType)) {
            return new ReplicationSSLConfig(properties);
        }
        throw new IllegalArgumentException("Unknown channel type: " + channelType);
    }

    public static ReplicationNetworkConfig createDefault() {
        return new ReplicationBasicConfig();
    }

    public ReplicationNetworkConfig() {
    }

    public ReplicationNetworkConfig(Properties properties) {
        this.applyRepNetProperties(properties);
    }

    public abstract String getChannelType();

    public String getLogName() {
        return DbConfigManager.getVal(this.props, RepParams.CHANNEL_LOG_NAME);
    }

    public ReplicationNetworkConfig setLogName(String logName) throws IllegalArgumentException {
        this.setLogNameVoid(logName);
        return this;
    }

    public void setLogNameVoid(String logName) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, RepParams.CHANNEL_LOG_NAME, logName, true);
    }

    public String getChannelFactoryClass() {
        return DbConfigManager.getVal(this.props, RepParams.CHANNEL_FACTORY_CLASS);
    }

    public ReplicationNetworkConfig setChannelFactoryClass(String factoryClass) {
        this.setChannelFactoryClassVoid(factoryClass);
        return this;
    }

    public void setChannelFactoryClassVoid(String factoryClass) {
        DbConfigManager.setVal(this.props, RepParams.CHANNEL_FACTORY_CLASS, factoryClass, true);
    }

    public String getChannelFactoryParams() {
        return DbConfigManager.getVal(this.props, RepParams.CHANNEL_FACTORY_PARAMS);
    }

    public ReplicationNetworkConfig setChannelFactoryParams(String factoryParams) {
        this.setChannelFactoryParamsVoid(factoryParams);
        return this;
    }

    public void setChannelFactoryParamsVoid(String factoryParams) {
        DbConfigManager.setVal(this.props, RepParams.CHANNEL_FACTORY_PARAMS, factoryParams, true);
    }

    public ReplicationNetworkConfig setConfigParam(String paramName, String value) throws IllegalArgumentException {
        if (this.isValidConfigParam(paramName)) {
            ReplicationNetworkConfig.setConfigParam(this.props, paramName, value, true);
        }
        return this;
    }

    public ReplicationNetworkConfig clone() {
        try {
            ReplicationNetworkConfig copy = (ReplicationNetworkConfig)super.clone();
            return copy;
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    static Set<String> getRepNetLocalPropertySet() {
        return repNetLocalProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getRepNetPropertySet() {
        Set<String> set = repNetLocalProperties;
        synchronized (set) {
            if (repNetAllProperties == null) {
                HashSet<String> props = new HashSet<String>();
                props.addAll(repNetLocalProperties);
                props.addAll(ReplicationBasicConfig.getRepBasicPropertySet());
                props.addAll(ReplicationSSLConfig.getRepSSLPropertySet());
                repNetAllProperties = Collections.unmodifiableSet(props);
            }
            return repNetAllProperties;
        }
    }

    public static void registerParams() {
        ReplicationNetworkConfig.getRepNetPropertySet();
    }

    void applyRepNetProperties(Properties sourceProps) throws IllegalArgumentException {
        for (Map.Entry<Object, Object> propPair : sourceProps.entrySet()) {
            String name = (String)propPair.getKey();
            if (!this.isValidConfigParam(name)) continue;
            String value = (String)propPair.getValue();
            ReplicationNetworkConfig.setConfigParam(this.props, name, value, true);
        }
    }

    public static void applyRepNetProperties(Properties sourceProps, Properties updateProps) throws IllegalArgumentException {
        Set<String> repNetProps = ReplicationNetworkConfig.getRepNetPropertySet();
        for (Map.Entry<Object, Object> propPair : sourceProps.entrySet()) {
            String name = (String)propPair.getKey();
            if (!repNetProps.contains(name)) continue;
            String value = (String)propPair.getValue();
            ReplicationNetworkConfig.setConfigParam(updateProps, name, value, true);
        }
    }

    Properties getProps() {
        Properties returnProps = new Properties(this.props);
        returnProps.setProperty(CHANNEL_TYPE, this.getChannelType());
        return returnProps;
    }

    private static void setConfigParam(Properties props, String paramName, String value, boolean validateParams) throws IllegalArgumentException {
        DbConfigManager.setConfigParam(props, paramName, value, false, validateParams, true, false);
    }

    protected boolean isValidConfigParam(String paramName) {
        return repNetLocalProperties.contains(paramName);
    }

    private static Properties readProperties(File propFile) throws FileNotFoundException {
        if (!propFile.exists()) {
            throw new FileNotFoundException("The properties file " + propFile + " does not exist.");
        }
        Properties props = new Properties();
        RepUtils.populateNetProps(props, propFile);
        return props;
    }

    static {
        repNetLocalProperties.add(CHANNEL_TYPE);
        repNetLocalProperties.add(CHANNEL_LOG_NAME);
        repNetLocalProperties.add(CHANNEL_FACTORY_CLASS);
        repNetLocalProperties.add(CHANNEL_FACTORY_PARAMS);
        repNetLocalProperties = Collections.unmodifiableSet(repNetLocalProperties);
        ConfigParam configParam = RepParams.CHANNEL_TYPE;
    }
}

