/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.elections;

import com.tangosol.internal.sleepycat.je.rep.elections.Protocol;
import com.tangosol.internal.sleepycat.je.rep.impl.node.RepNode;
import com.tangosol.internal.sleepycat.je.rep.net.DataChannel;
import com.tangosol.internal.sleepycat.je.rep.utilint.RepUtils;
import com.tangosol.internal.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.tangosol.internal.sleepycat.je.utilint.LoggerUtils;
import com.tangosol.internal.sleepycat.je.utilint.StoppableThread;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Formatter;
import java.util.logging.Logger;

public class ElectionAgentThread
extends StoppableThread {
    protected final Protocol protocol;
    protected final Logger logger;
    protected final Formatter formatter;
    protected final BlockingQueue<DataChannel> channelQueue = new LinkedBlockingQueue<DataChannel>();

    protected ElectionAgentThread(RepNode repNode, Protocol protocol, String threadName) {
        super(repNode == null ? null : repNode.getRepImpl(), threadName);
        this.protocol = protocol;
        this.logger = this.envImpl != null ? LoggerUtils.getLogger(this.getClass()) : LoggerUtils.getLoggerFormatterNeeded(this.getClass());
        this.formatter = new ReplicationFormatter(protocol.getNameIdPair());
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    public void shutdown() throws InterruptedException {
        if (this.shutdownDone()) {
            return;
        }
        this.shutdownThread(this.logger);
    }

    @Override
    protected int initiateSoftShutdown() {
        this.channelQueue.clear();
        this.channelQueue.add(RepUtils.CHANNEL_EOF_MARKER);
        return 0;
    }
}

