/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.tree;

import com.tangosol.internal.sleepycat.je.DatabaseEntry;
import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.OperationFailureException;
import com.tangosol.internal.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseImpl;
import com.tangosol.internal.sleepycat.je.dbi.DbTree;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentFailureReason;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.dbi.INList;
import com.tangosol.internal.sleepycat.je.dbi.MemoryBudget;
import com.tangosol.internal.sleepycat.je.log.BasicVersionedWriteLoggable;
import com.tangosol.internal.sleepycat.je.log.FileManager;
import com.tangosol.internal.sleepycat.je.log.LogContext;
import com.tangosol.internal.sleepycat.je.log.LogEntryType;
import com.tangosol.internal.sleepycat.je.log.LogItem;
import com.tangosol.internal.sleepycat.je.log.LogUtils;
import com.tangosol.internal.sleepycat.je.log.Loggable;
import com.tangosol.internal.sleepycat.je.log.Provisional;
import com.tangosol.internal.sleepycat.je.log.ReplicationContext;
import com.tangosol.internal.sleepycat.je.log.VersionedWriteLoggable;
import com.tangosol.internal.sleepycat.je.log.entry.LNLogEntry;
import com.tangosol.internal.sleepycat.je.tree.BIN;
import com.tangosol.internal.sleepycat.je.tree.IN;
import com.tangosol.internal.sleepycat.je.tree.Key;
import com.tangosol.internal.sleepycat.je.tree.Node;
import com.tangosol.internal.sleepycat.je.tree.TreeUtils;
import com.tangosol.internal.sleepycat.je.tree.VersionedLN;
import com.tangosol.internal.sleepycat.je.txn.LockGrantType;
import com.tangosol.internal.sleepycat.je.txn.LockResult;
import com.tangosol.internal.sleepycat.je.txn.LockType;
import com.tangosol.internal.sleepycat.je.txn.Locker;
import com.tangosol.internal.sleepycat.je.txn.Txn;
import com.tangosol.internal.sleepycat.je.txn.WriteLockInfo;
import com.tangosol.internal.sleepycat.je.utilint.DbLsn;
import com.tangosol.internal.sleepycat.je.utilint.SizeofMarker;
import com.tangosol.internal.sleepycat.je.utilint.VLSN;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class LN
extends Node
implements VersionedWriteLoggable {
    private static final String BEGIN_TAG = "<ln>";
    private static final String END_TAG = "</ln>";
    private static final int LAST_FORMAT_CHANGE = 8;
    private byte[] data;
    private static final int DIRTY_BIT = Integer.MIN_VALUE;
    private static final int CLEAR_DIRTY_BIT = Integer.MAX_VALUE;
    private int flags;

    public LN() {
        this.data = null;
    }

    public static LN makeLN(EnvironmentImpl envImpl, byte[] dataParam) {
        if (envImpl.getPreserveVLSN()) {
            return new VersionedLN(dataParam);
        }
        return new LN(dataParam);
    }

    LN(byte[] data) {
        if (data == null) {
            this.data = null;
        } else {
            this.init(data, 0, data.length);
        }
        this.setDirty();
    }

    public static LN makeLN(EnvironmentImpl envImpl, DatabaseEntry dbt) {
        if (envImpl.getPreserveVLSN()) {
            return new VersionedLN(dbt);
        }
        return new LN(dbt);
    }

    LN(DatabaseEntry dbt) {
        byte[] dat = dbt.getData();
        if (dat == null) {
            this.data = null;
        } else if (dbt.getPartial()) {
            this.init(dat, dbt.getOffset(), dbt.getPartialOffset() + dbt.getSize(), dbt.getPartialOffset(), dbt.getSize());
        } else {
            this.init(dat, dbt.getOffset(), dbt.getSize());
        }
        this.setDirty();
    }

    public LN(SizeofMarker marker, DatabaseEntry dbt) {
        this(dbt);
    }

    private void init(byte[] data, int off, int len, int doff, int dlen) {
        if (len == 0) {
            this.data = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
        } else {
            this.data = new byte[len];
            System.arraycopy(data, off, this.data, doff, dlen);
        }
    }

    private void init(byte[] data, int off, int len) {
        this.init(data, off, len, 0, len);
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isDeleted() {
        return this.data == null;
    }

    @Override
    public boolean isLN() {
        return true;
    }

    void makeDeleted() {
        this.data = null;
    }

    public boolean isDirty() {
        return (this.flags & Integer.MIN_VALUE) != 0;
    }

    public void setDirty() {
        this.flags |= Integer.MIN_VALUE;
    }

    private void clearDirty() {
        this.flags &= Integer.MAX_VALUE;
    }

    public long getVLSNSequence() {
        return VLSN.NULL_VLSN.getSequence();
    }

    public void setVLSNSequence(long seq) {
    }

    @Override
    boolean isValidForDelete() {
        return false;
    }

    boolean isEvictableInexact() {
        return true;
    }

    boolean isEvictable(long lsn) throws DatabaseException {
        return true;
    }

    public void delete() {
        this.makeDeleted();
        this.setDirty();
    }

    public void modify(byte[] newData) {
        this.data = newData;
        this.setDirty();
    }

    public byte[] setEmpty() {
        byte[] retVal = this.data;
        this.data = Key.EMPTY_KEY;
        return retVal;
    }

    @Override
    void rebuildINList(INList inList) {
    }

    @Override
    void accountForSubtreeRemoval(INList inList, LocalUtilizationTracker localTracker) {
    }

    @Override
    void accountForDeferredWriteSubtreeRemoval(INList inList, IN subtreeParent) {
    }

    @Override
    public long getMemorySizeIncludedByParent() {
        int size = MemoryBudget.LN_OVERHEAD;
        if (this.data != null) {
            size += MemoryBudget.byteArraySize(this.data.length);
        }
        return size;
    }

    public void releaseMemoryBudget() {
    }

    public long getTreeAdminMemory() {
        return 0L;
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    @Override
    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuilder self = new StringBuilder();
        if (dumpTags) {
            self.append(TreeUtils.indent(nSpaces));
            self.append(this.beginTag());
            self.append('\n');
        }
        self.append(super.dumpString(nSpaces + 2, true));
        self.append('\n');
        if (this.data != null) {
            self.append(TreeUtils.indent(nSpaces + 2));
            self.append("<data>");
            self.append(Key.DUMP_TYPE.dumpByteArray(this.data));
            self.append("</data>");
            self.append('\n');
        }
        if (dumpTags) {
            self.append(TreeUtils.indent(nSpaces));
            self.append(this.endTag());
        }
        return self.toString();
    }

    public LogResult optionalLog(EnvironmentImpl envImpl, DatabaseImpl dbImpl, byte[] key, long oldLsn, int oldSize, Locker locker, WriteLockInfo writeLockInfo, ReplicationContext repContext) throws DatabaseException {
        if (dbImpl.isDeferredWriteMode()) {
            return new LogResult(this.assignTransientLsn(envImpl, dbImpl, oldLsn, locker), -1);
        }
        return this.logInternal(envImpl, dbImpl, key, oldLsn, oldSize, locker, writeLockInfo, false, false, repContext);
    }

    public LogResult log(EnvironmentImpl envImpl, DatabaseImpl dbImpl, byte[] key, long oldLsn, int oldSize, Locker locker, WriteLockInfo writeLockInfo, boolean backgroundIO, ReplicationContext repContext) throws DatabaseException {
        return this.logInternal(envImpl, dbImpl, key, oldLsn, oldSize, locker, writeLockInfo, backgroundIO, false, repContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogResult logInternal(EnvironmentImpl envImpl, DatabaseImpl dbImpl, byte[] key, long oldLsn, int oldSize, Locker locker, WriteLockInfo writeLockInfo, boolean backgroundIO, boolean isProvisional, ReplicationContext repContext) throws DatabaseException {
        LogItem item;
        block23: {
            Txn logTxn;
            boolean logAbortKnownDeleted;
            long logAbortLsn;
            LogEntryType entryType;
            boolean isInsert;
            if (envImpl.isReadOnly()) {
                throw EnvironmentFailureException.unexpectedState("Cannot log LNs in read-only env.");
            }
            boolean isNamingDB = dbImpl.getId().equals(DbTree.NAME_DB_ID);
            if (!isNamingDB && envImpl.isReplicated() && locker != null && dbImpl.isReplicated() != locker.isReplicated()) {
                throw EnvironmentFailureException.unexpectedState((locker.isReplicated() ? "Rep txn used to write to non-rep DB" : "Non-rep txn used to write to rep DB") + ", class = " + locker.getClass().getName() + ", txnId = " + locker.getId() + ", dbName = " + dbImpl.getDebugName());
            }
            if (!isNamingDB) {
                boolean isRepLocker;
                boolean bl = isRepLocker = locker != null && locker.isReplicated();
                if (repContext.inReplicationStream() != isRepLocker) {
                    throw EnvironmentFailureException.unexpectedState((isRepLocker ? "Rep txn used to write outside of rep stream" : "Non-rep txn used to write in rep stream") + (locker != null ? ", class = " + locker.getClass().getName() + ", txnId = " + locker.getId() : ", null locker") + ", dbName = " + dbImpl.getDebugName());
                }
            }
            LogContext context = new LogContext();
            boolean bl = isInsert = oldLsn == -1L;
            if (locker != null && locker.isTransactional()) {
                entryType = this.getLogType(isInsert, true);
                logAbortLsn = writeLockInfo.getAbortLsn();
                logAbortKnownDeleted = writeLockInfo.getAbortKnownDeleted();
                logTxn = locker.getTxnLocker();
                assert (logTxn != null);
                context.obsoleteDupsAllowed = locker.isRolledBack();
            } else {
                entryType = this.getLogType(isInsert, false);
                logAbortLsn = -1L;
                logAbortKnownDeleted = false;
                logTxn = null;
            }
            item = new LogItem();
            item.entry = this.createLogEntry(entryType, dbImpl, key, logAbortLsn, logAbortKnownDeleted, logTxn, repContext);
            Provisional provisional = item.provisional = dbImpl.isTemporary() || isProvisional ? Provisional.YES : Provisional.NO;
            if (oldLsn != logAbortLsn && !dbImpl.isLNImmediatelyObsolete()) {
                item.oldLsn = oldLsn;
                item.oldSize = oldSize;
            }
            item.repContext = repContext;
            context.backgroundIO = backgroundIO;
            context.nodeDb = dbImpl;
            if (logTxn != null && oldLsn == logAbortLsn) {
                writeLockInfo.setAbortInfo(dbImpl, oldSize);
            }
            try {
                if (logTxn != null) {
                    Txn txn = logTxn;
                    synchronized (txn) {
                        envImpl.getLogManager().log(item, context);
                        break block23;
                    }
                }
                envImpl.getLogManager().log(item, context);
            }
            catch (DatabaseException e) {
                if (FileManager.continueAfterWriteException()) {
                    if (locker != null) {
                        new LNWriteFailureException(locker, e);
                    }
                    throw e;
                }
                if (envImpl.isValid()) {
                    throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INCOMPLETE, "LN could not be logged", e);
                }
                throw e;
            }
            finally {
                this.clearDirty();
            }
        }
        if (locker != null) {
            LockResult lockResult = locker.nonBlockingLock(item.newLsn, LockType.WRITE, false, dbImpl);
            assert (lockResult.getLockGrant() != LockGrantType.DENIED) : DbLsn.getNoFormatString(item.newLsn);
            lockResult.copyWriteLockInfo(writeLockInfo);
        }
        return new LogResult(item.newLsn, item.newSize);
    }

    LNLogEntry<?> createLogEntry(LogEntryType entryType, DatabaseImpl dbImpl, byte[] key, long logAbortLsn, boolean logAbortKnownDeleted, Txn logTxn, ReplicationContext repContext) {
        return new LNLogEntry<LN>(entryType, this, dbImpl.getId(), key, logAbortLsn, logAbortKnownDeleted, logTxn);
    }

    @Override
    void incFetchStats(EnvironmentImpl envImpl, boolean isMiss) {
        envImpl.getEvictor().incLNFetchStats(isMiss);
    }

    @Override
    public LogEntryType getGenericLogType() {
        return this.getLogType(true, false);
    }

    protected LogEntryType getLogType(boolean isInsert, boolean isTransactional) {
        if (this.isDeleted()) {
            assert (!isInsert);
            return isTransactional ? LogEntryType.LOG_DEL_LN_TRANSACTIONAL : LogEntryType.LOG_DEL_LN;
        }
        if (isInsert) {
            return isTransactional ? LogEntryType.LOG_INS_LN_TRANSACTIONAL : LogEntryType.LOG_INS_LN;
        }
        return isTransactional ? LogEntryType.LOG_UPD_LN_TRANSACTIONAL : LogEntryType.LOG_UPD_LN;
    }

    private long assignTransientLsn(EnvironmentImpl envImpl, DatabaseImpl dbImpl, long oldLsn, Locker locker) {
        long newLsn = oldLsn != -1L ? oldLsn : envImpl.getNodeSequence().getNextTransientLsn();
        if (locker != null) {
            LockResult lockResult = locker.nonBlockingLock(newLsn, LockType.WRITE, false, dbImpl);
            assert (lockResult.getLockGrant() != LockGrantType.DENIED) : DbLsn.getNoFormatString(newLsn);
        }
        return newLsn;
    }

    @Override
    public int getLastFormatChange() {
        return 8;
    }

    @Override
    public int getLogSize(int logVersion) {
        return BasicVersionedWriteLoggable.getLogSize(this, logVersion);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer, int logVersion) {
        BasicVersionedWriteLoggable.writeToLog(this, logBuffer, logVersion);
    }

    @Override
    public int getLogSize() {
        return this.calcLogSize(this.isDeleted() ? -1 : this.data.length);
    }

    private int calcLogSize(int dataLen) {
        int size = super.getLogSize();
        if (dataLen < 0) {
            size += LogUtils.getPackedIntLogSize(-1);
        } else {
            size += LogUtils.getPackedIntLogSize(dataLen);
            size += dataLen;
        }
        return size;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        if (this.isDeleted()) {
            LogUtils.writePackedInt(logBuffer, -1);
        } else {
            LogUtils.writePackedInt(logBuffer, this.data.length);
            LogUtils.writeBytesNoLength(logBuffer, this.data);
        }
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        super.readFromLog(itemBuffer, entryVersion);
        if (entryVersion < 8) {
            LogUtils.readLong(itemBuffer, entryVersion < 6);
        }
        if (entryVersion < 6) {
            boolean dataExists = LogUtils.readBoolean(itemBuffer);
            if (dataExists) {
                this.data = LogUtils.readByteArray(itemBuffer, true);
            }
        } else {
            int size = LogUtils.readInt(itemBuffer, false);
            if (size >= 0) {
                this.data = LogUtils.readBytesNoLength(itemBuffer, size);
            }
        }
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof LN)) {
            return false;
        }
        LN otherLN = (LN)other;
        return Arrays.equals(this.getData(), otherLN.getData());
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append(this.beginTag());
        super.dumpLog(sb, verbose);
        if (this.data != null) {
            sb.append("<data>");
            if (verbose) {
                sb.append(Key.DUMP_TYPE.dumpByteArray(this.data));
            } else {
                sb.append("hidden");
            }
            sb.append("</data>");
        }
        this.dumpLogAdditional(sb, verbose);
        sb.append(this.endTag());
    }

    public void dumpKey(StringBuilder sb, byte[] key) {
        sb.append(Key.dumpString(key, 0));
    }

    protected void dumpLogAdditional(StringBuilder sb, boolean verbose) {
    }

    public void addExtraMarshaledMemorySize(BIN parentBIN) {
    }

    public void setEntry(DatabaseEntry entry) {
        assert (!this.isDeleted());
        int len = this.data.length;
        byte[] bytes = new byte[len];
        System.arraycopy(this.data, 0, bytes, 0, len);
        entry.setData(bytes);
    }

    public static void setEntry(DatabaseEntry dest, byte[] bytes) {
        if (bytes != null) {
            int len;
            boolean partial = dest.getPartial();
            int off = partial ? dest.getPartialOffset() : 0;
            int n = len = partial ? dest.getPartialLength() : bytes.length;
            if (off + len > bytes.length) {
                len = off > bytes.length ? 0 : bytes.length - off;
            }
            byte[] newdata = null;
            if (len == 0) {
                newdata = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
            } else {
                newdata = new byte[len];
                System.arraycopy(bytes, off, newdata, 0, len);
            }
            dest.setData(newdata);
            dest.setOffset(0);
            dest.setSize(len);
        } else {
            dest.setData(null);
            dest.setOffset(0);
            dest.setSize(0);
        }
    }

    public static void setEntry(DatabaseEntry dest, DatabaseEntry src) {
        if (src.getData() != null) {
            int len;
            byte[] srcBytes = src.getData();
            boolean partial = dest.getPartial();
            int off = partial ? dest.getPartialOffset() : 0;
            int n = len = partial ? dest.getPartialLength() : srcBytes.length;
            if (off + len > srcBytes.length) {
                len = off > srcBytes.length ? 0 : srcBytes.length - off;
            }
            byte[] newdata = null;
            if (len == 0) {
                newdata = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
            } else {
                newdata = new byte[len];
                System.arraycopy(srcBytes, off, newdata, 0, len);
            }
            dest.setData(newdata);
            dest.setOffset(0);
            dest.setSize(len);
        } else {
            dest.setData(null);
            dest.setOffset(0);
            dest.setSize(0);
        }
    }

    public static byte[] copyEntryData(DatabaseEntry entry) {
        assert (!entry.getPartial());
        int len = entry.getSize();
        byte[] newData = len == 0 ? LogUtils.ZERO_LENGTH_BYTE_ARRAY : new byte[len];
        System.arraycopy(entry.getData(), entry.getOffset(), newData, 0, len);
        return newData;
    }

    public static byte[] resolvePartialEntry(DatabaseEntry entry, byte[] foundDataBytes) {
        int slicelen;
        int origlen;
        assert (foundDataBytes != null);
        int dlen = entry.getPartialLength();
        int doff = entry.getPartialOffset();
        int oldlen = doff + dlen > (origlen = foundDataBytes.length) ? doff + dlen : origlen;
        int len = oldlen - dlen + entry.getSize();
        byte[] newData = len == 0 ? LogUtils.ZERO_LENGTH_BYTE_ARRAY : new byte[len];
        int pos = 0;
        int n = slicelen = doff < origlen ? doff : origlen;
        if (slicelen > 0) {
            System.arraycopy(foundDataBytes, 0, newData, pos, slicelen);
        }
        slicelen = entry.getSize();
        System.arraycopy(entry.getData(), entry.getOffset(), newData, pos += doff, slicelen);
        pos += slicelen;
        slicelen = origlen - (doff + dlen);
        if (slicelen > 0) {
            System.arraycopy(foundDataBytes, doff + dlen, newData, pos, slicelen);
        }
        return newData;
    }

    static class LNWriteFailureException
    extends OperationFailureException {
        LNWriteFailureException(Locker locker, Exception cause) {
            super(locker, true, null, cause);
        }

        private LNWriteFailureException(String message, LNWriteFailureException cause) {
            super(message, cause);
        }

        @Override
        public OperationFailureException wrapSelf(String msg) {
            return new LNWriteFailureException(msg, this);
        }
    }

    public static class LogResult {
        public final long newLsn;
        public final int newSize;

        private LogResult(long newLsn, int newSize) {
            this.newLsn = newLsn;
            this.newSize = newSize;
        }
    }
}

