/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.tree.dupConvert;

import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.dbi.MemoryBudget;
import com.tangosol.internal.sleepycat.je.log.LogEntryType;
import com.tangosol.internal.sleepycat.je.log.LogUtils;
import com.tangosol.internal.sleepycat.je.tree.ChildReference;
import com.tangosol.internal.sleepycat.je.tree.IN;
import com.tangosol.internal.sleepycat.je.tree.Key;
import com.tangosol.internal.sleepycat.je.tree.TreeUtils;
import com.tangosol.internal.sleepycat.je.utilint.SizeofMarker;
import java.nio.ByteBuffer;

public final class DIN
extends IN {
    private static final String BEGIN_TAG = "<din>";
    private static final String END_TAG = "</din>";
    private byte[] dupKey;
    private ChildReference dupCountLNRef;

    public DIN() {
        this.dupCountLNRef = new ChildReference();
        this.init(null, Key.EMPTY_KEY, 0, 0);
    }

    public DIN(SizeofMarker marker) {
        super(marker);
        this.dupKey = null;
    }

    @Override
    public boolean isDIN() {
        return true;
    }

    public ChildReference getDupCountLNRef() {
        return this.dupCountLNRef;
    }

    @Override
    public boolean containsDuplicates() {
        return true;
    }

    @Override
    public long computeMemorySize() {
        long size = super.computeMemorySize();
        if (this.dupCountLNRef != null) {
            size += (long)MemoryBudget.byteArraySize(this.dupCountLNRef.getKey().length);
            if (this.dupCountLNRef.getTarget() != null) {
                size += this.dupCountLNRef.getTarget().getMemorySizeIncludedByParent();
            }
        }
        return size;
    }

    @Override
    protected long printMemorySize() {
        long inTotal = super.printMemorySize();
        long dupKeySize = 0L;
        long dupLNSize = 0L;
        if (this.dupCountLNRef != null) {
            dupKeySize = MemoryBudget.byteArraySize(this.dupCountLNRef.getKey().length);
            if (this.dupCountLNRef.getTarget() != null) {
                dupLNSize = this.dupCountLNRef.getTarget().getMemorySizeIncludedByParent();
            }
        }
        long dupTotal = inTotal + dupKeySize + dupLNSize;
        System.out.format("DIN: %d dkey: %d ln: %d %n", dupTotal, dupKeySize, dupLNSize);
        return dupTotal;
    }

    @Override
    protected long getFixedMemoryOverhead() {
        return MemoryBudget.DIN_FIXED_OVERHEAD;
    }

    @Override
    public LogEntryType getLogType() {
        return LogEntryType.LOG_DIN;
    }

    @Override
    public int getLogSize() {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        boolean unpacked = entryVersion < 6;
        super.readFromLog(itemBuffer, entryVersion);
        this.dupKey = LogUtils.readByteArray(itemBuffer, unpacked);
        boolean dupCountLNRefExists = false;
        byte booleans = itemBuffer.get();
        boolean bl = dupCountLNRefExists = (booleans & 1) != 0;
        if (dupCountLNRefExists) {
            this.dupCountLNRef.readFromLog(itemBuffer, entryVersion);
        } else {
            this.dupCountLNRef = null;
        }
    }

    @Override
    protected void dumpLogAdditional(StringBuilder sb) {
        super.dumpLogAdditional(sb);
        sb.append(Key.dumpString(this.dupKey, 0));
        if (this.dupCountLNRef != null) {
            this.dupCountLNRef.dumpLog(sb, true);
        }
    }

    @Override
    public String beginTag() {
        return BEGIN_TAG;
    }

    @Override
    public String endTag() {
        return END_TAG;
    }

    @Override
    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuilder sb = new StringBuilder();
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.beginTag());
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<dupkey>");
        sb.append(this.dupKey == null ? "" : Key.dumpString(this.dupKey, 0));
        sb.append("</dupkey>");
        sb.append('\n');
        if (this.dupCountLNRef == null) {
            sb.append(TreeUtils.indent(nSpaces + 2));
            sb.append("<dupCountLN/>");
        } else {
            sb.append(this.dupCountLNRef.dumpString(nSpaces + 4, true));
        }
        sb.append('\n');
        sb.append(super.dumpString(nSpaces, false));
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.endTag());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.dumpString(0, true);
    }

    @Override
    public String shortClassName() {
        return "DIN";
    }
}

