/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.util;

import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.DbInternal;
import com.tangosol.internal.sleepycat.je.Environment;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.log.FileManager;
import com.tangosol.internal.sleepycat.je.utilint.DbLsn;
import com.tangosol.internal.sleepycat.je.utilint.TestHook;
import com.tangosol.internal.sleepycat.je.utilint.TestHookExecute;

public class DbBackup {
    private final EnvironmentImpl envImpl;
    private final boolean envIsReadOnly;
    private final long firstFileInBackup;
    private long lastFileInBackup = -1L;
    private boolean backupStarted;
    private String[] snapshotFiles;
    private boolean invalid;
    private long rollbackStartedFileNumber;
    private TestHook testHook;

    public DbBackup(Environment env) throws DatabaseException {
        this(env, -1L);
    }

    public DbBackup(Environment env, long lastFileInPrevBackup) {
        this(env, DbInternal.getEnvironmentImpl(env), lastFileInPrevBackup);
    }

    public DbBackup(EnvironmentImpl envImpl) {
        this(null, envImpl, -1L);
    }

    private DbBackup(Environment env, EnvironmentImpl envImpl, long lastFileInPrevBackup) {
        if (env != null) {
            env.checkHandleIsValid();
        }
        this.envImpl = envImpl;
        this.envIsReadOnly = envImpl.getFileManager().checkEnvHomePermissions(true);
        if (!this.envIsReadOnly && envImpl.isReadOnly()) {
            throw new IllegalArgumentException("Environment handle may not be read-only when directory is read-write");
        }
        this.firstFileInBackup = lastFileInPrevBackup + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startBackup() throws DatabaseException {
        if (this.backupStarted) {
            throw new IllegalStateException("startBackup was already called");
        }
        if (!this.envImpl.addDbBackup(this)) {
            throw this.envImpl.createLogOverwriteException("A replication operation is overwriting log files. The backup can not proceed because files may be invalid. The backup may be attempted at a later time.");
        }
        this.envImpl.getCleaner().addProtectedFileRange(0L);
        try {
            this.envImpl.getCleaner().addProtectedFileRange(this.firstFileInBackup);
            this.backupStarted = true;
            if (this.envIsReadOnly) {
                this.lastFileInBackup = this.envImpl.getFileManager().getLastFileNum();
            } else {
                long newFileLsn = this.envImpl.forceLogFileFlip();
                this.lastFileInBackup = DbLsn.getFileNumber(newFileLsn) - 1L;
            }
            this.snapshotFiles = this.envImpl.getFileManager().listFileNames(0L, this.lastFileInBackup);
        }
        finally {
            this.envImpl.getCleaner().removeProtectedFileRange(0L);
        }
    }

    public synchronized void endBackup() {
        this.checkBackupStarted();
        this.backupStarted = false;
        assert (TestHookExecute.doHookIfSet(this.testHook));
        this.envImpl.getCleaner().removeProtectedFileRange(this.firstFileInBackup);
        this.envImpl.removeDbBackup(this);
        if (this.invalid) {
            this.invalid = false;
            throw this.envImpl.createLogOverwriteException("A replication operation has overwritten log files from file " + this.rollbackStartedFileNumber + ". Any copied files " + "should be considered invalid and discarded. The backup " + "may be attempted at a later time.");
        }
    }

    public synchronized long getLastFileInBackupSet() {
        this.checkBackupStarted();
        return this.lastFileInBackup;
    }

    public synchronized String[] getLogFilesInBackupSet() {
        this.checkBackupStarted();
        return this.envImpl.getFileManager().listFileNames(this.firstFileInBackup, this.lastFileInBackup);
    }

    @Deprecated
    public synchronized String[] getLogFilesInBackupSet(long lastFileInPrevBackup) {
        this.checkBackupStarted();
        FileManager fileManager = this.envImpl.getFileManager();
        return fileManager.listFileNames(lastFileInPrevBackup + 1L, this.lastFileInBackup);
    }

    public synchronized String[] getLogFilesInSnapshot() {
        this.checkBackupStarted();
        return this.snapshotFiles;
    }

    private void checkBackupStarted() {
        if (!this.backupStarted) {
            throw new IllegalStateException("startBackup was not called");
        }
    }

    public synchronized boolean backupIsOpen() {
        return this.backupStarted;
    }

    public void invalidate(long fileNumber) {
        this.invalid = true;
        this.rollbackStartedFileNumber = fileNumber;
    }

    public void setTestHook(TestHook testHook) {
        this.testHook = testHook;
    }
}

