/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.util;

import com.tangosol.internal.sleepycat.je.DbInternal;
import com.tangosol.internal.sleepycat.je.Environment;
import com.tangosol.internal.sleepycat.je.JEVersion;
import com.tangosol.internal.sleepycat.je.config.EnvironmentParams;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.log.FileManager;
import com.tangosol.internal.sleepycat.je.util.LogVerificationException;
import com.tangosol.internal.sleepycat.je.util.LogVerificationInputStream;
import com.tangosol.internal.sleepycat.je.utilint.CmdUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class DbVerifyLog {
    private static final String USAGE = "usage: " + CmdUtil.getJavaCommand(DbVerifyLog.class) + "\n" + "   [-h <dir>]  # environment home directory\n" + "   [-s <file>] # starting (minimum) file number\n" + "   [-e <file>] # ending (one past the maximum) file number\n" + "   [-V]        # print JE version number";
    private final EnvironmentImpl envImpl;
    private final int readBufferSize;

    public DbVerifyLog(Environment env) {
        this(env, 0);
    }

    public DbVerifyLog(Environment env, int readBufferSize) {
        this(DbInternal.getEnvironmentImpl(env), readBufferSize);
    }

    private DbVerifyLog(EnvironmentImpl envImpl, int readBufferSize) {
        this.readBufferSize = readBufferSize > 0 ? readBufferSize : envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        this.envImpl = envImpl;
    }

    public void verifyAll() throws LogVerificationException, IOException {
        this.verify(0L, Long.MAX_VALUE);
    }

    public void verify(long startFile, long endFile) throws LogVerificationException, IOException {
        FileManager fileManager = this.envImpl.getFileManager();
        File homeDir = this.envImpl.getEnvironmentHome();
        String[] fileNames = fileManager.listFileNames(startFile, endFile - 1L);
        byte[] buf = new byte[this.readBufferSize];
        for (String fileName : fileNames) {
            File file = new File(homeDir, fileName);
            FileInputStream fis = new FileInputStream(file);
            LogVerificationInputStream vis = new LogVerificationInputStream(this.envImpl, fis, fileName, -1L);
            IOException ioe = null;
            try {
                while (vis.read(buf) != -1) {
                }
            }
            catch (IOException e) {
                ioe = e;
                throw ioe;
            }
            finally {
                block11: {
                    try {
                        vis.close();
                    }
                    catch (IOException e) {
                        if (ioe != null) break block11;
                        throw e;
                    }
                }
            }
        }
    }

    public static void main(String[] argv) {
        try {
            File envHome = new File(".");
            long startFile = 0L;
            long endFile = Long.MAX_VALUE;
            for (int whichArg = 0; whichArg < argv.length; ++whichArg) {
                String arg;
                int slashOff;
                String nextArg = argv[whichArg];
                if (nextArg.equals("-h")) {
                    envHome = new File(CmdUtil.getArg(argv, ++whichArg));
                    continue;
                }
                if (nextArg.equals("-s")) {
                    if ((slashOff = (arg = CmdUtil.getArg(argv, ++whichArg)).indexOf("/")) >= 0) {
                        arg = arg.substring(0, slashOff);
                    }
                    startFile = CmdUtil.readLongNumber(arg);
                    continue;
                }
                if (nextArg.equals("-e")) {
                    if ((slashOff = (arg = CmdUtil.getArg(argv, ++whichArg)).indexOf("/")) >= 0) {
                        arg = arg.substring(0, slashOff);
                    }
                    endFile = CmdUtil.readLongNumber(arg);
                    continue;
                }
                if (nextArg.equals("-V")) {
                    System.out.println(JEVersion.CURRENT_VERSION);
                    System.exit(0);
                    continue;
                }
                DbVerifyLog.printUsageAndExit("Unknown argument: " + nextArg);
            }
            EnvironmentImpl envImpl = CmdUtil.makeUtilityEnvironment(envHome, true);
            DbVerifyLog verifier = new DbVerifyLog(envImpl, 0);
            verifier.verify(startFile, endFile);
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            DbVerifyLog.printUsageAndExit(e.toString());
        }
    }

    private static void printUsageAndExit(String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println(USAGE);
        System.exit(1);
    }
}

