/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.utilint;

import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.utilint.Stat;
import com.tangosol.internal.sleepycat.je.utilint.StatDefinition;
import com.tangosol.internal.sleepycat.je.utilint.StatGroup;
import java.util.concurrent.atomic.AtomicInteger;

public class AtomicIntStat
extends Stat<Integer>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private AtomicInteger counter = new AtomicInteger(0);

    public AtomicIntStat(StatGroup group, StatDefinition definition) {
        super(group, definition);
    }

    @Override
    public Integer get() {
        return this.counter.get();
    }

    @Override
    public void set(Integer newValue) {
        this.counter.set(newValue);
    }

    public void increment() {
        this.counter.incrementAndGet();
    }

    public void add(int count) {
        this.counter.addAndGet(count);
    }

    @Override
    public void add(Stat<Integer> other) {
        this.counter.addAndGet(other.get());
    }

    @Override
    public void clear() {
        this.counter.set(0);
    }

    @Override
    public Stat<Integer> computeInterval(Stat<Integer> base) {
        AtomicIntStat ret = this.copy();
        if (this.definition.getType() == StatDefinition.StatType.INCREMENTAL) {
            ret.set(this.counter.get() - base.get());
        }
        return ret;
    }

    @Override
    public void negate() {
        if (this.definition.getType() == StatDefinition.StatType.INCREMENTAL) {
            this.counter.set(-this.counter.get());
        }
    }

    public AtomicIntStat copy() {
        try {
            AtomicIntStat ret = (AtomicIntStat)super.clone();
            ret.counter = new AtomicInteger(this.counter.get());
            return ret;
        }
        catch (CloneNotSupportedException unexpected) {
            throw EnvironmentFailureException.unexpectedException(unexpected);
        }
    }

    @Override
    protected String getFormattedValue() {
        return Stat.FORMAT.format(this.counter.get());
    }

    @Override
    public boolean isNotSet() {
        return this.counter.get() == 0;
    }
}

