/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.persist.impl;

import com.tangosol.internal.sleepycat.compat.DbCompat;
import com.tangosol.internal.sleepycat.persist.impl.Accessor;
import com.tangosol.internal.sleepycat.persist.impl.Catalog;
import com.tangosol.internal.sleepycat.persist.impl.EnhancedAccessor;
import com.tangosol.internal.sleepycat.persist.impl.EntityInput;
import com.tangosol.internal.sleepycat.persist.impl.EntityOutput;
import com.tangosol.internal.sleepycat.persist.impl.Evolver;
import com.tangosol.internal.sleepycat.persist.impl.FieldInfo;
import com.tangosol.internal.sleepycat.persist.impl.Format;
import com.tangosol.internal.sleepycat.persist.impl.RawAccessor;
import com.tangosol.internal.sleepycat.persist.impl.RawComplexInput;
import com.tangosol.internal.sleepycat.persist.impl.RecordInput;
import com.tangosol.internal.sleepycat.persist.impl.RecordOutput;
import com.tangosol.internal.sleepycat.persist.impl.ReflectionAccessor;
import com.tangosol.internal.sleepycat.persist.impl.RefreshException;
import com.tangosol.internal.sleepycat.persist.impl.SimpleCatalog;
import com.tangosol.internal.sleepycat.persist.model.ClassMetadata;
import com.tangosol.internal.sleepycat.persist.model.EntityModel;
import com.tangosol.internal.sleepycat.persist.model.FieldMetadata;
import com.tangosol.internal.sleepycat.persist.raw.RawField;
import com.tangosol.internal.sleepycat.persist.raw.RawObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class CompositeKeyFormat
extends Format {
    private static final long serialVersionUID = 306843428409314630L;
    private ClassMetadata metadata;
    private List<FieldInfo> fields;
    private transient Accessor objAccessor;
    private transient Accessor rawAccessor;
    private volatile transient Map<String, RawField> rawFields;
    private volatile transient FieldInfo[] rawInputFields;

    static String[] getFieldNameArray(List<FieldMetadata> list) {
        int index = 0;
        String[] a = new String[list.size()];
        for (FieldMetadata f : list) {
            a[index] = f.getName();
            ++index;
        }
        return a;
    }

    CompositeKeyFormat(Catalog catalog, Class cls, ClassMetadata metadata, List<FieldMetadata> fieldMeta) {
        this(catalog, cls, metadata, CompositeKeyFormat.getFieldNameArray(fieldMeta));
    }

    CompositeKeyFormat(Catalog catalog, Class cls, String[] fieldNames) {
        this(catalog, cls, null, fieldNames);
    }

    private CompositeKeyFormat(Catalog catalog, Class cls, ClassMetadata metadata, String[] fieldNames) {
        super(catalog, cls);
        this.metadata = metadata;
        Class superCls = cls.getSuperclass();
        if (superCls != Object.class) {
            throw new IllegalArgumentException("Composite key class must be derived from Object: " + cls.getName());
        }
        List<FieldInfo> instanceFields = FieldInfo.getInstanceFields(cls, metadata);
        this.fields = new ArrayList<FieldInfo>(instanceFields.size());
        for (String fieldName : fieldNames) {
            FieldInfo field = null;
            for (FieldInfo tryField : instanceFields) {
                if (!fieldName.equals(tryField.getName())) continue;
                field = tryField;
                break;
            }
            if (field == null) {
                throw new IllegalArgumentException("Composite key field is not an instance field: " + this.getClassName() + '.' + fieldName);
            }
            this.fields.add(field);
            instanceFields.remove(field);
            Class fieldCls = field.getFieldClass(this.getCatalog());
            if (SimpleCatalog.isSimpleType(fieldCls) || fieldCls.isEnum()) continue;
            throw new IllegalArgumentException("Composite key field is not a simple type or enum: " + this.getClassName() + '.' + fieldName);
        }
        if (instanceFields.size() > 0) {
            throw new IllegalArgumentException("All composite key instance fields must be key fields: " + this.getClassName() + '.' + instanceFields.get(0).getName());
        }
    }

    List<FieldInfo> getFieldInfo() {
        return this.fields;
    }

    @Override
    void migrateFromBeta(Map<String, Format> formatMap) {
        super.migrateFromBeta(formatMap);
        for (FieldInfo field : this.fields) {
            field.migrateFromBeta(formatMap);
        }
    }

    @Override
    boolean isModelClass() {
        return true;
    }

    @Override
    public ClassMetadata getClassMetadata() {
        if (this.metadata == null) {
            throw DbCompat.unexpectedState(this.getClassName());
        }
        return this.metadata;
    }

    @Override
    public Map<String, RawField> getFields() {
        if (this.rawFields == null) {
            HashMap<String, RawField> map = new HashMap<String, RawField>();
            for (RawField rawField : this.fields) {
                map.put(rawField.getName(), rawField);
            }
            this.rawFields = map;
        }
        return this.rawFields;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
        for (FieldInfo field : this.fields) {
            field.collectRelatedFormats(catalog, newFormats);
        }
    }

    @Override
    void initialize(Catalog catalog, EntityModel model, int initVersion) {
        for (FieldInfo field : this.fields) {
            field.initialize(catalog, model, initVersion);
        }
        Class type = this.getType();
        if (type != null) {
            this.objAccessor = EnhancedAccessor.isEnhanced(type) ? new EnhancedAccessor(catalog, type, this.fields) : new ReflectionAccessor(catalog, type, this.fields);
        }
        this.rawAccessor = new RawAccessor(this, this.fields);
    }

    @Override
    Object newArray(int len) {
        return this.objAccessor.newArray(len);
    }

    @Override
    public Object newInstance(EntityInput input, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        return accessor.newInstance();
    }

    @Override
    public Object readObject(Object o, EntityInput input, boolean rawAccess) throws RefreshException {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        accessor.readCompositeKeyFields(o, input);
        return o;
    }

    @Override
    void writeObject(Object o, EntityOutput output, boolean rawAccess) throws RefreshException {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        accessor.writeCompositeKeyFields(o, output);
    }

    @Override
    Object convertRawObject(Catalog catalog, boolean rawAccess, RawObject rawObject, IdentityHashMap converted) throws RefreshException {
        FieldInfo[] myFields = this.rawInputFields;
        if (myFields == null) {
            myFields = new FieldInfo[this.fields.size()];
            this.fields.toArray(myFields);
            this.rawInputFields = myFields;
        }
        if (rawObject.getSuper() != null) {
            throw new IllegalArgumentException("RawObject has too many superclasses: " + rawObject.getType().getClassName());
        }
        Object[] objects = new RawObject[myFields.length];
        Arrays.fill(objects, rawObject);
        RawComplexInput in = new RawComplexInput(catalog, rawAccess, converted, myFields, (RawObject[])objects);
        Object o = this.newInstance(in, rawAccess);
        converted.put(rawObject, o);
        return this.readObject(o, in, rawAccess);
    }

    @Override
    void skipContents(RecordInput input) throws RefreshException {
        int maxNum = this.fields.size();
        for (int i = 0; i < maxNum; ++i) {
            this.fields.get(i).getType().skipContents(input);
        }
    }

    @Override
    void copySecKey(RecordInput input, RecordOutput output) {
        int maxNum = this.fields.size();
        for (int i = 0; i < maxNum; ++i) {
            this.fields.get(i).getType().copySecKey(input, output);
        }
    }

    @Override
    Format getSequenceKeyFormat() {
        if (this.fields.size() != 1) {
            throw new IllegalArgumentException("A composite key class used with a sequence may contain only a single key field: " + this.getClassName());
        }
        return this.fields.get(0).getType().getSequenceKeyFormat();
    }

    @Override
    boolean evolve(Format newFormatParam, Evolver evolver) {
        if (!(newFormatParam instanceof CompositeKeyFormat)) {
            evolver.addEvolveError(this, newFormatParam, null, "A composite key class may not be changed to a different type");
            return false;
        }
        CompositeKeyFormat newFormat = (CompositeKeyFormat)newFormatParam;
        if (this.fields.size() != newFormat.fields.size()) {
            evolver.addEvolveError(this, newFormat, "Composite key class fields were added or removed ", "Old fields: " + this.fields + " new fields: " + newFormat.fields);
            return false;
        }
        boolean newVersion = false;
        for (int i = 0; i < this.fields.size(); ++i) {
            int result = evolver.evolveRequiredKeyField(this, newFormat, this.fields.get(i), newFormat.fields.get(i));
            if (result == 2) {
                return false;
            }
            if (result != 1) continue;
            newVersion = true;
        }
        if (newVersion) {
            evolver.useEvolvedFormat(this, newFormat, newFormat);
        } else {
            evolver.useOldFormat(this, newFormat);
        }
        return true;
    }
}

