/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.persist.impl;

import com.tangosol.internal.sleepycat.bind.EntryBinding;
import com.tangosol.internal.sleepycat.bind.tuple.TupleBase;
import com.tangosol.internal.sleepycat.compat.DbCompat;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;
import com.tangosol.internal.sleepycat.persist.impl.Catalog;
import com.tangosol.internal.sleepycat.persist.impl.CompositeKeyFormat;
import com.tangosol.internal.sleepycat.persist.impl.Format;
import com.tangosol.internal.sleepycat.persist.impl.PersistCatalog;
import com.tangosol.internal.sleepycat.persist.impl.PersistEntityBinding;
import com.tangosol.internal.sleepycat.persist.impl.RecordInput;
import com.tangosol.internal.sleepycat.persist.impl.RecordOutput;
import com.tangosol.internal.sleepycat.persist.impl.RefreshException;

public class PersistKeyBinding
implements EntryBinding {
    volatile Catalog catalog;
    volatile Format keyFormat;
    final boolean rawAccess;

    public PersistKeyBinding(Catalog catalogParam, String clsName, boolean rawAccess) {
        this.catalog = catalogParam;
        try {
            this.keyFormat = PersistEntityBinding.getOrCreateFormat(this.catalog, clsName, rawAccess);
        }
        catch (RefreshException e) {
            this.catalog = e.refresh();
            try {
                this.keyFormat = PersistEntityBinding.getOrCreateFormat(this.catalog, clsName, rawAccess);
            }
            catch (RefreshException e2) {
                throw DbCompat.unexpectedException(e2);
            }
        }
        if (!(this.keyFormat.isSimple() || this.keyFormat.isEnum() || this.keyFormat.getClassMetadata() != null && this.keyFormat.getClassMetadata().getCompositeKeyFields() != null)) {
            throw new IllegalArgumentException("Key class is not a simple type, an enum, or a composite key class (composite keys must include @KeyField annotations): " + clsName);
        }
        this.rawAccess = rawAccess;
    }

    PersistKeyBinding(Catalog catalog, Class cls, String[] compositeFieldOrder) {
        this.catalog = catalog;
        this.keyFormat = new CompositeKeyFormat(catalog, cls, compositeFieldOrder);
        this.keyFormat.initializeIfNeeded(catalog, null);
        this.rawAccess = false;
    }

    Object bytesToObject(byte[] bytes, int offset, int length) throws RefreshException {
        return PersistKeyBinding.readKey(this.keyFormat, this.catalog, bytes, offset, length, this.rawAccess);
    }

    static Object readKey(Format keyFormat, Catalog catalog, byte[] bytes, int offset, int length, boolean rawAccess) throws RefreshException {
        RecordInput input = new RecordInput(catalog, rawAccess, null, 0, bytes, offset, length);
        return input.readKeyObject(keyFormat);
    }

    public Object entryToObject(DatabaseEntry entry) {
        try {
            return this.entryToObjectInternal(entry);
        }
        catch (RefreshException e) {
            e.refresh();
            try {
                return this.entryToObjectInternal(entry);
            }
            catch (RefreshException e2) {
                throw DbCompat.unexpectedException(e2);
            }
        }
    }

    private Object entryToObjectInternal(DatabaseEntry entry) throws RefreshException {
        return this.bytesToObject(entry.getData(), entry.getOffset(), entry.getSize());
    }

    public void objectToEntry(Object object, DatabaseEntry entry) {
        try {
            this.objectToEntryInternal(object, entry);
        }
        catch (RefreshException e) {
            e.refresh();
            try {
                this.objectToEntryInternal(object, entry);
            }
            catch (RefreshException e2) {
                throw DbCompat.unexpectedException(e2);
            }
        }
    }

    private void objectToEntryInternal(Object object, DatabaseEntry entry) throws RefreshException {
        RecordOutput output = new RecordOutput(this.catalog, this.rawAccess);
        output.writeKeyObject(object, this.keyFormat);
        TupleBase.outputToEntry(output, entry);
    }

    void refresh(PersistCatalog newCatalog) {
        this.catalog = newCatalog;
        this.keyFormat = this.catalog.getFormat(this.keyFormat.getClassName());
    }
}

