/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.tracing;

import com.tangosol.internal.tracing.NoopAware;
import com.tangosol.internal.tracing.SpanContext;
import com.tangosol.internal.tracing.Wrapper;
import java.io.Serializable;
import java.util.Map;

public interface Span
extends NoopAware,
Wrapper {
    public Span setMetadata(String var1, String var2);

    public Span setMetadata(String var1, long var2);

    public Span setMetadata(String var1, double var2);

    public Span setMetadata(String var1, boolean var2);

    public Span log(String var1);

    public Span log(Map<String, ? super Serializable> var1);

    public Span updateName(String var1);

    public void end();

    public SpanContext getContext();

    public static enum Association {
        FOLLOWS_FROM;

        private final String f_sKey = super.name().toLowerCase();

        public String key() {
            return this.f_sKey;
        }
    }

    public static enum Metadata {
        LISTENER_CLASSES;

        private final String f_sKey = super.name().toLowerCase().replace('_', '.');

        public String key() {
            return this.f_sKey;
        }
    }

    public static enum Type {
        COMPONENT;

        private final String f_sKey = super.name().toLowerCase();

        public String key() {
            return this.f_sKey;
        }
    }

    public static final class Noop
    implements Span {
        public static final Span INSTANCE = new Noop();

        private Noop() {
        }

        @Override
        public Span setMetadata(String sKey, String sValue) {
            return this;
        }

        @Override
        public Span setMetadata(String sKey, long lValue) {
            return this;
        }

        @Override
        public Span setMetadata(String sKey, double dValue) {
            return this;
        }

        @Override
        public Span setMetadata(String sKey, boolean fValue) {
            return this;
        }

        @Override
        public Span log(String sEvent) {
            return this;
        }

        @Override
        public Span log(Map<String, ? super Serializable> mapFields) {
            return null;
        }

        @Override
        public Span updateName(String sName) {
            return this;
        }

        @Override
        public void end() {
        }

        @Override
        public SpanContext getContext() {
            return SpanContext.Noop.INSTANCE;
        }

        @Override
        public boolean isNoop() {
            return true;
        }

        @Override
        public <T> T underlying() {
            return null;
        }

        public String toString() {
            return "Span.Noop";
        }
    }

    public static interface Builder {
        public Builder setParent(Span var1);

        public Builder setParent(SpanContext var1);

        public Builder setNoParent();

        public Builder withMetadata(String var1, String var2);

        public Builder withMetadata(String var1, boolean var2);

        public Builder withMetadata(String var1, long var2);

        public Builder withMetadata(String var1, double var2);

        public Builder withAssociation(String var1, SpanContext var2);

        public Builder setStartTimestamp(long var1);

        public Span startSpan();

        public static final class Noop
        implements Builder {
            public static final Builder INSTANCE = new Noop();

            private Noop() {
            }

            @Override
            public Builder setParent(Span parent) {
                return this;
            }

            @Override
            public Builder setParent(SpanContext remoteParent) {
                return this;
            }

            @Override
            public Builder setNoParent() {
                return this;
            }

            @Override
            public Builder withMetadata(String sKey, String sValue) {
                return this;
            }

            @Override
            public Builder withMetadata(String sKey, boolean fValue) {
                return this;
            }

            @Override
            public Builder withMetadata(String sKey, long lValue) {
                return this;
            }

            @Override
            public Builder withMetadata(String sKey, double dValue) {
                return this;
            }

            @Override
            public Builder withAssociation(String sLabel, SpanContext associatedContext) {
                return this;
            }

            @Override
            public Builder setStartTimestamp(long ldtStartTime) {
                return this;
            }

            @Override
            public Span startSpan() {
                return com.tangosol.internal.tracing.Span$Noop.INSTANCE;
            }
        }
    }
}

