/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.tracing.opentracing33;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.tracing.Tracer;
import com.tangosol.internal.tracing.opentracing.AbstractOpenTracingShim;
import com.tangosol.internal.tracing.opentracing33.OpenTracingTracer;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.util.GlobalTracer;
import java.lang.reflect.Field;

public class OpenTracingShim
extends AbstractOpenTracingShim {
    protected static final Field GLOBAL_TRACER_REGISTERED_FIELD;

    @Override
    protected boolean registerTracer(io.opentracing.Tracer tracer) {
        if (GLOBAL_TRACER_REGISTERED_FIELD == null) {
            return false;
        }
        return GlobalTracer.registerIfAbsent((io.opentracing.Tracer)tracer);
    }

    @Override
    protected void onControlClose() {
        try {
            GLOBAL_TRACER_REGISTERED_FIELD.set(null, false);
            GlobalTracer.registerIfAbsent((io.opentracing.Tracer)NoopTracerFactory.create());
            GLOBAL_TRACER_REGISTERED_FIELD.set(null, false);
        }
        catch (IllegalAccessException | IllegalStateException e) {
            Logger.finest("Unexpected exception resetting GlobalTracer: ", (Throwable)e);
        }
    }

    @Override
    protected String getApiVersion() {
        return "0.33.0";
    }

    @Override
    protected Tracer createTracer() {
        return new OpenTracingTracer();
    }

    static {
        Field fieldRegistered = null;
        try {
            fieldRegistered = GlobalTracer.class.getDeclaredField("isRegistered");
            fieldRegistered.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            Logger.err("An incompatible version of the OpenTracing API has been detected on the classpath. Tracing will be disabled.");
        }
        GLOBAL_TRACER_REGISTERED_FIELD = fieldRegistered;
    }
}

