/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Base;
import java.util.BitSet;

public class OwnershipConflictResolver {
    public static final int STATE_OPEN = 0;
    public static final int STATE_RESOLVED = 1;
    public static final int STATE_RESOLVED_CONFLICT = 2;
    protected OwnershipView[] m_aView;
    protected int m_cPartitions;
    protected int m_cBackups;
    protected int m_nState;

    public OwnershipConflictResolver(int cPartitions, int cBackups) {
        this.m_cPartitions = cPartitions;
        this.m_cBackups = cBackups;
        this.m_aView = new OwnershipView[cPartitions * (cBackups + 1)];
    }

    public int getPartitionCount() {
        return this.m_cPartitions;
    }

    public int getBackupCount() {
        return this.m_cBackups;
    }

    public int getState() {
        return this.m_nState;
    }

    protected void setState(int nState) {
        this.m_nState = nState;
    }

    public void registerOwnership(int nMember, int[][] aaiOwners) {
        int cPartitions = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        OwnershipView[] aView = this.m_aView;
        if (this.getState() > 0) {
            throw new IllegalStateException();
        }
        for (int iStore = 0; iStore <= cBackups; ++iStore) {
            for (int iPart = 0; iPart < cPartitions; ++iPart) {
                int iView = iPart + iStore * cPartitions;
                OwnershipView view = aView[iView];
                int nOwner = aaiOwners[iPart][iStore];
                while (view != null) {
                    if (view.m_nOwner == nOwner) {
                        view.m_bsMembers.set(nMember);
                        break;
                    }
                    view = view.m_viewNext;
                }
                if (view != null) continue;
                view = new OwnershipView(nOwner);
                view.m_bsMembers.set(nMember);
                view.m_viewNext = aView[iView];
                aView[iView] = view;
            }
        }
    }

    public PartitionSet resolveConflicts() {
        if (this.getState() > 0) {
            throw new IllegalStateException();
        }
        int cPartitions = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        OwnershipView[] aView = this.m_aView;
        PartitionSet partsConflict = new PartitionSet(cPartitions);
        for (int iPart = 0; iPart < cPartitions; ++iPart) {
            OwnershipView view = aView[iPart];
            if (view.m_viewNext == null) continue;
            partsConflict.add(iPart);
        }
        for (int iStore = 1; iStore <= cBackups; ++iStore) {
            block2: for (int iPart = 0; iPart < cPartitions; ++iPart) {
                int iView = iPart + iStore * cPartitions;
                OwnershipView viewFirst = aView[iView];
                if (viewFirst.m_viewNext == null) continue;
                OwnershipView view = viewFirst;
                block3: do {
                    int nOwner;
                    if ((nOwner = view.m_nOwner) == 0 || view.m_bsMembers.get(nOwner)) continue;
                    OwnershipView viewTest = aView[iView];
                    do {
                        if (!viewTest.m_bsMembers.get(nOwner)) continue;
                        viewTest.m_bsMembers.or(view.m_bsMembers);
                        this.removeView(iPart, iStore, view);
                        continue block3;
                    } while ((viewTest = viewTest.m_viewNext) != null);
                } while ((view = view.m_viewNext) != null);
                view = aView[iView];
                int cViews = 0;
                do {
                    int nOwner;
                    if ((nOwner = view.m_nOwner) == 0 || ++cViews <= 1 && view.m_bsMembers.get(nOwner)) continue;
                    partsConflict.add(iPart);
                    continue block2;
                } while ((view = view.m_viewNext) != null);
            }
        }
        this.setState(partsConflict.isEmpty() ? 1 : 2);
        return partsConflict;
    }

    public int[][] getResolvedAssignments() {
        int cPartitions = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        OwnershipView[] aView = this.m_aView;
        int[][] aaiOwners = new int[cPartitions][cBackups + 1];
        if (this.getState() != 1) {
            throw new IllegalArgumentException();
        }
        for (int iPart = 0; iPart < cPartitions; ++iPart) {
            aaiOwners[iPart] = new int[cBackups + 1];
            int[] aiOwners = aaiOwners[iPart];
            for (int iStore = 0; iStore <= cBackups; ++iStore) {
                int iView = iPart + iStore * cPartitions;
                OwnershipView view = aView[iView];
                OwnershipView viewNext = view.m_viewNext;
                int nOwner = view.m_nOwner;
                if (nOwner == 0 && viewNext != null) {
                    Base.azzert(viewNext.m_viewNext == null);
                    nOwner = viewNext.m_nOwner;
                }
                aiOwners[iStore] = nOwner;
            }
        }
        return aaiOwners;
    }

    protected void removeView(int iPartition, int iStore, OwnershipView view) {
        OwnershipView viewNext;
        OwnershipView[] aView = this.m_aView;
        int iView = iPartition + iStore * this.getPartitionCount();
        OwnershipView viewCur = aView[iView];
        if (viewCur == view) {
            aView[iView] = view.m_viewNext;
            return;
        }
        do {
            if ((viewNext = viewCur.m_viewNext) != view) continue;
            viewCur.m_viewNext = view.m_viewNext;
        } while ((viewCur = viewNext) != null);
    }

    private static class OwnershipView {
        public OwnershipView m_viewNext;
        public final int m_nOwner;
        public final BitSet m_bsMembers;

        public OwnershipView(int nOwner) {
            this.m_nOwner = nOwner;
            this.m_bsMembers = new BitSet();
        }
    }
}

