/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.aggregator;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;

public final class BigDecimalSerializationWrapper
implements ExternalizableLite,
PortableObject {
    private int m_count;
    private BigDecimal m_bigDecimal;
    private static final int COUNT = 0;
    private static final int BIG_DECIMAL = 1;

    public BigDecimalSerializationWrapper() {
        this(Integer.MIN_VALUE, null);
    }

    public BigDecimalSerializationWrapper(BigDecimal partialResult) {
        this(Integer.MIN_VALUE, partialResult);
    }

    public BigDecimalSerializationWrapper(int count, BigDecimal partialResult) {
        this.m_count = count;
        this.m_bigDecimal = partialResult;
    }

    public int getCount() {
        return this.m_count;
    }

    public BigDecimal getBigDecimal() {
        return this.m_bigDecimal;
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.m_count = ExternalizableHelper.readInt(dataInput);
        if (this.m_count == Integer.MIN_VALUE || this.m_count > 0) {
            this.m_bigDecimal = ExternalizableHelper.readBigDecimal(dataInput);
        }
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        ExternalizableHelper.writeInt(dataOutput, this.m_count);
        if (this.m_count == Integer.MIN_VALUE || this.m_count > 0) {
            ExternalizableHelper.writeBigDecimal(dataOutput, this.m_bigDecimal);
        }
    }

    @Override
    public void readExternal(PofReader pofReader) throws IOException {
        this.m_count = pofReader.readInt(0);
        if (this.m_count == Integer.MIN_VALUE || this.m_count > 0) {
            this.m_bigDecimal = pofReader.readBigDecimal(1);
        }
    }

    @Override
    public void writeExternal(PofWriter pofWriter) throws IOException {
        pofWriter.writeInt(0, this.m_count);
        if (this.m_count == Integer.MIN_VALUE || this.m_count > 0) {
            pofWriter.writeBigDecimal(1, this.m_bigDecimal);
        }
    }
}

