/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.graal.js;

import com.tangosol.internal.util.graal.ScriptDescriptor;
import com.tangosol.util.ScriptException;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class Module {
    private final String m_sName;
    private Map<Object, Object> mapExports = new HashMap<Object, Object>();
    private final ScriptDescriptor m_descriptor;
    private Value m_value;
    private boolean m_fLoaded;
    private final Map<String, Module> m_mapDependents = new HashMap<String, Module>();

    public Module(ScriptDescriptor descriptor) {
        this.m_sName = descriptor.getScriptUrl().toString();
        this.m_descriptor = descriptor;
    }

    public String getName() {
        return this.m_sName;
    }

    public Map<Object, Object> getExports() {
        return this.mapExports;
    }

    public void setExports(Map<Object, Object> exports) {
        this.mapExports = exports;
    }

    public Value getValue() {
        return this.m_value;
    }

    public boolean isLoaded() {
        return this.m_fLoaded;
    }

    public ScriptDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    public void load(Context context) throws ScriptException {
        String scriptPath = this.m_descriptor.getScriptPath();
        if (!this.m_descriptor.exists()) {
            throw new ScriptException(scriptPath);
        }
        if (this.m_descriptor.isDirectory()) {
            throw new IllegalArgumentException(scriptPath + " is a directory");
        }
        CharSequence wrappedText = this.m_descriptor.getScriptSource().getCharacters();
        try {
            if (this.m_descriptor.getScriptSource().getName().endsWith(".json")) {
                wrappedText = "module.exports = " + wrappedText;
                Source wrappedSource = Source.newBuilder((String)"js", (CharSequence)wrappedText, (String)this.m_descriptor.getScriptUrl().toString()).buildLiteral();
                this.m_value = context.eval(wrappedSource);
            } else if (this.m_descriptor.getScriptSource().getName().endsWith(".mjs")) {
                Source src = Source.newBuilder((String)"js", (CharSequence)wrappedText, (String)this.m_descriptor.getScriptUrl().toString()).buildLiteral();
                this.m_value = context.eval(src);
            } else {
                wrappedText = String.join((CharSequence)System.getProperty("line.separator"), "", "(function (exports, module, __filename, __dirname) {", wrappedText, "", "return module.exports;", "", "});", "");
                Source wrappedSource = Source.newBuilder((String)"js", (CharSequence)wrappedText, (String)this.m_descriptor.getScriptUrl().toString()).buildLiteral();
                Value wrapperFunc = context.eval(wrappedSource);
                String fileNamePath = this.m_descriptor.getResourcePath();
                this.m_value = wrapperFunc.execute(new Object[]{this.getExports(), this, fileNamePath, this.m_descriptor.getDirectory()});
            }
            this.m_fLoaded = true;
        }
        catch (PolyglotException polyEx) {
            polyEx.printStackTrace();
            throw new ScriptException("Exception while evaluating script", polyEx);
        }
    }

    public Map<String, Module> getDependents() {
        return this.m_mapDependents;
    }

    void addDependentModule(Module dependent) {
        this.m_mapDependents.put(dependent.getDescriptor().getScriptUrl().toString(), dependent);
    }

    public String toString() {
        return "Module {desciptor= " + this.m_descriptor + "}";
    }
}

