/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.Streamer;
import com.tangosol.util.stream.RemotePipeline;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.json.bind.annotation.JsonbProperty;

public class IntCollectorAggregator<K, V, R>
implements InvocableMap.StreamingAggregator<K, V, R, R>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="pipeline")
    protected RemotePipeline<IntStream> m_pipeline;
    @JsonbProperty(value="supplier")
    protected Supplier<R> m_supplier;
    @JsonbProperty(value="accumulator")
    protected ObjIntConsumer<R> m_accumulator;
    @JsonbProperty(value="combiner")
    protected BiConsumer<R, R> m_combiner;
    private transient R m_result;

    public IntCollectorAggregator() {
    }

    public IntCollectorAggregator(RemotePipeline<IntStream> pipeline, Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        this.m_pipeline = pipeline;
        this.m_supplier = supplier;
        this.m_accumulator = accumulator;
        this.m_combiner = combiner;
    }

    @Override
    public R aggregate(Set<? extends InvocableMap.Entry<? extends K, ? extends V>> setEntries) {
        IntStream s = this.m_pipeline.evaluate(setEntries.stream());
        return s.collect(this.m_supplier, this.m_accumulator, this.m_combiner);
    }

    @Override
    public InvocableMap.StreamingAggregator<K, V, R, R> supply() {
        return new IntCollectorAggregator<K, V, R>(this.m_pipeline, this.m_supplier, this.m_accumulator, this.m_combiner);
    }

    @Override
    public boolean accumulate(Streamer<? extends InvocableMap.Entry<? extends K, ? extends V>> streamer) {
        IntStream stream = this.m_pipeline.evaluate(streamer.stream());
        this.m_result = this.m_supplier.get();
        stream.forEach(t -> this.m_accumulator.accept(this.m_result, t));
        return true;
    }

    @Override
    public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
        return true;
    }

    @Override
    public boolean combine(R partialResult) {
        if (this.m_result == null) {
            this.m_result = this.m_supplier.get();
        }
        this.m_combiner.accept(this.m_result, partialResult);
        return true;
    }

    @Override
    public R getPartialResult() {
        return this.m_result;
    }

    @Override
    public R finalizeResult() {
        return this.m_result;
    }

    @Override
    public int characteristics() {
        return this.m_pipeline.isParallel() ? 1 : 2;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_pipeline = (RemotePipeline)ExternalizableHelper.readObject(in);
        this.m_supplier = (Supplier)ExternalizableHelper.readObject(in);
        this.m_accumulator = (ObjIntConsumer)ExternalizableHelper.readObject(in);
        this.m_combiner = (BiConsumer)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_pipeline);
        ExternalizableHelper.writeObject(out, this.m_supplier);
        ExternalizableHelper.writeObject(out, this.m_accumulator);
        ExternalizableHelper.writeObject(out, this.m_combiner);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_pipeline = (RemotePipeline)in.readObject(0);
        this.m_supplier = (Supplier)in.readObject(1);
        this.m_accumulator = (ObjIntConsumer)in.readObject(2);
        this.m_combiner = (BiConsumer)in.readObject(3);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_pipeline);
        out.writeObject(1, this.m_supplier);
        out.writeObject(2, this.m_accumulator);
        out.writeObject(3, this.m_combiner);
    }
}

