/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream.collectors;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.json.bind.annotation.JsonbProperty;

public class CollectingAndThenCollector<T, A, R, RR>
implements RemoteCollector<T, A, RR>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="finisher")
    protected Function<R, RR> m_finisher;
    @JsonbProperty(value="downstream")
    protected RemoteCollector<T, A, R> m_downstream;

    public CollectingAndThenCollector() {
    }

    public CollectingAndThenCollector(RemoteCollector<T, A, R> downstream, Remote.Function<R, RR> finisher) {
        this.m_downstream = downstream;
        this.m_finisher = finisher;
    }

    @Override
    public Supplier<A> supplier() {
        return this.m_downstream.supplier();
    }

    @Override
    public BiConsumer<A, T> accumulator() {
        return this.m_downstream.accumulator();
    }

    @Override
    public BinaryOperator<A> combiner() {
        return this.m_downstream.combiner();
    }

    @Override
    public Function<A, RR> finisher() {
        Function<R, RR> finisher = this.m_finisher;
        return this.m_downstream.finisher().andThen(finisher);
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        Set<Collector.Characteristics> characteristics = this.m_downstream.characteristics();
        if (characteristics.contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            if (characteristics.size() == 1) {
                characteristics = Collections.emptySet();
            } else {
                characteristics = EnumSet.copyOf(characteristics);
                characteristics.remove((Object)Collector.Characteristics.IDENTITY_FINISH);
                characteristics = Collections.unmodifiableSet(characteristics);
            }
        }
        return characteristics;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_finisher = (Function)ExternalizableHelper.readObject(in);
        this.m_downstream = (RemoteCollector)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_finisher);
        ExternalizableHelper.writeObject(out, this.m_downstream);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_finisher = (Function)in.readObject(0);
        this.m_downstream = (RemoteCollector)in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_finisher);
        out.writeObject(1, this.m_downstream);
    }
}

