/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream.collectors;

import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.json.bind.annotation.JsonbProperty;

public class GroupingByCollector<T, K, D, A, M extends Map<K, D>>
implements RemoteCollector<T, Map<K, A>, M>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="classifier")
    protected Function<? super T, ? extends K> m_classifier;
    @JsonbProperty(value="downstream")
    protected RemoteCollector<? super T, A, D> m_downstream;
    @JsonbProperty(value="mapFactory")
    protected Supplier<M> m_mapFactory;

    public GroupingByCollector() {
    }

    public GroupingByCollector(Remote.Function<? super T, ? extends K> classifier, RemoteCollector<? super T, A, D> downstream, Remote.Supplier<M> mapFactory) {
        this.m_classifier = Lambdas.ensureRemotable(classifier);
        this.m_downstream = downstream;
        this.m_mapFactory = mapFactory;
    }

    @Override
    public Supplier<Map<K, A>> supplier() {
        return HashMap::new;
    }

    @Override
    public BiConsumer<Map<K, A>, T> accumulator() {
        Function classifier = this.m_classifier;
        Supplier supplier = this.m_downstream.supplier();
        BiConsumer accumulator = this.m_downstream.accumulator();
        return (m, t) -> {
            Object key = Objects.requireNonNull(classifier.apply(t), "element cannot be mapped to a null key");
            Object container = m.computeIfAbsent(key, arg_0 -> GroupingByCollector.lambda$accumulator$0((Supplier)supplier, arg_0));
            accumulator.accept(container, t);
        };
    }

    @Override
    public BinaryOperator<Map<K, A>> combiner() {
        return Remote.BinaryOperator.mapMerger(this.m_downstream.combiner());
    }

    @Override
    public Function<Map<K, A>, M> finisher() {
        Supplier mapFactory = this.m_mapFactory;
        Function finisher = this.m_downstream.finisher();
        return m -> {
            Map result = (Map)mapFactory.get();
            m.forEach((k, a) -> result.put(k, finisher.apply(a)));
            return result;
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_classifier = (Function)ExternalizableHelper.readObject(in);
        this.m_downstream = (RemoteCollector)ExternalizableHelper.readObject(in);
        this.m_mapFactory = (Supplier)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_classifier);
        ExternalizableHelper.writeObject(out, this.m_downstream);
        ExternalizableHelper.writeObject(out, this.m_mapFactory);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_classifier = (Function)in.readObject(0);
        this.m_downstream = (RemoteCollector)in.readObject(1);
        this.m_mapFactory = (Supplier)in.readObject(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_classifier);
        out.writeObject(1, this.m_downstream);
        out.writeObject(2, this.m_mapFactory);
    }

    private static /* synthetic */ Object lambda$accumulator$0(Supplier supplier, Object k) {
        return supplier.get();
    }
}

