/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream.collectors;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.LiteSet;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.json.bind.annotation.JsonbProperty;

public class SimpleRemoteCollector<T, A, R>
implements RemoteCollector<T, A, R>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="supplier")
    protected Supplier<A> m_supplier;
    @JsonbProperty(value="accumulator")
    protected BiConsumer<A, T> m_accumulator;
    @JsonbProperty(value="combiner")
    protected BinaryOperator<A> m_combiner;
    @JsonbProperty(value="finisher")
    protected Function<A, R> m_finisher;
    @JsonbProperty(value="characteristics")
    protected Set<Collector.Characteristics> m_characteristics;

    public SimpleRemoteCollector() {
    }

    public SimpleRemoteCollector(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
        this.m_supplier = supplier;
        this.m_accumulator = accumulator;
        this.m_combiner = combiner;
        this.m_finisher = finisher;
        this.m_characteristics = characteristics;
    }

    public SimpleRemoteCollector(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Set<Collector.Characteristics> characteristics) {
        this(supplier, accumulator, combiner, SimpleRemoteCollector.castingIdentity(), characteristics);
    }

    public SimpleRemoteCollector(Remote.Supplier<A> supplier, Remote.BiConsumer<A, T> accumulator, Remote.BinaryOperator<A> combiner, Remote.Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
        this.m_supplier = supplier;
        this.m_accumulator = accumulator;
        this.m_combiner = combiner;
        this.m_finisher = finisher;
        this.m_characteristics = characteristics;
    }

    public SimpleRemoteCollector(Remote.Supplier<A> supplier, Remote.BiConsumer<A, T> accumulator, Remote.BinaryOperator<A> combiner, Set<Collector.Characteristics> characteristics) {
        this(supplier, accumulator, combiner, SimpleRemoteCollector.castingIdentity(), characteristics);
    }

    @Override
    public BiConsumer<A, T> accumulator() {
        return this.m_accumulator;
    }

    @Override
    public Supplier<A> supplier() {
        return this.m_supplier;
    }

    @Override
    public BinaryOperator<A> combiner() {
        return this.m_combiner;
    }

    @Override
    public Function<A, R> finisher() {
        return this.m_finisher;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return this.m_characteristics;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_supplier = (Supplier)ExternalizableHelper.readObject(in);
        this.m_accumulator = (BiConsumer)ExternalizableHelper.readObject(in);
        this.m_combiner = (BinaryOperator)ExternalizableHelper.readObject(in);
        this.m_finisher = (Function)ExternalizableHelper.readObject(in);
        LiteSet set = new LiteSet();
        ExternalizableHelper.readCollection(in, set, null);
        this.m_characteristics = set.size() > 0 ? Collections.unmodifiableSet(EnumSet.copyOf(set)) : Collections.emptySet();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_supplier);
        ExternalizableHelper.writeObject(out, this.m_accumulator);
        ExternalizableHelper.writeObject(out, this.m_combiner);
        ExternalizableHelper.writeObject(out, this.m_finisher);
        ExternalizableHelper.writeCollection(out, this.m_characteristics);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_supplier = (Supplier)in.readObject(0);
        this.m_accumulator = (BiConsumer)in.readObject(1);
        this.m_combiner = (BinaryOperator)in.readObject(2);
        this.m_finisher = (Function)in.readObject(3);
        LiteSet set = new LiteSet();
        in.readCollection(4, set);
        this.m_characteristics = set.size() > 0 ? Collections.unmodifiableSet(EnumSet.copyOf(set)) : Collections.emptySet();
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_supplier);
        out.writeObject(1, this.m_accumulator);
        out.writeObject(2, this.m_combiner);
        out.writeObject(3, this.m_finisher);
        out.writeCollection(4, this.m_characteristics, Collector.Characteristics.class);
    }

    protected static <I, R> Remote.Function<I, R> castingIdentity() {
        return i -> i;
    }
}

