/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.OutputStreaming;
import com.tangosol.util.Base;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class Base64OutputStream
extends OutputStream
implements OutputStreaming {
    protected static final char[] BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    protected static final char BASE64_PAD = '=';
    protected static final char BASE64_LF = '\n';
    protected static final int GROUPS_PER_LINE = 19;
    protected boolean m_fClosed;
    protected Writer m_writer;
    protected boolean m_fBreakLines;
    protected int m_cLineGroups = 19;
    protected byte[] m_abAccum = new byte[3];
    protected int m_cAccum;
    protected char[] m_achGroup = new char[4];

    public Base64OutputStream(Writer writer) {
        this(writer, true);
    }

    public Base64OutputStream(Writer writer, boolean fBreakLines) {
        Base.azzert(writer != null);
        this.m_writer = writer;
        this.m_fBreakLines = fBreakLines;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.m_fClosed) {
            throw new IOException("Base64OutputStream is closed");
        }
        this.m_abAccum[this.m_cAccum++] = (byte)(b & 0xFF);
        if (this.m_cAccum == 3) {
            this.flushAccumulator();
        }
    }

    @Override
    public void write(byte[] ab, int ofb, int cb) throws IOException {
        if (cb > 256) {
            while (this.m_cAccum != 0 || this.m_cLineGroups != 19 && this.m_cLineGroups != 0) {
                this.write(ab[ofb++]);
                --cb;
            }
            if (this.m_cLineGroups == 0) {
                this.m_writer.write(10);
            }
            int cbChunk = this.m_fBreakLines ? 57 : 3;
            int cChunks = cb / cbChunk;
            int cbBlock = cChunks * cbChunk;
            this.m_writer.write(Base64OutputStream.encode(ab, ofb, cbBlock, this.m_fBreakLines));
            ofb += cbBlock;
            cb -= cbBlock;
            if (this.m_fBreakLines) {
                this.m_cLineGroups = 0;
            }
        }
        int ofbEnd = ofb + cb;
        while (ofb < ofbEnd) {
            this.write(ab[ofb++]);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.m_fClosed) {
            throw new IOException("Base64OutputStream is closed");
        }
        this.flushAccumulator();
        this.m_writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.m_fClosed = true;
    }

    protected void flushAccumulator() throws IOException {
        int cAccum = this.m_cAccum;
        if (cAccum == 0) {
            return;
        }
        int cLinesGroups = this.m_cLineGroups;
        if (cLinesGroups == 0) {
            this.m_writer.write(10);
            cLinesGroups = 19;
        }
        byte[] ab = this.m_abAccum;
        char[] ach = this.m_achGroup;
        char[] alpha = BASE64_ALPHABET;
        switch (cAccum) {
            case 1: {
                int n = ab[0] & 0xFF;
                ach[0] = alpha[n >> 2];
                ach[1] = alpha[n << 4 & 0x3F];
                ach[2] = 61;
                ach[3] = 61;
                break;
            }
            case 2: {
                int n = (ab[0] & 0xFF) << 8 | ab[1] & 0xFF;
                ach[0] = alpha[n >> 10];
                ach[1] = alpha[n >> 4 & 0x3F];
                ach[2] = alpha[n << 2 & 0x3F];
                ach[3] = 61;
                break;
            }
            case 3: {
                int n = (ab[0] & 0xFF) << 16 | (ab[1] & 0xFF) << 8 | ab[2] & 0xFF;
                ach[0] = alpha[n >> 18];
                ach[1] = alpha[n >> 12 & 0x3F];
                ach[2] = alpha[n >> 6 & 0x3F];
                ach[3] = alpha[n & 0x3F];
                break;
            }
            default: {
                Base.azzert();
            }
        }
        this.m_writer.write(ach);
        if (this.m_fBreakLines) {
            this.m_cLineGroups = cLinesGroups - 1;
        }
        this.m_cAccum = 0;
    }

    public static char[] encode(byte[] ab) {
        return Base64OutputStream.encode(ab, true);
    }

    public static char[] encode(byte[] ab, boolean fBreakLines) {
        return Base64OutputStream.encode(ab, 0, ab.length, fBreakLines);
    }

    public static char[] encode(byte[] ab, int ofb, int cb, boolean fBreakLines) {
        char[] alpha = BASE64_ALPHABET;
        int cGroups = cb / 3;
        int cbRemain = cb * 4 % 3;
        int cchRaw = (cb + 2) / 3 * 4;
        int cLines = fBreakLines ? (cchRaw - 1) / 76 : 0;
        int cch = cchRaw + cLines;
        char[] ach = new char[cch];
        int ofch = 0;
        if (cGroups > 0) {
            int cLineGroups = fBreakLines ? 19 : -1;
            while (true) {
                int n = (ab[ofb++] & 0xFF) << 16 | (ab[ofb++] & 0xFF) << 8 | ab[ofb++] & 0xFF;
                ach[ofch++] = alpha[n >> 18];
                ach[ofch++] = alpha[n >> 12 & 0x3F];
                ach[ofch++] = alpha[n >> 6 & 0x3F];
                ach[ofch++] = alpha[n & 0x3F];
                if (--cGroups == 0) break;
                if (--cLineGroups != 0) continue;
                ach[ofch++] = 10;
                cLineGroups = 19;
            }
        }
        switch (cbRemain) {
            default: {
                break;
            }
            case 1: {
                int n = ab[ofb] & 0xFF;
                ach[ofch++] = alpha[n >> 2];
                ach[ofch++] = alpha[n << 4 & 0x3F];
                ach[ofch++] = 61;
                ach[ofch++] = 61;
                break;
            }
            case 2: {
                int n = (ab[ofb++] & 0xFF) << 8 | ab[ofb] & 0xFF;
                ach[ofch++] = alpha[n >> 10];
                ach[ofch++] = alpha[n >> 4 & 0x3F];
                ach[ofch++] = alpha[n << 2 & 0x3F];
                ach[ofch++] = 61;
            }
        }
        Base.azzert(ofch == cch);
        return ach;
    }
}

