/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.AbstractReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.nio.ByteBufferOutputStream;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class MultiBufferReadBuffer
extends AbstractReadBuffer {
    private final ReadBuffer[] m_abuf;
    private final int[] m_aofBuffer;
    private final int m_ofStart;
    private final int m_ofEnd;
    private transient int m_ofLastOffset;
    private transient int m_iBufLastAnswer;

    public MultiBufferReadBuffer(ReadBuffer[] abuf) {
        abuf = (ReadBuffer[])abuf.clone();
        int cBuffers = abuf.length;
        int[] aof = new int[cBuffers];
        int cb = 0;
        for (int i = 0; i < cBuffers; ++i) {
            aof[i] = cb;
            int cbBuf = abuf[i].length();
            if (cb + cbBuf < cb) {
                throw new IllegalArgumentException("cumulative buffer length exceeds 2GB");
            }
            cb += cbBuf;
        }
        this.m_abuf = abuf;
        this.m_aofBuffer = aof;
        this.m_ofStart = 0;
        this.m_ofEnd = cb;
    }

    MultiBufferReadBuffer(ReadBuffer[] abuf, int[] aofBuffer, int ofStart, int ofEnd) {
        this.m_abuf = abuf;
        this.m_aofBuffer = aofBuffer;
        this.m_ofStart = ofStart;
        this.m_ofEnd = ofEnd;
    }

    public ReadBuffer.BufferInput getDestructiveBufferInput() {
        return this.instantiateBufferInput(true);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        this.writeTo(new DataOutputStream(out));
    }

    @Override
    public void writeTo(OutputStream out, int of, int cb) throws IOException {
        this.writeTo(new DataOutputStream(out), of, cb);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.writeTo(out, 0, this.length());
    }

    @Override
    public void writeTo(DataOutput out, int of, int cb) throws IOException {
        if (this.length() == 0 || cb == 0) {
            return;
        }
        int iBufFirst = this.getBufferIndexByOffset(of);
        int iBufLast = this.getBufferIndexByOffset(of + cb);
        for (int iBuf = iBufFirst; iBuf <= iBufLast; ++iBuf) {
            ReadBuffer buf = this.getBuffer(iBuf);
            int cbBuf = buf.length();
            if (iBuf == iBufFirst) {
                int ofSrc = this.getBufferOffset(iBuf);
                buf = buf.getReadBuffer(of - ofSrc, cbBuf + ofSrc);
                cbBuf += ofSrc;
            } else if (iBuf == iBufLast) {
                buf = buf.getReadBuffer(0, cb);
            }
            buf.writeTo(out);
            cb -= cbBuf;
        }
    }

    @Override
    public void writeTo(ByteBuffer buf) {
        try {
            this.writeTo(new ByteBufferOutputStream(buf));
        }
        catch (IOException e) {
            throw MultiBufferReadBuffer.ensureRuntimeException(e);
        }
    }

    @Override
    public void writeTo(ByteBuffer buf, int of, int cb) throws IOException {
        this.writeTo(new ByteBufferOutputStream(buf), of, cb);
    }

    @Override
    public int length() {
        return this.m_ofEnd - this.m_ofStart;
    }

    @Override
    public byte byteAt(int of) {
        this.checkBounds(of, 1);
        int iBuf = this.getBufferIndexByOffset(of);
        return this.getBuffer(iBuf).byteAt(of - this.getBufferOffset(iBuf));
    }

    @Override
    public void copyBytes(int ofBegin, int ofEnd, byte[] abDest, int ofDest) {
        int cbDest = ofEnd - ofBegin;
        this.checkBounds(ofBegin, cbDest);
        if (ofDest < 0 || ofDest + cbDest > abDest.length) {
            throw new IndexOutOfBoundsException("ofDest=" + ofDest + ", abDest.length=" + abDest.length + ", bytes requested=" + cbDest);
        }
        int iBuf = this.getBufferIndexByOffset(ofBegin);
        ReadBuffer buf = this.getBuffer(iBuf);
        int ofBuf = this.getBufferOffset(iBuf);
        int ofSrc = ofBegin - ofBuf;
        int cbSrc = Math.min(cbDest, buf.length() - ofSrc);
        buf.copyBytes(ofSrc, ofSrc + cbSrc, abDest, ofDest);
        ofDest += cbSrc;
        cbDest -= cbSrc;
        while (cbDest > 0) {
            buf = this.getBuffer(++iBuf);
            cbSrc = Math.min(cbDest, buf.length());
            buf.copyBytes(0, cbSrc, abDest, ofDest);
            ofDest += cbSrc;
            cbDest -= cbSrc;
        }
    }

    @Override
    public byte[] toByteArray(int of, int cb) {
        this.checkBounds(of, cb);
        if (cb == 0) {
            return NO_BYTES;
        }
        int iBuf = this.getBufferIndexByOffset(of);
        return iBuf == this.getBufferIndexByOffset(of + cb - 1) ? this.getBuffer(iBuf).toByteArray(of - this.getBufferOffset(iBuf), cb) : super.toByteArray(of, cb);
    }

    @Override
    public Binary toBinary(int of, int cb) {
        this.checkBounds(of, cb);
        if (cb == 0) {
            return NO_BINARY;
        }
        int iBuf = this.getBufferIndexByOffset(of);
        return iBuf == this.getBufferIndexByOffset(of + cb - 1) ? this.getBuffer(iBuf).toBinary(of - this.getBufferOffset(iBuf), cb) : super.toBinary(of, cb);
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.toByteBuffer(0, this.length());
    }

    @Override
    public ByteBuffer toByteBuffer(int of, int cb) {
        int iBuf = this.getBufferIndexByOffset(of);
        if (iBuf == this.getBufferIndexByOffset(of + cb - 1)) {
            return this.getBuffer(iBuf).toByteBuffer(of - this.getBufferOffset(iBuf), cb);
        }
        return ByteBuffer.wrap(this.toByteArray(of, cb)).asReadOnlyBuffer();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReadBuffer) {
            int cbThat;
            ReadBuffer bufThat = (ReadBuffer)o;
            int cbThis = this.length();
            if (cbThis != (cbThat = bufThat.length())) {
                return false;
            }
            if (cbThat == 0) {
                return true;
            }
            int iBufFirst = this.getBufferIndexByOffset(0);
            int iBufLast = this.getBufferIndexByOffset(cbThis);
            int of = 0;
            for (int iBuf = iBufFirst; iBuf <= iBufLast; ++iBuf) {
                ReadBuffer buf = this.getBuffer(iBuf);
                int cb = buf.length();
                if (iBuf == iBufFirst) {
                    int ofSrc = this.getBufferOffset(iBuf);
                    buf = buf.getReadBuffer(of - ofSrc, cb + ofSrc);
                    cb += ofSrc;
                } else if (iBuf == iBufLast) {
                    buf = buf.getReadBuffer(0, cbThis - of);
                    cb = cbThis - of;
                }
                if (!buf.equals(bufThat.getReadBuffer(of, cb))) {
                    return false;
                }
                of += cb;
            }
            return true;
        }
        return false;
    }

    @Override
    protected ReadBuffer instantiateReadBuffer(int of, int cb) {
        this.checkBounds(of, cb);
        if (cb == 0) {
            return NO_BINARY;
        }
        int iBufFirst = this.getBufferIndexByOffset(of);
        int iBufLast = this.getBufferIndexByOffset(of + cb - 1);
        of -= this.getBufferOffset(iBufFirst);
        if (iBufFirst == iBufLast) {
            ReadBuffer buf = this.getBuffer(iBufFirst);
            return cb == buf.length() ? buf : buf.getReadBuffer(of, cb);
        }
        int cBuffers = iBufLast - iBufFirst + 1;
        ReadBuffer[] abuf = new ReadBuffer[cBuffers];
        int[] aof = new int[cBuffers];
        int cbTotal = 0;
        for (int i = 0; i < cBuffers; ++i) {
            ReadBuffer buf;
            abuf[i] = buf = this.getBuffer(iBufFirst + i);
            aof[i] = cbTotal;
            cbTotal += buf.length();
        }
        return new MultiBufferReadBuffer(abuf, aof, of, of + cb);
    }

    @Override
    protected ReadBuffer.BufferInput instantiateBufferInput() {
        return this.instantiateBufferInput(false);
    }

    protected ReadBuffer.BufferInput instantiateBufferInput(boolean fDestructive) {
        return new MultiBufferInput(fDestructive);
    }

    protected int getBufferCount() {
        return this.m_abuf.length;
    }

    protected int getBufferOffset(int iBuffer) {
        return this.m_aofBuffer[iBuffer] - this.m_ofStart;
    }

    protected ReadBuffer getBuffer(int iBuffer) {
        ReadBuffer buf = this.m_abuf[iBuffer];
        if (buf == null) {
            throw new IndexOutOfBoundsException("the requested buffer '" + iBuffer + "' has been released");
        }
        return buf;
    }

    protected ReadBuffer releaseBuffer(int iBuffer) {
        ReadBuffer[] abuf = this.m_abuf;
        ReadBuffer buf = this.m_abuf[iBuffer];
        abuf[iBuffer] = null;
        return buf;
    }

    protected int getBufferIndexByOffset(int of) {
        int[] aof = this.m_aofBuffer;
        int cBuffers = aof.length;
        if (cBuffers == 1) {
            return 0;
        }
        int iBuf = 0;
        int iLow = 0;
        boolean fFound = false;
        if ((of += this.m_ofStart) >= this.m_ofLastOffset) {
            iLow = iBuf + 2;
            for (iBuf = this.m_iBufLastAnswer; iBuf < iLow; ++iBuf) {
                if (iBuf + 1 < cBuffers && of >= aof[iBuf + 1]) continue;
                fFound = true;
                break;
            }
        }
        if (!fFound) {
            int iHigh = cBuffers - 1;
            while (iLow <= iHigh) {
                int iRoot = iLow + iHigh >> 1;
                int ofRoot = aof[iRoot];
                if (of == ofRoot) {
                    for (iBuf = iRoot; iBuf < iHigh && ofRoot == aof[iBuf + 1]; ++iBuf) {
                    }
                    break;
                }
                if (of < ofRoot) {
                    iHigh = iRoot - 1;
                    continue;
                }
                iLow = iRoot + 1;
                iBuf = iRoot;
            }
        }
        this.m_ofLastOffset = of;
        this.m_iBufLastAnswer = iBuf;
        return iBuf;
    }

    public final class MultiBufferInput
    extends AbstractReadBuffer.AbstractBufferInput {
        private ReadBuffer.BufferInput m_in;
        protected boolean m_fDestructive;

        public MultiBufferInput() {
            this(false);
        }

        public MultiBufferInput(boolean fDestructive) {
            super(MultiBufferReadBuffer.this);
            this.m_fDestructive = fDestructive;
            this.sync();
        }

        @Override
        public int read() throws IOException {
            int b;
            ReadBuffer.BufferInput in = this.m_in;
            if (in.available() >= 1) {
                b = in.read();
                this.adjustOffsetInternal(1);
            } else {
                b = super.read();
                this.sync();
            }
            return b;
        }

        @Override
        public int read(byte[] ab, int of, int cb) throws IOException {
            int cbActual;
            ReadBuffer.BufferInput in = this.m_in;
            if (in.available() >= cb) {
                cbActual = in.read(ab, of, cb);
                assert (cbActual == cb);
                this.adjustOffsetInternal(cbActual);
            } else {
                cbActual = super.read(ab, of, cb);
                this.sync();
            }
            return cbActual;
        }

        @Override
        public void reset() throws IOException {
            int ofMark = this.getMarkInternal();
            if (ofMark < 0) {
                throw new IOException("not marked");
            }
            ReadBuffer.BufferInput in = this.getIn();
            int of = this.getOffset();
            if (of > ofMark) {
                int cbRewind = of - ofMark;
                int ofCurrent = in.getOffset();
                if (cbRewind < ofCurrent) {
                    in.setOffset(ofCurrent - cbRewind);
                    this.adjustOffsetInternal(-cbRewind);
                    return;
                }
            } else if (of < ofMark) {
                int cbForward = ofMark - of;
                if (cbForward < in.available()) {
                    in.skipBytes(cbForward);
                    this.adjustOffsetInternal(cbForward);
                    return;
                }
            } else {
                return;
            }
            super.reset();
            this.sync();
        }

        @Override
        public int skipBytes(int cb) throws IOException {
            int cbActual;
            ReadBuffer.BufferInput in = this.m_in;
            if (in.available() >= cb) {
                cbActual = in.skipBytes(cb);
                assert (cbActual == cb);
                this.adjustOffsetInternal(cbActual);
            } else {
                cbActual = super.skipBytes(cb);
                this.sync();
            }
            return cbActual;
        }

        @Override
        public byte readByte() throws IOException {
            byte b;
            ReadBuffer.BufferInput in = this.m_in;
            if (in.available() >= 1) {
                b = in.readByte();
                this.adjustOffsetInternal(1);
            } else {
                b = super.readByte();
                this.sync();
            }
            return b;
        }

        @Override
        public short readShort() throws IOException {
            short n;
            ReadBuffer.BufferInput in = this.m_in;
            if (in.available() >= 2) {
                n = in.readShort();
                this.adjustOffsetInternal(2);
            } else {
                n = super.readShort();
                this.sync();
            }
            return n;
        }

        @Override
        public int readUnsignedShort() throws IOException {
            int n;
            ReadBuffer.BufferInput in = this.m_in;
            if (in.available() >= 2) {
                n = in.readUnsignedShort();
                this.adjustOffsetInternal(2);
            } else {
                n = super.readUnsignedShort();
                this.sync();
            }
            return n;
        }

        @Override
        public char readChar() throws IOException {
            char ch;
            ReadBuffer.BufferInput in = this.m_in;
            if (in.available() >= 2) {
                ch = in.readChar();
                this.adjustOffsetInternal(2);
            } else {
                ch = super.readChar();
                this.sync();
            }
            return ch;
        }

        @Override
        public int readInt() throws IOException {
            int n;
            ReadBuffer.BufferInput in = this.getIn();
            if (in.available() >= 4) {
                n = in.readInt();
                this.adjustOffsetInternal(4);
            } else {
                n = super.readInt();
                this.sync();
            }
            return n;
        }

        @Override
        public long readLong() throws IOException {
            long l;
            ReadBuffer.BufferInput in = this.m_in;
            if (in.available() >= 8) {
                l = in.readLong();
                this.adjustOffsetInternal(8);
            } else {
                l = super.readLong();
                this.sync();
            }
            return l;
        }

        @Override
        public float readFloat() throws IOException {
            float fl;
            ReadBuffer.BufferInput in = this.m_in;
            if (in.available() >= 4) {
                fl = in.readFloat();
                this.adjustOffsetInternal(4);
            } else {
                fl = super.readFloat();
                this.sync();
            }
            return fl;
        }

        @Override
        public double readDouble() throws IOException {
            double dfl;
            ReadBuffer.BufferInput in = this.m_in;
            if (in.available() >= 8) {
                dfl = in.readDouble();
                this.adjustOffsetInternal(8);
            } else {
                dfl = super.readDouble();
                this.sync();
            }
            return dfl;
        }

        @Override
        public String readUTF() throws IOException {
            int cbChars;
            ReadBuffer.BufferInput in = this.m_in;
            int cbAvail = in.available();
            if (cbAvail >= 2) {
                int ofBefore = in.getOffset();
                cbChars = in.readUnsignedShort();
                int cbTotal = 2 + cbChars;
                if (cbAvail >= cbTotal) {
                    in.setOffset(ofBefore);
                    String s = in.readUTF();
                    this.adjustOffsetInternal(cbTotal);
                    return s;
                }
                this.adjustOffsetInternal(2);
            } else {
                cbChars = this.readUnsignedShort();
            }
            String s = this.readUTF(cbChars);
            this.sync();
            return s;
        }

        @Override
        public String readSafeUTF() throws IOException {
            int cbChars;
            ReadBuffer.BufferInput in = this.m_in;
            int cbAvail = in.available();
            if (cbAvail >= 5) {
                int ofBefore = in.getOffset();
                cbChars = in.readPackedInt();
                int cbLength = in.getOffset() - ofBefore;
                int cbTotal = cbLength + cbChars;
                if (cbChars > 0 && cbAvail >= cbTotal) {
                    in.setOffset(ofBefore);
                    String s = in.readSafeUTF();
                    this.adjustOffsetInternal(cbTotal);
                    return s;
                }
                this.adjustOffsetInternal(cbLength);
            } else {
                cbChars = this.readPackedInt();
            }
            String s = this.readUTF(cbChars);
            if (cbChars > 0) {
                this.sync();
            }
            return s;
        }

        @Override
        public int readPackedInt() throws IOException {
            int n;
            ReadBuffer.BufferInput in = this.m_in;
            if (in.available() >= 5) {
                int of = in.getOffset();
                n = in.readPackedInt();
                this.adjustOffsetInternal(in.getOffset() - of);
            } else {
                n = super.readPackedInt();
                this.sync();
            }
            return n;
        }

        @Override
        public long readPackedLong() throws IOException {
            long l;
            ReadBuffer.BufferInput in = this.m_in;
            if (in.available() >= 10) {
                int of = in.getOffset();
                l = in.readPackedLong();
                this.adjustOffsetInternal(in.getOffset() - of);
            } else {
                l = super.readPackedLong();
                this.sync();
            }
            return l;
        }

        @Override
        public ReadBuffer readBuffer(int cb) throws IOException {
            ReadBuffer buf;
            ReadBuffer.BufferInput in = this.m_in;
            if (in.available() >= cb) {
                buf = in.readBuffer(cb);
                this.adjustOffsetInternal(cb);
            } else {
                buf = super.readBuffer(cb);
                this.sync();
            }
            return buf;
        }

        @Override
        public void setOffset(int of) {
            block7: {
                ReadBuffer.BufferInput in = this.getIn();
                int ofCur = this.getOffset();
                if (ofCur > of) {
                    int cbRewind = ofCur - of;
                    int ofCurrent = in.getOffset();
                    if (cbRewind < ofCurrent) {
                        in.setOffset(ofCurrent - cbRewind);
                        this.adjustOffsetInternal(-cbRewind);
                        return;
                    }
                } else {
                    if (ofCur < of) {
                        int cbForward = of - ofCur;
                        try {
                            if (cbForward < in.available()) {
                                in.skipBytes(cbForward);
                                this.adjustOffsetInternal(cbForward);
                                return;
                            }
                            break block7;
                        }
                        catch (IOException e) {
                            throw Base.ensureRuntimeException(e);
                        }
                    }
                    return;
                }
            }
            super.setOffset(of);
            this.sync();
        }

        protected ReadBuffer.BufferInput getIn() {
            return this.m_in;
        }

        protected void sync() {
            MultiBufferReadBuffer bufMulti = MultiBufferReadBuffer.this;
            int of = this.getOffset();
            int iBuf = bufMulti.getBufferIndexByOffset(of);
            ReadBuffer buf = bufMulti.getBuffer(iBuf);
            of -= bufMulti.getBufferOffset(iBuf);
            ReadBuffer.BufferInput inPrev = this.m_in;
            if (inPrev != null && buf == inPrev.getBuffer()) {
                inPrev.setOffset(of);
            } else {
                ReadBuffer.BufferInput in;
                if (this.m_fDestructive) {
                    int ofMark = this.getMarkInternal();
                    if (ofMark >= 0) {
                        iBuf = Math.min(iBuf, bufMulti.getBufferIndexByOffset(ofMark) - 1);
                    }
                    while (--iBuf >= 0 && bufMulti.releaseBuffer(iBuf) != null) {
                    }
                }
                this.m_in = in = buf.getBufferInput();
                in.setOffset(of);
            }
        }
    }
}

