/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WriteBuffer;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;

@Named(value="multi")
public class MultiplexingSerializer
implements Serializer,
ClassLoaderAware {
    protected WeakReference<ClassLoader> m_refLoader;
    protected final Serializer[] f_serializers;
    protected final ConcurrentMap<String, Serializer> f_mapTypeToSerializer = new ConcurrentHashMap<String, Serializer>(32);
    protected final Map<String, Serializer> f_idToSerializer;
    protected static final String NULL_TYPE = "NULL";

    public MultiplexingSerializer(Serializer ... serializers) {
        if (serializers == null || serializers.length == 0) {
            throw new IllegalArgumentException("At least one Serializer must be provided.");
        }
        this.f_serializers = (Serializer[])serializers.clone();
        this.f_idToSerializer = new HashMap<String, Serializer>(serializers.length);
        for (Serializer serializer : serializers) {
            if (serializer.getName() == null) {
                String msg = "Serializer '%s' returned a null name";
                throw new IllegalArgumentException(String.format(msg, serializer.getClass().getName()));
            }
            this.f_idToSerializer.put(serializer.getName(), serializer);
        }
    }

    @Override
    public void serialize(WriteBuffer.BufferOutput out, Object o) throws IOException {
        this.doSerialization(out, o, this.f_serializers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(ReadBuffer.BufferInput in, Class<? extends T> clazz) throws IOException {
        SerializationHeader serializationHeader = this.readSerializationHeader(in);
        if (serializationHeader == null) {
            throw new IOException("Unable to read or missing serialization header");
        }
        String serializerName = serializationHeader.getSerializerName();
        Serializer serializer = this.f_idToSerializer.get(serializerName);
        if (serializer == null) {
            throw new IOException(String.format("Unknown serializer '%s'", serializerName));
        }
        int cbPayload = serializationHeader.getLength();
        int nOrig = in.getOffset();
        ReadBuffer buffSub = in.getBuffer().getReadBuffer(nOrig, cbPayload);
        try {
            T t = serializer.deserialize(buffSub.getBufferInput(), clazz);
            return t;
        }
        finally {
            in.setOffset(nOrig + cbPayload);
        }
    }

    @Override
    public String getName() {
        return "multi";
    }

    @Override
    public ClassLoader getContextClassLoader() {
        WeakReference<ClassLoader> refLoader = this.m_refLoader;
        return refLoader == null ? null : (ClassLoader)refLoader.get();
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        assert (this.m_refLoader == null);
        if (loader != null) {
            this.m_refLoader = new WeakReference<ClassLoader>(loader);
            for (Serializer s : this.f_serializers) {
                if (!(s instanceof ClassLoaderAware)) continue;
                ((ClassLoaderAware)((Object)s)).setContextClassLoader(loader);
            }
        }
    }

    public String toString() {
        return this.getName() + ", " + this.getClass().getName() + "{loader=" + this.getContextClassLoader() + ", {serializers=" + Arrays.toString(this.f_serializers) + '}';
    }

    protected void doSerialization(WriteBuffer.BufferOutput out, Object o, Serializer[] serializers) throws IOException {
        String type = o == null ? NULL_TYPE : o.getClass().getName();
        Serializer serializer = (Serializer)this.f_mapTypeToSerializer.get(type);
        int nStart = out.getOffset();
        if (serializer == null) {
            LinkedHashMap<Serializer, Exception> mapError = null;
            for (Serializer s2 : this.f_serializers) {
                try {
                    this.doWrite(out, o, s2);
                    if (this.f_mapTypeToSerializer.put(type, s2) == null) {
                        Logger.fine(() -> String.format("Using serializer '%s' for type '%s'", s2.getName(), type));
                    }
                    return;
                }
                catch (Exception e) {
                    if (mapError == null) {
                        mapError = new LinkedHashMap<Serializer, Exception>(this.f_serializers.length);
                    }
                    mapError.put(s2, e);
                    out.setOffset(nStart);
                    Logger.fine(() -> {
                        String rawMsg = "Unable to serialize type '%s' using serializer '%s'.  This may be expected.";
                        return String.format(rawMsg, type, s2.getName());
                    });
                }
            }
            this.logSerializationErrors(mapError, type);
            throw new IOException(String.format("No valid serializer available for type '%s'", type));
        }
        try {
            this.doWrite(out, o, serializer);
        }
        catch (IOException ioe) {
            Logger.fine(() -> "Unexpected exception raised using cached serializer.  Trying others...", (Throwable)ioe);
            this.f_mapTypeToSerializer.remove(type);
            out.setOffset(nStart);
            this.doSerialization(out, o, (Serializer[])Arrays.stream(serializers).filter(s -> s != serializer).toArray(Serializer[]::new));
        }
    }

    protected void doWrite(WriteBuffer.BufferOutput out, Object o, Serializer serializer) throws IOException {
        int nStart = out.getOffset();
        int nWritten = this.writeSerializationHeader(out, serializer.getName());
        serializer.serialize(out, o);
        int nAfterSer = out.getOffset();
        int nPayload = nAfterSer - (nStart + nWritten);
        out.setOffset(nStart);
        out.writeInt(nPayload);
        out.setOffset(nAfterSer);
    }

    protected void logSerializationErrors(Map<Serializer, Exception> serializerExceptionMap, String typeName) {
        assert (serializerExceptionMap != null && !serializerExceptionMap.isEmpty());
        if (Logger.isEnabled(5)) {
            String msg = "Unable to serialize/deserialize type '%s' using serializer '%s'.";
            for (Map.Entry<Serializer, Exception> entry : serializerExceptionMap.entrySet()) {
                Logger.fine(String.format(msg, typeName, entry.getKey().getName()), (Throwable)entry.getValue());
            }
        }
    }

    protected int writeSerializationHeader(WriteBuffer.BufferOutput out, String serializerName) throws IOException {
        int nOff = out.getOffset();
        out.setOffset(nOff + 4);
        out.writeUTF(serializerName);
        return out.getOffset() - nOff;
    }

    protected SerializationHeader readSerializationHeader(ReadBuffer.BufferInput in) {
        int nOrig = in.getOffset();
        try {
            int cbPayload = in.readInt();
            if (cbPayload < 0) {
                in.setOffset(nOrig);
                return null;
            }
            String serializerName = in.readUTF();
            return new SerializationHeader(cbPayload, serializerName);
        }
        catch (IOException ioe) {
            in.setOffset(nOrig);
            return null;
        }
    }

    protected static final class SerializationHeader {
        protected final int f_nLength;
        protected final String f_serializerName;

        private SerializationHeader(int cbLength, String serializerName) {
            this.f_nLength = cbLength;
            this.f_serializerName = serializerName;
        }

        private int getLength() {
            return this.f_nLength;
        }

        private String getSerializerName() {
            return this.f_serializerName;
        }
    }
}

