/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.internal.net.MessageComponent;
import com.tangosol.io.InputStreaming;
import com.tangosol.io.OutputStreaming;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class WrapperBufferOutput
extends Base
implements WriteBuffer.BufferOutput {
    private final DataOutput m_out;
    private final WriteBuffer.BufferOutput m_bufOut;
    private transient byte[] m_abBuf;

    public WrapperBufferOutput(DataOutput out) {
        this.m_out = out;
        this.m_bufOut = out instanceof WriteBuffer.BufferOutput ? (WriteBuffer.BufferOutput)out : null;
    }

    @Override
    public void write(int b) throws IOException {
        this.m_out.write(b);
    }

    @Override
    public void write(byte[] ab) throws IOException {
        this.m_out.write(ab);
    }

    @Override
    public void write(byte[] ab, int of, int cb) throws IOException {
        this.m_out.write(ab, of, cb);
    }

    @Override
    public void flush() throws IOException {
        DataOutput out = this.m_out;
        if (out instanceof OutputStreaming) {
            ((OutputStreaming)((Object)out)).flush();
        } else if (out instanceof OutputStream) {
            ((OutputStream)((Object)out)).flush();
        } else if (out instanceof ObjectOutput) {
            ((ObjectOutput)out).flush();
        }
    }

    @Override
    public void close() throws IOException {
        DataOutput out = this.m_out;
        if (out instanceof OutputStreaming) {
            ((OutputStreaming)((Object)out)).close();
        } else if (out instanceof OutputStream) {
            ((OutputStream)((Object)out)).close();
        } else if (out instanceof ObjectOutput) {
            ((ObjectOutput)out).close();
        }
    }

    @Override
    public void writeBoolean(boolean f) throws IOException {
        this.m_out.writeBoolean(f);
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.m_out.writeByte(b);
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.m_out.writeShort(n);
    }

    @Override
    public void writeChar(int n) throws IOException {
        this.m_out.writeChar(n);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.m_out.writeInt(n);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.m_out.writeLong(l);
    }

    @Override
    public void writeFloat(float fl) throws IOException {
        this.m_out.writeFloat(fl);
    }

    @Override
    public void writeDouble(double dfl) throws IOException {
        this.m_out.writeDouble(dfl);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.m_out.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.m_out.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.m_out.writeUTF(s);
    }

    @Override
    public WriteBuffer getBuffer() {
        return this.m_bufOut == null ? null : this.m_bufOut.getBuffer();
    }

    @Override
    public void writeSafeUTF(String s) throws IOException {
        WriteBuffer.BufferOutput bufOut = this.m_bufOut;
        if (bufOut == null) {
            ExternalizableHelper.writeSafeUTF(this.m_out, s);
        } else {
            bufOut.writeSafeUTF(s);
        }
    }

    @Override
    public void writePackedInt(int n) throws IOException {
        WriteBuffer.BufferOutput bufOut = this.m_bufOut;
        if (bufOut == null) {
            ExternalizableHelper.writeInt(this.m_out, n);
        } else {
            bufOut.writePackedInt(n);
        }
    }

    @Override
    public void writePackedLong(long l) throws IOException {
        WriteBuffer.BufferOutput bufOut = this.m_bufOut;
        if (bufOut == null) {
            ExternalizableHelper.writeLong(this.m_out, l);
        } else {
            bufOut.writePackedLong(l);
        }
    }

    @Override
    public void writeBuffer(ReadBuffer buf) throws IOException {
        WriteBuffer.BufferOutput bufOut = this.m_bufOut;
        if (bufOut == null) {
            this.write(buf.toByteArray());
        } else {
            bufOut.writeBuffer(buf);
        }
    }

    @Override
    public void writeBuffer(ReadBuffer buf, int of, int cb) throws IOException {
        WriteBuffer.BufferOutput bufOut = this.m_bufOut;
        if (bufOut == null) {
            this.write(buf.toByteArray(of, cb));
        } else {
            bufOut.writeBuffer(buf, of, cb);
        }
    }

    @Override
    public void writeStream(InputStreaming stream) throws IOException {
        WriteBuffer.BufferOutput bufOut = this.m_bufOut;
        if (bufOut == null) {
            byte[] ab = this.getTempBuffer();
            int c = stream.read(ab);
            while (c >= 0) {
                this.write(ab, 0, c);
                c = stream.read(ab);
            }
        } else {
            bufOut.writeStream(stream);
        }
    }

    @Override
    public void writeStream(InputStreaming stream, int cb) throws IOException {
        WriteBuffer.BufferOutput bufOut = this.m_bufOut;
        if (bufOut == null) {
            byte[] ab = this.getTempBuffer();
            int c = stream.read(ab);
            for (int t = 0; c >= 0 && t < cb; t += c) {
                this.write(ab, 0, c);
                c = stream.read(ab);
            }
        } else {
            bufOut.writeStream(stream, cb);
        }
    }

    @Override
    public int getOffset() {
        WriteBuffer.BufferOutput bufOut = this.m_bufOut;
        return bufOut == null ? 0 : bufOut.getOffset();
    }

    @Override
    public void setOffset(int of) {
        WriteBuffer.BufferOutput bufOut = this.m_bufOut;
        if (bufOut == null) {
            throw new UnsupportedOperationException();
        }
        bufOut.setOffset(of);
    }

    public DataOutput getDataOutput() {
        return this.m_out;
    }

    private byte[] getTempBuffer() {
        byte[] abBuf = this.m_abBuf;
        if (abBuf == null) {
            abBuf = this.m_abBuf = new byte[1024];
        }
        return abBuf;
    }

    public static class VersionAwareBufferOutput
    extends WrapperBufferOutput {
        protected final MessageComponent f_message;

        public VersionAwareBufferOutput(DataOutput out, MessageComponent message) {
            super(out);
            this.f_message = message;
        }

        public boolean isVersionCompatible(int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
            return this.f_message.isRecipientCompatible(nMajor, nMinor, nMicro, nPatchSet, nPatch);
        }
    }
}

