/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.jandex.AnnotationInstance;
import com.tangosol.internal.jandex.AnnotationTarget;
import com.tangosol.internal.jandex.AnnotationValue;
import com.tangosol.internal.jandex.DotName;
import com.tangosol.internal.jandex.Index;
import com.tangosol.internal.jandex.IndexReader;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.Evolvable;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofAnnotationSerializer;
import com.tangosol.io.pof.PofBufferReader;
import com.tangosol.io.pof.PofBufferWriter;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.io.pof.PortableObjectSerializer;
import com.tangosol.io.pof.PortableTypeSerializer;
import com.tangosol.io.pof.annotation.Portable;
import com.tangosol.io.pof.schema.annotation.PortableType;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.CopyOnWriteMap;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.LiteMap;
import com.tangosol.util.Resources;
import com.tangosol.util.SafeHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.inject.Named;

@Named(value="pof")
public class ConfigurablePofContext
implements PofContext,
ClassLoaderAware,
XmlConfigurable {
    public static final String PROPERTY_CONFIG = "coherence.pof.config";
    public static final String DEFAULT_RESOURCE = Config.getProperty("coherence.pof.config", "pof-config.xml");
    protected static final Class ROOT_LAMBDA_CLASS = FunctionalInterface.class;
    protected static final String DEFAULT_INDEX_FILE_NAME = "META-INF/jandex.idx";
    private static final Map s_mapConfigurations = new WeakHashMap();
    private WeakReference<ClassLoader> m_refLoader;
    private String m_sUri;
    private XmlElement m_xml;
    private boolean m_fReferenceEnabled;
    private boolean m_fPreferJavaTime;
    private volatile PofConfig m_cfg;
    private String m_sIndexFileName = "META-INF/jandex.idx";

    public ConfigurablePofContext() {
        this((String)null);
    }

    public ConfigurablePofContext(String sLocator) {
        this.m_sUri = sLocator;
    }

    public ConfigurablePofContext(XmlElement xml) {
        this.setConfig(xml);
    }

    public ConfigurablePofContext(ConfigurablePofContext that) {
        this.m_cfg = that.m_cfg;
        this.m_fReferenceEnabled = that.m_fReferenceEnabled;
        this.m_refLoader = that.m_refLoader;
        this.m_sUri = that.m_sUri;
        this.m_xml = that.m_xml;
    }

    @Override
    public XmlElement getConfig() {
        return this.m_xml;
    }

    @Override
    public synchronized void setConfig(XmlElement xml) {
        if (xml != null && !XmlHelper.isEmpty(xml)) {
            this.checkNotInitialized();
            if (this.m_sUri == null) {
                this.m_sUri = "xml:" + Base.toDecString(xml.toString().hashCode() & Integer.MAX_VALUE, 8);
            }
            this.m_xml = xml;
        }
    }

    @Override
    public ClassLoader getContextClassLoader() {
        ClassLoader loader = null;
        WeakReference<ClassLoader> ref = this.m_refLoader;
        if (ref != null && (loader = (ClassLoader)ref.get()) == null) {
            throw new IllegalStateException("ClassLoader is no longer available");
        }
        return loader;
    }

    @Override
    public synchronized void setContextClassLoader(ClassLoader loader) {
        this.checkNotInitialized();
        this.m_refLoader = loader == null ? null : new WeakReference<ClassLoader>(loader);
        this.initialize();
    }

    @Override
    public void serialize(WriteBuffer.BufferOutput out, Object o) throws IOException {
        this.ensureInitialized();
        PofBufferWriter writer = new PofBufferWriter(out, (PofContext)this);
        if (this.isReferenceEnabled() && !(o instanceof Evolvable)) {
            writer.enableReference();
        }
        try {
            writer.writeObject(-1, o);
        }
        catch (RuntimeException e) {
            IOException ioex = new IOException(e.getMessage());
            ioex.initCause(e);
            throw ioex;
        }
    }

    @Override
    public Object deserialize(ReadBuffer.BufferInput in) throws IOException {
        this.ensureInitialized();
        PofBufferReader reader = new PofBufferReader(in, this);
        try {
            return reader.readObject(-1);
        }
        catch (RuntimeException e) {
            IOException ioex = new IOException(e.getMessage());
            ioex.initCause(e);
            throw ioex;
        }
    }

    @Override
    public String getName() {
        return "pof";
    }

    @Override
    public PofSerializer getPofSerializer(int nTypeId) {
        PofSerializer serializer;
        this.ensureInitialized();
        try {
            serializer = this.m_cfg.m_aSerByTypeId[nTypeId];
        }
        catch (IndexOutOfBoundsException e) {
            serializer = null;
        }
        if (serializer == null) {
            throw new IllegalArgumentException("unknown user type: " + nTypeId);
        }
        return serializer;
    }

    @Override
    public int getUserTypeIdentifier(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        return this.getUserTypeIdentifier(o.getClass());
    }

    @Override
    public int getUserTypeIdentifier(Class clz) {
        int nTypeId = this.getUserTypeIdentifierInternal(clz);
        if (nTypeId < 0) {
            throw new IllegalArgumentException("unknown user type: " + clz.getName());
        }
        return nTypeId;
    }

    @Override
    public int getUserTypeIdentifier(String sClass) {
        int nTypeId = this.getUserTypeIdentifierInternal(sClass);
        if (nTypeId < 0) {
            throw new IllegalArgumentException("unknown user type: " + sClass);
        }
        return nTypeId;
    }

    @Override
    public String getClassName(int nTypeId) {
        return (String)this.m_cfg.m_mapClassNameByTypeId.get(nTypeId);
    }

    @Override
    public Class getClass(int nTypeId) {
        String sClass;
        Class clz;
        this.ensureInitialized();
        try {
            clz = (Class)this.m_cfg.m_aClzByTypeId[nTypeId].get();
        }
        catch (IndexOutOfBoundsException e) {
            clz = null;
        }
        if (clz == null && (sClass = (String)this.m_cfg.m_mapClassNameByTypeId.get(nTypeId)) != null && !sClass.isEmpty()) {
            clz = this.loadClass(sClass);
        }
        if (clz == null) {
            throw new IllegalArgumentException("unknown user type: " + nTypeId);
        }
        return clz;
    }

    @Override
    public boolean isUserType(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        return this.isUserType(o.getClass());
    }

    @Override
    public boolean isUserType(Class clz) {
        return this.getUserTypeIdentifierInternal(clz) >= 0;
    }

    @Override
    public boolean isUserType(String sClass) {
        return this.getUserTypeIdentifierInternal(sClass) >= 0;
    }

    @Override
    public boolean isPreferJavaTime() {
        return this.m_fPreferJavaTime;
    }

    protected int getUserTypeIdentifierInternal(Class clz) {
        this.ensureInitialized();
        Integer ITypeId = (Integer)this.m_cfg.m_mapTypeIdByClass.get(clz);
        return ITypeId == null ? this.getInheritedUserTypeIdentifier(clz) : ITypeId.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getInheritedUserTypeIdentifier(Class clz) {
        Map mapClzToId = this.m_cfg.m_mapTypeIdByClass;
        if (clz == null) {
            throw new IllegalArgumentException("class is required");
        }
        if (this.isSubclassAllowed()) {
            for (Class clzSuper = clz.getSuperclass(); clzSuper != null; clzSuper = clzSuper.getSuperclass()) {
                Integer ITypeId = (Integer)mapClzToId.get(clzSuper);
                if (ITypeId == null) continue;
                int nTypeId = ITypeId;
                mapClzToId.put(clz, ITypeId);
                return nTypeId;
            }
        }
        if (this.isInterfaceAllowed()) {
            Map map = mapClzToId;
            synchronized (map) {
                for (Map.Entry entry : mapClzToId.entrySet()) {
                    Class clzCur = (Class)entry.getKey();
                    Integer ICurId = (Integer)entry.getValue();
                    if (clzCur == null || ICurId == null || !clzCur.isInterface() || !clzCur.isAssignableFrom(clz)) continue;
                    int nTypeId = ICurId;
                    mapClzToId.put(clz, ICurId);
                    return nTypeId;
                }
            }
        }
        mapClzToId.put(clz, -1);
        return -1;
    }

    protected int getUserTypeIdentifierInternal(String sClass) {
        this.ensureInitialized();
        int nTypeId = -1;
        Map mapNameToId = this.m_cfg.m_mapTypeIdByClassName;
        Integer ITypeId = (Integer)mapNameToId.get(sClass);
        if (ITypeId == null) {
            if (sClass == null || sClass.length() == 0) {
                throw new IllegalArgumentException("class name is required");
            }
            if ((this.isSubclassAllowed() || this.isInterfaceAllowed() || this.isLambdaAllowed()) && (nTypeId = this.getUserTypeIdentifierInternal(this.loadClass(sClass))) >= 0) {
                mapNameToId.put(sClass, nTypeId);
            }
        } else {
            nTypeId = ITypeId;
        }
        return nTypeId;
    }

    protected boolean isInitialized() {
        return this.m_cfg != null;
    }

    protected String getConfigLocation() {
        return this.m_sUri;
    }

    protected PofConfig getPofConfig() {
        return this.m_cfg;
    }

    protected boolean isInterfaceAllowed() {
        PofConfig cfg = this.m_cfg;
        return cfg != null && cfg.m_fInterfaceAllowed;
    }

    protected boolean isSubclassAllowed() {
        PofConfig cfg = this.m_cfg;
        return cfg != null && cfg.m_fSubclassAllowed;
    }

    protected boolean isLambdaAllowed() {
        PofConfig cfg = this.m_cfg;
        return cfg != null && cfg.m_mapTypeIdByClass.containsKey(ROOT_LAMBDA_CLASS);
    }

    public boolean isReferenceEnabled() {
        return this.m_fReferenceEnabled;
    }

    public void setReferenceEnabled(boolean fReferenceEnabled) {
        this.m_fReferenceEnabled = fReferenceEnabled;
    }

    public void setPreferJavaTime(boolean fPreferJavaTime) {
        this.m_fPreferJavaTime = fPreferJavaTime;
    }

    public void setIndexFileName(String sIndexFile) {
        this.m_sIndexFileName = sIndexFile;
    }

    public String getIndexFileName() {
        return this.m_sIndexFileName;
    }

    public String toString() {
        return this.getClass().getName() + " {location=" + this.m_sUri + '}';
    }

    protected void checkNotInitialized() {
        if (this.m_cfg != null) {
            throw new IllegalStateException("already initialized");
        }
    }

    protected void ensureInitialized() {
        if (this.m_cfg == null) {
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initialize() {
        if (this.m_cfg == null) {
            PofConfig cfg;
            SafeHashMap<String, PofConfig> mapConfigByURI;
            Map mapConfigByLoader;
            Map map = mapConfigByLoader = s_mapConfigurations;
            synchronized (map) {
                ClassLoader loader = this.getContextClassLoader();
                mapConfigByURI = (SafeHashMap<String, PofConfig>)mapConfigByLoader.get(loader);
                if (mapConfigByURI == null) {
                    mapConfigByURI = new SafeHashMap<String, PofConfig>();
                    mapConfigByLoader.put(loader, mapConfigByURI);
                }
            }
            String sURI = this.m_sUri;
            if (sURI == null) {
                this.m_sUri = sURI = DEFAULT_RESOURCE;
            }
            if ((cfg = (PofConfig)mapConfigByURI.get(sURI)) == null) {
                cfg = this.createPofConfig();
                SafeHashMap<String, PofConfig> safeHashMap = mapConfigByURI;
                synchronized (safeHashMap) {
                    if (mapConfigByURI.containsKey(sURI)) {
                        cfg = (PofConfig)mapConfigByURI.get(sURI);
                    } else {
                        mapConfigByURI.put(sURI, cfg);
                    }
                }
            }
            this.m_cfg = cfg;
            this.m_fReferenceEnabled = cfg.m_fReferenceEnabled;
            this.m_fPreferJavaTime = cfg.m_fPreferJavaTime;
        }
    }

    protected PofConfig createPofConfig() {
        Class<?> clz;
        Integer ITypeId;
        int nMinPortableTypeId;
        Map<URL, Index> mapIndexes;
        XmlElement xmlAllTypes;
        String sURI = this.m_sUri;
        XmlElement xmlConfig = this.m_xml;
        int cClasses = 0;
        if (xmlConfig == null) {
            xmlConfig = XmlHelper.loadFileOrResource(sURI, "POF configuration", this.getContextClassLoader());
        }
        if ((xmlAllTypes = xmlConfig.getElement("user-type-list")) == null) {
            this.report(sURI, -1, null, null, "Missing <user-type-list> element");
        }
        ConfigurablePofContext.mergeIncludes(sURI, xmlConfig, this.getContextClassLoader());
        boolean fAllowInterfaces = xmlConfig.getSafeElement("allow-interfaces").getBoolean();
        boolean fAllowSubclasses = xmlConfig.getSafeElement("allow-subclasses").getBoolean();
        boolean fEnableReferences = xmlConfig.getSafeElement("enable-references").getBoolean();
        boolean fEnableTypeDiscovery = xmlConfig.getSafeElement("enable-type-discovery").getBoolean();
        boolean fPreferJavaTime = xmlConfig.getSafeElement("prefer-java-time").getBoolean();
        SafeHashMap<String, Integer> mapPortableTypes = new SafeHashMap<String, Integer>();
        if (fEnableTypeDiscovery && (mapIndexes = this.loadIndexes()).size() > 0) {
            for (Map.Entry<URL, Index> entry : mapIndexes.entrySet()) {
                Index index = entry.getValue();
                cClasses = 0;
                for (AnnotationInstance anno : index.getAnnotations(DotName.createSimple(PortableType.class.getName()))) {
                    if (!anno.target().kind().equals((Object)AnnotationTarget.Kind.CLASS)) continue;
                    AnnotationValue id = anno.value("id");
                    mapPortableTypes.put(anno.target().asClass().toString(), id == null ? -1 : id.asInt());
                    ++cClasses;
                }
                Logger.info(cClasses + " class" + (cClasses != 1 ? "es" : "") + " registered with PortableType annotation from index: " + entry.getKey());
            }
        }
        List listTypes = xmlAllTypes.getElementList();
        int nMaxTypeId = -1;
        boolean fSomeMissing = false;
        boolean fSomePresent = false;
        for (XmlElement xmlType : listTypes) {
            XmlElement xmlId;
            if (!xmlType.getName().equals("user-type")) {
                this.report(sURI, -1, null, null, "<user-type-list> contains an illegal element: " + xmlType.getName());
            }
            if ((xmlId = xmlType.getElement("type-id")) == null) {
                fSomeMissing = true;
                if (!fSomePresent) continue;
                this.report(sURI, -1, null, null, "<user-type-list> contains a <user-type> that is missing a type ID value");
                continue;
            }
            int nTypeId = xmlId.getInt(-1);
            if (nTypeId < 0) {
                this.report(sURI, -1, null, null, "<user-type-list> contains a <user-type> that has a missing or invalid type ID value: " + xmlId.getString(null));
            }
            fSomePresent = true;
            if (fSomeMissing) {
                this.report(sURI, -1, null, null, "<user-type-list> contains a <user-type> that is missing a type ID value");
            }
            if (nTypeId <= nMaxTypeId) continue;
            nMaxTypeId = nTypeId;
        }
        int cPortableTypes = mapPortableTypes.size();
        int nMaxPortableTypeId = cPortableTypes == 0 ? 0 : (Integer)mapPortableTypes.values().stream().reduce(Integer::max).get();
        int n = nMinPortableTypeId = cPortableTypes == 0 ? 0 : (Integer)mapPortableTypes.values().stream().reduce(Integer::min).get();
        if (nMaxPortableTypeId > nMaxTypeId) {
            nMaxTypeId = nMaxPortableTypeId;
        }
        boolean fAutoNumber = fSomeMissing || nMinPortableTypeId == -1;
        int cElements = fAutoNumber ? listTypes.size() + cPortableTypes : nMaxTypeId + 1;
        WeakHashMap mapTypeIdByClass = new WeakHashMap();
        SafeHashMap<String, Integer> mapTypeIdByClassName = new SafeHashMap<String, Integer>();
        SafeHashMap<Integer, String> mapClassNameByTypeId = new SafeHashMap<Integer, String>();
        WeakReference[] aClzByTypeId = new WeakReference[cElements];
        PofSerializer[] aSerByTypeId = new PofSerializer[cElements];
        int cTypeIds = 0;
        for (XmlElement xmlElement : listTypes) {
            PofSerializer<Object> serializer;
            String sClass;
            int nTypeId;
            int n2 = nTypeId = fAutoNumber ? cTypeIds : xmlElement.getElement("type-id").getInt();
            if (aClzByTypeId[nTypeId] != null) {
                this.report(sURI, nTypeId, null, null, "Duplicate user type id");
            }
            if ((sClass = xmlElement.getSafeElement("class-name").getString()) == null || sClass.length() == 0) {
                this.report(sURI, nTypeId, null, null, "Missing class name");
            }
            ITypeId = nTypeId;
            clz = this.loadClass(sURI, sClass, nTypeId);
            this.validateClass(sURI, sClass, clz, nTypeId, fAllowInterfaces, fAllowSubclasses);
            XmlElement xmlSer = xmlElement.getElement("serializer");
            if (xmlSer == null) {
                if (PortableObject.class.isAssignableFrom(clz)) {
                    serializer = clz.isAnnotationPresent(PortableType.class) ? new PortableTypeSerializer(nTypeId, clz) : new PortableObjectSerializer(nTypeId);
                } else {
                    if (clz.getAnnotation(Portable.class) == null) {
                        throw this.report(sURI, nTypeId, clz.getName(), null, "Missing PofSerializer configuration");
                    }
                    serializer = new PofAnnotationSerializer(nTypeId, clz);
                }
            } else {
                serializer = this.instantiateSerializer(xmlSer, nTypeId, clz);
            }
            if (serializer instanceof XmlConfigurable) {
                try {
                    SimpleElement xmlParams = new SimpleElement("config");
                    XmlHelper.transformInitParams(xmlParams, xmlSer.getSafeElement("init-params"));
                    ((XmlConfigurable)((Object)serializer)).setConfig(xmlParams);
                }
                catch (RuntimeException e) {
                    this.report(sURI, nTypeId, sClass, e, "Unable to configure PofSerializer");
                }
            }
            if (serializer instanceof ClassLoaderAware) {
                try {
                    ((ClassLoaderAware)((Object)serializer)).setContextClassLoader(this.getContextClassLoader());
                }
                catch (RuntimeException e) {
                    this.report(sURI, nTypeId, sClass, e, "Unable to set ContextClassLoader for PofSerializer");
                }
            }
            mapTypeIdByClass.put(clz, ITypeId);
            mapTypeIdByClassName.put(sClass, ITypeId);
            mapClassNameByTypeId.put(ITypeId, sClass);
            aClzByTypeId[nTypeId] = new WeakReference(clz);
            aSerByTypeId[nTypeId] = serializer;
            ++cTypeIds;
        }
        for (Map.Entry entry : mapPortableTypes.entrySet()) {
            String sClass = (String)entry.getKey();
            int nTypeId = (Integer)entry.getValue();
            if (nTypeId == -1) {
                nTypeId = cTypeIds++;
            }
            if (mapClassNameByTypeId.containsKey(ITypeId = Integer.valueOf(nTypeId))) {
                this.report(sURI, nTypeId, null, null, "Duplicate user type id from PortableType annotation");
            }
            clz = this.loadClass(sURI, sClass, nTypeId);
            this.validateClass(sURI, sClass, clz, nTypeId, fAllowInterfaces, fAllowSubclasses);
            mapTypeIdByClass.put(clz, ITypeId);
            mapTypeIdByClassName.put(sClass, ITypeId);
            mapClassNameByTypeId.put(ITypeId, sClass);
            aClzByTypeId[nTypeId] = new WeakReference(clz);
            aSerByTypeId[nTypeId] = new PortableTypeSerializer(nTypeId, clz);
        }
        PofConfig cfg = new PofConfig();
        cfg.m_mapTypeIdByClass = new CopyOnWriteMap(mapTypeIdByClass);
        cfg.m_mapTypeIdByClassName = mapTypeIdByClassName;
        cfg.m_mapClassNameByTypeId = mapClassNameByTypeId;
        cfg.m_mapPortableTypes = mapPortableTypes;
        cfg.m_aClzByTypeId = aClzByTypeId;
        cfg.m_aSerByTypeId = aSerByTypeId;
        cfg.m_fInterfaceAllowed = fAllowInterfaces;
        cfg.m_fSubclassAllowed = fAllowSubclasses;
        cfg.m_fReferenceEnabled = fEnableReferences;
        cfg.m_fPreferJavaTime = fPreferJavaTime;
        cfg.m_fEnableTypeDiscovery = fEnableTypeDiscovery;
        return cfg;
    }

    private Class<?> loadClass(String sURI, String sClass, int nTypeId) {
        Class clz;
        try {
            clz = this.loadClass(sClass);
        }
        catch (RuntimeException e) {
            throw this.report(sURI, nTypeId, sClass, e, "Unable to load class for user type");
        }
        return clz;
    }

    private void validateClass(String sURI, String sClass, Class<?> clz, int nTypeId, boolean fAllowInterfaces, boolean fAllowSubclasses) {
        if (clz.isInterface()) {
            if (!fAllowInterfaces) {
                throw this.report(sURI, nTypeId, sClass, null, "User Type cannot be an interface (allow-interfaces=false)");
            }
        } else if (Modifier.isAbstract(clz.getModifiers()) && !fAllowSubclasses) {
            throw this.report(sURI, nTypeId, sClass, null, "User Type cannot be an abstract class (allow-subclasses=false)");
        }
    }

    protected PofSerializer instantiateSerializer(XmlElement xmlSer, int nTypeId, final Class clz) {
        final Integer ITypeId = nTypeId;
        PofSerializer serializer = null;
        String sURI = this.m_sUri;
        if (xmlSer != null) {
            Iterator iterParam;
            Class clzSer;
            String sSerClass = xmlSer.getElement("class-name").getString();
            if (sSerClass == null || sSerClass.length() == 0) {
                this.report(sURI, nTypeId, clz.getName(), null, "Missing PofSerializer class name");
            }
            try {
                clzSer = this.loadClass(sSerClass);
            }
            catch (RuntimeException e) {
                throw this.report(sURI, nTypeId, clz.getName(), e, "Unable to load PofSerializer class: " + sSerClass);
            }
            if (!PofSerializer.class.isAssignableFrom(clzSer)) {
                throw this.report(sURI, nTypeId, clz.getName(), null, "Class is not a PofSerializer: " + sSerClass);
            }
            XmlElement xmlParams = xmlSer.getElement("init-params");
            if (xmlParams == null || (iterParam = xmlParams.getElements("init-param")).hasNext() && ((XmlElement)iterParam.next()).getElement("param-type") == null) {
                try {
                    serializer = (PofSerializer)ClassHelper.newInstance(clzSer, new Object[]{ITypeId, clz, this.getContextClassLoader()});
                }
                catch (Throwable throwable) {
                    try {
                        serializer = (PofSerializer)ClassHelper.newInstance(clzSer, new Object[]{ITypeId, clz});
                    }
                    catch (Throwable throwable2) {
                        try {
                            serializer = (PofSerializer)ClassHelper.newInstance(clzSer, new Object[]{ITypeId});
                        }
                        catch (Throwable throwable3) {
                            try {
                                serializer = (PofSerializer)clzSer.newInstance();
                            }
                            catch (Throwable e) {
                                throw this.report(sURI, nTypeId, clz.getName(), e, "Unable to instantiate PofSerializer class using predefined constructors: " + sSerClass);
                            }
                        }
                    }
                }
            } else {
                Object[] aoParams;
                XmlHelper.ParameterResolver resolver = new XmlHelper.ParameterResolver(){

                    @Override
                    public Object resolveParameter(String sType, String sValue) {
                        if (sValue.equals("{type-id}")) {
                            return ITypeId;
                        }
                        if (sValue.equals("{class-name}")) {
                            return clz.getName();
                        }
                        if (sValue.equals("{class}")) {
                            return clz;
                        }
                        if (sValue.equals("{class-loader}")) {
                            return ConfigurablePofContext.this.getContextClassLoader();
                        }
                        return sValue;
                    }
                };
                try {
                    aoParams = XmlHelper.parseInitParams(xmlParams, resolver);
                }
                catch (RuntimeException e) {
                    throw this.report(sURI, nTypeId, clz.getName(), e, "Error parsing constructor parameters for PofSerializer:" + sSerClass);
                }
                try {
                    serializer = (PofSerializer)ClassHelper.newInstance(clzSer, aoParams);
                }
                catch (Throwable e) {
                    throw this.report(sURI, nTypeId, clz.getName(), e, "Unable to instantiate PofSerializer class: " + sSerClass);
                }
            }
        }
        return serializer;
    }

    protected Class loadClass(String sClass) {
        try {
            return ExternalizableHelper.loadClass(sClass, this.getContextClassLoader(), null);
        }
        catch (ClassNotFoundException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected RuntimeException report(String sURI, int nTypeId, String sClass, Throwable e, String sText) {
        StringBuffer sb = new StringBuffer();
        if (sURI != null && sURI.length() > 0) {
            sb.append("Config=").append(sURI);
        }
        if (nTypeId >= 0) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("Type-Id=").append(nTypeId);
        }
        if (sClass != null && sClass.length() > 0) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("Class-Name=").append(sClass);
        }
        if (sb.length() > 0) {
            sText = sText + " (" + sb + ')';
        }
        throw e == null ? new IllegalStateException(sText) : Base.ensureRuntimeException(e, sText);
    }

    private Map<URL, Index> loadIndexes() {
        LiteMap<URL, Index> mapIndexes = new LiteMap<URL, Index>();
        String sIndexFileName = this.m_sIndexFileName;
        try {
            Iterable<URL> iterUrls = Resources.findResources(sIndexFileName, this.getContextClassLoader());
            for (URL url : iterUrls) {
                try {
                    InputStream input = url.openStream();
                    try {
                        mapIndexes.put(url, new IndexReader(input).read());
                    }
                    finally {
                        if (input == null) continue;
                        input.close();
                    }
                }
                catch (Exception ignore) {
                    Logger.warn("Unable to read Jandex index file " + url + ", error is " + ignore.getMessage());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mapIndexes;
    }

    public static void mergeIncludes(String sURI, XmlElement xmlConfig, ClassLoader loader) {
        boolean fAllowInterfaces = xmlConfig.getSafeElement("allow-interfaces").getBoolean();
        boolean fAllowSubclasses = xmlConfig.getSafeElement("allow-subclasses").getBoolean();
        boolean fEnableReferences = xmlConfig.getSafeElement("enable-references").getBoolean();
        boolean fEnableTypeDiscovery = xmlConfig.getSafeElement("enable-type-discovery").getBoolean();
        XmlElement xmlAllTypes = xmlConfig.getElement("user-type-list");
        ConfigurablePofContext.appendDefaultSerializerToUserTypes(xmlConfig);
        ArrayList<String> listURI = null;
        while (xmlAllTypes.getElement("include") != null) {
            if (listURI == null) {
                listURI = new ArrayList<String>();
                listURI.add(sURI);
            }
            ArrayList<XmlDocument> listInclude = new ArrayList<XmlDocument>();
            Iterator iter = xmlAllTypes.getElements("include");
            while (iter.hasNext()) {
                String string = ((XmlElement)iter.next()).getString();
                iter.remove();
                if (listURI.contains(string)) continue;
                listURI.add(string);
                listInclude.add(XmlHelper.loadFileOrResource(string, "included POF configuration", loader));
            }
            for (XmlElement xmlElement : listInclude) {
                XmlElement xmlIncludeTypes = xmlElement.getSafeElement("user-type-list");
                ConfigurablePofContext.appendDefaultSerializerToUserTypes(xmlElement);
                fAllowInterfaces |= xmlElement.getSafeElement("allow-interfaces").getBoolean();
                fAllowSubclasses |= xmlElement.getSafeElement("allow-subclasses").getBoolean();
                fEnableReferences |= xmlElement.getSafeElement("enable-references").getBoolean();
                fEnableTypeDiscovery |= xmlElement.getSafeElement("enable-type-discovery").getBoolean();
                XmlHelper.addElements(xmlAllTypes, xmlIncludeTypes.getElements("user-type"));
                XmlHelper.addElements(xmlAllTypes, xmlIncludeTypes.getElements("include"));
            }
        }
        xmlConfig.ensureElement("allow-interfaces").setBoolean(fAllowInterfaces);
        xmlConfig.ensureElement("allow-subclasses").setBoolean(fAllowSubclasses);
        xmlConfig.ensureElement("enable-type-discovery").setBoolean(fEnableTypeDiscovery);
        xmlConfig.ensureElement("enable-references").setBoolean(fEnableReferences);
    }

    protected static void appendDefaultSerializerToUserTypes(XmlElement xmlConfig) {
        XmlElement xmlDefaultSerializer = xmlConfig.getElement("default-serializer");
        if (xmlDefaultSerializer != null) {
            XmlElement xmlAllTypes = xmlConfig.getElement("user-type-list");
            Iterator iter = xmlAllTypes.getElements("user-type");
            while (iter.hasNext()) {
                XmlElement xmlType = (XmlElement)iter.next();
                XmlElement xmlSer = xmlType.getElement("serializer");
                if (xmlSer != null) continue;
                XmlElement xmlNewSer = (XmlElement)xmlDefaultSerializer.clone();
                xmlNewSer.setName("serializer");
                xmlType.getElementList().add(xmlNewSer);
            }
        }
    }

    protected static class PofConfig {
        public Map m_mapTypeIdByClass;
        public Map m_mapTypeIdByClassName;
        public WeakReference[] m_aClzByTypeId;
        public PofSerializer[] m_aSerByTypeId;
        public boolean m_fInterfaceAllowed;
        public boolean m_fSubclassAllowed;
        public boolean m_fReferenceEnabled;
        public boolean m_fPreferJavaTime;
        public Map m_mapClassNameByTypeId;
        public Map<String, Integer> m_mapPortableTypes;
        public boolean m_fEnableTypeDiscovery;

        protected PofConfig() {
        }
    }
}

