/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;
import java.util.OptionalInt;

public class OptionalIntSerializer
implements PofSerializer<OptionalInt> {
    @Override
    public void serialize(PofWriter out, OptionalInt value) throws IOException {
        boolean fPresent = value.isPresent();
        out.writeBoolean(0, fPresent);
        if (fPresent) {
            out.writeInt(1, value.getAsInt());
        }
        out.writeRemainder(null);
    }

    @Override
    public OptionalInt deserialize(PofReader in) throws IOException {
        boolean fPresent = in.readBoolean(0);
        OptionalInt value = fPresent ? OptionalInt.of(in.readInt(1)) : OptionalInt.empty();
        in.readRemainder();
        return value;
    }
}

