/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.Evolvable;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.RawDate;
import com.tangosol.io.pof.RawDateTime;
import com.tangosol.io.pof.RawDayTimeInterval;
import com.tangosol.io.pof.RawQuad;
import com.tangosol.io.pof.RawTime;
import com.tangosol.io.pof.RawTimeInterval;
import com.tangosol.io.pof.RawYearMonthInterval;
import com.tangosol.io.pof.WritingPofHandler;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.LongArray;
import com.tangosol.util.WrapperException;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class PofBufferWriter
extends PofHelper
implements PofWriter {
    protected WriteBuffer.BufferOutput m_out;
    protected PofContext m_ctx;
    protected boolean m_fEvolvable;
    protected WritingPofHandler m_handler;
    protected ReferenceLibrary m_refs;

    public PofBufferWriter(WriteBuffer.BufferOutput out, PofContext ctx) {
        PofBufferWriter.azzert(out != null, "BufferOutput cannot be null");
        PofBufferWriter.azzert(ctx != null, "PofContext cannot be null");
        this.m_out = out;
        this.m_ctx = ctx;
        this.m_handler = new WritingPofHandler(out);
    }

    public PofBufferWriter(WritingPofHandler handler, PofContext ctx) {
        PofBufferWriter.azzert(handler != null, "WritingPofHandler cannot be null");
        PofBufferWriter.azzert(ctx != null, "PofContext cannot be null");
        this.m_out = handler.getBufferOutput();
        this.m_ctx = ctx;
        this.m_handler = handler;
    }

    @Override
    public void writeBoolean(int iProp, boolean f) throws IOException {
        this.writeBoolean(iProp, f, false);
    }

    protected void writeBoolean(int iProp, boolean f, boolean fReferenceable) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (fReferenceable) {
                handler.registerIdentity(-1);
            }
            handler.onBoolean(iProp, f);
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeByte(int iProp, byte b) throws IOException {
        this.writeByte(iProp, b, false);
    }

    protected void writeByte(int iProp, byte b, boolean fReferenceable) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (fReferenceable) {
                handler.registerIdentity(-1);
            }
            handler.onOctet(iProp, b);
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeChar(int iProp, char ch) throws IOException {
        this.writeChar(iProp, ch, false);
    }

    protected void writeChar(int iProp, char ch, boolean fReferenceable) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (fReferenceable) {
                handler.registerIdentity(-1);
            }
            handler.onChar(iProp, ch);
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeShort(int iProp, short n) throws IOException {
        this.writeShort(iProp, n, false);
    }

    protected void writeShort(int iProp, short n, boolean fReferenceable) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (fReferenceable) {
                handler.registerIdentity(-1);
            }
            handler.onInt16(iProp, n);
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeInt(int iProp, int n) throws IOException {
        this.writeInt(iProp, n, false);
    }

    protected void writeInt(int iProp, int n, boolean fReferenceable) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (fReferenceable) {
                handler.registerIdentity(-1);
            }
            handler.onInt32(iProp, n);
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeLong(int iProp, long n) throws IOException {
        this.writeLong(iProp, n, false);
    }

    protected void writeLong(int iProp, long n, boolean fReferenceable) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (fReferenceable) {
                handler.registerIdentity(-1);
            }
            handler.onInt64(iProp, n);
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeFloat(int iProp, float fl) throws IOException {
        this.writeFloat(iProp, fl, false);
    }

    protected void writeFloat(int iProp, float fl, boolean fReferenceable) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (fReferenceable) {
                handler.registerIdentity(-1);
            }
            handler.onFloat32(iProp, fl);
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeDouble(int iProp, double dfl) throws IOException {
        this.writeDouble(iProp, dfl, false);
    }

    protected void writeDouble(int iProp, double dfl, boolean fReferenceable) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (fReferenceable) {
                handler.registerIdentity(-1);
            }
            handler.onFloat64(iProp, dfl);
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeBooleanArray(int iProp, boolean[] af) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (af == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = af.length;
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, cElements, -11);
                for (int i = 0; i < cElements; ++i) {
                    handler.onBoolean(i, af[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeByteArray(int iProp, byte[] ab) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (ab == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, ab.length, -12);
                this.getBufferOutput().write(ab);
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeCharArray(int iProp, char[] ach) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (ach == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = ach.length;
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, cElements, -14);
                for (int i = 0; i < cElements; ++i) {
                    handler.onChar(i, ach[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeShortArray(int iProp, short[] an) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (an == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = an.length;
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, cElements, -1);
                for (int i = 0; i < cElements; ++i) {
                    handler.onInt16(i, an[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeIntArray(int iProp, int[] an) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (an == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = an.length;
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, cElements, -2);
                for (int i = 0; i < cElements; ++i) {
                    handler.onInt32(i, an[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeLongArray(int iProp, long[] an) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (an == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = an.length;
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, cElements, -3);
                for (int i = 0; i < cElements; ++i) {
                    handler.onInt64(i, an[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeFloatArray(int iProp, float[] afl) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (afl == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = afl.length;
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, cElements, -5);
                for (int i = 0; i < cElements; ++i) {
                    handler.onFloat32(i, afl[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeDoubleArray(int iProp, double[] adfl) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (adfl == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = adfl.length;
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, cElements, -6);
                for (int i = 0; i < cElements; ++i) {
                    handler.onFloat64(i, adfl[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeBigInteger(int iProp, BigInteger n) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (n == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onInt128(iProp, n);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeRawQuad(int iProp, RawQuad qfl) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (qfl == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onFloat128(iProp, qfl);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeBigDecimal(int iProp, BigDecimal dec) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dec == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                switch (PofBufferWriter.calcDecimalSize(dec)) {
                    case 4: {
                        handler.onDecimal32(iProp, dec);
                        break;
                    }
                    case 8: {
                        handler.onDecimal64(iProp, dec);
                        break;
                    }
                    case 16: {
                        handler.onDecimal128(iProp, dec);
                        break;
                    }
                    default: {
                        throw PofBufferWriter.azzert();
                    }
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeBinary(int iProp, Binary bin) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (bin == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onOctetString(iProp, bin);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeString(int iProp, String s) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (s == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onCharString(iProp, s);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeDate(int iProp, Date dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onDate(iProp, dt.getYear() + 1900, dt.getMonth() + 1, dt.getDate());
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeDate(int iProp, LocalDate dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onDate(iProp, dt.getYear(), dt.getMonthValue(), dt.getDayOfMonth());
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeDateTime(int iProp, Date dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                dt = PofBufferWriter.fixNanos(dt);
                handler.onDateTime(iProp, dt.getYear() + 1900, dt.getMonth() + 1, dt.getDate(), dt.getHours(), dt.getMinutes(), dt.getSeconds(), PofBufferWriter.getNanos(dt), false);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeDateTime(int iProp, LocalDateTime dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onDateTime(iProp, dt.getYear(), dt.getMonthValue(), dt.getDayOfMonth(), dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getNano(), false);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeDateTime(int iProp, Timestamp dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onDateTime(iProp, dt.getYear() + 1900, dt.getMonth() + 1, dt.getDate(), dt.getHours(), dt.getMinutes(), dt.getSeconds(), dt.getNanos(), false);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeDateTimeWithZone(int iProp, Date dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                dt = PofBufferWriter.fixNanos(dt);
                int cMinuteOff = -dt.getTimezoneOffset();
                if (cMinuteOff == 0) {
                    handler.onDateTime(iProp, dt.getYear() + 1900, dt.getMonth() + 1, dt.getDate(), dt.getHours(), dt.getMinutes(), dt.getSeconds(), PofBufferWriter.getNanos(dt), true);
                } else {
                    int cHourOff = cMinuteOff / 60;
                    cMinuteOff = Math.abs(cMinuteOff);
                    handler.onDateTime(iProp, dt.getYear() + 1900, dt.getMonth() + 1, dt.getDate(), dt.getHours(), dt.getMinutes(), dt.getSeconds(), PofBufferWriter.getNanos(dt), cHourOff, cHourOff == 0 ? cMinuteOff : cMinuteOff % 60);
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeDateTimeWithZone(int iProp, OffsetDateTime dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                ZoneOffset of = dt.getOffset();
                if (ZoneOffset.UTC.equals(of)) {
                    handler.onDateTime(iProp, dt.getYear(), dt.getMonthValue(), dt.getDayOfMonth(), dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getNano(), true);
                } else {
                    int cMinuteOff = of.getTotalSeconds() / 60;
                    int cHourOff = cMinuteOff / 60;
                    cMinuteOff = Math.abs(cMinuteOff);
                    handler.onDateTime(iProp, dt.getYear(), dt.getMonthValue(), dt.getDayOfMonth(), dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getNano(), cHourOff, cHourOff == 0 ? cMinuteOff : cMinuteOff % 60);
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeDateTimeWithZone(int iProp, Timestamp dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                int cMinuteOff = -dt.getTimezoneOffset();
                if (cMinuteOff == 0) {
                    handler.onDateTime(iProp, dt.getYear() + 1900, dt.getMonth() + 1, dt.getDate(), dt.getHours(), dt.getMinutes(), dt.getSeconds(), dt.getNanos(), true);
                } else {
                    int cHourOff = cMinuteOff / 60;
                    cMinuteOff = Math.abs(cMinuteOff);
                    handler.onDateTime(iProp, dt.getYear() + 1900, dt.getMonth() + 1, dt.getDate(), dt.getHours(), dt.getMinutes(), dt.getSeconds(), dt.getNanos(), cHourOff, cHourOff == 0 ? cMinuteOff : cMinuteOff % 60);
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeTime(int iProp, Date dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                dt = PofBufferWriter.fixNanos(dt);
                handler.onTime(iProp, dt.getHours(), dt.getMinutes(), dt.getSeconds(), PofBufferWriter.getNanos(dt), false);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeTime(int iProp, LocalTime dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onTime(iProp, dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getNano(), false);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeTime(int iProp, Timestamp dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onTime(iProp, dt.getHours(), dt.getMinutes(), dt.getSeconds(), dt.getNanos(), false);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeTimeWithZone(int iProp, Date dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                dt = PofBufferWriter.fixNanos(dt);
                int cMinuteOff = -dt.getTimezoneOffset();
                if (cMinuteOff == 0) {
                    handler.onTime(iProp, dt.getHours(), dt.getMinutes(), dt.getSeconds(), PofBufferWriter.getNanos(dt), true);
                } else {
                    int cHourOff = cMinuteOff / 60;
                    cMinuteOff = Math.abs(cMinuteOff);
                    handler.onTime(iProp, dt.getHours(), dt.getMinutes(), dt.getSeconds(), PofBufferWriter.getNanos(dt), cHourOff, cHourOff == 0 ? cMinuteOff : cMinuteOff % 60);
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeTimeWithZone(int iProp, OffsetTime dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                ZoneOffset of = dt.getOffset();
                if (ZoneOffset.UTC.equals(of)) {
                    handler.onTime(iProp, dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getNano(), true);
                } else {
                    int cMinuteOff = of.getTotalSeconds() / 60;
                    int cHourOff = cMinuteOff / 60;
                    cMinuteOff = Math.abs(cMinuteOff);
                    handler.onTime(iProp, dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getNano(), cHourOff, cHourOff == 0 ? cMinuteOff : cMinuteOff % 60);
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeTimeWithZone(int iProp, Timestamp dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                int cMinuteOff = -dt.getTimezoneOffset();
                if (cMinuteOff == 0) {
                    handler.onTime(iProp, dt.getHours(), dt.getMinutes(), dt.getSeconds(), dt.getNanos(), true);
                } else {
                    int cHourOff = cMinuteOff / 60;
                    cMinuteOff = Math.abs(cMinuteOff);
                    handler.onTime(iProp, dt.getHours(), dt.getMinutes(), dt.getSeconds(), dt.getNanos(), cHourOff, cHourOff == 0 ? cMinuteOff : cMinuteOff % 60);
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeRawDate(int iProp, RawDate date) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (date == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onDate(iProp, date.getYear(), date.getMonth(), date.getDay());
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeRawTime(int iProp, RawTime time) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (time == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                if (time.hasTimezone()) {
                    if (time.isUTC()) {
                        handler.onTime(iProp, time.getHour(), time.getMinute(), time.getSecond(), time.getNano(), true);
                    } else {
                        handler.onTime(iProp, time.getHour(), time.getMinute(), time.getSecond(), time.getNano(), time.getHourOffset(), time.getMinuteOffset());
                    }
                } else {
                    handler.onTime(iProp, time.getHour(), time.getMinute(), time.getSecond(), time.getNano(), false);
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeRawDateTime(int iProp, RawDateTime dt) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (dt == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                RawDate date = dt.getRawDate();
                RawTime time = dt.getRawTime();
                if (time.hasTimezone()) {
                    if (time.isUTC()) {
                        handler.onDateTime(iProp, date.getYear(), date.getMonth(), date.getDay(), time.getHour(), time.getMinute(), time.getSecond(), time.getNano(), true);
                    } else {
                        handler.onDateTime(iProp, date.getYear(), date.getMonth(), date.getDay(), time.getHour(), time.getMinute(), time.getSecond(), time.getNano(), time.getHourOffset(), time.getMinuteOffset());
                    }
                } else {
                    handler.onDateTime(iProp, date.getYear(), date.getMonth(), date.getDay(), time.getHour(), time.getMinute(), time.getSecond(), time.getNano(), false);
                }
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeRawYearMonthInterval(int iProp, RawYearMonthInterval interval) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (interval == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onYearMonthInterval(iProp, interval.getYears(), interval.getMonths());
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeRawTimeInterval(int iProp, RawTimeInterval interval) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (interval == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onTimeInterval(iProp, interval.getHours(), interval.getMinutes(), interval.getSeconds(), interval.getNanos());
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeRawDayTimeInterval(int iProp, RawDayTimeInterval interval) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (interval == null) {
                handler.onNullReference(iProp);
            } else {
                handler.registerIdentity(-1);
                handler.onDayTimeInterval(iProp, interval.getDays(), interval.getHours(), interval.getMinutes(), interval.getSeconds(), interval.getNanos());
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public void writeObject(int iProp, Object o) throws IOException {
        switch (PofBufferWriter.getJavaTypeId(o, this.getPofContext())) {
            case 0: {
                this.beginProperty(iProp);
                try {
                    WritingPofHandler handler = this.getPofHandler();
                    handler.registerIdentity(-1);
                    handler.onNullReference(iProp);
                }
                catch (Exception e) {
                    this.onException(e);
                }
                this.endProperty(iProp);
                break;
            }
            case 1: {
                this.writeBoolean(iProp, (Boolean)o, true);
                break;
            }
            case 2: {
                this.writeByte(iProp, (Byte)o, true);
                break;
            }
            case 3: {
                this.writeChar(iProp, ((Character)o).charValue(), true);
                break;
            }
            case 4: {
                this.writeShort(iProp, (Short)o, true);
                break;
            }
            case 5: {
                this.writeInt(iProp, (Integer)o, true);
                break;
            }
            case 6: {
                this.writeLong(iProp, (Long)o, true);
                break;
            }
            case 7: {
                this.writeBigInteger(iProp, (BigInteger)o);
                break;
            }
            case 8: {
                this.writeFloat(iProp, ((Float)o).floatValue(), true);
                break;
            }
            case 9: {
                this.writeDouble(iProp, (Double)o, true);
                break;
            }
            case 10: {
                this.writeRawQuad(iProp, (RawQuad)o);
                break;
            }
            case 11: {
                this.writeBigDecimal(iProp, (BigDecimal)o);
                break;
            }
            case 12: {
                this.writeBinary(iProp, ((ReadBuffer)o).toBinary());
                break;
            }
            case 13: {
                this.writeString(iProp, (String)o);
                break;
            }
            case 14: {
                this.writeDate(iProp, (Date)o);
                break;
            }
            case 37: {
                this.writeDate(iProp, (LocalDate)o);
                break;
            }
            case 15: {
                this.writeTimeWithZone(iProp, (Date)o);
                break;
            }
            case 38: {
                this.writeTime(iProp, (LocalTime)o);
                break;
            }
            case 40: {
                this.writeTimeWithZone(iProp, (OffsetTime)o);
                break;
            }
            case 16: {
                this.writeDateTimeWithZone(iProp, (Date)o);
                break;
            }
            case 39: {
                this.writeDateTime(iProp, (LocalDateTime)o);
                break;
            }
            case 41: {
                this.writeDateTimeWithZone(iProp, (OffsetDateTime)o);
                break;
            }
            case 42: {
                this.writeDateTimeWithZone(iProp, (ZonedDateTime)o);
                break;
            }
            case 17: {
                this.writeDateTimeWithZone(iProp, (Timestamp)o);
                break;
            }
            case 18: {
                this.writeRawDate(iProp, (RawDate)o);
                break;
            }
            case 19: {
                this.writeRawTime(iProp, (RawTime)o);
                break;
            }
            case 20: {
                this.writeRawDateTime(iProp, (RawDateTime)o);
                break;
            }
            case 21: {
                this.writeRawYearMonthInterval(iProp, (RawYearMonthInterval)o);
                break;
            }
            case 22: {
                this.writeRawTimeInterval(iProp, (RawTimeInterval)o);
                break;
            }
            case 23: {
                this.writeRawDayTimeInterval(iProp, (RawDayTimeInterval)o);
                break;
            }
            case 24: {
                this.writeBooleanArray(iProp, (boolean[])o);
                break;
            }
            case 25: {
                this.writeByteArray(iProp, (byte[])o);
                break;
            }
            case 26: {
                this.writeCharArray(iProp, (char[])o);
                break;
            }
            case 27: {
                this.writeShortArray(iProp, (short[])o);
                break;
            }
            case 28: {
                this.writeIntArray(iProp, (int[])o);
                break;
            }
            case 29: {
                this.writeLongArray(iProp, (long[])o);
                break;
            }
            case 30: {
                this.writeFloatArray(iProp, (float[])o);
                break;
            }
            case 31: {
                this.writeDoubleArray(iProp, (double[])o);
                break;
            }
            case 32: {
                this.writeObjectArray(iProp, (Object[])o);
                break;
            }
            case 33: {
                this.writeLongArray(iProp, (LongArray)o);
                break;
            }
            case 34: {
                this.writeCollection(iProp, (Collection)o);
                break;
            }
            case 35: {
                this.writeMap(iProp, (Map)o);
                break;
            }
            default: {
                this.writeUserType(iProp, o);
            }
        }
    }

    protected void writeUserType(int iProp, Object o) throws IOException {
        o = ExternalizableHelper.replace(o);
        boolean fEvolvableOld = this.isEvolvable();
        boolean fEvolvable = fEvolvableOld || o instanceof Evolvable;
        this.setEvolvable(fEvolvable);
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            int iRef = -1;
            boolean fRef = false;
            ReferenceLibrary refs = this.m_refs;
            if (refs != null && !fEvolvable) {
                iRef = refs.getIdentity(o);
                if (iRef < 0) {
                    iRef = refs.registerReference(o);
                } else {
                    fRef = true;
                }
            }
            if (fRef) {
                handler.onIdentityReference(iProp, iRef);
            } else {
                PofContext ctx = this.getPofContext();
                int nTypeId = ctx.getUserTypeIdentifier(o);
                UserTypeWriter writer = new UserTypeWriter(this, this.getPofHandler(), ctx, nTypeId, iProp, iRef);
                if (refs != null && !fEvolvable) {
                    writer.enableReference();
                }
                ctx.getPofSerializer(nTypeId).serialize(writer, o);
                writer.closeNested();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
        this.setEvolvable(fEvolvableOld);
    }

    @Override
    public <T> void writeObjectArray(int iProp, T[] ao) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (ao == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = ao.length;
                handler.registerIdentity(-1);
                handler.beginArray(iProp, cElements);
                for (int i = 0; i < cElements; ++i) {
                    this.writeObject(i, ao[i]);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public <T> void writeObjectArray(int iProp, T[] ao, Class<? extends T> clz) throws IOException {
        int c;
        int n = c = ao == null ? 0 : ao.length;
        for (int i = 0; i < c; ++i) {
            if (ao[i] != null) continue;
            this.writeObjectArray(iProp, ao);
            return;
        }
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (ao == null) {
                handler.onNullReference(iProp);
            } else {
                int nTypeId = PofBufferWriter.getPofTypeId(clz, this.getPofContext());
                int cElements = ao.length;
                handler.registerIdentity(-1);
                handler.beginUniformArray(iProp, cElements, nTypeId);
                for (int i = 0; i < cElements; ++i) {
                    T o = ao[i];
                    PofBufferWriter.assertEqual(clz, o.getClass());
                    this.writeObject(i, o);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public <T> void writeCollection(int iProp, Collection<? extends T> coll) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (coll == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = coll.size();
                int cWritten = 0;
                handler.registerIdentity(-1);
                handler.beginCollection(iProp, cElements);
                Iterator<T> iter = coll.iterator();
                while (iter.hasNext()) {
                    this.writeObject(cWritten, iter.next());
                    ++cWritten;
                }
                if (cWritten != cElements) {
                    throw new IOException("expected to write " + cElements + " objects but actually wrote " + cWritten);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public <T> void writeCollection(int iProp, Collection<? extends T> coll, Class<? extends T> clz) throws IOException {
        if (coll != null) {
            try {
                if (coll.contains(null)) {
                    this.writeCollection(iProp, coll);
                    return;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (coll == null) {
                handler.onNullReference(iProp);
            } else {
                int nTypeId = PofBufferWriter.getPofTypeId(clz, this.getPofContext());
                int cElements = coll.size();
                int cWritten = 0;
                handler.registerIdentity(-1);
                handler.beginUniformCollection(iProp, cElements, nTypeId);
                for (T o : coll) {
                    PofBufferWriter.assertEqual(clz, o.getClass());
                    this.writeObject(cWritten, o);
                    ++cWritten;
                }
                if (cWritten != cElements) {
                    throw new IOException("expected to write " + cElements + " objects but actually wrote " + cWritten);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeLongArray(int iProp, LongArray la) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (la == null) {
                handler.onNullReference(iProp);
            } else {
                long nSize = la.getLastIndex() + 1L;
                int cElements = la.getSize();
                int cWritten = 0;
                if (cElements > 0 && (la.getFirstIndex() < 0L || nSize > Integer.MAX_VALUE)) {
                    throw new IndexOutOfBoundsException("cannot encode LongArray[" + la.getFirstIndex() + ", " + la.getLastIndex() + "] as a POF sparse array");
                }
                handler.registerIdentity(-1);
                handler.beginSparseArray(iProp, (int)nSize);
                Iterator iter = la.iterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    int n = (int)iter.getIndex();
                    this.writeObject(n, o);
                    ++cWritten;
                }
                if (cWritten != cElements) {
                    throw new IOException("expected to write " + cElements + " objects but actually wrote " + cWritten);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeLongArray(int iProp, LongArray la, Class clz) throws IOException {
        if (la != null && la.contains(null)) {
            this.writeLongArray(iProp, la);
            return;
        }
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (la == null) {
                handler.onNullReference(iProp);
            } else {
                long nSize = la.getLastIndex() + 1L;
                int nTypeId = PofBufferWriter.getPofTypeId(clz, this.getPofContext());
                int cElements = la.getSize();
                int cWritten = 0;
                if (cElements > 0 && (la.getFirstIndex() < 0L || nSize > Integer.MAX_VALUE)) {
                    throw new IndexOutOfBoundsException("cannot encode LongArray[" + la.getFirstIndex() + ", " + la.getLastIndex() + "] as a POF sparse array");
                }
                handler.registerIdentity(-1);
                handler.beginUniformSparseArray(iProp, (int)nSize, nTypeId);
                Iterator iter = la.iterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    int n = (int)iter.getIndex();
                    PofBufferWriter.assertEqual(clz, o.getClass());
                    this.writeObject(n, o);
                    ++cWritten;
                }
                if (cWritten != cElements) {
                    throw new IOException("expected to write " + cElements + " objects but actually wrote " + cWritten);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public <K, V> void writeMap(int iProp, Map<? extends K, ? extends V> map) throws IOException {
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (map == null) {
                handler.onNullReference(iProp);
            } else {
                int cElements = map.size();
                int cWritten = 0;
                handler.registerIdentity(-1);
                handler.beginMap(iProp, cElements);
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    K oKey = entry.getKey();
                    V oValue = entry.getValue();
                    this.writeObject(cWritten, oKey);
                    this.writeObject(cWritten, oValue);
                    ++cWritten;
                }
                if (cWritten != cElements) {
                    throw new IOException("expected to write " + cElements + " objects but actually wrote " + cWritten);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public <K, V> void writeMap(int iProp, Map<K, ? extends V> map, Class<? extends K> clzKey) throws IOException {
        if (map != null) {
            try {
                if (map.containsKey(null)) {
                    this.writeMap(iProp, map);
                    return;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (map == null) {
                handler.onNullReference(iProp);
            } else {
                int nTypeId = PofBufferWriter.getPofTypeId(clzKey, this.getPofContext());
                int cElements = map.size();
                int cWritten = 0;
                handler.registerIdentity(-1);
                handler.beginUniformKeysMap(iProp, cElements, nTypeId);
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    K oKey = entry.getKey();
                    V oValue = entry.getValue();
                    PofBufferWriter.assertEqual(clzKey, oKey.getClass());
                    this.writeObject(cWritten, oKey);
                    this.writeObject(cWritten, oValue);
                    ++cWritten;
                }
                if (cWritten != cElements) {
                    throw new IOException("expected to write " + cElements + " objects but actually wrote " + cWritten);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    @Override
    public <K, V> void writeMap(int iProp, Map<K, V> map, Class<? extends K> clzKey, Class<? extends V> clzValue) throws IOException {
        if (map != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                if (entry.getKey() != null && entry.getValue() != null) continue;
                this.writeMap(iProp, map);
                return;
            }
        }
        this.beginProperty(iProp);
        try {
            WritingPofHandler handler = this.getPofHandler();
            if (map == null) {
                handler.onNullReference(iProp);
            } else {
                PofContext ctx = this.getPofContext();
                int nTypeIdKey = PofBufferWriter.getPofTypeId(clzKey, ctx);
                int nTypeIdValue = PofBufferWriter.getPofTypeId(clzValue, ctx);
                int cElements = map.size();
                int cWritten = 0;
                handler.registerIdentity(-1);
                handler.beginUniformMap(iProp, cElements, nTypeIdKey, nTypeIdValue);
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    K oKey = entry.getKey();
                    V oValue = entry.getValue();
                    PofBufferWriter.assertEqual(clzKey, oKey.getClass());
                    PofBufferWriter.assertEqual(clzValue, oValue.getClass());
                    this.writeObject(cWritten, oKey);
                    this.writeObject(cWritten, oValue);
                    ++cWritten;
                }
                if (cWritten != cElements) {
                    throw new IOException("expected to write " + cElements + " objects but actually wrote " + cWritten);
                }
                handler.endComplexValue();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
        this.endProperty(iProp);
    }

    public void writeOptionalInt(int iProp, OptionalInt n) throws IOException {
    }

    public void writeOptionalLong(int iProp, OptionalLong n) throws IOException {
    }

    public void writeOptionalDouble(int iProp, OptionalDouble n) throws IOException {
    }

    public <T> void writeOptional(int iProp, Optional<T> o) throws IOException {
    }

    @Override
    public PofContext getPofContext() {
        return this.m_ctx;
    }

    @Override
    public void setPofContext(PofContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("PofContext cannot be null");
        }
        this.m_ctx = ctx;
    }

    @Override
    public int getUserTypeId() {
        return -1;
    }

    @Override
    public int getVersionId() {
        throw new IllegalStateException("not in a user type");
    }

    @Override
    public void setVersionId(int nVersionId) {
        throw new IllegalStateException("not in a user type");
    }

    @Override
    public PofWriter createNestedPofWriter(int iProp) throws IOException {
        throw new IllegalStateException("not in a user type");
    }

    @Override
    public PofWriter createNestedPofWriter(int iProp, int nTypeId) throws IOException {
        throw new IllegalStateException("not in a user type");
    }

    @Override
    public void writeRemainder(Binary binProps) throws IOException {
        throw new IllegalStateException("not in a user type");
    }

    protected PofBufferWriter getParentWriter() {
        return null;
    }

    protected void beginProperty(int iProp) throws IOException {
        if (iProp > 0 && this.getPofHandler().getComplex() == null) {
            throw new IllegalArgumentException("not in a complex type");
        }
    }

    protected void endProperty(int iProp) {
    }

    protected void onException(Exception e) throws IOException {
        Throwable eOrig;
        if (e instanceof WrapperException && (eOrig = ((WrapperException)e).getOriginalException()) instanceof IOException) {
            throw (IOException)eOrig;
        }
        throw PofBufferWriter.ensureRuntimeException(e);
    }

    protected static Date fixNanos(Date dt) {
        long cTime = dt.getTime();
        return cTime < 0L && cTime % 1000L != 0L ? new Timestamp(cTime) : dt;
    }

    protected static int getNanos(Date dt) {
        return dt instanceof Timestamp ? ((Timestamp)dt).getNanos() : (int)(dt.getTime() % 1000L) * 1000000;
    }

    protected static void assertEqual(Class clz, Class clzTest) {
        if (!clz.equals(clzTest)) {
            throw new IllegalArgumentException("illegal class \"" + clzTest.getName() + "\"; expected \"" + clz.getName() + '\"');
        }
    }

    protected WriteBuffer.BufferOutput getBufferOutput() {
        return this.m_out;
    }

    protected WritingPofHandler getPofHandler() {
        return this.m_handler;
    }

    public void enableReference() {
        if (this.m_refs == null) {
            this.m_refs = new ReferenceLibrary();
        }
    }

    public boolean isReferenceEnabled() {
        return this.m_refs != null;
    }

    protected boolean isEvolvable() {
        return this.m_fEvolvable;
    }

    protected void setEvolvable(boolean fEvolvable) {
        this.m_fEvolvable = fEvolvable;
    }

    public static void main(String[] args) {
        System.out.println(Integer.highestOneBit(0));
        System.out.println(Integer.highestOneBit(0));
    }

    public static class ReferenceLibrary {
        private int m_cRefs;
        protected IdentityHashMap m_mapIdentities = new IdentityHashMap();

        public int getIdentity(Object o) {
            Integer I = (Integer)this.m_mapIdentities.get(o);
            return I == null ? -1 : I;
        }

        public int registerReference(Object o) {
            int iRef;
            Integer IOld;
            IdentityHashMap mapIdentities = this.m_mapIdentities;
            ++this.m_cRefs;
            if ((IOld = mapIdentities.put(o, iRef = this.m_cRefs--)) != null) {
                mapIdentities.put(o, IOld);
                throw new IllegalStateException("object already registered");
            }
            return iRef;
        }
    }

    public static class UserTypeWriter
    extends PofBufferWriter {
        private PofBufferWriter m_writerParent;
        protected int m_nTypeId;
        protected int m_nVersionId;
        protected int m_iProp;
        protected int m_nId = -1;
        protected int m_iPrevProp = -1;
        protected boolean m_fUserTypeBegin;
        protected boolean m_fUserTypeEnd;
        protected WritingPofHandler.Complex m_complex;
        protected UserTypeWriter m_writerNested;

        public UserTypeWriter(WriteBuffer.BufferOutput out, PofContext ctx, int nTypeId, int iProp) {
            this(null, out, ctx, nTypeId, iProp);
        }

        public UserTypeWriter(PofBufferWriter parent, WriteBuffer.BufferOutput out, PofContext ctx, int nTypeId, int iProp) {
            super(out, ctx);
            assert (nTypeId >= 0);
            this.m_writerParent = parent;
            this.m_nTypeId = nTypeId;
            this.m_iProp = iProp;
            this.m_refs = parent == null ? null : parent.m_refs;
        }

        public UserTypeWriter(WritingPofHandler handler, PofContext ctx, int nTypeId, int iProp) {
            this(null, handler, ctx, nTypeId, iProp);
        }

        public UserTypeWriter(PofBufferWriter parent, WritingPofHandler handler, PofContext ctx, int nTypeId, int iProp) {
            this(parent, handler, ctx, nTypeId, iProp, -1);
        }

        public UserTypeWriter(PofBufferWriter parent, WritingPofHandler handler, PofContext ctx, int nTypeId, int iProp, int nId) {
            super(handler, ctx);
            assert (nTypeId >= 0);
            this.m_writerParent = parent;
            this.m_nTypeId = nTypeId;
            this.m_iProp = iProp;
            this.m_refs = parent == null ? null : parent.m_refs;
            this.m_nId = nId;
        }

        @Override
        public int getUserTypeId() {
            return this.m_nTypeId;
        }

        @Override
        public int getVersionId() {
            return this.m_nVersionId;
        }

        @Override
        public void setVersionId(int nVersionId) {
            if (nVersionId < 0) {
                throw new IllegalArgumentException("negative version identifier: " + nVersionId);
            }
            this.m_nVersionId = nVersionId;
        }

        @Override
        public PofWriter createNestedPofWriter(int iProp) throws IOException {
            return this.createNestedPofWriter(iProp, this.m_nTypeId);
        }

        @Override
        public PofWriter createNestedPofWriter(int iProp, int nTypeId) throws IOException {
            this.beginProperty(iProp);
            try {
                this.getPofHandler().registerIdentity(-1);
                PofContext ctx = this.getPofContext();
                UserTypeWriter writer = new UserTypeWriter((PofBufferWriter)this, this.getPofHandler(), ctx, nTypeId, iProp);
                if (this.isReferenceEnabled()) {
                    writer.enableReference();
                }
                this.m_writerNested = writer;
                return writer;
            }
            catch (Exception e) {
                this.onException(e);
                throw UserTypeWriter.azzert();
            }
        }

        @Override
        public void writeRemainder(Binary binProps) throws IOException {
            this.closeNested();
            this.writeUserTypeInfo();
            try {
                if (binProps != null) {
                    this.getBufferOutput().writeBuffer(binProps);
                }
                this.getPofHandler().endComplexValue();
            }
            catch (Exception e) {
                this.onException(e);
            }
            this.m_fUserTypeEnd = true;
            this.m_complex = null;
        }

        @Override
        protected PofBufferWriter getParentWriter() {
            return this.m_writerParent;
        }

        @Override
        protected void beginProperty(int iProp) throws IOException {
            this.closeNested();
            if (iProp < 0) {
                throw new IllegalArgumentException("negative property index: " + iProp);
            }
            this.writeUserTypeInfo();
            if (this.getPofHandler().getComplex() == this.m_complex && iProp <= this.m_iPrevProp) {
                throw new IllegalArgumentException("previous property index=" + this.m_iPrevProp + ", requested property index=" + iProp + " while writing user type " + this.getUserTypeId());
            }
        }

        @Override
        protected void endProperty(int iProp) {
            if (this.getPofHandler().getComplex() == this.m_complex) {
                this.m_iPrevProp = iProp;
            }
        }

        protected void closeNested() {
            UserTypeWriter writerNested = this.m_writerNested;
            if (writerNested != null) {
                if (!writerNested.m_fUserTypeEnd) {
                    this.getPofHandler().endComplexValue();
                }
                writerNested.closeNested();
                this.endProperty(writerNested.m_iProp);
                this.m_writerNested = null;
            }
        }

        @Override
        protected void onException(Exception e) throws IOException {
            this.m_fUserTypeEnd = true;
            this.m_complex = null;
            super.onException(e);
        }

        protected void writeUserTypeInfo() throws IOException {
            if (this.m_fUserTypeEnd) {
                throw new EOFException("user type POF stream terminated");
            }
            if (!this.m_fUserTypeBegin) {
                WritingPofHandler handler = this.getPofHandler();
                try {
                    handler.beginUserType(this.m_iProp, this.m_nId, this.getUserTypeId(), this.getVersionId());
                }
                catch (Exception e) {
                    this.onException(e);
                }
                this.m_fUserTypeBegin = true;
                this.m_complex = handler.getComplex();
            }
        }

        @Override
        public void enableReference() {
            if (this.m_refs == null) {
                PofBufferWriter parent = this.m_writerParent;
                if (parent == null) {
                    this.m_refs = new ReferenceLibrary();
                } else {
                    parent.enableReference();
                    this.m_refs = parent.m_refs;
                }
                UserTypeWriter child = this.m_writerNested;
                if (child != null) {
                    child.enableReference();
                }
            }
        }

        @Override
        protected boolean isEvolvable() {
            PofBufferWriter parent;
            if (!this.m_fEvolvable && (parent = this.m_writerParent) != null) {
                this.m_fEvolvable = parent.isEvolvable();
            }
            return this.m_fEvolvable;
        }
    }
}

