/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofConstants;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.io.pof.RawDate;
import com.tangosol.io.pof.RawDateTime;
import com.tangosol.io.pof.RawDayTimeInterval;
import com.tangosol.io.pof.RawQuad;
import com.tangosol.io.pof.RawTime;
import com.tangosol.io.pof.RawTimeInterval;
import com.tangosol.io.pof.RawYearMonthInterval;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.LiteMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.LongArray;
import com.tangosol.util.ObservableHashMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.SimpleMapEntry;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public abstract class PofHelper
extends Base
implements PofConstants {
    private static final Map JAVA_TO_POF_TYPE;
    private static final int[] MAX_DAYS_PER_MONTH;
    public static final BigInteger BIGINTEGER_MAX_LONG;
    public static final BigInteger BIGINTEGER_MIN_LONG;
    public static final BigDecimal BIGDECIMAL_ZERO;
    public static final boolean[] BOOLEAN_ARRAY_EMPTY;
    public static final byte[] BYTE_ARRAY_EMPTY;
    public static final char[] CHAR_ARRAY_EMPTY;
    public static final short[] SHORT_ARRAY_EMPTY;
    public static final int[] INT_ARRAY_EMPTY;
    public static final long[] LONG_ARRAY_EMPTY;
    public static final float[] FLOAT_ARRAY_EMPTY;
    public static final double[] DOUBLE_ARRAY_EMPTY;
    public static final Object[] OBJECT_ARRAY_EMPTY;
    public static final Collection COLLECTION_EMPTY;
    public static final Binary BINARY_EMPTY;

    public static int getJavaTypeId(Object o, PofContext ctx) {
        assert (ctx != null);
        return o == null ? 0 : (o instanceof PortableObject ? 36 : (o instanceof String ? 13 : (o instanceof Number ? (o instanceof Integer ? 5 : (o instanceof Long ? 6 : (o instanceof Double ? 9 : (o instanceof BigInteger ? (ctx.isUserType(o) ? 36 : 7) : (o instanceof BigDecimal ? (ctx.isUserType(o) ? 36 : 11) : (o instanceof Short ? 4 : (o instanceof Float ? 8 : (o instanceof Byte ? 2 : 36)))))))) : (o instanceof Boolean ? 1 : (o instanceof Character ? 3 : (o instanceof ReadBuffer ? 12 : (o instanceof byte[] ? 25 : (o instanceof int[] ? 28 : (o instanceof long[] ? 29 : (o instanceof double[] ? 31 : (o instanceof char[] ? 26 : (o instanceof boolean[] ? 24 : (o instanceof short[] ? 27 : (o instanceof float[] ? 30 : (ctx.isUserType(o) ? 36 : (o instanceof Map ? 35 : (o instanceof Collection ? 34 : (o instanceof LocalDate ? 37 : (o instanceof Date ? 14 : (o instanceof LocalTime ? 38 : (o instanceof OffsetTime ? 40 : (o instanceof Time ? 15 : (o instanceof Timestamp ? 17 : (o instanceof java.util.Date ? 16 : (o instanceof LocalDateTime ? 39 : (o instanceof OffsetDateTime ? 41 : (o instanceof ZonedDateTime ? 42 : (o instanceof LongArray ? 33 : (o instanceof RawQuad ? 10 : (o instanceof PofHelper ? (o instanceof RawDate ? 18 : (o instanceof RawTime ? 19 : (o instanceof RawDateTime ? 20 : (o instanceof RawYearMonthInterval ? 21 : (o instanceof RawTimeInterval ? 22 : (o instanceof RawDayTimeInterval ? 23 : 36)))))) : (o instanceof Object[] ? 32 : 36)))))))))))))))))))))))))))))));
    }

    public static int getPofTypeId(Class clz, PofContext ctx) {
        assert (clz != null);
        assert (ctx != null);
        Integer I = (Integer)JAVA_TO_POF_TYPE.get(clz);
        return I != null ? I : (PortableObject.class.isAssignableFrom(clz) ? ctx.getUserTypeIdentifier(clz) : (ctx.isUserType(clz) ? ctx.getUserTypeIdentifier(clz) : (BigInteger.class.isAssignableFrom(clz) ? -4 : (BigDecimal.class.isAssignableFrom(clz) ? -10 : (Map.class.isAssignableFrom(clz) ? -28 : (Collection.class.isAssignableFrom(clz) ? -22 : (java.util.Date.class.isAssignableFrom(clz) ? -20 : (RawQuad.class.isAssignableFrom(clz) ? -7 : (RawDate.class.isAssignableFrom(clz) ? -16 : (RawTime.class.isAssignableFrom(clz) ? -18 : (RawDateTime.class.isAssignableFrom(clz) ? -20 : (RawYearMonthInterval.class.isAssignableFrom(clz) ? -17 : (RawTimeInterval.class.isAssignableFrom(clz) ? -19 : (RawDayTimeInterval.class.isAssignableFrom(clz) ? -21 : (clz.isArray() ? -24 : ctx.getUserTypeIdentifier(clz))))))))))))))));
    }

    public static boolean isIntrinsicPofType(Class clz) {
        assert (clz != null);
        Integer I = (Integer)JAVA_TO_POF_TYPE.get(clz);
        return I != null || BigInteger.class.isAssignableFrom(clz) || BigDecimal.class.isAssignableFrom(clz) || Map.class.isAssignableFrom(clz) || Collection.class.isAssignableFrom(clz) || java.util.Date.class.isAssignableFrom(clz) || RawDate.class.isAssignableFrom(clz) || RawTime.class.isAssignableFrom(clz) || RawDateTime.class.isAssignableFrom(clz) || RawYearMonthInterval.class.isAssignableFrom(clz) || RawTimeInterval.class.isAssignableFrom(clz) || RawDayTimeInterval.class.isAssignableFrom(clz) || clz.isArray();
    }

    public static Number convertNumber(Number number, int nJavaTypeId) {
        if (number == null) {
            return null;
        }
        switch (nJavaTypeId) {
            case 2: {
                return number instanceof Byte ? (Number)number : (Number)number.byteValue();
            }
            case 4: {
                return number instanceof Short ? (Number)number : (Number)number.shortValue();
            }
            case 5: {
                return number instanceof Integer ? (Number)number : (Number)number.intValue();
            }
            case 6: {
                return number instanceof Long ? (Number)number : (Number)number.longValue();
            }
            case 7: {
                if (number instanceof BigInteger) {
                    return number;
                }
                if (number instanceof BigDecimal) {
                    return ((BigDecimal)number).setScale(0, 1).unscaledValue();
                }
                if (number instanceof Float || number instanceof Double) {
                    return new BigDecimal(number.doubleValue()).setScale(0, 1).unscaledValue();
                }
                return BigInteger.valueOf(number.longValue());
            }
            case 8: {
                return number instanceof Float ? (Number)number : (Number)Float.valueOf(number.floatValue());
            }
            case 9: {
                return number instanceof Double ? (Number)number : (Number)number.doubleValue();
            }
            case 10: {
                return number instanceof RawQuad ? number : new RawQuad(number.doubleValue());
            }
            case 11: {
                if (number instanceof BigDecimal) {
                    return number;
                }
                if (number instanceof BigInteger) {
                    BigInteger n = (BigInteger)number;
                    if (n.compareTo(BIGINTEGER_MIN_LONG) >= 0 && n.compareTo(BIGINTEGER_MAX_LONG) <= 0) {
                        return BigDecimal.valueOf(n.longValue());
                    }
                    return new BigDecimal(n);
                }
                if (number instanceof Float || number instanceof Double) {
                    return BigDecimal.valueOf(number.doubleValue());
                }
                return BigDecimal.valueOf(number.longValue());
            }
        }
        throw new IllegalArgumentException("Java type ID " + nJavaTypeId + " is not a number type");
    }

    public static java.util.Date convertToDate(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof java.util.Date) {
            return (java.util.Date)o;
        }
        if (o instanceof RawDate) {
            return ((RawDate)o).toJavaDate();
        }
        if (o instanceof RawTime) {
            return ((RawTime)o).toJavaDate();
        }
        if (o instanceof RawDateTime) {
            return ((RawDateTime)o).toJavaDate();
        }
        throw new IllegalArgumentException("Unable to convert " + o.getClass().getName() + " to a Date value");
    }

    public static <T> T[] resizeArray(T[] aoOld, int cNew) {
        Object[] aoNew = aoOld == null ? new Object[cNew] : (cNew > aoOld.length ? (Object[])Array.newInstance(aoOld.getClass().getComponentType(), cNew) : aoOld);
        return aoNew;
    }

    public static int decodeTinyInt(int n) {
        assert (n <= -41 && n >= -64);
        return -42 - n;
    }

    public static char readChar(DataInput in) throws IOException {
        char ch;
        int b = in.readUnsignedByte();
        switch ((b & 0xF0) >>> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ch = (char)b;
                break;
            }
            case 12: 
            case 13: {
                int b2 = in.readUnsignedByte();
                if ((b2 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                ch = (char)((b & 0x1F) << 6 | b2 & 0x3F);
                break;
            }
            case 14: {
                int n = in.readUnsignedShort();
                int b2 = n >>> 8;
                int b3 = n & 0xFF;
                if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                ch = (char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                break;
            }
            default: {
                throw new UTFDataFormatException("illegal leading UTF byte: " + b);
            }
        }
        return ch;
    }

    public static BigInteger readBigInteger(DataInput in) throws IOException {
        int cb = 16;
        byte[] ab = new byte[cb];
        int b = in.readUnsignedByte();
        boolean fNeg = (b & 0x40) != 0;
        boolean fTiny = true;
        int of = cb - 1;
        ab[of] = (byte)(b & 0x3F);
        int cBits = 6;
        while ((b & 0x80) != 0) {
            b = in.readUnsignedByte();
            ab[of] = (byte)(ab[of] & 0xFF | (b & 0x7F) << cBits);
            if ((cBits += 7) >= 8 && (cBits -= 8) > 0 && --of >= 0) {
                ab[of] = (byte)((b & 0x7F) >>> 7 - cBits);
            }
            fTiny = false;
        }
        if (fNeg) {
            for (of = 0; of < 16; ++of) {
                ab[of] = ~ab[of];
            }
        }
        if (fTiny && (b = ab[ab.length - 1]) >= -16 && b <= 16) {
            return BigInteger.valueOf(b);
        }
        return new BigInteger(ab);
    }

    public static RawQuad readQuad(ReadBuffer.BufferInput in) throws IOException {
        int of = in.getOffset();
        int cb = 16;
        in.skipBytes(16);
        return new RawQuad(in.getBuffer().toBinary(of, cb));
    }

    public static BigDecimal readBigDecimal(ReadBuffer.BufferInput in, int cBytes) throws IOException {
        assert (cBytes == 4 || cBytes == 8 || cBytes == 16);
        BigInteger n = PofHelper.readBigInteger(in);
        int nScale = in.readPackedInt();
        if (n.compareTo(BIGINTEGER_MIN_LONG) >= 0 && n.compareTo(BIGINTEGER_MAX_LONG) <= 0) {
            return BigDecimal.valueOf(n.longValue(), nScale);
        }
        return new BigDecimal(n, nScale);
    }

    public static LocalDate readLocalDate(ReadBuffer.BufferInput in) throws IOException {
        int nYear = in.readPackedInt();
        int nMonth = in.readPackedInt();
        int nDay = in.readPackedInt();
        return LocalDate.of(nYear, nMonth, nDay);
    }

    public static LocalDateTime readLocalDateTime(ReadBuffer.BufferInput in) throws IOException {
        return LocalDateTime.of(PofHelper.readLocalDate(in), PofHelper.readLocalTime(in));
    }

    public static LocalTime readLocalTime(ReadBuffer.BufferInput in) throws IOException {
        int nHour = in.readPackedInt();
        int nMinute = in.readPackedInt();
        int nSecond = in.readPackedInt();
        int nFraction = in.readPackedInt();
        int nNanos = nFraction <= 0 ? -nFraction : nFraction * 1000000;
        byte nZoneType = in.readByte();
        if (nZoneType == 0) {
            return LocalTime.of(nHour, nMinute, nSecond, nNanos);
        }
        throw new IOException("Attempted to read time with zone information as LocalTime");
    }

    public static OffsetDateTime readOffsetDateTime(ReadBuffer.BufferInput in) throws IOException {
        LocalDate date = PofHelper.readLocalDate(in);
        OffsetTime time = PofHelper.readOffsetTime(in);
        return OffsetDateTime.of(date, time.toLocalTime(), time.getOffset());
    }

    public static OffsetTime readOffsetTime(ReadBuffer.BufferInput in) throws IOException {
        int nHour = in.readPackedInt();
        int nMinute = in.readPackedInt();
        int nSecond = in.readPackedInt();
        int nFraction = in.readPackedInt();
        int nNanos = nFraction <= 0 ? -nFraction : nFraction * 1000000;
        byte nZoneType = in.readByte();
        switch (nZoneType) {
            case 1: {
                return OffsetTime.of(nHour, nMinute, nSecond, nNanos, ZoneOffset.UTC);
            }
            case 2: {
                int nOfHours = in.readPackedInt();
                int nOfMin = in.readPackedInt();
                return OffsetTime.of(nHour, nMinute, nSecond, nNanos, ZoneOffset.ofHoursMinutes(nOfHours, nOfMin));
            }
        }
        throw new IOException("Attempted to read time without zone information as OffsetTime");
    }

    public static RawDate readRawDate(ReadBuffer.BufferInput in) throws IOException {
        int nYear = in.readPackedInt();
        int nMonth = in.readPackedInt();
        int nDay = in.readPackedInt();
        return new RawDate(nYear, nMonth, nDay);
    }

    public static RawTime readRawTime(ReadBuffer.BufferInput in) throws IOException {
        RawTime time;
        int nHour = in.readPackedInt();
        int nMinute = in.readPackedInt();
        int nSecond = in.readPackedInt();
        int nFraction = in.readPackedInt();
        int nNanos = nFraction <= 0 ? -nFraction : nFraction * 1000000;
        byte nZoneType = in.readByte();
        if (nZoneType == 2) {
            int nHourOffset = in.readPackedInt();
            int nMinuteOffset = in.readPackedInt();
            time = new RawTime(nHour, nMinute, nSecond, nNanos, nHourOffset, nMinuteOffset);
        } else {
            assert (nZoneType == 0 || nZoneType == 1);
            boolean fUTC = nZoneType == 1;
            time = new RawTime(nHour, nMinute, nSecond, nNanos, fUTC);
        }
        return time;
    }

    public static char readAsChar(ReadBuffer.BufferInput in, int nType) throws IOException {
        switch (nType) {
            case -12: {
                return (char)in.readUnsignedByte();
            }
            case -14: {
                return PofHelper.readChar(in);
            }
        }
        return (char)PofHelper.readAsInt(in, nType);
    }

    public static int readAsInt(ReadBuffer.BufferInput in, int nType) throws IOException {
        switch (nType) {
            case -11: 
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                return in.readPackedInt();
            }
            case -5: {
                return (int)in.readFloat();
            }
            case -6: {
                return (int)in.readDouble();
            }
            case -7: {
                return PofHelper.readQuad(in).intValue();
            }
            case -8: {
                return PofHelper.readBigDecimal(in, 4).intValue();
            }
            case -9: {
                return PofHelper.readBigDecimal(in, 8).intValue();
            }
            case -10: {
                return PofHelper.readBigDecimal(in, 16).intValue();
            }
            case -12: {
                return in.readUnsignedByte();
            }
            case -14: {
                return PofHelper.readChar(in);
            }
            case -42: 
            case -37: 
            case -33: {
                return 0;
            }
            case -43: 
            case -34: {
                return 1;
            }
            case -64: 
            case -63: 
            case -62: 
            case -61: 
            case -60: 
            case -59: 
            case -58: 
            case -57: 
            case -56: 
            case -55: 
            case -54: 
            case -53: 
            case -52: 
            case -51: 
            case -50: 
            case -49: 
            case -48: 
            case -47: 
            case -46: 
            case -45: 
            case -44: 
            case -41: {
                return PofHelper.decodeTinyInt(nType);
            }
        }
        throw new IOException("unable to convert type " + nType + " to a numeric type");
    }

    public static long readAsLong(ReadBuffer.BufferInput in, int nType) throws IOException {
        switch (nType) {
            case -4: 
            case -3: {
                return in.readPackedLong();
            }
            case -5: {
                return (long)in.readFloat();
            }
            case -6: {
                return (long)in.readDouble();
            }
            case -7: {
                return PofHelper.readQuad(in).longValue();
            }
            case -8: {
                return PofHelper.readBigDecimal(in, 4).longValue();
            }
            case -9: {
                return PofHelper.readBigDecimal(in, 8).longValue();
            }
            case -10: {
                return PofHelper.readBigDecimal(in, 16).longValue();
            }
        }
        return PofHelper.readAsInt(in, nType);
    }

    public static float readAsFloat(ReadBuffer.BufferInput in, int nType) throws IOException {
        switch (nType) {
            case -3: {
                return in.readPackedLong();
            }
            case -5: {
                return in.readFloat();
            }
            case -6: {
                return (float)in.readDouble();
            }
            case -7: {
                return PofHelper.readQuad(in).floatValue();
            }
            case -4: {
                return PofHelper.readBigInteger(in).floatValue();
            }
            case -8: {
                return PofHelper.readBigDecimal(in, 4).floatValue();
            }
            case -9: {
                return PofHelper.readBigDecimal(in, 8).floatValue();
            }
            case -10: {
                return PofHelper.readBigDecimal(in, 16).floatValue();
            }
            case -39: {
                return Float.NEGATIVE_INFINITY;
            }
            case -38: {
                return Float.POSITIVE_INFINITY;
            }
            case -40: {
                return Float.NaN;
            }
        }
        return PofHelper.readAsInt(in, nType);
    }

    public static double readAsDouble(ReadBuffer.BufferInput in, int nType) throws IOException {
        switch (nType) {
            case -3: {
                return in.readPackedLong();
            }
            case -5: {
                return in.readFloat();
            }
            case -6: {
                return in.readDouble();
            }
            case -7: {
                return PofHelper.readQuad(in).doubleValue();
            }
            case -4: {
                return PofHelper.readBigInteger(in).doubleValue();
            }
            case -10: 
            case -9: 
            case -8: {
                return PofHelper.readAsBigDecimal(in, nType).doubleValue();
            }
            case -39: {
                return Double.NEGATIVE_INFINITY;
            }
            case -38: {
                return Double.POSITIVE_INFINITY;
            }
            case -40: {
                return Double.NaN;
            }
        }
        return PofHelper.readAsInt(in, nType);
    }

    public static RawQuad readAsQuad(ReadBuffer.BufferInput in, int nType) throws IOException {
        if (nType == -7) {
            return PofHelper.readQuad(in);
        }
        return new RawQuad(PofHelper.readAsDouble(in, nType));
    }

    public static BigInteger readAsBigInteger(ReadBuffer.BufferInput in, int nType) throws IOException {
        switch (nType) {
            case -4: {
                return PofHelper.readBigInteger(in);
            }
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: {
                return (BigInteger)PofHelper.convertNumber(PofHelper.readAsBigDecimal(in, nType), 7);
            }
        }
        return BigInteger.valueOf(PofHelper.readAsLong(in, nType));
    }

    public static BigDecimal readAsBigDecimal(ReadBuffer.BufferInput in, int nType) throws IOException {
        switch (nType) {
            case -4: {
                return (BigDecimal)PofHelper.convertNumber(PofHelper.readBigInteger(in), 11);
            }
            case -5: {
                return BigDecimal.valueOf(in.readFloat());
            }
            case -6: {
                return BigDecimal.valueOf(in.readDouble());
            }
            case -7: {
                return BigDecimal.valueOf(PofHelper.readQuad(in).doubleValue());
            }
            case -8: {
                return PofHelper.readBigDecimal(in, 4);
            }
            case -9: {
                return PofHelper.readBigDecimal(in, 8);
            }
            case -10: {
                return PofHelper.readBigDecimal(in, 16);
            }
        }
        return BigDecimal.valueOf(PofHelper.readAsLong(in, nType));
    }

    public static void skipValue(ReadBuffer.BufferInput in) throws IOException {
        int nType = in.readPackedInt();
        if (nType == -31) {
            PofHelper.skipPackedInts(in, 1);
            nType = in.readPackedInt();
        }
        PofHelper.skipUniformValue(in, nType);
    }

    public static void skipUniformValue(ReadBuffer.BufferInput in, int nType) throws IOException {
        switch (nType) {
            case -32: 
            case -11: 
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                PofHelper.skipPackedInts(in, 1);
                break;
            }
            case -17: {
                PofHelper.skipPackedInts(in, 2);
                break;
            }
            case -16: {
                PofHelper.skipPackedInts(in, 3);
                break;
            }
            case -19: {
                PofHelper.skipPackedInts(in, 4);
                break;
            }
            case -21: {
                PofHelper.skipPackedInts(in, 5);
                break;
            }
            case -5: {
                in.skipBytes(4);
                break;
            }
            case -6: {
                in.skipBytes(8);
                break;
            }
            case -7: {
                in.skipBytes(16);
                break;
            }
            case -10: 
            case -9: 
            case -8: {
                PofHelper.skipPackedInts(in, 2);
                break;
            }
            case -12: {
                in.skipBytes(1);
                break;
            }
            case -13: {
                in.skipBytes(in.readPackedInt());
                break;
            }
            case -14: {
                switch (in.readUnsignedByte() & 0xF0) {
                    case 192: 
                    case 208: {
                        in.skipBytes(1);
                        break;
                    }
                    case 224: {
                        in.skipBytes(2);
                    }
                }
                break;
            }
            case -15: {
                in.skipBytes(in.readPackedInt());
                break;
            }
            case -20: {
                PofHelper.skipPackedInts(in, 3);
            }
            case -18: {
                PofHelper.skipPackedInts(in, 4);
                int nZoneType = in.readPackedInt();
                if (nZoneType != 2) break;
                PofHelper.skipPackedInts(in, 2);
                break;
            }
            case -24: 
            case -22: {
                int c = in.readPackedInt();
                for (int i = 0; i < c; ++i) {
                    PofHelper.skipValue(in);
                }
                break;
            }
            case -25: 
            case -23: {
                int nElementTypeId = in.readPackedInt();
                int c = in.readPackedInt();
                for (int i = 0; i < c; ++i) {
                    PofHelper.skipUniformValue(in, nElementTypeId);
                }
                break;
            }
            case -26: {
                int iPos;
                int c = in.readPackedInt();
                for (int i = 0; i < c && (iPos = in.readPackedInt()) >= 0; ++i) {
                    PofHelper.skipValue(in);
                }
                break;
            }
            case -27: {
                int iPos;
                int nElementTypeId = in.readPackedInt();
                int c = in.readPackedInt();
                for (int i = 0; i < c && (iPos = in.readPackedInt()) >= 0; ++i) {
                    PofHelper.skipUniformValue(in, nElementTypeId);
                }
                break;
            }
            case -28: {
                int c = in.readPackedInt();
                for (int i = 0; i < c; ++i) {
                    PofHelper.skipValue(in);
                    PofHelper.skipValue(in);
                }
                break;
            }
            case -29: {
                int nKeyTypeId = in.readPackedInt();
                int c = in.readPackedInt();
                for (int i = 0; i < c; ++i) {
                    PofHelper.skipUniformValue(in, nKeyTypeId);
                    PofHelper.skipValue(in);
                }
                break;
            }
            case -30: {
                int nKeyTypeId = in.readPackedInt();
                int nValueTypeId = in.readPackedInt();
                int c = in.readPackedInt();
                for (int i = 0; i < c; ++i) {
                    PofHelper.skipUniformValue(in, nKeyTypeId);
                    PofHelper.skipUniformValue(in, nValueTypeId);
                }
                break;
            }
            case -64: 
            case -63: 
            case -62: 
            case -61: 
            case -60: 
            case -59: 
            case -58: 
            case -57: 
            case -56: 
            case -55: 
            case -54: 
            case -53: 
            case -52: 
            case -51: 
            case -50: 
            case -49: 
            case -48: 
            case -47: 
            case -46: 
            case -45: 
            case -44: 
            case -43: 
            case -42: 
            case -41: 
            case -40: 
            case -39: 
            case -38: 
            case -37: 
            case -36: 
            case -35: 
            case -34: 
            case -33: {
                break;
            }
            default: {
                if (nType >= 0) {
                    if (in.readPackedInt() == -31) {
                        throw new UnsupportedOperationException("Detected object identity/reference in uniform collection, which is not currently supported");
                    }
                    while (in.readPackedInt() >= 0) {
                        PofHelper.skipValue(in);
                    }
                    break;
                }
                throw new StreamCorruptedException("type=" + nType);
            }
        }
    }

    public static void skipPackedInts(ReadBuffer.BufferInput in, int c) throws IOException {
        int n = 0;
        while (c-- > 0) {
            n = in.read();
            while ((n & 0xFFFFFF80) == 128) {
                n = in.read();
            }
        }
        if (n == -1) {
            throw new EOFException();
        }
    }

    public static void writeBigInteger(WriteBuffer.BufferOutput out, BigInteger n) throws IOException {
        int cBits = n.bitLength();
        if (cBits <= 63) {
            out.writePackedLong(n.longValue());
        } else {
            int ofMSB;
            byte[] ab = n.toByteArray();
            int cb = ab.length;
            if (cb > 16) {
                throw new IllegalStateException("too many bits for 128-bit integer: " + (cBits + 1));
            }
            int b = 0;
            if ((ab[0] & 0x80) != 0) {
                b = 64;
                for (int of = 0; of < cb; ++of) {
                    ab[of] = ~ab[of];
                }
            }
            for (ofMSB = 0; ofMSB < cb && ab[ofMSB] == 0; ++ofMSB) {
            }
            if (ofMSB < cb) {
                int of = cb - 1;
                int nBits = ab[of] & 0xFF;
                b |= (byte)(nBits & 0x3F);
                nBits >>>= 6;
                cBits = 2;
                while (nBits != 0 || of > ofMSB) {
                    out.writeByte(b |= 0x80);
                    if (cBits < 7) {
                        nBits |= (--of < 0 ? 0 : ab[of] & 0xFF) << cBits;
                        cBits += 8;
                    }
                    b = nBits & 0x7F;
                    nBits >>>= 7;
                    cBits -= 7;
                }
            }
            out.writeByte(b);
        }
    }

    public static void writeBigDecimal(WriteBuffer.BufferOutput out, BigDecimal dec, int cBytes) throws IOException {
        PofHelper.checkDecimalRange(dec, cBytes);
        PofHelper.writeBigInteger(out, dec.unscaledValue());
        out.writePackedInt(dec.scale());
    }

    public static int encodeTinyInt(int n) {
        assert (n >= -1 && n <= 22);
        return -42 - n;
    }

    public static void writeDate(WriteBuffer.BufferOutput out, int nYear, int nMonth, int nDay) throws IOException {
        out.writePackedInt(nYear);
        out.writePackedInt(nMonth);
        out.writePackedInt(nDay);
    }

    public static void writeTime(WriteBuffer.BufferOutput out, int nHour, int nMinute, int nSecond, int nNano, int nTimeZoneType, int nHourOffset, int nMinuteOffset) throws IOException {
        int nFraction = 0;
        if (nNano != 0) {
            nFraction = nNano % 1000000 == 0 ? nNano / 1000000 : -nNano;
        }
        out.writePackedInt(nHour);
        out.writePackedInt(nMinute);
        out.writePackedInt(nSecond);
        out.writePackedInt(nFraction);
        out.writeByte(nTimeZoneType);
        if (nTimeZoneType == 2) {
            out.writePackedInt(nHourOffset);
            out.writePackedInt(nMinuteOffset);
        }
    }

    public static void checkType(int nType) {
        if (nType < 0) {
            switch (nType) {
                case -32: 
                case -31: 
                case -30: 
                case -29: 
                case -28: 
                case -27: 
                case -26: 
                case -25: 
                case -24: 
                case -23: 
                case -22: 
                case -21: 
                case -20: 
                case -19: 
                case -18: 
                case -17: 
                case -16: 
                case -15: 
                case -14: 
                case -13: 
                case -12: 
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown type: " + nType);
                }
            }
        }
    }

    public static void checkElementCount(int cElements) {
        if (cElements < 0) {
            throw new IllegalStateException("illegal element count: " + cElements);
        }
    }

    public static void checkReferenceRange(int nId) {
        if (nId < 0) {
            throw new IllegalStateException("illegal reference identity: " + nId);
        }
    }

    public static void checkDecimalRange(BigDecimal dec, int cBytes) {
        BigInteger nUnscaled = dec.unscaledValue();
        int nScale = dec.scale();
        switch (cBytes) {
            case 4: {
                if (nUnscaled.abs().compareTo(MAX_DECIMAL32_UNSCALED) <= 0 && nScale >= -95 && nScale <= 96) break;
                throw new IllegalStateException("decimal value exceeds IEEE754r 32-bit range: " + dec);
            }
            case 8: {
                if (nUnscaled.abs().compareTo(MAX_DECIMAL64_UNSCALED) <= 0 && nScale >= -383 && nScale <= 384) break;
                throw new IllegalStateException("decimal value exceeds IEEE754r 64-bit range: " + dec);
            }
            case 16: {
                if (nUnscaled.abs().compareTo(MAX_DECIMAL128_UNSCALED) <= 0 && nScale >= -6143 && nScale <= 6144) break;
                throw new IllegalStateException("decimal value exceeds IEEE754r 128-bit range: " + dec);
            }
            default: {
                throw new IllegalArgumentException("byte count (" + cBytes + ") must be 4, 8 or 16");
            }
        }
    }

    public static int calcDecimalSize(BigDecimal dec) {
        BigInteger nUnscaled = dec.unscaledValue();
        int nScale = dec.scale();
        if (nUnscaled.abs().compareTo(MAX_DECIMAL32_UNSCALED) <= 0 && nScale >= -95 && nScale <= 96) {
            return 4;
        }
        if (nUnscaled.abs().compareTo(MAX_DECIMAL64_UNSCALED) <= 0 && nScale >= -383 && nScale <= 384) {
            return 8;
        }
        if (nUnscaled.abs().compareTo(MAX_DECIMAL128_UNSCALED) <= 0 && nScale >= -6143 && nScale <= 6144) {
            return 16;
        }
        throw new IllegalStateException("decimal value exceeds IEEE754r 128-bit range: " + dec);
    }

    public static void checkDate(int nYear, int nMonth, int nDay) {
        if (nMonth < 1 || nMonth > 12) {
            throw new IllegalStateException("month is out of range: " + nMonth);
        }
        if (nDay < 1 || nDay > MAX_DAYS_PER_MONTH[nMonth - 1]) {
            throw new IllegalStateException("day is out of range: " + nDay);
        }
        if (nMonth == 2 && nDay == 29 && (nYear % 4 != 0 || nYear % 100 == 0 && nYear % 400 != 0)) {
            throw new IllegalStateException("not a leap year: " + nYear);
        }
    }

    public static void checkTime(int nHour, int nMinute, int nSecond, int nNano) {
        if (nHour < 0 || nHour > 23) {
            if (nHour == 24 && nMinute == 0 && nSecond == 0 && nNano == 0) {
                throw new IllegalStateException("end-of-day midnight (24:00:00.0) is supported by ISO8601, but use 00:00:00.0 instead");
            }
            throw new IllegalStateException("hour is out of range: " + nHour);
        }
        if (nMinute < 0 || nMinute > 59) {
            throw new IllegalStateException("minute is out of range: " + nMinute);
        }
        if (nSecond < 0 || nSecond == 60 && nNano > 0 || nSecond > 60) {
            throw new IllegalStateException("second is out of range: " + nSecond);
        }
        if (nNano < 0 || nNano > 999999999) {
            throw new IllegalStateException("nanosecond is out of range: " + nNano);
        }
    }

    public static void checkTimeZone(int nHourOffset, int nMinuteOffset) {
        if (nHourOffset < -23 || nHourOffset > 23) {
            throw new IllegalStateException("invalid hour offset: " + nHourOffset);
        }
        if (nMinuteOffset < 0 || nMinuteOffset > 59) {
            throw new IllegalStateException("invalid minute offset: " + nMinuteOffset);
        }
    }

    public static void checkYearMonthInterval(int cYears, int cMonths) {
        if (cYears == 0 && (cMonths < -11 || cMonths > 11)) {
            throw new IllegalStateException("month interval is out of range: " + cMonths);
        }
    }

    public static void checkTimeInterval(int cHours, int cMinutes, int cSeconds, int cNanos) {
        if (cHours == 0) {
            if (cMinutes == 0) {
                if (cSeconds == 0) {
                    cNanos = Math.abs(cNanos);
                } else {
                    cSeconds = Math.abs(cSeconds);
                }
            } else {
                cMinutes = Math.abs(cMinutes);
            }
        } else {
            cHours = Math.abs(cHours);
        }
        PofHelper.checkTime(cHours, cMinutes, cSeconds, cNanos);
    }

    public static void checkDayTimeInterval(int cDays, int cHours, int cMinutes, int cSeconds, int cNanos) {
        if (cDays == 0) {
            PofHelper.checkTimeInterval(cHours, cMinutes, cSeconds, cNanos);
        } else {
            PofHelper.checkTime(cHours, cMinutes, cSeconds, cNanos);
        }
    }

    public static String formatDate(int nYear, int nMonth, int nDay) {
        return PofHelper.toDecString(nYear, Math.max(4, PofHelper.getMaxDecDigits(nYear))) + "-" + PofHelper.toDecString(nMonth, Math.max(2, PofHelper.getMaxDecDigits(nMonth))) + "-" + PofHelper.toDecString(nDay, Math.max(2, PofHelper.getMaxDecDigits(nDay)));
    }

    public static String formatTime(int nHour, int nMinute, int nSecond, int nNano, boolean fUTC) {
        StringBuilder sb = new StringBuilder();
        sb.append(PofHelper.toDecString(nHour, Math.max(2, PofHelper.getMaxDecDigits(nHour)))).append(":").append(PofHelper.toDecString(nMinute, Math.max(2, PofHelper.getMaxDecDigits(nMinute))));
        if (nSecond != 0 || nNano != 0) {
            sb.append(":").append(PofHelper.toDecString(nSecond, Math.max(2, PofHelper.getMaxDecDigits(nSecond))));
            if (nNano != 0) {
                sb.append('.');
                if (nNano % 1000000 == 0) {
                    sb.append(PofHelper.toDecString(nNano / 1000000, 3));
                } else {
                    sb.append(PofHelper.toDecString(nNano, 9));
                }
            }
        }
        if (fUTC) {
            sb.append('Z');
        }
        return sb.toString();
    }

    public static String formatTime(int nHour, int nMinute, int nSecond, int nNano, int nHourOffset, int nMinuteOffset) {
        StringBuilder sb = new StringBuilder();
        sb.append(PofHelper.formatTime(nHour, nMinute, nSecond, nNano, false));
        if (nHourOffset < 0) {
            sb.append('-');
            nHourOffset = -nHourOffset;
        } else {
            sb.append('+');
        }
        sb.append(PofHelper.toDecString(nHourOffset, Math.max(2, PofHelper.getMaxDecDigits(nHourOffset)))).append(":").append(PofHelper.toDecString(nMinuteOffset, Math.max(2, PofHelper.getMaxDecDigits(nMinuteOffset))));
        return sb.toString();
    }

    static {
        HashMap<Class, Integer> map = new HashMap<Class, Integer>();
        map.put(Short.TYPE, -1);
        map.put(Short.class, -1);
        map.put(Integer.TYPE, -2);
        map.put(Integer.class, -2);
        map.put(Long.TYPE, -3);
        map.put(Long.class, -3);
        map.put(Float.TYPE, -5);
        map.put(Float.class, -5);
        map.put(Double.TYPE, -6);
        map.put(Double.class, -6);
        map.put(RawQuad.class, -7);
        map.put(Boolean.TYPE, -11);
        map.put(Boolean.class, -11);
        map.put(Byte.TYPE, -12);
        map.put(Byte.class, -12);
        map.put(Binary.class, -13);
        map.put(Character.TYPE, -14);
        map.put(Character.class, -14);
        map.put(String.class, -15);
        map.put(java.util.Date.class, -20);
        map.put(Date.class, -16);
        map.put(Time.class, -18);
        map.put(Timestamp.class, -20);
        map.put(RawDate.class, -16);
        map.put(RawTime.class, -18);
        map.put(RawDateTime.class, -20);
        map.put(RawYearMonthInterval.class, -17);
        map.put(RawTimeInterval.class, -19);
        map.put(RawDayTimeInterval.class, -21);
        map.put(boolean[].class, -25);
        map.put(byte[].class, -25);
        map.put(char[].class, -15);
        map.put(short[].class, -25);
        map.put(int[].class, -25);
        map.put(long[].class, -25);
        map.put(float[].class, -25);
        map.put(double[].class, -25);
        map.put(ArrayList.class, -22);
        map.put(ImmutableArrayList.class, -22);
        map.put(Vector.class, -22);
        map.put(LinkedList.class, -22);
        map.put(SafeLinkedList.class, -22);
        map.put(RecyclingLinkedList.class, -22);
        map.put(LiteSet.class, -22);
        map.put(HashSet.class, -22);
        map.put(SafeHashSet.class, -22);
        map.put(TreeSet.class, -22);
        map.put(LiteMap.class, -28);
        map.put(Hashtable.class, -28);
        map.put(HashMap.class, -28);
        map.put(SafeHashMap.class, -28);
        map.put(ObservableHashMap.class, -28);
        map.put(TreeMap.class, -28);
        JAVA_TO_POF_TYPE = map;
        MAX_DAYS_PER_MONTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        BIGINTEGER_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
        BIGINTEGER_MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
        BIGDECIMAL_ZERO = BigDecimal.valueOf(0L);
        BOOLEAN_ARRAY_EMPTY = new boolean[0];
        BYTE_ARRAY_EMPTY = new byte[0];
        CHAR_ARRAY_EMPTY = new char[0];
        SHORT_ARRAY_EMPTY = new short[0];
        INT_ARRAY_EMPTY = new int[0];
        LONG_ARRAY_EMPTY = new long[0];
        FLOAT_ARRAY_EMPTY = new float[0];
        DOUBLE_ARRAY_EMPTY = new double[0];
        OBJECT_ARRAY_EMPTY = new Object[0];
        COLLECTION_EMPTY = new ImmutableArrayList(OBJECT_ARRAY_EMPTY);
        BINARY_EMPTY = new Binary(BYTE_ARRAY_EMPTY);
    }

    public static class ReadableEntrySetMap
    extends AbstractMap {
        private List m_listEntries;

        public ReadableEntrySetMap() {
            this.clear();
        }

        @Override
        public Object put(Object oKey, Object oValue) {
            this.m_listEntries.add(new SimpleMapEntry<Object, Object>(oKey, oValue));
            return null;
        }

        @Override
        public void clear() {
            this.m_listEntries = new ArrayList();
        }

        @Override
        public Set entrySet() {
            return new ImmutableArrayList(this.m_listEntries);
        }
    }

    public static class WriteableEntrySetMap
    extends AbstractMap {
        private Set m_setEntries;

        public WriteableEntrySetMap(Map.Entry entry) {
            this.m_setEntries = Collections.singleton(entry);
        }

        public WriteableEntrySetMap(Set setEntries) {
            this.m_setEntries = Collections.unmodifiableSet(setEntries);
        }

        @Override
        public Set entrySet() {
            return this.m_setEntries;
        }
    }
}

