/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.generator;

import com.tangosol.dev.introspect.ClassAnnotationSeeker;
import com.tangosol.dev.introspect.ClassPathResourceDiscoverer;
import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.io.pof.annotation.Portable;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.filter.InFilter;
import com.tangosol.util.filter.NotFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PofConfigGenerator {
    protected static final String DEFAULT_POF_CONFIG_FILE_NAME = "pof-config.xml";
    protected Dependencies m_deps;
    protected XmlElement m_xmlConfig;
    protected String m_sWrittenPath;
    protected List<URL> m_listClassPath;

    public PofConfigGenerator(Dependencies deps) {
        Base.azzert(deps != null, "PofConfigGenerator requires dependencies");
        deps.validate();
        this.m_deps = deps.clone();
    }

    public void generate() {
        ClassLoader loader = this.ensureClassLoader();
        Map<Integer, TypeInfo> mapReserved = this.ensureReservedUserTypes(loader);
        Map<Integer, TypeInfo> mapDiscovered = this.discoverUserTypes(mapReserved, loader);
        for (Map.Entry<Integer, TypeInfo> entry : mapReserved.entrySet()) {
            TypeInfo type = entry.getValue();
            if (!type.m_fExport) continue;
            mapDiscovered.put(entry.getKey(), type);
        }
        this.persist(this.generateXml(mapDiscovered));
    }

    public String getWrittenPath() {
        return this.m_sWrittenPath;
    }

    public Dependencies getDependencies() {
        return this.m_deps;
    }

    public void setDependencies(Dependencies deps) {
        this.m_deps = deps;
    }

    public void setListClassPath(List<URL> listClassPath) {
        this.m_listClassPath = listClassPath;
    }

    protected ClassLoader ensureClassLoader() {
        URL url;
        List<String> listRoots = this.m_deps.getPathRoot();
        if (listRoots.isEmpty()) {
            return Base.getContextClassLoader();
        }
        List<URL> listClassPath = this.extractClassPath(listRoots);
        ProtectionDomain domain = this.getClass().getProtectionDomain();
        CodeSource codeSrc = domain == null ? null : domain.getCodeSource();
        URL uRL = url = codeSrc == null ? null : codeSrc.getLocation();
        if (url != null) {
            try {
                url = this.toJarUrl(url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            listClassPath.add(url);
        }
        this.setListClassPath(listClassPath);
        return new URLClassLoader(listClassPath.toArray(new URL[0]));
    }

    protected Map<Integer, TypeInfo> ensureReservedUserTypes(ClassLoader loader) {
        int i;
        Dependencies deps = this.m_deps;
        String sPofConfig = deps.getPofConfig();
        boolean fInclude = deps.isInclude();
        sPofConfig = sPofConfig == null ? ConfigurablePofContext.DEFAULT_RESOURCE : sPofConfig;
        XmlDocument xmlConfig = XmlHelper.loadFileOrResource(sPofConfig, "POF configuration", loader);
        XmlElement[] axmlUserTypes = new XmlElement[2];
        XmlElement xmlConfigGen = (XmlElement)xmlConfig.clone();
        axmlUserTypes[0] = xmlConfigGen.getSafeElement("user-type-list");
        ConfigurablePofContext.mergeIncludes(sPofConfig, xmlConfig, loader);
        HashMap<Integer, TypeInfo> mapReserved = new HashMap<Integer, TypeInfo>();
        axmlUserTypes[1] = xmlConfig.getSafeElement("user-type-list");
        StringBuilder sbErrors = new StringBuilder();
        int n = i = fInclude ? 1 : 0;
        while (i < axmlUserTypes.length) {
            XmlElement xmlUserTypes = axmlUserTypes[i];
            HashSet<Integer> setTypeIds = new HashSet<Integer>();
            Iterator iterUserTypes = xmlUserTypes.getElements("user-type");
            while (iterUserTypes.hasNext()) {
                Integer ITypeId;
                XmlElement xmlUserType = (XmlElement)iterUserTypes.next();
                XmlElement xmlTypeId = xmlUserType.getSafeElement("type-id");
                XmlElement xmlClassName = xmlUserType.getSafeElement("class-name");
                int nTypeId = xmlTypeId.getInt(-1);
                String sClassName = xmlClassName.getString();
                if (nTypeId < 0) {
                    sbErrors.append("\t<user-type-list> contains a <user-type> that has a missing or invalid type ID value: " + xmlTypeId.getString(null));
                }
                if (sClassName.isEmpty()) {
                    sbErrors.append("\tMissing class name for type-id: " + nTypeId);
                }
                if (setTypeIds.contains(ITypeId = Integer.valueOf(nTypeId))) {
                    sbErrors.append("\tDuplicate user type id: " + nTypeId);
                    continue;
                }
                if (mapReserved.containsKey(ITypeId)) continue;
                setTypeIds.add(ITypeId);
                mapReserved.put(ITypeId, new TypeInfo(sClassName, i == 0, xmlUserType));
            }
            ++i;
        }
        if (sbErrors.length() > 0) {
            throw new IllegalStateException("Encountered the following errors when parsing POF Configuration " + sPofConfig + ":\n" + sbErrors.toString());
        }
        XmlElement xmlUserTypes = xmlConfigGen.getSafeElement("user-type-list");
        Iterator iter = xmlUserTypes.getElementList().iterator();
        while (iter.hasNext()) {
            XmlElement xmlChild = (XmlElement)iter.next();
            if (!fInclude && xmlChild.getName().equals("include")) continue;
            iter.remove();
        }
        this.m_xmlConfig = xmlConfigGen;
        return mapReserved;
    }

    protected Map<Integer, TypeInfo> discoverUserTypes(Map<Integer, TypeInfo> mapReservedTypes, ClassLoader loader) {
        Dependencies deps = this.m_deps;
        List<URL> listClassPath = this.m_listClassPath;
        TypeIdIterator iterTypeId = new TypeIdIterator(mapReservedTypes.keySet(), deps.getStartTypeId());
        ClassAnnotationSeeker.Dependencies seekerDeps = new ClassAnnotationSeeker.Dependencies().setFilter(new NotFilter(new InFilter(new KeyExtractor(), this.extractClassNames(mapReservedTypes)))).setPackages(deps.getPackages());
        if (listClassPath != null && !listClassPath.isEmpty()) {
            seekerDeps.setDiscoverer(new ClassPathResourceDiscoverer.InformedResourceDiscoverer(listClassPath.toArray(new URL[listClassPath.size()])));
        }
        seekerDeps.setContextClassLoader(loader);
        ArrayList<String> listClassNames = new ArrayList<String>(new ClassAnnotationSeeker(seekerDeps).findClassNames(Portable.class));
        Collections.sort(listClassNames);
        TreeMap<Integer, TypeInfo> mapDiscoveredTypes = new TreeMap<Integer, TypeInfo>();
        for (String sClassName : listClassNames) {
            mapDiscoveredTypes.put((Integer)iterTypeId.next(), new TypeInfo(sClassName, true));
        }
        return mapDiscoveredTypes;
    }

    protected XmlElement generateXml(Map<Integer, TypeInfo> mapAllUserTypes) {
        Dependencies deps = this.m_deps;
        XmlElement xmlConfig = this.m_xmlConfig;
        XmlElement xmlUserTypes = xmlConfig.ensureElement("user-type-list");
        if (deps.isInclude()) {
            String sPofConfig = deps.getPofConfig();
            File filePofConfig = new File(sPofConfig);
            sPofConfig = filePofConfig.exists() ? filePofConfig.getName() : sPofConfig;
            xmlUserTypes.ensureElement("include").setString(sPofConfig);
        }
        for (Map.Entry<Integer, TypeInfo> entry : mapAllUserTypes.entrySet()) {
            TypeInfo type = entry.getValue();
            XmlElement xmlUserType = type.m_xmlUserType;
            if (xmlUserType == null) {
                xmlUserType = xmlUserTypes.addElement("user-type");
                XmlElement xmlTypeId = xmlUserType.ensureElement("type-id");
                XmlElement xmlClassName = xmlUserType.ensureElement("class-name");
                xmlTypeId.setInt(entry.getKey());
                xmlClassName.setString(type.m_sClassName);
                continue;
            }
            xmlUserTypes.getElementList().add(xmlUserType);
        }
        return xmlConfig;
    }

    protected void persist(XmlElement xmlConfig) {
        String sOutputPath = this.m_deps.getOutputPath();
        File fileOut = sOutputPath == null || sOutputPath.isEmpty() ? new File(".") : new File(sOutputPath);
        try {
            if (fileOut.isDirectory()) {
                fileOut = this.ensureUniqueFile(fileOut, this.getDefaultPofConfigFileName());
            } else {
                fileOut.createNewFile();
            }
            if (!fileOut.canWrite()) {
                throw new IllegalStateException("Insufficient permissions to write to file: " + fileOut);
            }
            xmlConfig.writeXml(new PrintWriter(fileOut), true);
            this.m_sWrittenPath = fileOut.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error in writing file: " + fileOut, e);
        }
    }

    protected List<URL> extractClassPath(List<String> listRoots) {
        ArrayList<URL> listClassPath = new ArrayList<URL>(listRoots.size());
        for (String sFile : listRoots) {
            File[] afileJars;
            File file = new File(sFile);
            if (!file.exists()) {
                throw new IllegalArgumentException("Path in root is invalid: " + sFile);
            }
            if (file.isFile()) {
                String sExtension;
                String sFileName = file.getName();
                int iPosExt = sFileName.lastIndexOf(46);
                String string = sExtension = iPosExt < 0 ? "" : sFileName.substring(iPosExt);
                if (!sExtension.endsWith("jar")) {
                    throw new IllegalArgumentException("Root location refers to a file without a jar extension: " + sFileName);
                }
                try {
                    listClassPath.add(this.toJarUrl(file));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Root location can not be referred to: " + sFileName);
                }
            }
            if (!file.isDirectory()) continue;
            String sErrorHead = "The following file descriptors could not be referred to:\n";
            StringBuilder sbldrErrors = new StringBuilder(sErrorHead);
            try {
                listClassPath.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                sbldrErrors.append("\t" + file);
            }
            for (File fileJar : afileJars = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            })) {
                try {
                    listClassPath.add(this.toJarUrl(fileJar));
                }
                catch (MalformedURLException e) {
                    sbldrErrors.append("\t" + fileJar);
                }
            }
            if (sbldrErrors.length() <= sErrorHead.length()) continue;
            throw new IllegalArgumentException(sbldrErrors.toString());
        }
        return listClassPath;
    }

    protected File ensureUniqueFile(File fileDir, String sName) throws IOException {
        File fileOut = null;
        String sFileName = sName;
        int iInject = sName.lastIndexOf(46);
        iInject = iInject == -1 ? sName.length() : iInject;
        String sPrefix = sName.substring(0, iInject) + "-";
        String sSuffix = sName.substring(iInject, sName.length());
        int i = 0;
        while (i < 255) {
            File fileAttempt = new File(fileDir, sFileName);
            if (!fileAttempt.exists()) {
                fileOut = fileAttempt;
                break;
            }
            sFileName = sPrefix + ++i + sSuffix;
        }
        if (fileOut == null) {
            fileOut = File.createTempFile(sPrefix, sSuffix, fileDir);
        } else {
            fileOut.createNewFile();
        }
        return fileOut;
    }

    protected Set<String> extractClassNames(Map<Integer, TypeInfo> mapTypes) {
        HashSet<String> setClassNames = new HashSet<String>(mapTypes.size());
        for (Map.Entry<Integer, TypeInfo> entry : mapTypes.entrySet()) {
            setClassNames.add(entry.getValue().m_sClassName);
        }
        return setClassNames;
    }

    protected URL toJarUrl(File file) throws MalformedURLException {
        return this.toJarUrl(file.toURI().toURL());
    }

    protected URL toJarUrl(URL url) throws MalformedURLException {
        String sExternal = url.toExternalForm();
        return url.getProtocol().equals("jar") || !sExternal.endsWith(".jar") ? url : new URL("jar:" + sExternal + "!/");
    }

    protected String getDefaultPofConfigFileName() {
        return DEFAULT_POF_CONFIG_FILE_NAME;
    }

    public static class Dependencies {
        protected String m_sPofConfig;
        protected List<String> m_listRoots = new ArrayList<String>();
        protected String m_sOutputPath;
        protected Set<String> m_setPackages = new HashSet<String>();
        protected boolean m_fInclude;
        protected int m_nStartTypeId = 1000;

        public Dependencies() {
            this.m_fInclude = false;
        }

        public Dependencies(Dependencies deps) {
            this.m_sPofConfig = deps.getPofConfig();
            this.m_listRoots = deps.getPathRoot();
            this.m_sOutputPath = deps.getOutputPath();
            this.m_fInclude = deps.isInclude();
            this.m_setPackages = new HashSet<String>(deps.getPackages());
            this.m_nStartTypeId = deps.getStartTypeId();
        }

        public String getPofConfig() {
            return this.m_sPofConfig;
        }

        public Dependencies setPofConfig(String sPofConfig) {
            this.m_sPofConfig = sPofConfig;
            return this;
        }

        public List<String> getPathRoot() {
            return this.m_listRoots;
        }

        public Dependencies setPathRoot(List<String> listRoots) {
            Base.azzert(listRoots != null, "PofConfigGenerator.Dependencies can not have a null path root");
            this.m_listRoots = listRoots;
            return this;
        }

        public String getOutputPath() {
            return this.m_sOutputPath;
        }

        public Dependencies setOutputPath(String sOutputPath) {
            this.m_sOutputPath = sOutputPath;
            return this;
        }

        public Set<String> getPackages() {
            return this.m_setPackages;
        }

        public Dependencies setPackages(Set<String> setPackages) {
            Base.azzert(setPackages != null, "PofConfigGenerator.Dependencies can not have a null set of packages");
            this.m_setPackages = setPackages;
            return this;
        }

        public Dependencies addPackage(String sPackage) {
            this.m_setPackages.add(sPackage);
            return this;
        }

        public boolean isInclude() {
            return this.m_fInclude;
        }

        public Dependencies setInclude(boolean fInclude) {
            this.m_fInclude = fInclude;
            return this;
        }

        public int getStartTypeId() {
            return this.m_nStartTypeId;
        }

        public Dependencies setStartTypeId(Integer nStartTypeId) {
            this.m_nStartTypeId = nStartTypeId == null ? this.m_nStartTypeId : nStartTypeId;
            return this;
        }

        public void validate() {
            String sPofConfig = this.m_sPofConfig;
            if (sPofConfig == null || sPofConfig.isEmpty()) {
                sPofConfig = this.m_sPofConfig = ConfigurablePofContext.DEFAULT_RESOURCE;
            }
        }

        protected Dependencies clone() {
            return new Dependencies(this);
        }

        public String toString() {
            return "PofConfigGenerator.Dependencies{pathRoot = '" + this.m_listRoots + '\'' + ", outputPath = '" + this.m_sOutputPath + '\'' + ", pofConfig = '" + this.m_sPofConfig + '\'' + ", include = " + this.m_fInclude + ", packages = " + this.m_setPackages + ", startTypeId = " + this.m_nStartTypeId + '}';
        }
    }

    protected class TypeIdIterator
    extends FilterEnumerator {
        protected TypeIdIterator(Set<Integer> setReservedTypeIds) {
            this(setReservedTypeIds, 1000);
        }

        protected TypeIdIterator(Set<Integer> setReservedTypeIds, final int nStartTypeId) {
            super(new Iterator(){
                protected int m_nCurrentTypeId;
                {
                    this.m_nCurrentTypeId = nStartTypeId;
                }

                @Override
                public boolean hasNext() {
                    int nCurrentTypeId = this.m_nCurrentTypeId;
                    return nCurrentTypeId >= 0 && nCurrentTypeId < Integer.MAX_VALUE;
                }

                public Object next() {
                    return this.m_nCurrentTypeId++;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }, new NotFilter(new InFilter(IdentityExtractor.INSTANCE, setReservedTypeIds)));
        }
    }

    protected class TypeInfo {
        protected String m_sClassName;
        protected boolean m_fExport;
        protected XmlElement m_xmlUserType;

        protected TypeInfo(String sClassName, boolean fExport) {
            this(sClassName, fExport, null);
        }

        protected TypeInfo(String sClassName, boolean fExport, XmlElement xmlUserType) {
            this.m_sClassName = sClassName;
            this.m_fExport = fExport;
            this.m_xmlUserType = fExport ? xmlUserType : null;
        }
    }
}

