/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.reflect;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.reflect.Codec;
import com.tangosol.util.Base;
import com.tangosol.util.LongArray;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class Codecs {
    public static final Codec DEFAULT_CODEC = new DefaultCodec();

    public static Codec getCodec(Class<?> clz) {
        if (DefaultCodec.class.equals(clz)) {
            return DEFAULT_CODEC;
        }
        if (Codec.class.isAssignableFrom(clz)) {
            try {
                return (Codec)clz.newInstance();
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, "Unable to instantiate class (" + clz + ") that should implement Codec and have a no-arg constructor");
            }
        }
        if (clz.isArray()) {
            return new ArrayCodec(clz.getComponentType());
        }
        if (Collection.class.isAssignableFrom(clz)) {
            return new CollectionCodec(clz);
        }
        if (Map.class.isAssignableFrom(clz)) {
            return new MapCodec(clz);
        }
        if (LongArray.class.isAssignableFrom(clz)) {
            return new LongArrayCodec(clz);
        }
        throw new IllegalArgumentException("Provided Class (" + clz + " is not a Codec or a supported type");
    }

    public static class ArrayCodec
    extends AbstractCodec {
        protected Class<?> f_clzComponent;

        public ArrayCodec(Class<?> clzComponent) {
            this.f_clzComponent = clzComponent;
        }

        @Override
        public Object decode(PofReader in, int index) throws IOException {
            return in.readArray(index, cSize -> (Object[])Array.newInstance(this.f_clzComponent, cSize));
        }
    }

    public static class LongArrayCodec
    extends AbstractCodec {
        protected Class<LongArray<Object>> f_clzLa;

        public LongArrayCodec(Class<LongArray<Object>> clzLa) {
            this.f_clzLa = clzLa;
        }

        @Override
        public Object decode(PofReader in, int index) throws IOException {
            return in.readLongArray(index, LongArrayCodec.newInstance(this.f_clzLa));
        }
    }

    public static class MapCodec
    extends AbstractCodec {
        protected Class<? extends Map<Object, Object>> f_clzMap;

        public MapCodec(Class<? extends Map<Object, Object>> clzMap) {
            this.f_clzMap = clzMap;
        }

        @Override
        public Object decode(PofReader in, int index) throws IOException {
            return in.readMap(index, MapCodec.newInstance(this.f_clzMap));
        }
    }

    public static class CollectionCodec
    extends AbstractCodec {
        protected Class<? extends Collection<Object>> f_clzCol;

        public CollectionCodec(Class<? extends Collection<Object>> clzCol) {
            this.f_clzCol = clzCol;
        }

        @Override
        public Object decode(PofReader in, int index) throws IOException {
            return in.readCollection(index, CollectionCodec.newInstance(this.f_clzCol));
        }
    }

    public static class DefaultCodec
    extends AbstractCodec {
        @Override
        public Object decode(PofReader in, int index) throws IOException {
            return in.readObject(index);
        }
    }

    public static abstract class AbstractCodec
    implements Codec {
        @Override
        public void encode(PofWriter out, int index, Object value) throws IOException {
            out.writeObject(index, value);
        }

        protected static <T> T newInstance(Class<T> clz) {
            try {
                return clz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw Base.ensureRuntimeException(e, "Unable to instantiate class (" + clz + ") that should implement Codec and have a no-arg constructor");
            }
        }
    }
}

