/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.Coherence;
import com.tangosol.net.SessionConfiguration;
import com.tangosol.net.events.EventInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public interface CoherenceConfiguration {
    public static Builder builder() {
        return new Builder();
    }

    public static CoherenceConfiguration create() {
        return CoherenceConfiguration.builder().withSession(SessionConfiguration.defaultSession()).discoverSessions().build();
    }

    public String getName();

    public Map<String, SessionConfiguration> getSessionConfigurations();

    public Iterable<EventInterceptor<?>> getInterceptors();

    public static class SimpleConfig
    implements CoherenceConfiguration {
        private final String f_sName;
        private final Map<String, SessionConfiguration> f_mapConfig;
        private final List<EventInterceptor<?>> f_listInterceptor;

        private SimpleConfig(String sName, Map<String, SessionConfiguration> mapConfig, List<EventInterceptor<?>> listInterceptor) {
            this.f_sName = sName == null || sName.trim().isEmpty() ? "" : sName.trim();
            this.f_mapConfig = Collections.unmodifiableMap(new HashMap<String, SessionConfiguration>(mapConfig));
            this.f_listInterceptor = Collections.unmodifiableList(new ArrayList(listInterceptor));
        }

        @Override
        public String getName() {
            return this.f_sName;
        }

        @Override
        public Map<String, SessionConfiguration> getSessionConfigurations() {
            return this.f_mapConfig;
        }

        @Override
        public Iterable<EventInterceptor<?>> getInterceptors() {
            return this.f_listInterceptor;
        }
    }

    public static class Builder {
        private String m_sName;
        private final Map<String, SessionConfiguration> f_mapConfig = new HashMap<String, SessionConfiguration>();
        private final List<EventInterceptor<?>> f_listInterceptor = new ArrayList();

        public Builder named(String sName) {
            this.m_sName = sName;
            return this;
        }

        public Builder discoverSessions() {
            this.withSessions(ServiceLoader.load(SessionConfiguration.class));
            return this;
        }

        public Builder withSession(SessionConfiguration config) {
            if (config != null && config.isEnabled()) {
                String sName = config.getName();
                if (sName == null) {
                    throw new IllegalArgumentException("A session configuration must provide a non-null name");
                }
                this.f_mapConfig.put(sName, config);
            }
            return this;
        }

        public Builder withSessions(Iterable<? extends SessionConfiguration> configs) {
            for (SessionConfiguration sessionConfiguration : configs) {
                this.withSession(sessionConfiguration);
            }
            return this;
        }

        public Builder withSessions(SessionConfiguration ... configs) {
            for (SessionConfiguration configuration : configs) {
                this.withSession(configuration);
            }
            return this;
        }

        public Builder withEventInterceptor(EventInterceptor<?> interceptor) {
            this.f_listInterceptor.add(interceptor);
            return this;
        }

        public Builder withEventInterceptors(EventInterceptor<?> ... interceptors) {
            Collections.addAll(this.f_listInterceptor, interceptors);
            return this;
        }

        public Builder withEventInterceptors(Iterable<? extends EventInterceptor<?>> interceptors) {
            for (EventInterceptor<?> interceptor : interceptors) {
                this.f_listInterceptor.add(interceptor);
            }
            return this;
        }

        public CoherenceConfiguration build() {
            if (Coherence.getInstance(this.m_sName) != null) {
                throw new IllegalStateException("A Coherence instance already exists with the name " + this.m_sName);
            }
            HashMap<String, SessionConfiguration> mapConfig = new HashMap<String, SessionConfiguration>(this.f_mapConfig);
            if (mapConfig.isEmpty()) {
                SessionConfiguration cfgDefault = SessionConfiguration.defaultSession();
                mapConfig.put(cfgDefault.getName(), cfgDefault);
            }
            return new SimpleConfig(this.m_sName, mapConfig, this.f_listInterceptor);
        }
    }
}

