/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.util.GridComponent;
import com.tangosol.net.Action;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberIdentity;
import com.tangosol.net.MemberListener;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.ProxyService;
import com.tangosol.net.Service;
import com.tangosol.net.internal.QuorumInfo;
import com.tangosol.net.management.Registry;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.persistence.CachePersistenceHelper;
import com.tangosol.persistence.GUIDHelper;
import com.tangosol.util.Base;
import com.tangosol.util.LongArray;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SynchronousListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class ConfigurableQuorumPolicy
extends Base
implements ActionPolicy {
    protected ConfigurableQuorumPolicy() {
    }

    public abstract String getStatusDescription();

    public static PartitionedCacheQuorumPolicy instantiatePartitionedCachePolicy(MembershipQuorumPolicy.QuorumRule[] aRule, AddressProvider provider) {
        return new PartitionedCacheQuorumPolicy(aRule, provider);
    }

    public static ProxyQuorumPolicy instantiateProxyPolicy(MembershipQuorumPolicy.QuorumRule[] aRule) {
        return new ProxyQuorumPolicy(aRule);
    }

    public static ClusterQuorumPolicy instantiateClusterPolicy(Map<String, Integer> mapQuorum) {
        return new ClusterQuorumPolicy(mapQuorum);
    }

    public static class ClusterQuorumPolicy
    extends ConfigurableQuorumPolicy
    implements ActionPolicy {
        public static final String ROLE_ALL = "*role-any*";
        public static final String SITES = "*sites*";
        public static final String MACHINES = "*machines*";
        protected Service m_service;
        protected Map<String, Integer> m_mapQuorumByRole;

        protected ClusterQuorumPolicy(Map<String, Integer> mapQuorum) {
            this.setClusterQuorumMap(mapQuorum);
        }

        protected Map<String, Integer> getClusterQuorumMap() {
            return this.m_mapQuorumByRole;
        }

        protected void setClusterQuorumMap(Map mapQuorumByRole) {
            this.m_mapQuorumByRole = mapQuorumByRole;
        }

        public Service getService() {
            return this.m_service;
        }

        public void setService(Service service) {
            this.m_service = service;
        }

        @Override
        public String getStatusDescription() {
            StringBuilder sb = new StringBuilder();
            sb.append("thresholds: {");
            Iterator<Map.Entry<String, Integer>> iter = this.getClusterQuorumMap().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, Integer> entry = iter.next();
                String sRole = entry.getKey();
                Integer IQuorum = entry.getValue();
                sb.append(ClusterQuorumPolicy.equals(sRole, ROLE_ALL) ? "*" : "\"" + sRole + "\"");
                sb.append("=").append(IQuorum);
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
            return sb.toString();
        }

        protected Set ensureSet(Set set) {
            return set == null ? NullImplementation.getSet() : set;
        }

        protected Map<String, Set<Member>> groupMembersByRole(Set<Member> setMembers) {
            HashMap<String, Set<Member>> mapByRole = new HashMap<String, Set<Member>>();
            mapByRole.put(ROLE_ALL, setMembers);
            for (Member member : setMembers) {
                for (String sRole : member.getRoles()) {
                    HashSet<Member> setRoleMember = (HashSet<Member>)mapByRole.get(sRole);
                    if (setRoleMember == null) {
                        setRoleMember = new HashSet<Member>();
                        mapByRole.put(sRole, setRoleMember);
                    }
                    setRoleMember.add(member);
                }
            }
            return mapByRole;
        }

        protected boolean checkSiteQuorum(int cQuorum, Set<Member> setMembers, Set<Member> setTimedOut, Set<Member> setHealthy, Set<Member> setAnnouncing) {
            return setHealthy.stream().map(MemberIdentity::getSiteName).filter(Objects::nonNull).distinct().count() >= (long)cQuorum;
        }

        protected boolean checkMachineQuorum(int cQuorum, Set<Member> setMembers, Set<Member> setTimedOut, Set<Member> setHealthy, Set<Member> setAnnouncing) {
            return setHealthy.stream().map(MemberIdentity::getMachineName).filter(Objects::nonNull).distinct().count() >= (long)cQuorum;
        }

        protected boolean checkRoleQuorum(int cQuorum, Set setMembers, Set setTimedOut, Set setHealthy, Set setAnnouncing) {
            if (setTimedOut.contains(this.getService().getCluster().getLocalMember())) {
                return cQuorum == 0;
            }
            return setHealthy.size() + setAnnouncing.size() >= cQuorum;
        }

        @Override
        public void init(Service service) {
            this.setService(service);
        }

        @Override
        public boolean isAllowed(Service service, Action action) {
            if (action instanceof Cluster.MemberTimeoutAction) {
                Cluster.MemberTimeoutAction timeoutAction = (Cluster.MemberTimeoutAction)action;
                Set setMembers = service.getInfo().getServiceMembers();
                Set<Member> setTimedOut = timeoutAction.getTimedOutMemberSet();
                Set<Member> setHealthy = timeoutAction.getResponsiveMemberSet();
                Set<Member> setAnnouncing = timeoutAction.getAnnouncingMemberSet();
                Map<String, Set<Member>> mapMembersByRole = this.groupMembersByRole(setMembers);
                Map<String, Set<Member>> mapTimedOutByRole = this.groupMembersByRole(setTimedOut);
                Map<String, Set<Member>> mapHealthyByRole = this.groupMembersByRole(setHealthy);
                Map<String, Set<Member>> mapAnnouncingByRole = this.groupMembersByRole(setAnnouncing);
                for (Map.Entry<String, Integer> entry : this.getClusterQuorumMap().entrySet()) {
                    String sRole = entry.getKey();
                    int cQuorum = entry.getValue();
                    if (!(sRole.startsWith(SITES) ? !this.checkSiteQuorum(cQuorum, this.ensureSet(mapMembersByRole.get(sRole = sRole.substring(SITES.length()))), this.ensureSet(mapTimedOutByRole.get(sRole)), this.ensureSet(mapHealthyByRole.get(sRole)), this.ensureSet(mapAnnouncingByRole.get(sRole))) : (sRole.startsWith(MACHINES) ? !this.checkMachineQuorum(cQuorum, this.ensureSet(mapMembersByRole.get(sRole = sRole.substring(MACHINES.length()))), this.ensureSet(mapTimedOutByRole.get(sRole)), this.ensureSet(mapHealthyByRole.get(sRole)), this.ensureSet(mapAnnouncingByRole.get(sRole))) : !this.checkRoleQuorum(cQuorum, this.ensureSet(mapMembersByRole.get(sRole)), this.ensureSet(mapTimedOutByRole.get(sRole)), this.ensureSet(mapHealthyByRole.get(sRole)), this.ensureSet(mapAnnouncingByRole.get(sRole)))))) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class ProxyQuorumPolicy
    extends MembershipQuorumPolicy {
        public static final int MASK_CONNECT = 1;

        protected ProxyQuorumPolicy(MembershipQuorumPolicy.QuorumRule[] aRule) {
            this.configure(aRule);
        }

        @Override
        public String getStatusDescription() {
            int nMask = this.getCurrentRule().getRuleMask();
            StringBuilder sbStatus = new StringBuilder();
            sbStatus.append("allowed-actions=");
            if ((nMask & 1) != 0) {
                sbStatus.append("connect");
            }
            return sbStatus.toString();
        }

        @Override
        public boolean isAllowed(Service service, Action action) {
            MembershipQuorumPolicy.QuorumRule ruleCurrent = this.getCurrentRule();
            if (ruleCurrent == MembershipQuorumPolicy.QuorumRule.ALL_ALLOWED) {
                return true;
            }
            if (action == ProxyService.ProxyAction.CONNECT) {
                return ruleCurrent.contains(1);
            }
            return true;
        }
    }

    public static class PartitionedCacheQuorumPolicy
    extends MembershipQuorumPolicy {
        public static final int MASK_DISTRIBUTION = 1;
        public static final int MASK_RESTORE = 2;
        public static final int MASK_READ = 4;
        public static final int MASK_WRITE = 8;
        public static final int MASK_RECOVER = 16;
        protected static final int MASK_LAST = 16;
        protected AddressProvider m_apRecovery;
        protected long m_ldtLastReport;
        protected boolean m_fDynamic;
        private boolean m_fLogged = false;

        public PartitionedCacheQuorumPolicy(MembershipQuorumPolicy.QuorumRule[] aRule, AddressProvider provider) {
            this.configure(aRule);
            this.m_apRecovery = provider;
            this.m_fDynamic = provider == null;
        }

        protected Set getOwnershipMemberSet() {
            return this.getService().getOwnershipEnabledMembers();
        }

        @Override
        public PartitionedService getService() {
            return (PartitionedService)super.getService();
        }

        protected List<Notification> checkRecoveryMembership(PartitionedService.PartitionRecoveryAction action) {
            List<Notification> listReasons = null;
            QuorumInfo info = action.getQuorumInfo();
            GUIDHelper.GUIDResolver resolver = action.getResolver();
            PartitionSet partsRecover = action.getOrphanedPartitions();
            PartitionSet partsMissing = resolver.getUnresolvedPartitions();
            if (this.m_fDynamic) {
                int cQuorum;
                PartitionSet partsStale;
                Set<Member> setLast;
                Set<Member> set = setLast = info == null ? null : info.getMembers();
                if (setLast == null) {
                    if (partsMissing.isFull()) {
                        return null;
                    }
                    if (partsMissing.isEmpty()) {
                        return null;
                    }
                    if (!partsRecover.isFull() && !partsMissing.intersects(partsRecover)) {
                        return null;
                    }
                    return PartitionedCacheQuorumPolicy.addReason(listReasons, "Unreachable quorum info " + partsMissing, "recovery of " + partsRecover + " is disallowed");
                }
                if (partsMissing.intersects(partsRecover)) {
                    partsMissing = new PartitionSet(partsMissing);
                    partsMissing.retain(partsRecover);
                    listReasons = PartitionedCacheQuorumPolicy.addReason(listReasons, "Unreachable " + partsMissing, PartitionedCacheQuorumPolicy.reportLastOwnership(partsMissing, info));
                }
                if (!(partsStale = this.getStalePartitions(action, partsRecover, partsMissing)).isEmpty()) {
                    listReasons = PartitionedCacheQuorumPolicy.addReason(listReasons, "Stale storage versions for " + partsStale, PartitionedCacheQuorumPolicy.reportLastOwnership(partsStale, info));
                }
                int cLast = setLast.size();
                int cParts = partsRecover.getPartitionCount();
                int cCurrent = this.getOwnershipMemberSet().size();
                MembershipQuorumPolicy.QuorumRule ruleRecover = this.getRule(16);
                float fThreshold = ruleRecover.getThresholdFactor();
                int cMinimum = Math.min(this.calculateMinThreshold(cLast, fThreshold), cParts);
                int n = cQuorum = ruleRecover == null ? 0 : ruleRecover.getThreshold();
                if (cQuorum > 0) {
                    cMinimum = cQuorum;
                }
                if (cCurrent < cMinimum) {
                    listReasons = PartitionedCacheQuorumPolicy.addReason(listReasons, "Insufficient capacity", cQuorum == 0 ? "the last known ownership size was " + cLast : ", need at least " + cMinimum + " nodes to recover");
                } else if (!resolver.isSharedStorage()) {
                    int cMinThreshold;
                    int cMinLast = PartitionedCacheQuorumPolicy.calculateMinimumNodeCount(info.getMembers());
                    int cMinCurrent = PartitionedCacheQuorumPolicy.calculateMinimumNodeCount(this.getService().getOwnershipEnabledMembers());
                    if (cMinCurrent < (cMinThreshold = this.calculateMinThreshold(cMinLast, fThreshold))) {
                        listReasons = PartitionedCacheQuorumPolicy.addReason(listReasons, "Insufficient minimum capacity", "the last known distribution had " + cMinLast + " nodes on the least loaded machine, current minimum is " + cMinCurrent);
                    }
                }
            } else {
                AddressProvider provider = this.m_apRecovery;
                if (provider != null) {
                    HashSet<String> setAddresses = new HashSet<String>();
                    for (Member member : this.getOwnershipMemberSet()) {
                        setAddresses.add(member.getAddress().getHostAddress());
                    }
                    InetSocketAddress address = provider.getNextAddress();
                    while (address != null) {
                        String sAddress = address.getAddress().getHostAddress();
                        if (!setAddresses.contains(sAddress)) {
                            if (this.m_fLogged) {
                                listReasons = PartitionedCacheQuorumPolicy.addReason(listReasons, "Address in <recovery-hosts> is not present: " + sAddress, "");
                            } else {
                                listReasons = PartitionedCacheQuorumPolicy.addReason(listReasons, "Address in <recovery-hosts> is not present: " + sAddress, "Persistence recovery will be deferred until a member from the missing host(s) joins the service.\nTo commence recovery regardless of the missing hosts use the forceRecovery operation on the PersistenceManagerMBean.");
                                this.m_fLogged = true;
                            }
                        }
                        address = provider.getNextAddress();
                    }
                }
                if (listReasons == null) {
                    PartitionSet partsStale;
                    if (!partsMissing.isFull() && !partsMissing.isEmpty() && partsMissing.intersects(partsRecover)) {
                        partsMissing = new PartitionSet(partsMissing);
                        partsMissing.retain(partsRecover);
                        listReasons = PartitionedCacheQuorumPolicy.addReason(listReasons, "Unreachable " + partsMissing, PartitionedCacheQuorumPolicy.reportLastOwnership(partsMissing, info));
                    }
                    if (!(partsStale = this.getStalePartitions(action, partsRecover, partsMissing)).isEmpty()) {
                        listReasons = PartitionedCacheQuorumPolicy.addReason(listReasons, "Stale storage versions for " + partsStale, PartitionedCacheQuorumPolicy.reportLastOwnership(partsStale, info));
                    }
                }
            }
            return listReasons;
        }

        protected PartitionSet getStalePartitions(PartitionedService.PartitionRecoveryAction action, PartitionSet partsRecover, PartitionSet partsMissing) {
            QuorumInfo info = action.getQuorumInfo();
            GUIDHelper.GUIDResolver resolver = action.getResolver();
            PartitionSet partsStale = new PartitionSet(partsRecover);
            partsStale.remove(partsMissing);
            int iPart = partsStale.next(0);
            while (iPart >= 0) {
                int nVersionPresent;
                int nVersionLast;
                int n = nVersionLast = info == null ? 0 : info.getVersions()[iPart];
                if (nVersionLast <= 0 || nVersionLast <= (nVersionPresent = (int)GUIDHelper.getVersion(resolver.getNewestGUID(iPart)))) {
                    partsStale.remove(iPart);
                }
                iPart = partsStale.next(iPart + 1);
            }
            return partsStale;
        }

        protected int calculateMinThreshold(int cLast, float flPct) {
            return (int)(flPct > 0.0f ? (float)cLast * flPct : (float)(cLast * 2 / 3));
        }

        private static List<Notification> addReason(List<Notification> list, String sMessage, String sData) {
            if (list == null) {
                list = new LinkedList<Notification>();
            }
            list.add(new Notification(sMessage, sData));
            return list;
        }

        protected static String reportLastOwnership(PartitionSet parts, QuorumInfo info) {
            if (info == null) {
                return "";
            }
            LongArray<Member> laMembers = info.getMemberArray();
            int[] anOwner = info.getOwners();
            HashSet<Member> setMembers = new HashSet<Member>();
            int iPart = parts.next(0);
            while (iPart >= 0) {
                int nOwner = anOwner[iPart];
                if (nOwner > 0) {
                    setMembers.add(laMembers.get(nOwner));
                }
                iPart = parts.next(iPart + 1);
            }
            HashSet<String> setReported = new HashSet<String>();
            StringBuilder sb = new StringBuilder("last known locations:");
            for (Member member : setMembers) {
                String sMachine = member.getMachineName();
                if (sMachine == null) {
                    sMachine = member.getAddress().toString();
                }
                if (!setReported.add(sMachine)) continue;
                sb.append(' ');
                String sAddress = member.getAddress().toString();
                if (sAddress.contains(sMachine)) {
                    sb.append(sAddress);
                } else {
                    sb.append(sMachine).append(" at ").append(sAddress);
                }
                sb.append(',');
            }
            return setReported.isEmpty() ? "" : sb.substring(0, sb.length() - 1);
        }

        protected static int calculateMinimumNodeCount(Set<Member> setMembers) {
            Integer ICount;
            HashMap<Object, Integer> mapCount = new HashMap<Object, Integer>();
            for (Member member : setMembers) {
                String sName = member.getMachineName();
                if (sName == null || sName.isEmpty()) {
                    mapCount.clear();
                    break;
                }
                ICount = (Integer)mapCount.get(sName);
                mapCount.put(sName, ICount == null ? 1 : ICount + 1);
            }
            if (mapCount.isEmpty()) {
                for (Member member : setMembers) {
                    InetAddress address;
                    ICount = (Integer)mapCount.get(address = member.getAddress());
                    mapCount.put(address, ICount == null ? 1 : ICount + 1);
                }
            }
            int cMin = Integer.MAX_VALUE;
            for (Integer C : mapCount.values()) {
                cMin = Math.min(cMin, C);
            }
            return cMin;
        }

        @Override
        public String getStatusDescription() {
            return "allowed-actions=" + this.getActionName(this.getCurrentRule().getRuleMask());
        }

        @Override
        public int getPolicyPopulation() {
            Set setOwners = this.getOwnershipMemberSet();
            setOwners.removeAll(this.getLeavingMembers());
            return setOwners.size();
        }

        @Override
        public boolean isAllowed(Service service, Action action) {
            int nMask = 0;
            List<Notification> listReasons = null;
            MembershipQuorumPolicy.QuorumRule ruleCurrent = this.getCurrentRule();
            if (action == CacheService.CacheAction.READ) {
                nMask = 4;
            } else if (action == CacheService.CacheAction.WRITE) {
                nMask = 8;
            } else if (action == PartitionedService.PartitionedAction.DISTRIBUTE) {
                nMask = 1;
            } else if (action == PartitionedService.PartitionedAction.RESTORE) {
                nMask = 2;
            } else if (action instanceof PartitionedService.PartitionRecoveryAction) {
                nMask = 16;
                listReasons = this.checkRecoveryMembership((PartitionedService.PartitionRecoveryAction)action);
                if (listReasons != null) {
                    ruleCurrent = MembershipQuorumPolicy.QuorumRule.NONE_ALLOWED;
                }
            }
            if (nMask > 0 && !ruleCurrent.contains(nMask)) {
                this.reportDisallowedAction(nMask, listReasons);
                return false;
            }
            return true;
        }

        @Override
        protected void updateCurrentRule() {
            super.updateCurrentRule();
            this.m_ldtLastReport = 0L;
        }

        protected void reportDisallowedAction(int nMaskDisallowed, List<Notification> listReasons) {
            long ldtNow = PartitionedCacheQuorumPolicy.getLastSafeTimeMillis();
            if (this.m_ldtLastReport > ldtNow - 60000L) {
                return;
            }
            MembershipQuorumPolicy.QuorumRule ruleCurrent = this.getCurrentRule();
            StringBuilder sb = new StringBuilder("Action \"").append(this.getActionName(nMaskDisallowed)).append("\" disallowed");
            if (ruleCurrent.compareTo(MembershipQuorumPolicy.QuorumRule.ALL_ALLOWED) != 0) {
                sb.append("; all-disallowed-actions: ").append(this.getActionName(~ruleCurrent.getRuleMask()));
            }
            if (listReasons != null) {
                GridComponent _service = (GridComponent)((Object)this.getService());
                Registry registry = _service.getCluster().getManagement();
                String sMBean = CachePersistenceHelper.getMBeanName(_service.getInfo().getServiceName());
                for (Notification note : listReasons) {
                    sb.append(":\n").append(note.Message).append(" - ").append(note.UserData);
                    if (registry == null) continue;
                    _service.dispatchNotification(registry.ensureGlobalName(sMBean), "recover.disallowed", note.Message, note.UserData);
                }
            }
            Logger.warn(sb.toString());
            this.m_ldtLastReport = ldtNow;
        }

        protected String getActionName(int nMask) {
            StringBuilder sb = new StringBuilder();
            block7: for (int nBit = 1; nBit <= 16; nBit <<= 1) {
                if ((nMask & nBit) == 0) continue;
                switch (nBit) {
                    case 1: {
                        sb.append(", distribution");
                        continue block7;
                    }
                    case 2: {
                        sb.append(", restore");
                        continue block7;
                    }
                    case 16: {
                        sb.append(", recover");
                        continue block7;
                    }
                    case 4: {
                        sb.append(", read");
                        continue block7;
                    }
                    case 8: {
                        sb.append(", write");
                    }
                }
            }
            return sb.length() == 0 ? sb.toString() : sb.substring(2);
        }

        public static enum ActionRule {
            DISTRIBUTION(1),
            RESTORE(2),
            RECOVER(16),
            READ(4),
            WRITE(8);

            private final int m_nMask;
            private final String m_sElementName;

            private ActionRule(int nMask) {
                this.m_nMask = nMask;
                this.m_sElementName = this.name().toLowerCase() + "-quorum";
            }

            public String getElementName() {
                return this.m_sElementName;
            }

            public int getMask() {
                return this.m_nMask;
            }
        }

        public static class Notification {
            public final String Message;
            public final String UserData;

            public Notification(String sMessage, String sUserData) {
                this.Message = sMessage;
                this.UserData = sUserData;
            }
        }
    }

    public static abstract class MembershipQuorumPolicy
    extends ConfigurableQuorumPolicy {
        protected Set m_setLeaving = new HashSet();
        protected Service m_service;
        protected QuorumRule m_ruleCurrent;
        protected QuorumRule[] m_aRules;

        protected MembershipQuorumPolicy() {
        }

        public Service getService() {
            return this.m_service;
        }

        protected void setService(Service service) {
            this.m_service = service;
        }

        protected QuorumRule getCurrentRule() {
            return this.m_ruleCurrent;
        }

        protected QuorumRule getRule(int nMask) {
            QuorumRule[] aRule;
            for (QuorumRule rule : aRule = this.getQuorumRules()) {
                if (!rule.contains(nMask)) continue;
                return rule;
            }
            return null;
        }

        protected void setCurrentRule(QuorumRule ruleCurrent) {
            this.m_ruleCurrent = ruleCurrent;
        }

        protected void setQuorumRules(QuorumRule[] aRule) {
            this.m_aRules = aRule;
        }

        protected QuorumRule[] getQuorumRules() {
            return this.m_aRules;
        }

        protected Set getLeavingMembers() {
            return this.m_setLeaving;
        }

        protected int getPolicyPopulation() {
            Set setMembers = this.getService().getInfo().getServiceMembers();
            setMembers.removeAll(this.getLeavingMembers());
            return setMembers.size();
        }

        protected void configure(QuorumRule[] aRule) {
            QuorumRule rulePrevious;
            int cRules = aRule.length;
            if (cRules == 0) {
                this.setQuorumRules(new QuorumRule[]{QuorumRule.ALL_ALLOWED});
                return;
            }
            Arrays.sort(aRule);
            ArrayList<QuorumRule> listNewRules = new ArrayList<QuorumRule>(cRules + 2);
            QuorumRule ruleNext = rulePrevious = QuorumRule.NONE_ALLOWED;
            for (int i = 0; i < cRules; ++i) {
                ruleNext = aRule[i].union(rulePrevious);
                if (ruleNext.getThreshold() > rulePrevious.getThreshold()) {
                    listNewRules.add(rulePrevious);
                }
                rulePrevious = ruleNext;
            }
            listNewRules.add(ruleNext);
            listNewRules.add(QuorumRule.ALL_ALLOWED);
            this.setQuorumRules(listNewRules.toArray(new QuorumRule[listNewRules.size()]));
            this.setCurrentRule(QuorumRule.NONE_ALLOWED);
        }

        protected void updateCurrentRule() {
            QuorumRule ruleNew = null;
            int nSize = this.getPolicyPopulation();
            for (QuorumRule ruleCurrent : this.getQuorumRules()) {
                if (nSize < ruleCurrent.getThreshold()) break;
                ruleNew = ruleCurrent;
            }
            if (ruleNew != this.getCurrentRule()) {
                this.setCurrentRule(ruleNew);
            }
        }

        @Override
        public void init(Service service) {
            this.setService(service);
            service.addMemberListener(this.instantiateMemberListener());
            this.updateCurrentRule();
        }

        @Override
        public String toString() {
            return "{" + this.getClass().getName() + " " + this.getStatusDescription() + "}";
        }

        protected MemberListener instantiateMemberListener() {
            return new QuorumListener();
        }

        public static class QuorumRule
        implements Comparable<QuorumRule> {
            private int m_nThreshold;
            private float m_flThresholdPct;
            private int m_nRuleMask;
            protected static final QuorumRule NONE_ALLOWED = new QuorumRule(0, 0);
            protected static final QuorumRule ALL_ALLOWED = new QuorumRule(-1, 0);

            public QuorumRule(int nRuleMask, int nThreshold) {
                this(nRuleMask, nThreshold, 0.0f);
            }

            public QuorumRule(int nRuleMask, int nThreshold, float flThresholdPct) {
                this.setRuleMask(nRuleMask);
                this.setThreshold(nThreshold);
                this.setThresholdFactor(flThresholdPct);
            }

            @Override
            public int compareTo(QuorumRule that) {
                return this.getThreshold() - that.getThreshold();
            }

            public String toString() {
                return "QuorumRule {threshold=" + this.getThreshold() + ", rule mask=" + this.getRuleMask() + "}";
            }

            protected boolean contains(int nMask) {
                return (this.getRuleMask() & nMask) != 0;
            }

            protected QuorumRule union(QuorumRule rule) {
                return new QuorumRule(this.getRuleMask() | rule.getRuleMask(), Math.max(this.getThreshold(), rule.getThreshold()), Math.max(this.getThresholdFactor(), rule.m_flThresholdPct));
            }

            protected int getRuleMask() {
                return this.m_nRuleMask;
            }

            protected void setRuleMask(int nRuleMask) {
                this.m_nRuleMask = nRuleMask;
            }

            protected int getThreshold() {
                return this.m_nThreshold;
            }

            protected void setThreshold(int nThreshold) {
                this.m_nThreshold = nThreshold;
            }

            protected float getThresholdFactor() {
                return this.m_flThresholdPct;
            }

            protected void setThresholdFactor(float flThreshold) {
                this.m_flThresholdPct = flThreshold;
            }
        }

        protected class QuorumListener
        implements MemberListener,
        SynchronousListener {
            protected QuorumListener() {
            }

            @Override
            public void memberJoined(MemberEvent evt) {
                MembershipQuorumPolicy.this.updateCurrentRule();
            }

            @Override
            public void memberLeaving(MemberEvent evt) {
                MembershipQuorumPolicy.this.getLeavingMembers().add(evt.getMember());
                MembershipQuorumPolicy.this.updateCurrentRule();
            }

            @Override
            public void memberLeft(MemberEvent evt) {
                MembershipQuorumPolicy.this.getLeavingMembers().remove(evt.getMember());
                MembershipQuorumPolicy.this.updateCurrentRule();
            }
        }
    }
}

