/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.internal.net.MultiplexedSocketProvider;
import com.oracle.coherence.common.net.InetAddresses;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class InetAddressHelper
extends InetAddresses {
    public static InetAddress getLocalAddress(Filter filter) throws UnknownHostException {
        return InetAddressHelper.getLocalAddress(filter::evaluate);
    }

    public static String[] getAddressDescriptions(Collection colAddresses) {
        if (colAddresses == null) {
            return new String[0];
        }
        String[] asAddr = new String[colAddresses.size()];
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (InetSocketAddress addr : colAddresses) {
            sb.append(InetAddressHelper.toString(addr.getAddress())).append(':').append(addr.getPort());
            asAddr[i++] = sb.toString();
            sb.setLength(0);
        }
        return asAddr;
    }

    public static Collection<InetAddress> getRoutableAddresses(InetAddress addrLocal, boolean fLocalSrc, Collection<InetAddress> colDest, boolean fLocalDest) {
        List<InetAddress> colLocal;
        block9: {
            block8: {
                if (colDest == null) {
                    return null;
                }
                if (addrLocal == null) {
                    fLocalSrc = true;
                    colLocal = InetAddressHelper.getAllLocalAddresses();
                    addrLocal = (InetAddress)colLocal.iterator().next();
                } else {
                    Collection<InetAddress> collection = colLocal = fLocalSrc ? InetAddressHelper.getAllLocalAddresses() : Collections.singleton(addrLocal);
                }
                if (!fLocalDest) break block8;
                if (fLocalSrc) break block9;
            }
            colDest = colDest.stream().filter(InetAddresses.IsRoutable.INSTANCE::evaluate).collect(Collectors.toSet());
        }
        if (fLocalDest && !Collections.disjoint(colLocal, colDest)) {
            if (colDest.contains(addrLocal)) {
                return Collections.singleton(addrLocal);
            }
            colLocal.retainAll(colDest);
            return colLocal;
        }
        Class<?> clzAddrLocal = addrLocal.getClass();
        Collection colIpvMatch = colDest.stream().filter(p -> p.getClass() == clzAddrLocal).collect(Collectors.toList());
        Collection<InetAddress> colResult = InetAddressHelper.getRoutes(colIpvMatch, colLocal);
        return colResult.isEmpty() ? InetAddressHelper.getRoutes(colDest, colLocal) : colResult;
    }

    @Deprecated
    public static boolean isLoopbackAddress(InetAddress addr) {
        Base.azzert(addr != null);
        return addr.isLoopbackAddress();
    }

    @Deprecated
    public static boolean isAnyLocalAddress(InetAddress addr) {
        Base.azzert(addr != null);
        return addr.isAnyLocalAddress();
    }

    @Deprecated
    public static boolean isLinkLocalAddress(InetAddress addr) {
        Base.azzert(addr != null);
        return addr.isLinkLocalAddress();
    }

    @Deprecated
    public static boolean isSiteLocalAddress(InetAddress addr) {
        Base.azzert(addr != null);
        return addr.isSiteLocalAddress();
    }

    public static boolean virtuallyEqual(byte[] abAddr1, byte[] abAddr2) {
        int cb1 = abAddr1.length;
        int cb2 = abAddr2.length;
        Base.azzert(cb1 == 4 || cb1 == 16);
        int of1 = 0;
        int of2 = 0;
        if (cb1 != cb2) {
            byte[] abIP6;
            Base.azzert(cb2 == 4 || cb2 == 16);
            if (cb1 == 4) {
                abIP6 = abAddr2;
                of2 = 12;
            } else {
                abIP6 = abAddr1;
                of1 = 12;
            }
            for (int of = 0; of < 12; ++of) {
                if (abIP6[of] == 0) continue;
                return false;
            }
        }
        while (of1 < cb1) {
            if (abAddr1[of1++] == abAddr2[of2++]) continue;
            return false;
        }
        return true;
    }

    public static String toString(byte[] ab) {
        int cb = ab.length;
        int of = 0;
        Base.azzert(cb == 4 || cb == 16);
        StringBuilder sb = new StringBuilder(40);
        boolean fIPv4 = true;
        if (cb == 16) {
            int ofZ = 0;
            int cZ = 0;
            int cZMax = 0;
            int ofZMax = 0;
            int i = 0;
            while (i < (fIPv4 ? 6 : 8)) {
                int iVal = (ab[of + 0] & 0xFF) << 8 | ab[of + 1] & 0xFF;
                if (i > 0) {
                    sb.append(":");
                }
                if (iVal == 0) {
                    if (++cZ == 1) {
                        ofZ = sb.length();
                    }
                } else if (cZ > 0) {
                    if (cZ > cZMax) {
                        ofZMax = ofZ;
                        cZMax = cZ;
                    }
                    cZ = 0;
                }
                sb.append(Base.toHexString(iVal, Base.getMaxHexDigits(iVal)).toLowerCase());
                fIPv4 &= iVal == (i == 5 ? 65535 : 0);
                ++i;
                of += 2;
            }
            if (cZMax > 1) {
                sb.replace(ofZMax, ofZMax + cZMax * 2, ofZMax == 0 ? "::" : ":");
            }
            if (fIPv4) {
                sb.append(':');
            }
        }
        if (fIPv4) {
            int i = 0;
            while (i < 3) {
                sb.append(ab[of] & 0xFF).append('.');
                ++i;
                ++of;
            }
            sb.append(ab[of] & 0xFF);
        }
        return sb.toString();
    }

    public static String toString(InetAddress addr) {
        if (addr == null) {
            return String.valueOf(addr);
        }
        if (addr instanceof Inet6Address) {
            return InetAddressHelper.toString(addr.getAddress());
        }
        return addr.getHostAddress();
    }

    public static String toString(int nPort) {
        String sPort = Integer.toString(MultiplexedSocketProvider.getBasePort(nPort));
        return MultiplexedSocketProvider.isPortExtended(nPort) ? sPort + '.' + MultiplexedSocketProvider.getSubPort(nPort) : sPort;
    }

    public static class SubnetMaskFilter
    extends InetAddresses.IsSubnetMask
    implements Filter<InetAddress> {
        public SubnetMaskFilter(InetAddress addrPattern, InetAddress addrMask) {
            super(addrPattern, addrMask);
        }

        public SubnetMaskFilter(InetAddress addrPattern, int cMaskBits) {
            super(addrPattern, cMaskBits);
        }

        public SubnetMaskFilter(String sAddr) {
            super(sAddr);
        }
    }

    public static class RoutableFilter
    extends InetAddresses.IsRoutable
    implements Filter<InetAddress> {
        public static final RoutableFilter INSTANCE = new RoutableFilter();
    }
}

