/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.dev.tools.CommandLineTool;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Daemon;
import com.tangosol.util.ListMap;
import com.tangosol.util.UID;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.util.Date;

public class MulticastTest
extends Base {
    private InetAddress m_addrIface;
    private InetSocketAddress m_addrGroup;
    private int m_nTTL;
    private String m_sNode;
    private MulticastSocket m_socket;
    private int m_cSecsDelay;
    private int m_cbMax;
    private UID m_uid = new UID();
    private boolean m_fTranslate;
    private int m_cb;
    private Class m_clzCoherence;
    private Object m_msgPrevHeartbeat;
    public static final String COMMAND_HELP = "?";
    public static final String COMMAND_ADDR_LOCAL = "local";
    public static final String COMMAND_ADDR_GROUP = "group";
    public static final String COMMAND_TTL = "ttl";
    public static final String COMMAND_DELAY = "delay";
    public static final String COMMAND_DISPLAY = "display";
    public static final String COMMAND_TRANSLATE = "translate";
    public static final String COMMAND_PACKET = "packetSize";
    public static final String DEFAULT_ADDR_LOCAL = "localhost";
    public static final int DEFAULT_PORT = 9000;
    public static final String DEFAULT_IP_GROUP = "239.192.0.0";
    public static final String DEFAULT_ADDR_GROUP = "239.192.0.0:9000";
    public static final int DEFAULT_TTL = 4;
    public static final int DEFAULT_DELAY = 2;
    public static final int DEFAULT_DISPLAY = 0;
    public static final int DEFAULT_PACKET = 1468;
    static final int MAGIC = 1952805748;
    static final int CLUSTER = 0xDDF00D0;
    static final int CLUSTER_MASK = -16;
    static final int BROADCAST = 232718546;
    public static final String[] VALID_COMMANDS = new String[]{"?", "local", "group", "ttl", "packetSize", "delay", "display", "translate"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] asArg) {
        int nMTU;
        InetSocketAddress addrGroup;
        InetAddress addrIface;
        ListMap mapArgs;
        try {
            mapArgs = CommandLineTool.parseArguments(asArg, VALID_COMMANDS, true);
            if (mapArgs.containsKey(COMMAND_HELP) || mapArgs.get(0) != null) {
                MulticastTest.showInstructions();
                return;
            }
            String sValue = (String)mapArgs.get(COMMAND_ADDR_LOCAL);
            addrIface = sValue == null ? null : InetAddressHelper.getLocalAddress(sValue);
            sValue = (String)mapArgs.get(COMMAND_ADDR_GROUP);
            if (sValue != null && sValue.startsWith(":")) {
                sValue = DEFAULT_IP_GROUP + sValue;
            }
            addrGroup = InetAddressHelper.getSocketAddress(sValue == null ? DEFAULT_ADDR_GROUP : sValue, 9000);
        }
        catch (Throwable e) {
            MulticastTest.err();
            MulticastTest.err(e);
            MulticastTest.err();
            MulticastTest.showInstructions();
            return;
        }
        int nTTL = 4;
        try {
            nTTL = Integer.parseInt((String)mapArgs.get(COMMAND_TTL));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = nMTU = addrIface == null ? 0 : InetAddressHelper.getLocalMTU(addrIface);
        if (nMTU == 0) {
            nMTU = 1500;
        }
        int cb = nMTU - 48;
        try {
            cb = (int)Base.parseMemorySize((String)mapArgs.get(COMMAND_PACKET));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int cSecsDelay = 2;
        try {
            cSecsDelay = Integer.parseInt((String)mapArgs.get(COMMAND_DELAY));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int cbMax = 0;
        try {
            cbMax = Integer.parseInt((String)mapArgs.get(COMMAND_DISPLAY));
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean fTranslate = mapArgs.containsKey(COMMAND_TRANSLATE);
        if (addrIface != null && addrIface.isMulticastAddress()) {
            MulticastTest.out("Interface address " + addrIface + " is multi-cast; it must be an IP address bound to a physical interface");
            MulticastTest.showInstructions();
            return;
        }
        if (!addrGroup.getAddress().isMulticastAddress()) {
            MulticastTest.out("Multicast address " + addrGroup + " is not multi-cast; it must be in the range 224.0.0.0 to 239.255.255.255");
            MulticastTest.showInstructions();
            return;
        }
        if (nTTL < 0 || nTTL > 255) {
            MulticastTest.out("TTL " + nTTL + " is out of range; it must be in the range 1 to 255");
            MulticastTest.showInstructions();
            return;
        }
        if (mapArgs.isEmpty()) {
            MulticastTest.showInstructions();
            MulticastTest.out();
            MulticastTest.out("running with all default values...");
            MulticastTest.out();
        }
        try {
            new MulticastTest(addrIface, addrGroup, nTTL, Math.max(cSecsDelay, 1), Math.max(cbMax, 0), fTranslate, cb).run();
        }
        catch (Exception e) {
            MulticastTest.err("An exception occurred while executing the MulticastTest:");
            MulticastTest.err(e);
            MulticastTest.err();
        }
        finally {
            MulticastTest.out();
            MulticastTest.out("Exiting MulticastTest");
        }
    }

    protected static void showInstructions() {
        MulticastTest.out();
        MulticastTest.out("java com.tangosol.net.MulticastTest <commands ...>");
        MulticastTest.out();
        MulticastTest.out("command options:");
        MulticastTest.out("\t-local      (optional) the address of the NIC to transmit on, specified as an ip address, default localhost");
        MulticastTest.out("\t-group      (optional) the multicast address to use, specified as ip:port, default 239.192.0.0:9000");
        MulticastTest.out("\t-ttl        (optional) the time to live for multicast packets, default 4");
        MulticastTest.out("\t-delay      (optional) the delay in seconds between sending packets, default 2");
        MulticastTest.out("\t-packetSize (optional) the size of packet to send, default based on local MTU");
        MulticastTest.out("\t-display    (optional) the number of bytes to display from unexpected packets, default 0");
        MulticastTest.out("\t-translate  (optional) listen to cluster multicast traffic and translate packets");
        MulticastTest.out();
        MulticastTest.out("Example:");
        MulticastTest.out("\tjava com.tangosol.net.MulticastTest -group 237.0.0.1:9000 -ttl 4");
        MulticastTest.out();
    }

    public MulticastTest(InetAddress addrIface, InetSocketAddress addrGroup, int nTTL, int cSecsDelay, int cbMax, boolean fTranslate, int cb) {
        this.m_addrIface = addrIface;
        this.m_addrGroup = addrGroup;
        this.m_nTTL = nTTL;
        this.m_cSecsDelay = fTranslate ? 3600 : cSecsDelay;
        this.m_cbMax = cbMax;
        this.m_sNode = "ip=" + addrIface + ", group=" + addrGroup + ", ttl=" + nTTL;
        this.m_fTranslate = fTranslate;
        this.m_cb = cb;
    }

    public void run() {
        String sNode = this.m_sNode;
        MulticastTest.out("Starting test on " + sNode);
        MulticastTest.out("Configuring multicast socket...");
        this.initSocket();
        MulticastTest.out("Starting listener...");
        Listener listener = new Listener(this.m_cb);
        listener.start();
        int cPackets = 0;
        try {
            while (true) {
                if (!this.m_fTranslate) {
                    ByteArrayOutputStream streamRaw = new ByteArrayOutputStream();
                    DataOutputStream streamData = new DataOutputStream(streamRaw);
                    streamData.writeInt(1952805748);
                    streamData.writeLong(System.currentTimeMillis());
                    streamData.writeInt(++cPackets);
                    this.m_uid.save(streamData);
                    streamData.writeUTF(sNode);
                    for (int i = this.m_cb - streamData.size(); i > 0; --i) {
                        streamData.write(i);
                    }
                    streamData.close();
                    streamRaw.flush();
                    byte[] ab = streamRaw.toByteArray();
                    MulticastTest.out(new Date() + ": Sent packet " + cPackets + " containing " + ab.length + " bytes.");
                    DatagramPacket packet = new DatagramPacket(ab, ab.length, this.m_addrGroup.getAddress(), this.m_addrGroup.getPort());
                    this.m_socket.send(packet);
                }
                Blocking.sleep(this.m_cSecsDelay * 1000);
            }
        }
        catch (Exception e) {
            throw MulticastTest.ensureRuntimeException(e);
        }
    }

    protected void initSocket() {
        try {
            MulticastSocket socket = new MulticastSocket(this.m_addrGroup.getPort());
            if (this.m_addrIface != null) {
                socket.setInterface(this.m_addrIface);
            }
            socket.setTimeToLive(this.m_nTTL);
            socket.joinGroup(this.m_addrGroup.getAddress());
            this.m_socket = socket;
        }
        catch (Exception e) {
            throw MulticastTest.ensureRuntimeException(e);
        }
    }

    public void displayPacket(ReadBuffer buf, InetSocketAddress addr) throws Exception {
        int iFirst;
        ReadBuffer.BufferInput streamData = buf.getBufferInput();
        int n = iFirst = buf.length() >= 4 ? streamData.readInt() : 0;
        if (iFirst == 1952805748) {
            long cMillis = streamData.readLong();
            int cPackets = streamData.readInt();
            UID uid = new UID(streamData);
            String sNode = streamData.readUTF();
            if (uid.equals(this.m_uid)) {
                long cDif = System.currentTimeMillis() - cMillis;
                MulticastTest.out(new Date() + ": Received test packet " + cPackets + " from self" + (cDif <= 0L ? "" : " (sent " + cDif + "ms ago)."));
            } else {
                MulticastTest.out(new Date() + ": Received test packet " + cPackets + " from " + addr + " containing " + buf.length() + " bytes.");
            }
        } else if (this.m_fTranslate && iFirst == 232718546) {
            Class<?> clzCoherence = this.m_clzCoherence;
            if (clzCoherence == null) {
                clzCoherence = this.m_clzCoherence = Class.forName("com.tangosol.coherence.component.application.console.Coherence");
            }
            this.m_msgPrevHeartbeat = ClassHelper.invokeStatic(clzCoherence, "displayMessage", new Object[]{buf, addr, this.m_msgPrevHeartbeat});
        } else {
            int cb = buf.length();
            StringBuffer sb = new StringBuffer();
            sb.append(cb).append(" bytes from ");
            if ((iFirst & 0xFFFFFFF0) == 0xDDF00D0) {
                sb.append("a Coherence cluster node");
            } else {
                sb.append("an unknown multicast application");
            }
            if (addr != null) {
                sb.append(" at ").append(addr.getAddress().getHostAddress());
            }
            sb.append(": ");
            if (this.m_cbMax == 0) {
                sb.append("???");
            } else {
                sb.append(Base.toHexEscape(buf.toByteArray(), 0, Math.min(this.m_cbMax, cb)));
            }
            MulticastTest.out(new Date() + ": Received " + sb);
        }
    }

    public class Listener
    extends Daemon {
        private int m_cb;

        public Listener(int cb) {
            super("listener", 5, false);
            this.m_cb = cb;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    byte[] ab = new byte[this.m_cb];
                    DatagramPacket packet = new DatagramPacket(ab, ab.length);
                    MulticastTest.this.m_socket.receive(packet);
                    MulticastTest.this.displayPacket(new ByteArrayReadBuffer(ab, 0, packet.getLength()), new InetSocketAddress(packet.getAddress(), packet.getPort()));
                }
            }
            catch (Exception e) {
                Listener.err("The listener encountered an exception: ");
                Listener.err(e);
                Listener.err();
                Listener.err("The listener is terminating.");
                Listener.err();
                return;
            }
        }
    }
}

