/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.coherence.config.Config;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.DescribableAddressProvider;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Daemon;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RefreshableAddressProvider
extends Base
implements DescribableAddressProvider {
    public static final long REFRESH_DEFAULT = Config.getLong("coherence.wka.refresh.interval", 10000L);
    protected final long f_lRefresh;
    protected final Daemon f_daemonRefresh;
    protected final CircularIterator f_iterator = new CircularIterator();
    protected volatile List m_listCache;
    protected long m_ldtLastRefresh;
    protected AddressProvider m_apRefresh;

    public RefreshableAddressProvider(AddressProvider ap) {
        this(ap, REFRESH_DEFAULT);
    }

    public RefreshableAddressProvider(AddressProvider ap, long lRefresh) {
        this.m_apRefresh = ap;
        this.f_lRefresh = lRefresh;
        this.refreshAddressList();
        this.f_daemonRefresh = new RefreshThread(lRefresh);
    }

    protected InetSocketAddress getNextAddressInternal() {
        return this.m_apRefresh == null ? null : this.m_apRefresh.getNextAddress();
    }

    @Override
    public boolean equals(Object o) {
        return Base.equals(this.m_apRefresh, o instanceof RefreshableAddressProvider ? ((RefreshableAddressProvider)o).m_apRefresh : o);
    }

    @Override
    public int hashCode() {
        return this.m_apRefresh == null ? 0 : this.m_apRefresh.hashCode();
    }

    @Override
    public final synchronized InetSocketAddress getNextAddress() {
        return this.f_iterator.hasNext() ? (InetSocketAddress)this.f_iterator.next() : null;
    }

    @Override
    public final synchronized void accept() {
        this.f_iterator.setCircular(true);
    }

    @Override
    public final synchronized void reject(Throwable eCause) {
        try {
            this.f_iterator.remove();
        }
        catch (IllegalStateException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public String[] getAddressDescriptions() {
        return this.m_apRefresh instanceof DescribableAddressProvider ? ((DescribableAddressProvider)this.m_apRefresh).getAddressDescriptions() : InetAddressHelper.getAddressDescriptions(this.m_listCache);
    }

    protected void refreshAddressList() {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>();
        InetSocketAddress address = this.getNextAddressInternal();
        while (address != null) {
            list.add(address);
            address = this.getNextAddressInternal();
        }
        this.m_listCache = list;
        this.m_ldtLastRefresh = Base.getSafeTimeMillis();
    }

    protected void ensureRefreshThread() {
        if (!this.f_daemonRefresh.isRunning()) {
            this.f_daemonRefresh.start();
        }
    }

    protected class CircularIterator
    implements Iterator {
        protected boolean m_fCircular;
        protected Iterator m_iterator;

        protected CircularIterator() {
        }

        @Override
        public boolean hasNext() {
            boolean fNext;
            while (!(fNext = this.ensureIterator().hasNext())) {
                this.refreshIterator();
                if (!this.m_fCircular) break;
                this.m_fCircular = false;
            }
            return fNext;
        }

        public Object next() {
            return this.ensureIterator().next();
        }

        @Override
        public void remove() {
            this.ensureIterator().remove();
        }

        public void setCircular(boolean fCircular) {
            this.m_fCircular = fCircular;
        }

        protected Iterator ensureIterator() {
            if (this.m_iterator == null) {
                this.refreshIterator();
            }
            return this.m_iterator;
        }

        protected void refreshIterator() {
            this.m_iterator = RefreshableAddressProvider.this.m_listCache.iterator();
            if (Base.getSafeTimeMillis() - RefreshableAddressProvider.this.m_ldtLastRefresh > RefreshableAddressProvider.this.f_lRefresh) {
                RefreshableAddressProvider.this.ensureRefreshThread();
            }
        }
    }

    protected class RefreshThread
    extends Daemon {
        protected final long f_lRefresh;

        protected RefreshThread(long lRefresh) {
            super(RefreshableAddressProvider.this.getClass().getName() + ": RefreshThread");
            this.f_lRefresh = lRefresh;
        }

        @Override
        public void run() {
            long lRefresh = this.f_lRefresh;
            while (!this.isStopping()) {
                try {
                    RefreshableAddressProvider.this.refreshAddressList();
                    this.stop();
                }
                catch (Throwable t) {
                    RefreshThread.err("An exception occurred while refreshing an address list: \n" + RefreshThread.getStackTrace(t) + "\nReducing the refresh rate.");
                    Base.sleep(lRefresh);
                    lRefresh = 2L * lRefresh;
                }
            }
        }
    }
}

