/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.CacheLoader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public interface CacheStore<K, V>
extends CacheLoader<K, V> {
    public void store(K var1, V var2);

    default public void storeAll(Map<? extends K, ? extends V> mapEntries) {
        boolean fRemove = true;
        Iterator<Map.Entry<K, V>> iter = mapEntries.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<K, V> entry = iter.next();
            this.store(entry.getKey(), entry.getValue());
            if (!fRemove) continue;
            try {
                iter.remove();
            }
            catch (UnsupportedOperationException e) {
                fRemove = false;
            }
        }
    }

    public void erase(K var1);

    default public void eraseAll(Collection<? extends K> colKeys) {
        boolean fRemove = true;
        Iterator<K> iter = colKeys.iterator();
        while (iter.hasNext()) {
            this.erase(iter.next());
            if (!fRemove) continue;
            try {
                iter.remove();
            }
            catch (UnsupportedOperationException e) {
                fRemove = false;
            }
        }
    }
}

