/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.cache.SimpleCacheStatistics;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MultiplexingMapListener;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SegmentedConcurrentMap;
import com.tangosol.util.filter.CacheEventFilter;
import com.tangosol.util.filter.InKeySetFilter;
import com.tangosol.util.filter.MapEventFilter;
import com.tangosol.util.filter.NotFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class CachingMap<K, V>
implements Map<K, V> {
    public static final int LISTEN_NONE = 0;
    public static final int LISTEN_PRESENT = 1;
    public static final int LISTEN_ALL = 2;
    public static final int LISTEN_AUTO = 3;
    public static final int LISTEN_LOGICAL = 4;
    private static final boolean STRICT_SYNCHRO_LISTENER = Config.getBoolean("coherence.near.strictlistener", true);
    private static final boolean STRICT_PRIMING = Config.getBoolean("coherence.near.strictpriming", true);
    private Map<K, V> m_mapBack;
    private Map<K, V> m_mapFront;
    protected int m_nStrategyTarget;
    protected int m_nStrategyCurrent;
    private MapListener m_listener;
    private FrontMapListener m_listenerFront;
    private Filter m_filterListener;
    protected NamedCacheDeactivationListener m_listenerDeactivation;
    private ConcurrentMap m_mapControl;
    private SimpleCacheStatistics m_stats = new SimpleCacheStatistics();
    private volatile long m_cInvalidationHits;
    private volatile long m_cInvalidationMisses;
    private volatile long m_cRegisterListener;
    private static final ThreadLocal<Set> s_tloKeys = new ThreadLocal();
    private final Object GLOBAL_KEY = new Object();
    private final AtomicBoolean f_atomicPrimingOnly = new AtomicBoolean();
    private static final List IGNORE_LIST = new ImmutableArrayList(new Object[0]){

        @Override
        public boolean add(Object o) {
            return true;
        }
    };

    public CachingMap(Map<K, V> mapFront, Map<K, V> mapBack) {
        this(mapFront, mapBack, 3);
    }

    public CachingMap(Map<K, V> mapFront, Map<K, V> mapBack, int nStrategy) {
        Base.azzert(mapFront != null && mapBack != null, "Null map");
        Base.azzert(0 <= nStrategy && nStrategy <= 4, "Invalid strategy value");
        this.m_mapFront = mapFront;
        this.m_mapBack = mapBack;
        this.m_mapControl = new SegmentedConcurrentMap();
        if (nStrategy != 0) {
            if (mapBack instanceof ObservableMap) {
                this.m_listener = this.instantiateBackMapListener(nStrategy);
                if (mapFront instanceof ObservableMap) {
                    this.m_listenerFront = this.instantiateFrontMapListener();
                }
                this.m_listenerDeactivation = new DeactivationListener();
            } else {
                nStrategy = 0;
            }
        }
        this.m_nStrategyTarget = nStrategy;
        this.m_nStrategyCurrent = 0;
    }

    public void release() {
        ConcurrentMap mapControl = this.getControlMap();
        if (!mapControl.lock(ConcurrentMap.LOCK_ALL, 0L)) {
            throw new IllegalStateException("Cache is in active use by other threads.");
        }
        try {
            mapControl.put(this.GLOBAL_KEY, IGNORE_LIST);
            switch (this.m_nStrategyCurrent) {
                case 1: {
                    this.unregisterFrontListener();
                    this.unregisterListeners(this.getFrontMap().keySet());
                    break;
                }
                case 2: 
                case 4: {
                    this.unregisterListener();
                }
            }
            this.unregisterDeactivationListener();
            this.m_listener = null;
            this.m_mapFront = null;
            this.m_mapBack = null;
            this.m_filterListener = null;
            this.m_listenerDeactivation = null;
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            mapControl.remove(this.GLOBAL_KEY);
            mapControl.unlock(ConcurrentMap.LOCK_ALL);
        }
    }

    public Map<K, V> getFrontMap() {
        Map<K, V> map = this.m_mapFront;
        if (map == null) {
            throw new IllegalStateException("Cache is not active");
        }
        return map;
    }

    public Map<K, V> getBackMap() {
        Map<K, V> map = this.m_mapBack;
        if (map == null) {
            throw new IllegalStateException("Cache is not active");
        }
        return map;
    }

    public int getInvalidationStrategy() {
        return this.m_nStrategyTarget;
    }

    public ConcurrentMap getControlMap() {
        return this.m_mapControl;
    }

    protected boolean isCoherent() {
        return this.m_listener != null;
    }

    public CacheStatistics getCacheStatistics() {
        return this.m_stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ConcurrentMap mapControl = this.getControlMap();
        int i = 0;
        while (!mapControl.lock(ConcurrentMap.LOCK_ALL, 0L)) {
            if (i == 100) {
                this.getBackMap().clear();
                if (this.m_nStrategyTarget == 0) {
                    this.getFrontMap().clear();
                }
                return;
            }
            try {
                Blocking.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Base.ensureRuntimeException(e);
            }
            ++i;
        }
        try {
            mapControl.put(this.GLOBAL_KEY, IGNORE_LIST);
            Map<K, V> mapFront = this.getFrontMap();
            Map<K, V> mapBack = this.getBackMap();
            switch (this.m_nStrategyCurrent) {
                case 1: {
                    this.unregisterFrontListener();
                    try {
                        Iterator<K> iter = mapFront.keySet().iterator();
                        while (iter.hasNext()) {
                            this.unregisterListener(iter.next());
                            iter.remove();
                        }
                        break;
                    }
                    catch (RuntimeException e) {
                        this.registerFrontListener();
                        throw e;
                    }
                }
                case 2: 
                case 4: {
                    this.unregisterListener();
                    try {
                        mapFront.clear();
                        break;
                    }
                    catch (RuntimeException e) {
                        this.registerListener();
                        throw e;
                    }
                }
                default: {
                    mapFront.clear();
                }
            }
            this.resetInvalidationStrategy();
            mapBack.clear();
        }
        finally {
            mapControl.remove(this.GLOBAL_KEY);
            mapControl.unlock(ConcurrentMap.LOCK_ALL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object oKey) {
        Map<K, V> mapFront = this.getFrontMap();
        if (mapFront.containsKey(oKey)) {
            this.m_stats.registerHit();
            return true;
        }
        ConcurrentMap mapControl = this.getControlMap();
        mapControl.lock(oKey, -1L);
        try {
            if (mapFront.containsKey(oKey)) {
                this.m_stats.registerHit();
                boolean bl = true;
                return bl;
            }
            mapControl.put(oKey, IGNORE_LIST);
            this.m_stats.registerMiss();
            boolean bl = this.getBackMap().containsKey(oKey);
            return bl;
        }
        finally {
            mapControl.remove(oKey);
            mapControl.unlock(oKey);
        }
    }

    @Override
    public boolean containsValue(Object oValue) {
        return this.getFrontMap().containsValue(oValue) || this.getBackMap().containsValue(oValue);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.getBackMap().entrySet();
        if (!this.isCoherent()) {
            set = Collections.unmodifiableSet(set);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object oKey) {
        Map<Object, V> mapFront = this.getFrontMap();
        V value = mapFront.get(oKey);
        if (value != null) {
            this.m_stats.registerHit();
            return value;
        }
        long ldtStart = Base.getSafeTimeMillis();
        ConcurrentMap mapControl = this.getControlMap();
        mapControl.lock(oKey, -1L);
        try {
            value = mapFront.get(oKey);
            if (value != null) {
                this.m_stats.registerHit(ldtStart);
                V v = value;
                return v;
            }
            Map<K, V> mapBack = this.getBackMap();
            if (this.m_nStrategyTarget == 0) {
                value = mapBack.get(oKey);
                if (value != null) {
                    mapFront.put(oKey, value);
                }
            } else {
                MapEvent evt;
                boolean fPrimed;
                LinkedList listEvents = new LinkedList();
                mapControl.put(oKey, listEvents);
                this.registerListener(oKey);
                LinkedList linkedList = listEvents;
                synchronized (linkedList) {
                    int c = listEvents.size();
                    switch (c) {
                        case 0: {
                            fPrimed = false;
                            break;
                        }
                        default: {
                            evt = (MapEvent)listEvents.get(c - 1);
                            fPrimed = this.isPriming(evt);
                            if (!fPrimed) break;
                            value = evt.getNewValue();
                            listEvents.remove(c - 1);
                        }
                    }
                }
                if (!fPrimed) {
                    try {
                        value = mapBack.get(oKey);
                    }
                    catch (RuntimeException e) {
                        this.unregisterListener(oKey);
                        mapControl.remove(oKey);
                        throw e;
                    }
                }
                linkedList = listEvents;
                synchronized (linkedList) {
                    if (value == null) {
                        this.unregisterListener(oKey);
                    } else {
                        boolean fValid = true;
                        switch (listEvents.size()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                evt = (MapEvent)listEvents.get(0);
                                fValid = evt.getId() == 1 && evt instanceof CacheEvent && ((CacheEvent)evt).isSynthetic();
                                break;
                            }
                            default: {
                                fValid = false;
                            }
                        }
                        if (fValid) {
                            Set setUnregister = this.setKeyHolder();
                            try {
                                mapFront.put(oKey, value);
                            }
                            finally {
                                if (setUnregister != null) {
                                    this.unregisterListeners(setUnregister);
                                    this.removeKeyHolder();
                                }
                            }
                        } else {
                            this.unregisterListener(oKey);
                            ++this.m_cInvalidationHits;
                        }
                    }
                    mapControl.remove(oKey);
                }
            }
            this.m_stats.registerMiss(ldtStart);
            V v = value;
            return v;
        }
        finally {
            mapControl.unlock(oKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getAll(Collection<? extends K> colKeys) {
        long ldtStart = Base.getSafeTimeMillis();
        Map<Iterator<Object>, V> mapResult = this.getAllFromFrontMap(colKeys);
        if (!mapResult.isEmpty()) {
            this.m_stats.registerHits(mapResult.size(), ldtStart);
        }
        if (mapResult.size() == colKeys.size()) {
            return mapResult;
        }
        HashSet<K> setMiss = new HashSet<K>(colKeys);
        setMiss.removeAll(mapResult.keySet());
        Map<K, V> mapBack = this.getBackMap();
        if (mapBack instanceof CacheMap) {
            Map mapFront = this.getFrontMap();
            ConcurrentMap mapControl = this.getControlMap();
            int nStrategy = this.ensureInvalidationStrategy();
            Set<K> setLocked = this.tryLock(setMiss);
            int cLocked = setLocked.size();
            int cMisses = setMiss.size();
            try {
                ArrayList listEvents = new ArrayList(cLocked);
                if (nStrategy != 0) {
                    setLocked.forEach((? super T k) -> mapControl.put(k, listEvents));
                    if (nStrategy == 1) {
                        this.registerListeners(setLocked);
                        ArrayList arrayList = listEvents;
                        synchronized (arrayList) {
                            for (int i = listEvents.size() - 1; i >= 0; --i) {
                                MapEvent evt = (MapEvent)listEvents.get(i);
                                if (!this.isPriming(evt)) continue;
                                Iterator<Object> key = evt.getKey();
                                mapResult.put(key, evt.getNewValue());
                                setMiss.remove(key);
                                listEvents.remove(i);
                            }
                        }
                    }
                }
                if (!setMiss.isEmpty()) {
                    try {
                        mapResult.putAll(new HashMap(((CacheMap)mapBack).getAll(setMiss)));
                    }
                    catch (RuntimeException e) {
                        if (nStrategy != 0) {
                            for (K key : setLocked) {
                                if (nStrategy == 1) {
                                    this.unregisterListener(key);
                                }
                                mapControl.remove(key);
                            }
                        }
                        throw e;
                    }
                }
                if (nStrategy == 0) {
                    for (K key : setLocked) {
                        V value = mapResult.get(key);
                        if (value == null) continue;
                        mapFront.put(key, value);
                    }
                } else {
                    HashSet setInvalid = new HashSet();
                    HashSet<K> setAdd = new HashSet<K>(setLocked);
                    ArrayList arrayList = listEvents;
                    synchronized (arrayList) {
                        for (MapEvent evt : listEvents) {
                            Object key = evt.getKey();
                            boolean fValid = setAdd.remove(key) && evt.getId() == 1 && evt instanceof CacheEvent && ((CacheEvent)evt).isSynthetic();
                            if (fValid) continue;
                            setInvalid.add(key);
                            ++this.m_cInvalidationHits;
                        }
                        Set setUnregister = this.setKeyHolder();
                        try {
                            for (Object key : setLocked) {
                                V value = mapResult.get(key);
                                if (value != null && !setInvalid.contains(key)) {
                                    mapFront.put(key, value);
                                } else {
                                    if (value == null) {
                                        mapResult.remove(key);
                                    }
                                    mapFront.remove(key);
                                    this.unregisterListener(key);
                                }
                                mapControl.remove(key);
                            }
                        }
                        finally {
                            if (setUnregister != null) {
                                this.unregisterListeners(setUnregister);
                                this.removeKeyHolder();
                            }
                        }
                    }
                }
                this.m_stats.registerMisses(cMisses, ldtStart);
            }
            finally {
                for (K key : setLocked) {
                    mapControl.unlock(key);
                }
            }
        }
        for (Object key : setMiss) {
            V value = this.get(key);
            if (value == null) continue;
            mapResult.put((Iterator<Object>)key, value);
        }
        return mapResult;
    }

    protected Map<K, V> getAllFromFrontMap(Collection<? extends K> colKeys) {
        Map<K, V> mapFront = this.getFrontMap();
        if (mapFront instanceof CacheMap) {
            return ((CacheMap)mapFront).getAll(colKeys);
        }
        HashMap<K, V> mapResult = new HashMap<K, V>(colKeys.size());
        for (K key : colKeys) {
            V value = mapFront.get(key);
            if (value == null) continue;
            mapResult.put(key, value);
        }
        return mapResult;
    }

    protected Set<K> tryLock(Set<K> setKeys) {
        ConcurrentMap mapControl = this.getControlMap();
        HashSet<K> setLocked = new HashSet<K>(setKeys.size());
        for (K key : setKeys) {
            if (!mapControl.lock(key, 0L)) continue;
            setLocked.add(key);
        }
        return setLocked;
    }

    protected boolean isPriming(MapEvent evt) {
        CacheEvent cacheEvent;
        CacheEvent cacheEvent2 = cacheEvent = evt instanceof CacheEvent ? (CacheEvent)evt : null;
        return cacheEvent != null && cacheEvent.getId() == 2 && (this.isCheckPrimingExclusively(cacheEvent.isPriming()) ? cacheEvent.isPriming() : cacheEvent.isSynthetic());
    }

    protected boolean isCheckPrimingExclusively(boolean fPriming) {
        boolean fPrimingOnly = this.f_atomicPrimingOnly.get();
        if (STRICT_PRIMING && !fPrimingOnly && fPriming) {
            fPrimingOnly = true;
            this.f_atomicPrimingOnly.set(true);
        }
        return fPrimingOnly;
    }

    @Override
    public boolean isEmpty() {
        return this.getBackMap().isEmpty();
    }

    @Override
    public Set<K> keySet() {
        Set<K> set = this.getBackMap().keySet();
        if (!this.isCoherent()) {
            set = Collections.unmodifiableSet(set);
        }
        return set;
    }

    @Override
    public V put(K oKey, V oValue) {
        return this.put(oKey, oValue, true, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K oKey, V oValue, boolean fReturn, long cMillis) {
        long ldtStart = Base.getSafeTimeMillis();
        Map<K, V> mapFront = this.getFrontMap();
        Map<K, V> mapBack = this.getBackMap();
        int nStrategyTarget = this.m_nStrategyTarget;
        int nStrategyCurrent = this.m_nStrategyCurrent;
        ConcurrentMap mapControl = this.getControlMap();
        mapControl.lock(oKey, -1L);
        try {
            V oOrig;
            V oFront;
            List listEvents = null;
            V v = oFront = oValue == null ? mapFront.remove(oKey) : mapFront.get(oKey);
            if (nStrategyTarget != 0) {
                if (oValue == null) {
                    listEvents = IGNORE_LIST;
                    mapControl.put(oKey, listEvents);
                    if (oFront != null) {
                        this.unregisterListener(oKey);
                    }
                } else if (oFront != null || nStrategyCurrent == 2 || nStrategyCurrent == 4) {
                    listEvents = new LinkedList();
                    mapControl.put(oKey, listEvents);
                } else {
                    listEvents = IGNORE_LIST;
                    mapControl.put(oKey, listEvents);
                }
            }
            try {
                if (cMillis > 0L || fReturn) {
                    oOrig = CachingMap.put(mapBack, oKey, oValue, cMillis);
                } else {
                    mapBack.putAll(Collections.singletonMap(oKey, oValue));
                    oOrig = null;
                }
            }
            catch (RuntimeException e) {
                mapControl.remove(oKey);
                try {
                    this.invalidateFront(oKey);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                throw e;
            }
            this.finalizePut(oKey, oValue, listEvents, cMillis);
            this.m_stats.registerPut(ldtStart);
            V v2 = oOrig;
            return v2;
        }
        finally {
            mapControl.unlock(oKey);
        }
    }

    private static <K, V> V put(Map<K, V> map, K oKey, V oValue, long cMillis) {
        if (map instanceof CacheMap) {
            return ((CacheMap)map).put(oKey, oValue, cMillis);
        }
        if (cMillis <= 0L) {
            return map.put(oKey, oValue);
        }
        throw new UnsupportedOperationException("Class \"" + map.getClass().getName() + "\" does not implement CacheMap interface");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map.size() == 1) {
            Iterator<Map.Entry<K, V>> iter = map.entrySet().iterator();
            if (iter.hasNext()) {
                Map.Entry<K, V> entry = iter.next();
                this.put(entry.getKey(), entry.getValue(), false, 0L);
            }
            return;
        }
        int nStrategyTarget = this.m_nStrategyTarget;
        int nStrategyCurrent = this.m_nStrategyCurrent;
        boolean fAllRegistered = nStrategyCurrent == 2 || nStrategyCurrent == 4;
        long ldtStart = Base.getSafeTimeMillis();
        ConcurrentMap mapControl = this.getControlMap();
        Map mapFront = this.getFrontMap();
        Map<K, V> mapBack = this.getBackMap();
        HashMap<K, V> mapLocked = new HashMap<K, V>();
        LinkedList<K> listUnlockable = null;
        try {
            Iterator iter;
            K key;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                key = entry.getKey();
                V value = entry.getValue();
                if (value != null && mapControl.lock(key, 0L)) {
                    mapLocked.put(key, value);
                    if (nStrategyTarget == 0) continue;
                    mapControl.put(key, fAllRegistered || mapFront.containsKey(key) ? new LinkedList() : IGNORE_LIST);
                    continue;
                }
                if (listUnlockable == null) {
                    listUnlockable = new LinkedList<K>();
                }
                listUnlockable.add(key);
            }
            mapBack.putAll(map);
            if (nStrategyTarget == 0) {
                mapFront.putAll(mapLocked);
                iter = mapLocked.keySet().iterator();
                while (iter.hasNext()) {
                    mapControl.unlock(iter.next());
                    iter.remove();
                }
            } else {
                iter = mapLocked.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    key = entry.getKey();
                    this.finalizePut(key, entry.getValue(), (List)mapControl.get(key), 0L);
                    mapControl.unlock(key);
                    iter.remove();
                }
            }
            this.m_stats.registerPuts(map.size(), ldtStart);
        }
        finally {
            for (Map.Entry entry : mapLocked.keySet()) {
                try {
                    this.invalidateFront(entry);
                }
                catch (RuntimeException runtimeException) {}
                mapControl.remove(entry);
                mapControl.unlock(entry);
            }
            if (listUnlockable != null && nStrategyTarget == 0) {
                mapFront.keySet().removeAll(listUnlockable);
            }
        }
    }

    protected void invalidateFront(Object oKey) {
        if (this.getFrontMap().remove(oKey) == null) {
            ++this.m_cInvalidationMisses;
        } else {
            this.unregisterListener(oKey);
            ++this.m_cInvalidationHits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizePut(K oKey, V oValue, List listEvents, long cMillis) {
        Map<K, V> mapFront = this.getFrontMap();
        ConcurrentMap mapControl = this.getControlMap();
        int nStrategyTarget = this.m_nStrategyTarget;
        int nStrategyCurrent = this.m_nStrategyCurrent;
        if (nStrategyTarget == 0) {
            if (oValue != null) {
                CachingMap.put(mapFront, oKey, oValue, cMillis);
            }
        } else if (listEvents == IGNORE_LIST) {
            mapControl.remove(oKey);
        } else {
            if (listEvents == null) {
                throw new IllegalStateException("Encountered unexpected key " + oKey + "; this may be caused by concurrent modification of the supplied key(s), or by an inconsistent hashCode() or equals() implementation.");
            }
            List list = listEvents;
            synchronized (list) {
                boolean fValid;
                if (oValue == null) {
                    fValid = false;
                } else {
                    switch (listEvents.size()) {
                        case 0: {
                            if (STRICT_SYNCHRO_LISTENER && (nStrategyCurrent == 2 || nStrategyCurrent == 4 || mapFront.containsKey(oKey))) {
                                Base.log("Expected an insert/update for " + oKey + ", but none have been received");
                                fValid = false;
                                break;
                            }
                            fValid = true;
                            break;
                        }
                        case 1: {
                            Object oValueNew;
                            MapEvent evt = (MapEvent)listEvents.get(0);
                            int nId = evt.getId();
                            boolean bl = fValid = nId == 1 || nId == 2;
                            if (!fValid || (oValueNew = evt.getNewValue()) == null) break;
                            oValue = oValueNew;
                            break;
                        }
                        default: {
                            fValid = false;
                        }
                    }
                }
                if (fValid) {
                    if (CachingMap.put(mapFront, oKey, oValue, cMillis) == null && nStrategyTarget == 1) {
                        mapFront.remove(oKey);
                    }
                } else {
                    this.invalidateFront(oKey);
                }
                mapControl.remove(oKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate(MapEvent evt) {
        ConcurrentMap mapControl = this.getControlMap();
        Object oKey = evt.getKey();
        long ldtStart = 0L;
        int i = 0;
        while (true) {
            List listEvents;
            if (mapControl.lock(oKey, 0L)) {
                try {
                    listEvents = (List)mapControl.get(oKey);
                    if (listEvents == null) {
                        if (!this.isPriming(evt)) {
                            this.invalidateFront(oKey);
                        }
                    } else {
                        listEvents.add(evt);
                    }
                    return;
                }
                finally {
                    mapControl.unlock(oKey);
                }
            }
            listEvents = (List)mapControl.get(oKey);
            if (listEvents == null && (listEvents = (List)mapControl.get(this.GLOBAL_KEY)) == null) {
                Thread.yield();
                long ldtNow = Base.getSafeTimeMillis();
                if (ldtStart == 0L) {
                    ldtStart = ldtNow;
                } else if (i > 5000 && ldtNow - ldtStart > 5000L) {
                    Base.err("Detected a state corruption on the key \"" + oKey + "\", of class " + oKey.getClass().getName() + " which is missing from the active key set " + mapControl.keySet() + ". This could be caused by a mutating or inconsistent key implementation, or a concurrent modification to the map passed to " + this.getClass().getName() + ".putAll()");
                    this.invalidateFront(oKey);
                    return;
                }
            } else {
                List list = listEvents;
                synchronized (list) {
                    List listKey = (List)mapControl.get(oKey);
                    if (listEvents == listKey || listKey == null && listEvents == mapControl.get(this.GLOBAL_KEY)) {
                        listEvents.add(evt);
                        return;
                    }
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object oKey) {
        Map<K, V> mapFront = this.getFrontMap();
        Map<K, V> mapBack = this.getBackMap();
        int nStrategy = this.m_nStrategyTarget;
        ConcurrentMap mapControl = this.getControlMap();
        mapControl.lock(oKey, -1L);
        try {
            if (nStrategy != 0) {
                mapControl.put(oKey, IGNORE_LIST);
            }
            if (mapFront.remove(oKey) != null) {
                this.unregisterListener(oKey);
            }
            V v = mapBack.remove(oKey);
            return v;
        }
        finally {
            if (nStrategy != 0) {
                mapControl.remove(oKey);
            }
            mapControl.unlock(oKey);
        }
    }

    @Override
    public int size() {
        return this.getBackMap().size();
    }

    @Override
    public Collection<V> values() {
        Collection<V> values = this.getBackMap().values();
        if (!this.isCoherent()) {
            values = Collections.unmodifiableCollection(values);
        }
        return values;
    }

    public long getInvalidationHits() {
        return this.m_cInvalidationHits;
    }

    public long getInvalidationMisses() {
        return this.m_cInvalidationMisses;
    }

    public long getTotalRegisterListener() {
        return this.m_cRegisterListener;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CachingMap");
        try {
            Map<K, V> mapFront = this.getFrontMap();
            Map<K, V> mapBack = this.getBackMap();
            String[] asStrategy = new String[]{"NONE", "PRESENT", "ALL", "AUTO", "LOGICAL"};
            sb.append("{FrontMap{class=").append(mapFront.getClass().getName()).append(", size=").append(mapFront.size()).append("}, BackMap{class=").append(mapBack.getClass().getName()).append(", size=").append(mapBack.size()).append("}, strategy=").append(asStrategy[this.getInvalidationStrategy()]).append(", CacheStatistics=").append(this.getCacheStatistics()).append(", invalidation hits=").append(this.getInvalidationHits()).append(", invalidation misses=").append(this.getInvalidationMisses()).append(", listener registrations=").append(this.getTotalRegisterListener()).append('}');
        }
        catch (IllegalStateException e) {
            sb.append(" not active");
        }
        return sb.toString();
    }

    protected void registerListener() {
        ((ObservableMap)this.getBackMap()).addMapListener(this.m_listener, this.m_filterListener, true);
    }

    protected void unregisterListener() {
        ((ObservableMap)this.getBackMap()).removeMapListener(this.m_listener, this.m_filterListener);
    }

    protected void registerListener(Object oKey) {
        if (this.ensureInvalidationStrategy() == 1) {
            try {
                ((ObservableMap)this.getBackMap()).addMapListener(this.m_listener, oKey, true);
            }
            catch (UnsupportedOperationException e) {
                this.m_listener = this.instantiateBackMapListener(2);
                ((ObservableMap)this.getBackMap()).addMapListener(this.m_listener, oKey, true);
            }
            ++this.m_cRegisterListener;
        }
    }

    protected void registerListeners(Set setKeys) {
        if (this.ensureInvalidationStrategy() == 1) {
            if (this.m_listener instanceof PrimingListener) {
                try {
                    ((ObservableMap)this.getBackMap()).addMapListener(this.m_listener, new InKeySetFilter(null, setKeys), true);
                    this.m_cRegisterListener += (long)setKeys.size();
                    return;
                }
                catch (UnsupportedOperationException e) {
                    this.m_listener = this.instantiateBackMapListener(2);
                }
            }
            for (Object oKey : setKeys) {
                this.registerListener(oKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterListener(Object oKey) {
        ConcurrentMap mapControl;
        if (this.m_nStrategyCurrent == 1 && (mapControl = this.getControlMap()).lock(oKey, 0L)) {
            Set setKeys;
            if (this.m_listener instanceof PrimingListener && (setKeys = s_tloKeys.get()) != null) {
                setKeys.add(oKey);
                return;
            }
            try {
                ((ObservableMap)this.getBackMap()).removeMapListener(this.m_listener, oKey);
            }
            finally {
                mapControl.unlock(oKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterListeners(Set<K> setKeys) {
        if (this.m_nStrategyCurrent == 1 && this.m_listener instanceof PrimingListener) {
            if (!setKeys.isEmpty()) {
                try {
                    ((ObservableMap)this.getBackMap()).removeMapListener(this.m_listener, new InKeySetFilter(null, setKeys));
                }
                finally {
                    ConcurrentMap mapControl = this.getControlMap();
                    for (K key : setKeys) {
                        mapControl.unlock(key);
                    }
                }
            }
        } else {
            throw new UnsupportedOperationException("unregisterListeners can only be called with PRESENT strategy");
        }
    }

    protected Set setKeyHolder() {
        if (this.m_nStrategyCurrent == 1 && this.m_listener instanceof PrimingListener) {
            HashSet setKeys = new HashSet();
            s_tloKeys.set(setKeys);
            return setKeys;
        }
        return null;
    }

    protected void removeKeyHolder() {
        s_tloKeys.set(null);
    }

    protected void registerFrontListener() {
        FrontMapListener listener = this.m_listenerFront;
        if (listener != null) {
            listener.register();
        }
    }

    protected void unregisterFrontListener() {
        FrontMapListener listener = this.m_listenerFront;
        if (listener != null) {
            listener.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int ensureInvalidationStrategy() {
        int nStrategyTarget = this.m_nStrategyTarget;
        switch (nStrategyTarget) {
            case 1: 
            case 3: {
                if (this.m_nStrategyCurrent != 1) {
                    Object object = this.GLOBAL_KEY;
                    synchronized (object) {
                        if (this.m_nStrategyCurrent != 1) {
                            this.registerFrontListener();
                            this.registerDeactivationListener();
                            this.m_nStrategyCurrent = 1;
                        }
                    }
                }
                return 1;
            }
            case 2: 
            case 4: {
                if (this.m_nStrategyCurrent != nStrategyTarget) {
                    Object object = this.GLOBAL_KEY;
                    synchronized (object) {
                        if (this.m_nStrategyCurrent != nStrategyTarget) {
                            if (nStrategyTarget == 4) {
                                this.m_filterListener = new NotFilter(new CacheEventFilter(4, 1));
                            }
                            this.registerListener();
                            this.registerDeactivationListener();
                            this.m_nStrategyCurrent = nStrategyTarget;
                        }
                    }
                }
                return nStrategyTarget;
            }
        }
        return 0;
    }

    protected void resetInvalidationStrategy() {
        this.m_nStrategyCurrent = 0;
        this.m_filterListener = null;
    }

    protected MapListener instantiateBackMapListener(int nStrategy) {
        return nStrategy == 3 || nStrategy == 1 ? new PrimingListener() : new SimpleListener();
    }

    protected void registerDeactivationListener() {
        try {
            NamedCacheDeactivationListener listener = this.m_listenerDeactivation;
            if (listener != null) {
                ((NamedCache)this.getBackMap()).addMapListener(listener);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected void unregisterDeactivationListener() {
        try {
            NamedCacheDeactivationListener listener = this.m_listenerDeactivation;
            if (listener != null) {
                ((NamedCache)this.getBackMap()).removeMapListener(listener);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void resetFrontMap() {
        try {
            this.unregisterFrontListener();
            this.getFrontMap().clear();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.resetInvalidationStrategy();
    }

    protected void unregisterMBean() {
    }

    protected FrontMapListener instantiateFrontMapListener() {
        return new FrontMapListener();
    }

    protected class FrontMapListener
    extends AbstractMapListener
    implements MapListenerSupport.SynchronousListener {
        protected Filter m_filter = new MapEventFilter(4);

        protected FrontMapListener() {
        }

        @Override
        public void entryDeleted(MapEvent evt) {
            if (evt instanceof CacheEvent) {
                if (((CacheEvent)evt).isSynthetic()) {
                    CachingMap.this.unregisterListener(evt.getKey());
                }
            } else {
                CachingMap.this.unregisterListener(evt.getKey());
            }
        }

        public void register() {
            ((ObservableMap)CachingMap.this.getFrontMap()).addMapListener(this, this.m_filter, true);
        }

        public void unregister() {
            ((ObservableMap)CachingMap.this.getFrontMap()).removeMapListener(this, this.m_filter);
        }
    }

    protected class SimpleListener
    extends MultiplexingMapListener
    implements MapListenerSupport.SynchronousListener {
        protected SimpleListener() {
        }

        protected void onMapEvent(MapEvent evt) {
            CachingMap.this.validate(evt);
        }
    }

    protected class PrimingListener
    extends MultiplexingMapListener
    implements MapListenerSupport.PrimingListener {
        protected PrimingListener() {
        }

        protected void onMapEvent(MapEvent evt) {
            CachingMap.this.validate(evt);
        }
    }

    protected class DeactivationListener
    extends AbstractMapListener
    implements NamedCacheDeactivationListener {
        protected DeactivationListener() {
        }

        @Override
        public void entryDeleted(MapEvent evt) {
            CachingMap.this.resetFrontMap();
            CachingMap.this.unregisterMBean();
        }

        @Override
        public void entryUpdated(MapEvent evt) {
            CachingMap.this.resetFrontMap();
        }
    }
}

