/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.io.pof.reflect.PofValue;
import com.tangosol.io.pof.reflect.PofValueParser;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.KeyAssociation;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.Converter;
import com.tangosol.util.DaemonThreadFactory;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.EqualsFilter;
import com.tangosol.util.filter.KeyAssociatedFilter;
import com.tangosol.util.processor.AbstractProcessor;
import com.tangosol.util.processor.ConditionalRemove;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class AspNetSessionStoreProvider {
    private static final String EXT_ATTR_CACHE_NAME = "aspnet-session-overflow";

    public static class SessionCleanupListener
    extends AbstractMapListener {
        private BackingMapManagerContext m_ctx;
        private static final Executor EXECUTOR = Executors.newSingleThreadExecutor(new DaemonThreadFactory("AspNetSessionCleanupThread-"));

        public SessionCleanupListener(BackingMapManagerContext context) {
            this.m_ctx = context;
        }

        @Override
        public void entryDeleted(MapEvent evt) {
            Converter conv = this.m_ctx.getKeyFromInternalConverter();
            final SessionKey sessionKey = (SessionKey)conv.convert(evt.getKey());
            final EqualsFilter filter = new EqualsFilter(new ReflectionExtractor("getSessionKey", null, 1), sessionKey);
            EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    NamedCache cache = CacheFactory.getCache(AspNetSessionStoreProvider.EXT_ATTR_CACHE_NAME);
                    cache.invokeAll(new KeyAssociatedFilter(filter, sessionKey), new ConditionalRemove(AlwaysFilter.INSTANCE));
                }
            });
        }
    }

    public static class ResetSessionTimeoutProcessor
    extends AbstractSessionProcessor {
        @Override
        protected Object processInternal(BinaryEntry binEntry) {
            Binary value = binEntry.getBinaryValue();
            if (value != null) {
                PofValue pofEntry = PofValueParser.parse(value, (PofContext)binEntry.getSerializer());
                long cMillis = (Long)pofEntry.getChild(4).getValue();
                this.resetSessionTimeout(cMillis);
            }
            return null;
        }
    }

    public static class SaveSessionProcessor
    extends AbstractSessionProcessor {
        private long m_nLockId;
        private boolean m_fNewSession;
        private boolean m_fInitialized;
        private long m_cTimeoutMillis;
        private Binary m_binItems;
        private Map m_mapExternalAttributes;
        private Collection m_collObsoleteExternalAttributes;

        @Override
        protected Object processInternal(BinaryEntry binEntry) {
            SessionHolder holder = (SessionHolder)binEntry.getValue();
            if (holder == null || this.m_fNewSession) {
                holder = new SessionHolder();
            } else if (this.m_nLockId != holder.getLockId()) {
                return null;
            }
            holder.setTimeoutMillis(this.m_cTimeoutMillis);
            holder.setInitialized(this.m_fInitialized);
            if (this.m_binItems != null) {
                holder.setItems(this.m_binItems);
            }
            if (this.m_mapExternalAttributes != null && this.m_mapExternalAttributes.size() > 0) {
                this.storeExternalAttributes(binEntry);
            }
            if (this.m_collObsoleteExternalAttributes != null && this.m_collObsoleteExternalAttributes.size() > 0) {
                this.removeObsoleteExternalAttributes(binEntry);
            }
            holder.unlock();
            binEntry.setValue(holder, false);
            this.resetSessionTimeout(holder.getTimeoutMillis());
            return null;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_nLockId = in.readLong(0);
            this.m_fNewSession = in.readBoolean(1);
            this.m_fInitialized = in.readBoolean(2);
            this.m_cTimeoutMillis = in.readLong(3);
            this.m_binItems = in.readBinary(4);
            this.m_mapExternalAttributes = in.readMap(5, new LiteMap());
            this.m_collObsoleteExternalAttributes = in.readCollection(6, new ArrayList());
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeLong(0, this.m_nLockId);
            out.writeBoolean(1, this.m_fNewSession);
            out.writeBoolean(2, this.m_fInitialized);
            out.writeLong(3, this.m_cTimeoutMillis);
            out.writeBinary(4, this.m_binItems);
            out.writeMap(5, this.m_mapExternalAttributes, String.class, Binary.class);
            out.writeCollection(6, this.m_collObsoleteExternalAttributes, String.class);
        }

        protected void storeExternalAttributes(BinaryEntry binEntry) {
            BackingMapManagerContext ctx = binEntry.getContext();
            SessionKey sessionKey = (SessionKey)binEntry.getKey();
            ObservableMap mapCache = ctx.getBackingMapContext(AspNetSessionStoreProvider.EXT_ATTR_CACHE_NAME).getBackingMap();
            Map mapAttr = this.m_mapExternalAttributes;
            Converter convKey = ctx.getKeyToInternalConverter();
            Converter convValue = ctx.getValueToInternalConverter();
            for (String sAttr : mapAttr.keySet()) {
                ExternalAttributeKey key = new ExternalAttributeKey(sessionKey, sAttr);
                mapCache.put(convKey.convert(key), convValue.convert(mapAttr.get(sAttr)));
            }
        }

        protected void removeObsoleteExternalAttributes(BinaryEntry binEntry) {
            BackingMapManagerContext ctx = binEntry.getContext();
            SessionKey sessionKey = (SessionKey)binEntry.getKey();
            ObservableMap mapCache = ctx.getBackingMapContext(AspNetSessionStoreProvider.EXT_ATTR_CACHE_NAME).getBackingMap();
            Collection collObsAttr = this.m_collObsoleteExternalAttributes;
            Converter convKey = ctx.getKeyToInternalConverter();
            for (String sAttr : collObsAttr) {
                ExternalAttributeKey key = new ExternalAttributeKey(sessionKey, sAttr);
                mapCache.remove(convKey.convert(key));
            }
        }
    }

    public static class ReleaseSessionProcessor
    extends AbstractSessionProcessor {
        private long m_nLockId;

        @Override
        protected Object processInternal(BinaryEntry binEntry) {
            SessionHolder holder = (SessionHolder)binEntry.getValue();
            if (holder != null && this.m_nLockId == holder.getLockId()) {
                holder.unlock();
                binEntry.setValue(holder, false);
                this.resetSessionTimeout(holder.getTimeoutMillis());
            }
            return null;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_nLockId = in.readLong(0);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeLong(0, this.m_nLockId);
        }
    }

    public static class AcquireSessionProcessor
    extends AbstractSessionProcessor {
        @Override
        protected Object processInternal(BinaryEntry binEntry) {
            SessionHolder holder = (SessionHolder)binEntry.getValue();
            if (holder == null) {
                return null;
            }
            if (holder.isLocked()) {
                holder.setItems(null);
            } else {
                holder.lock();
                binEntry.setValue(holder, false);
            }
            this.resetSessionTimeout(holder.getTimeoutMillis());
            return holder;
        }
    }

    public static abstract class AbstractSessionProcessor
    extends AbstractProcessor
    implements PortableObject {
        private transient BinaryEntry m_binEntry;

        protected AbstractSessionProcessor() {
        }

        @Override
        public Object process(InvocableMap.Entry entry) {
            this.m_binEntry = (BinaryEntry)entry;
            return this.processInternal(this.m_binEntry);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
        }

        protected abstract Object processInternal(BinaryEntry var1);

        protected void resetSessionTimeout(long cMillis) {
            BinaryEntry binEntry = this.m_binEntry;
            binEntry.expire(cMillis);
        }
    }

    public static class SessionHolder
    implements PortableObject {
        private long m_nVersion;
        private long m_nLockId;
        private Date m_dtLock;
        private boolean m_fInitialized;
        private long m_cTimeoutMillis;
        private Binary m_binItems;
        public static final int VERSION = 0;
        public static final int LOCK_ID = 1;
        public static final int LOCK_TIME = 2;
        public static final int INITIALIZED = 3;
        public static final int TIMEOUT = 4;
        public static final int ITEMS = 5;

        public void incrementVersion() {
            ++this.m_nVersion;
        }

        public void lock() {
            assert (this.m_nLockId == 0L);
            this.m_nLockId = ++this.m_nVersion;
            this.m_dtLock = new Date();
        }

        public void unlock() {
            this.m_nLockId = 0L;
            this.m_dtLock = null;
        }

        @Override
        public void readExternal(PofReader reader) throws IOException {
            this.m_nVersion = reader.readLong(0);
            this.m_nLockId = reader.readLong(1);
            this.m_dtLock = reader.readDate(2);
            this.m_fInitialized = reader.readBoolean(3);
            this.m_cTimeoutMillis = reader.readLong(4);
            this.m_binItems = reader.readBinary(5);
        }

        @Override
        public void writeExternal(PofWriter writer) throws IOException {
            writer.writeLong(0, this.m_nVersion);
            writer.writeLong(1, this.m_nLockId);
            writer.writeDateTime(2, this.m_dtLock);
            writer.writeBoolean(3, this.m_fInitialized);
            writer.writeLong(4, this.m_cTimeoutMillis);
            writer.writeBinary(5, this.m_binItems);
        }

        public String toString() {
            return "SessionHolder{Version=" + this.m_nVersion + ", LockId=" + this.m_nLockId + ", LockTime=" + this.m_dtLock + ", Initialized=" + this.m_fInitialized + ", Timeout=" + this.m_cTimeoutMillis + ", Items=" + this.m_binItems + '}';
        }

        public long getVersion() {
            return this.m_nVersion;
        }

        public long getLockId() {
            return this.m_nLockId;
        }

        public boolean isLocked() {
            return this.m_nLockId != 0L;
        }

        public Date getLockTime() {
            return this.m_dtLock;
        }

        public boolean isInitialized() {
            return this.m_fInitialized;
        }

        public void setInitialized(boolean fInitialized) {
            this.m_fInitialized = fInitialized;
        }

        public long getTimeoutMillis() {
            return this.m_cTimeoutMillis;
        }

        public void setTimeoutMillis(long cMillis) {
            this.m_cTimeoutMillis = cMillis;
        }

        public Binary getItems() {
            return this.m_binItems;
        }

        public void setItems(Binary binItems) {
            this.m_binItems = binItems;
        }
    }

    public static class ExternalAttributeKey
    implements PortableObject,
    KeyAssociation {
        private SessionKey m_sessionKey;
        private String m_sAttribute;

        public ExternalAttributeKey() {
        }

        public ExternalAttributeKey(SessionKey sessionKey, String sAttribute) {
            this.m_sessionKey = sessionKey;
            this.m_sAttribute = sAttribute;
        }

        @Override
        public Object getAssociatedKey() {
            return this.m_sessionKey;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_sessionKey = (SessionKey)in.readObject(0);
            this.m_sAttribute = in.readString(1);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_sessionKey);
            out.writeString(1, this.m_sAttribute);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ExternalAttributeKey) {
                ExternalAttributeKey key = (ExternalAttributeKey)o;
                return this.m_sAttribute.equals(key.m_sAttribute) && this.m_sessionKey.equals(key.m_sessionKey);
            }
            return false;
        }

        public int hashCode() {
            return this.m_sessionKey.hashCode() ^ this.m_sAttribute.hashCode();
        }

        public String toString() {
            return this.m_sessionKey + ":" + this.m_sAttribute;
        }

        public SessionKey getSessionKey() {
            return this.m_sessionKey;
        }

        public String getAttributeName() {
            return this.m_sAttribute;
        }
    }

    public static class SessionKey
    implements PortableObject {
        private String m_sApplicationId;
        private String m_sSessionId;

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_sApplicationId = in.readString(0);
            this.m_sSessionId = in.readString(1);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeString(0, this.m_sApplicationId);
            out.writeString(1, this.m_sSessionId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof SessionKey) {
                SessionKey key = (SessionKey)o;
                return this.m_sApplicationId.equals(key.m_sApplicationId) && this.m_sSessionId.equals(key.m_sSessionId);
            }
            return false;
        }

        public int hashCode() {
            return this.m_sApplicationId.hashCode() ^ this.m_sSessionId.hashCode();
        }

        public String toString() {
            return this.m_sApplicationId + ":" + this.m_sSessionId;
        }

        public String getApplicationId() {
            return this.m_sApplicationId;
        }

        public String getSessionId() {
            return this.m_sSessionId;
        }
    }
}

