/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.internal.SessionOptimisticPut;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SessionOptimisticRemove
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    public int m_nVersion;
    protected boolean m_fSynthetic = false;

    public SessionOptimisticRemove() {
    }

    public SessionOptimisticRemove(int nVersion) {
        this(nVersion, false);
    }

    public SessionOptimisticRemove(int nVersion, boolean fSynthetic) {
        if (nVersion < 0) {
            throw new IllegalArgumentException();
        }
        this.m_nVersion = nVersion;
        this.m_fSynthetic = fSynthetic;
    }

    @Override
    public Object process(InvocableMap.Entry entry) {
        int nVersionRet = 0;
        if (entry.isPresent()) {
            int nVersionExp;
            Binary binSession = ((BinaryEntry)entry).getBinaryValue();
            int nVersionOld = SessionOptimisticPut.extractVersion(binSession);
            if (nVersionOld == (nVersionExp = this.m_nVersion)) {
                entry.remove(this.m_fSynthetic);
                nVersionRet = nVersionOld;
            } else {
                nVersionRet = -nVersionOld;
            }
        }
        return nVersionRet;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_nVersion = ExternalizableHelper.readInt(in);
        try {
            this.m_fSynthetic = ExternalizableHelper.readInt(in) == 0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeInt(out, this.m_nVersion);
        ExternalizableHelper.writeInt(out, this.m_fSynthetic ? 0 : 1);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_nVersion = in.readInt(0);
        this.m_fSynthetic = in.readBoolean(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_nVersion);
        out.writeBoolean(1, this.m_fSynthetic);
    }
}

