/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.management;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.Config;
import com.tangosol.dev.tools.CommandLineTool;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ListMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;

public class MBeanConnector
extends MBeanHelper {
    public static final String HELP_COMMAND_LINE_ARG = "help";
    public static final String RMI_COMMAND_LINE_ARG = "rmi";
    public static final String HTTP_COMMAND_LINE_ARG = "http";
    public static final String[] VALID_COMMANDS = new String[]{"rmi", "http", "help"};
    public static final String RMI_HOST_PROPERTY = "coherence.management.remote.host";
    public static final String RMI_CONNECTION_PORT_PROPERTY = "coherence.management.remote.connectionport";
    public static final String RMI_CONNECTION_PORT_ADJUST_PROPERTY = "coherence.management.remote.connectionport.adjust";
    public static final String RMI_REGISTRY_PORT_PROPERTY = "coherence.management.remote.registryport";
    public static final String RMI_CUSTOM_AUTHENTICATOR_PROPERTY = "coherence.management.remote.authenticator";
    public static final String HTTP_PORT_PROPERTY = "coherence.management.remote.httpport";
    public static final String DEFAULT_RMI_HOST = "0.0.0.0";
    public static final int DEFAULT_RMI_CONNECTION_PORT = 0;
    public static final int DEFAULT_RMI_REGISTRY_PORT = 9000;
    public static final int DEFAULT_HTTP_PORT = 8888;

    public static void main(String[] asArg) throws Exception {
        ListMap mapArgs = CommandLineTool.parseArguments(asArg, VALID_COMMANDS, false);
        boolean fRmi = mapArgs.keySet().contains(RMI_COMMAND_LINE_ARG);
        boolean fHttp = mapArgs.keySet().contains(HTTP_COMMAND_LINE_ARG);
        boolean fHelp = mapArgs.keySet().contains(HELP_COMMAND_LINE_ARG);
        if (!fRmi && !fHttp || fHelp) {
            MBeanConnector.showUsage();
        } else {
            new MBeanConnector().start(fRmi, fHttp);
        }
    }

    public void start(boolean fRmi, boolean fHttp) {
        Cluster cluster = CacheFactory.ensureCluster();
        JMXConnectorServer rmiServer = null;
        Object httpServer = null;
        if (fRmi) {
            try {
                MBeanConnector.out("Starting RMI Connector...");
                rmiServer = this.startRmiConnector();
                MBeanConnector.out("RMI Connector started");
            }
            catch (Exception e) {
                MBeanConnector.out("Could not start RMI connector");
                MBeanConnector.out(e);
            }
        }
        if (fHttp) {
            try {
                MBeanConnector.out("Starting HTTP Connector...");
                httpServer = this.startHttpConnector();
                MBeanConnector.out("HTTP Connector started");
            }
            catch (Exception e) {
                MBeanConnector.out("Could not start HTTP Connector");
                MBeanConnector.out(e);
            }
        }
        if (rmiServer == null && httpServer == null) {
            return;
        }
        while (cluster.isRunning()) {
            try {
                Blocking.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (rmiServer != null) {
            try {
                rmiServer.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (httpServer != null) {
            try {
                ClassHelper.invoke(httpServer, "stop", ClassHelper.VOID_PARAMS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JMXConnectorServer startRmiConnector() throws IOException {
        return MBeanConnector.startRmiConnector(MBeanConnector.getHostName(), MBeanConnector.getRegistryPort(), MBeanConnector.getConnectionPort(), MBeanConnector.findMBeanServer(), MBeanConnector.getRMIConnectorAttributes());
    }

    public static String getHostName() {
        return Config.getProperty(RMI_HOST_PROPERTY, DEFAULT_RMI_HOST);
    }

    public static int getRegistryPort() {
        String sConPort = Config.getProperty(RMI_REGISTRY_PORT_PROPERTY);
        try {
            return sConPort == null ? 9000 : Integer.parseInt(sConPort);
        }
        catch (NumberFormatException e) {
            throw MBeanConnector.ensureRuntimeException(e, "Illegal coherence.management.remote.registryport system property value " + sConPort);
        }
    }

    public static int getConnectionPort() {
        String sConPort = Config.getProperty(RMI_CONNECTION_PORT_PROPERTY);
        try {
            return sConPort == null ? 0 : Integer.parseInt(sConPort);
        }
        catch (NumberFormatException e) {
            throw MBeanConnector.ensureRuntimeException(e, "Illegal coherence.management.remote.connectionport system property value " + sConPort);
        }
    }

    public static int getConnectionPortMax() {
        String sConPort = Config.getProperty(RMI_CONNECTION_PORT_ADJUST_PROPERTY);
        try {
            return sConPort == null ? 65535 : Integer.parseInt(sConPort);
        }
        catch (NumberFormatException e) {
            throw MBeanConnector.ensureRuntimeException(e, "Illegal coherence.management.remote.connectionport.adjust system property value " + sConPort);
        }
    }

    public static Map getRMIConnectorAttributes() {
        String sAuthenticator = Config.getProperty(RMI_CUSTOM_AUTHENTICATOR_PROPERTY);
        if (sAuthenticator != null) {
            try {
                Class<?> cls = Class.forName(sAuthenticator);
                JMXAuthenticator jmxAuthenticator = (JMXAuthenticator)cls.newInstance();
                HashMap<String, JMXAuthenticator> mapAttr = new HashMap<String, JMXAuthenticator>();
                mapAttr.put("jmx.remote.authenticator", jmxAuthenticator);
                return mapAttr;
            }
            catch (Throwable e) {
                Logger.err("Failed to instantiate custom JMXAuthenticator class " + sAuthenticator, e);
            }
        }
        return null;
    }

    public Object startHttpConnector() {
        int nPort;
        String sPort = Config.getProperty(HTTP_PORT_PROPERTY);
        try {
            nPort = sPort == null ? 8888 : Integer.parseInt(sPort);
        }
        catch (NumberFormatException e) {
            throw MBeanConnector.ensureRuntimeException(e, "Illegal 8888 system property value " + sPort);
        }
        MBeanServer mbs = MBeanConnector.findMBeanServer();
        return MBeanConnector.startHttpConnector(nPort, mbs);
    }

    public static void showUsage() {
        MBeanConnector.out();
        MBeanConnector.out("java com.tangosol.net.management.MBeanConnector [-rmi] [-http]");
        MBeanConnector.out();
        MBeanConnector.out("command option descriptions:");
        MBeanConnector.out("\t-rmi  (optional) start a JMX RMI server. The following properties may be set to configure ports:");
        MBeanConnector.out("\t -Dcoherence.management.remote.registryport (default is 9000)");
        MBeanConnector.out("\t -Dcoherence.management.remote.connectionport (default is 3000)");
        MBeanConnector.out();
        MBeanConnector.out("\t-http (optional) start a JMX HTTP server. The following property may be set to configure the HTTP port:");
        MBeanConnector.out("\t -Dcoherence.management.remote.httpport (default is 8888)");
        MBeanConnector.out();
        MBeanConnector.out("Note that at least one protocol (either rmi or http) must be selected.");
    }
}

