/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.oracle.coherence.common.base.Disposable;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.partition.PartitionAwareBackingMap;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.net.partition.PartitionSplittingBackingMap;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.WrapperObservableMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class ObservableSplittingBackingMap
extends WrapperObservableMap
implements CacheMap,
Disposable,
PartitionAwareBackingMap {
    private static final int EVT_SRC_UNKNOWN = 0;
    private static final int EVT_SRC_BACKING = 1;
    private static final int EVT_SRC_THIS = 2;
    private int m_nEventSource = 0;

    public ObservableSplittingBackingMap(BackingMapManager bmm, String sName) {
        this(new PartitionSplittingBackingMap(bmm, sName));
    }

    public ObservableSplittingBackingMap(PartitionAwareBackingMap map) {
        super(map);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        Object oOrig;
        Map mapPart = this.getPartitionSplittingBackingMap().getBackingMap(oKey);
        if (mapPart instanceof CacheMap) {
            boolean fFabricate = this.isEventFabricator();
            int nEvent = fFabricate && mapPart.containsKey(oKey) ? 2 : 1;
            this.prepareUpdate(mapPart, Collections.singletonMap(oKey, oValue));
            oOrig = ((CacheMap)mapPart).put(oKey, oValue, cMillis);
            if (fFabricate) {
                this.dispatchEvent(new CacheEvent<Object, Object>(this, nEvent, oKey, oOrig, oValue, false));
            }
        } else if (cMillis <= 0L) {
            oOrig = super.put(oKey, oValue);
        } else {
            throw new UnsupportedOperationException();
        }
        return oOrig;
    }

    @Override
    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        PartitionSplittingBackingMap mapPSBM;
        BackingMapManagerContext ctx;
        ObservableMap mapSource;
        ObservableSplittingBackingMap.azzert(listener != null);
        MapListenerSupport support = this.ensureMapListenerSupport();
        boolean fWasEmpty = support.isEmpty(oKey);
        boolean fWasLite = !fWasEmpty && !support.containsStandardListeners(oKey);
        support.addListener(listener, oKey, fLite);
        if (this.m_nEventSource == 1 && (fWasEmpty || fWasLite && !fLite) && (mapSource = (ObservableMap)this.getPartitionMap((ctx = (mapPSBM = this.getPartitionSplittingBackingMap()).getContext()).getKeyPartition(oKey))) != null) {
            if (fWasLite && !fLite) {
                mapSource.removeMapListener(this.ensureInternalListener(), oKey);
            }
            mapSource.addMapListener(this.ensureInternalListener(), oKey, fLite);
        }
    }

    @Override
    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        MapListenerSupport support = this.getMapListenerSupport();
        if (support != null) {
            PartitionSplittingBackingMap mapPSBM;
            BackingMapManagerContext ctx;
            ObservableMap mapSource;
            boolean fWasStandard = support.containsStandardListeners(oKey);
            support.removeListener(listener, oKey);
            if (this.m_nEventSource == 1 && (mapSource = (ObservableMap)this.getPartitionMap((ctx = (mapPSBM = this.getPartitionSplittingBackingMap()).getContext()).getKeyPartition(oKey))) != null) {
                MapListener listenerInternal = this.ensureInternalListener();
                if (support.isEmpty(oKey)) {
                    mapSource.removeMapListener(listenerInternal, oKey);
                    if (support.isEmpty()) {
                        this.m_listenerSupport = null;
                    }
                } else if (fWasStandard && !support.containsStandardListeners(oKey)) {
                    mapSource.removeMapListener(listenerInternal, oKey);
                    mapSource.addMapListener(listenerInternal, oKey, true);
                }
            }
        }
    }

    @Override
    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        ObservableSplittingBackingMap.azzert(listener != null);
        MapListenerSupport support = this.ensureMapListenerSupport();
        boolean fWasEmpty = support.isEmpty(filter);
        boolean fWasLite = !fWasEmpty && !support.containsStandardListeners(filter);
        support.addListener(listener, filter, fLite);
        if (this.m_nEventSource == 1 && (fWasEmpty || fWasLite && !fLite)) {
            MapListener listenerInternal = this.ensureInternalListener();
            Map[] amapSource = this.getPartitionSplittingBackingMap().getMapArray().getBackingMaps();
            int c = amapSource.length;
            for (int i = 0; i < c; ++i) {
                ObservableMap mapSource = (ObservableMap)amapSource[i];
                if (fWasLite && !fLite) {
                    mapSource.removeMapListener(listenerInternal, filter);
                }
                mapSource.addMapListener(listenerInternal, filter, fLite);
            }
        }
    }

    @Override
    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        MapListenerSupport support = this.getMapListenerSupport();
        if (support != null) {
            boolean fWasStandard = support.containsStandardListeners(filter);
            support.removeListener(listener, filter);
            if (this.m_nEventSource == 1) {
                boolean fRemove = false;
                boolean fAddLite = false;
                if (support.isEmpty(filter)) {
                    fRemove = true;
                    if (support.isEmpty()) {
                        this.m_listenerSupport = null;
                    }
                } else if (fWasStandard && !support.containsStandardListeners(filter)) {
                    fRemove = true;
                    fAddLite = true;
                }
                if (fRemove || fAddLite) {
                    MapListener listenerInternal = this.ensureInternalListener();
                    Map[] amapSource = this.getPartitionSplittingBackingMap().getMapArray().getBackingMaps();
                    int c = amapSource.length;
                    for (int i = 0; i < c; ++i) {
                        ObservableMap mapSource = (ObservableMap)amapSource[i];
                        if (fRemove) {
                            mapSource.removeMapListener(listenerInternal, filter);
                        }
                        if (!fAddLite) continue;
                        mapSource.addMapListener(listenerInternal, filter, true);
                    }
                }
            }
        }
    }

    @Override
    public BackingMapManager getBackingMapManager() {
        return this.getPartitionSplittingBackingMap().getBackingMapManager();
    }

    @Override
    public String getName() {
        return this.getPartitionSplittingBackingMap().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createPartition(int nPid) {
        PartitionSplittingBackingMap mapPSBM = this.getPartitionSplittingBackingMap();
        mapPSBM.createPartition(nPid);
        Map mapBacking = mapPSBM.getPartitionMap(nPid);
        boolean fObservable = mapBacking instanceof ObservableMap;
        int nEventSource = this.m_nEventSource;
        if (nEventSource == 0) {
            nEventSource = fObservable ? 1 : 2;
            this.m_nEventSource = nEventSource;
        } else {
            ObservableSplittingBackingMap.azzert(nEventSource == (fObservable ? 1 : 2));
        }
        ObservableSplittingBackingMap observableSplittingBackingMap = this;
        synchronized (observableSplittingBackingMap) {
            if (nEventSource == 1 && this.hasListeners()) {
                ObservableMap mapSource = (ObservableMap)mapBacking;
                MapListenerSupport support = this.getMapListenerSupport();
                MapListener listener = this.ensureInternalListener();
                Iterator iter = support.getFilterSet().iterator();
                while (iter.hasNext()) {
                    Filter filter;
                    mapSource.addMapListener(listener, filter, !support.containsStandardListeners(filter = (Filter)iter.next()));
                }
                BackingMapManagerContext ctx = mapPSBM.getContext();
                for (Object oKey : support.getKeySet()) {
                    if (ctx.getKeyPartition(oKey) != nPid) continue;
                    mapSource.addMapListener(listener, oKey, !support.containsStandardListeners(oKey));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyPartition(int nPid) {
        PartitionSplittingBackingMap mapPSBM = this.getPartitionSplittingBackingMap();
        ObservableSplittingBackingMap observableSplittingBackingMap = this;
        synchronized (observableSplittingBackingMap) {
            if (this.m_nEventSource == 1 && this.hasListeners()) {
                ObservableMap mapSource = (ObservableMap)mapPSBM.getPartitionMap(nPid);
                MapListenerSupport support = this.getMapListenerSupport();
                MapListener listener = this.ensureInternalListener();
                for (Filter filter : support.getFilterSet()) {
                    mapSource.removeMapListener(listener, filter);
                }
                BackingMapManagerContext ctx = mapPSBM.getContext();
                for (Object oKey : support.getKeySet()) {
                    if (ctx.getKeyPartition(oKey) != nPid) continue;
                    mapSource.removeMapListener(listener, oKey);
                }
            }
        }
        mapPSBM.destroyPartition(nPid);
    }

    @Override
    public Map getPartitionMap(int nPid) {
        return ((PartitionAwareBackingMap)this.m_map).getPartitionMap(nPid);
    }

    @Override
    public Map getPartitionMap(PartitionSet partitions) {
        return ((PartitionAwareBackingMap)this.m_map).getPartitionMap(partitions);
    }

    @Override
    public void dispose() {
        this.getPartitionSplittingBackingMap().dispose();
    }

    public PartitionSplittingBackingMap getPartitionSplittingBackingMap() {
        return (PartitionSplittingBackingMap)this.getMap();
    }

    @Override
    protected boolean isEventFabricator() {
        return this.hasListeners() && this.m_nEventSource == 2;
    }

    @Override
    public void setTranslateEvents(boolean fTranslate) {
        this.m_fTranslateEvents = fTranslate;
    }

    @Override
    public CacheStatistics getCacheStatistics() {
        return this.getPartitionSplittingBackingMap().getCacheStatistics();
    }

    @Override
    public boolean isCollectStats() {
        return false;
    }

    @Override
    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + '{' + this.getPartitionSplittingBackingMap() + '}';
    }

    protected void prepareUpdate(Map mapPart, Map mapUpdate) {
    }
}

