/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import javax.json.bind.annotation.JsonbProperty;

public class Ownership
extends ExternalizableHelper
implements ExternalizableLite,
PortableObject,
Cloneable {
    @JsonbProperty(value="ownership")
    protected int[] m_aiOwner;

    public Ownership() {
    }

    public Ownership(int cBackups) {
        this.m_aiOwner = new int[1 + cBackups];
    }

    public Ownership(Ownership owners) {
        this(owners.getBackupCount());
        this.setOwners(owners);
    }

    public int getPrimaryOwner() {
        return this.m_aiOwner[0];
    }

    public void setPrimaryOwner(int iOwner) {
        this.m_aiOwner[0] = iOwner;
    }

    public int getOwner(int iStore) {
        int[] aiOwner = this.m_aiOwner;
        return iStore < aiOwner.length ? aiOwner[iStore] : 0;
    }

    public int[] getOwners() {
        return this.getOwners(null);
    }

    public int[] getOwners(int[] aiOwner) {
        int[] aiOwnerThis = this.m_aiOwner;
        int cLen = aiOwnerThis.length;
        if (aiOwner != null && aiOwner.length >= cLen) {
            System.arraycopy(aiOwnerThis, 0, aiOwner, 0, cLen);
            return aiOwner;
        }
        return (int[])aiOwnerThis.clone();
    }

    public void setOwner(int iStore, int iOwner) {
        this.m_aiOwner[iStore] = iOwner;
    }

    public void setOwners(int[] aiOwners) {
        int[] aiOwnersThis = this.m_aiOwner;
        int cStoresThis = aiOwnersThis.length;
        if (cStoresThis != aiOwners.length) {
            throw new IllegalArgumentException("Incompatible backup count");
        }
        System.arraycopy(aiOwners, 0, aiOwnersThis, 0, cStoresThis);
    }

    public void setOwners(Ownership owners) {
        this.setOwners(owners.m_aiOwner);
    }

    public int getBackupCount() {
        return this.m_aiOwner.length - 1;
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder("Owners=");
        int[] aiOwner = this.m_aiOwner;
        int c = aiOwner.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(aiOwner[i]);
        }
        return sb.toString();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        int cStores = Ownership.readInt(in);
        int[] aiOwner = new int[cStores];
        for (int i = 0; i < cStores; ++i) {
            aiOwner[i] = Ownership.readInt(in);
        }
        this.m_aiOwner = aiOwner;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        int[] aiOwner = this.m_aiOwner;
        int cStores = aiOwner.length;
        Ownership.writeInt(out, cStores);
        for (int i = 0; i < cStores; ++i) {
            Ownership.writeInt(out, aiOwner[i]);
        }
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_aiOwner = in.readIntArray(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeIntArray(0, this.m_aiOwner);
    }

    public Object clone() {
        try {
            Ownership that = (Ownership)super.clone();
            that.m_aiOwner = (int[])this.m_aiOwner.clone();
            return that;
        }
        catch (CloneNotSupportedException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.m_aiOwner);
    }

    public boolean equals(Object o) {
        if (o instanceof Ownership) {
            if (o == this) {
                return true;
            }
            Ownership that = (Ownership)o;
            return Ownership.equalsDeep(this.m_aiOwner, that.m_aiOwner);
        }
        return false;
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "{" + this.getDescription() + "}";
    }
}

