/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.security;

import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.DefaultSerializer;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.ClusterPermission;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.NullImplementation;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SignedObject;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;

public class PermissionInfo
extends ExternalizableHelper
implements Externalizable,
PortableObject {
    private transient ClusterPermission m_permission;
    private String m_sServiceName;
    private SignedObject m_signedPermission;
    private Subject m_subject;

    public PermissionInfo() {
    }

    public PermissionInfo(ClusterPermission permission, String sServiceName, SignedObject signedPermission, Subject subject) {
        this.m_permission = permission;
        this.m_sServiceName = sServiceName;
        this.m_signedPermission = signedPermission;
        this.m_subject = subject;
    }

    public ClusterPermission getPermission() {
        return this.m_permission;
    }

    public String getServiceName() {
        return this.m_sServiceName;
    }

    public SignedObject getSignedPermission() {
        return this.m_signedPermission;
    }

    public Subject getSubject() {
        return this.m_subject;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        PofContext ctx = in.getPofContext();
        ClassLoader loader = ctx instanceof ClassLoaderAware ? ((ClassLoaderAware)((Object)ctx)).getContextClassLoader() : PermissionInfo.getContextClassLoader();
        DefaultSerializer serializer = new DefaultSerializer(loader);
        this.m_sServiceName = in.readString(0);
        this.m_signedPermission = (SignedObject)PermissionInfo.fromBinary(in.readBinary(1), serializer);
        if (in.readBoolean(2)) {
            Set setPrincipals = (Set)PermissionInfo.fromBinary(in.readBinary(3), serializer);
            Set setCredentials = (Set)PermissionInfo.fromBinary(in.readBinary(4), serializer);
            this.m_subject = new Subject(true, setPrincipals, setCredentials, NullImplementation.getSet());
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        DefaultSerializer serializer = new DefaultSerializer();
        out.writeString(0, this.m_sServiceName);
        out.writeBinary(1, PermissionInfo.toBinary(this.m_signedPermission, serializer));
        Subject subject = this.m_subject;
        if (subject == null) {
            out.writeBoolean(2, false);
        } else {
            out.writeBoolean(2, true);
            out.writeBinary(3, PermissionInfo.toBinary(subject.getPrincipals(), serializer));
            out.writeBinary(4, PermissionInfo.toBinary(subject.getPublicCredentials(), serializer));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_sServiceName = in.readUTF();
        this.m_signedPermission = (SignedObject)in.readObject();
        if (in.readBoolean()) {
            HashSet setPrincipals = new HashSet();
            HashSet setCredentials = new HashSet();
            PermissionInfo.readCollection(in, setPrincipals, null);
            PermissionInfo.readCollection(in, setCredentials, null);
            this.m_subject = new Subject(true, setPrincipals, setCredentials, NullImplementation.getSet());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getServiceName());
        out.writeObject(this.getSignedPermission());
        Subject subject = this.getSubject();
        if (subject == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            PermissionInfo.writeCollection(out, subject.getPrincipals());
            PermissionInfo.writeCollection(out, subject.getPublicCredentials());
        }
    }
}

