/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.persistence;

import com.oracle.datagrid.persistence.OfflinePersistenceInfo;
import com.oracle.datagrid.persistence.PersistenceStatistics;
import com.oracle.datagrid.persistence.PersistenceTools;
import com.tangosol.persistence.CachePersistenceHelper;
import com.tangosol.util.Binary;
import com.tangosol.util.LongArray;

public abstract class AbstractPersistenceTools
implements PersistenceTools {
    protected final OfflinePersistenceInfo f_info;

    public AbstractPersistenceTools(OfflinePersistenceInfo info) {
        this.f_info = info;
    }

    @Override
    public OfflinePersistenceInfo getPersistenceInfo() {
        return this.f_info;
    }

    public String toString() {
        PersistenceStatistics stats;
        StringBuilder sb = new StringBuilder();
        if (this.f_info != null) {
            sb.append(this.f_info);
        }
        if ((stats = this.getStatistics()) != null) {
            sb.append(stats);
        }
        return sb.toString();
    }

    protected static class StatsVisitor
    implements CachePersistenceHelper.Visitor {
        private LongArray m_laCaches = null;
        private final PersistenceStatistics f_stats;

        public StatsVisitor(PersistenceStatistics stats) {
            this.f_stats = stats;
        }

        @Override
        public boolean visitCacheEntry(long lOldCacheId, Binary binKey, Binary binValue) {
            String sCacheName = this.getCacheName(lOldCacheId);
            this.f_stats.addToBytes(sCacheName, binKey.length() + binValue.length());
            this.f_stats.incrementSize(sCacheName);
            return true;
        }

        @Override
        public boolean visitListener(long lOldCacheId, Binary binKey, long lListenerId, boolean fLite) {
            this.f_stats.incrementListeners(this.getCacheName(lOldCacheId));
            return true;
        }

        @Override
        public boolean visitLock(long lOldCacheId, Binary binKey, long lHolderId, long lHolderThreadId) {
            this.f_stats.incrementLocks(this.getCacheName(lOldCacheId));
            return true;
        }

        @Override
        public boolean visitIndex(long lOldCacheId, Binary binExtractor, Binary binComparator) {
            this.f_stats.incrementIndexes(this.getCacheName(lOldCacheId));
            return true;
        }

        @Override
        public boolean visitTrigger(long lOldCacheId, Binary binTrigger) {
            this.f_stats.incrementTriggers(this.getCacheName(lOldCacheId));
            return true;
        }

        protected String getCacheName(long lOldCacheId) {
            if (this.m_laCaches == null) {
                throw new IllegalStateException("You must use setCaches() to set the caches");
            }
            return (String)this.m_laCaches.get(lOldCacheId);
        }

        public void setCaches(LongArray laCaches) {
            this.m_laCaches = laCaches;
        }
    }
}

