/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.persistence;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.persistence.PersistenceException;
import com.oracle.coherence.persistence.PersistenceManager;
import com.tangosol.io.FileHelper;
import com.tangosol.io.ReadBuffer;
import com.tangosol.net.GuardSupport;
import com.tangosol.persistence.AbstractSnapshotArchiver;
import com.tangosol.persistence.ArchiverHelper;
import com.tangosol.persistence.CachePersistenceHelper;
import com.tangosol.persistence.GUIDHelper;
import com.tangosol.persistence.Snapshot;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;

public class DirectorySnapshotArchiver
extends AbstractSnapshotArchiver {
    private final File f_fileSharedDirectoryPath;

    public DirectorySnapshotArchiver(String sClusterName, String sServiceName, File fileDirectory) throws IOException {
        super(sClusterName, sServiceName);
        this.f_fileSharedDirectoryPath = fileDirectory;
        FileHelper.ensureDir(this.f_fileSharedDirectoryPath);
        if (!this.f_fileSharedDirectoryPath.exists() || !this.f_fileSharedDirectoryPath.canWrite()) {
            throw new IllegalArgumentException("Directory " + this.f_fileSharedDirectoryPath.getAbsolutePath() + " does not exist or cannot be written to");
        }
    }

    @Override
    protected String[] listInternal() {
        ArrayList<String> snapshotArrayList = new ArrayList<String>();
        File[] aFiles = this.f_fileSharedDirectoryPath.listFiles(ArchiverHelper.DirectoryFileFilter.INSTANCE);
        if (aFiles != null) {
            for (File file : aFiles) {
                snapshotArrayList.add(file.getName());
            }
        }
        return snapshotArrayList.toArray(new String[snapshotArrayList.size()]);
    }

    @Override
    protected void archiveInternal(Snapshot snapshot, PersistenceManager<ReadBuffer> mgr) {
        String sSnapshotName = snapshot.getName();
        OutputStream os = null;
        for (String sStore : snapshot.listStores()) {
            Logger.finer("Archiving store " + sStore + " for snapshot " + sSnapshotName);
            this.recordStartTime();
            try {
                File fileArchivedSnapshot = new File(this.f_fileSharedDirectoryPath, sSnapshotName);
                FileHelper.ensureDir(fileArchivedSnapshot);
                if (CachePersistenceHelper.isGlobalPartitioningSchemePID(GUIDHelper.getPartition(sStore))) {
                    this.writeMetadata(fileArchivedSnapshot, mgr, sStore);
                }
                File fileStore = new File(fileArchivedSnapshot, sStore);
                os = new FileOutputStream(fileStore);
                mgr.write(sStore, os);
                GuardSupport.heartbeat();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw CachePersistenceHelper.ensurePersistenceException(e, "Error writing store");
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException ioe) {
                        throw CachePersistenceHelper.ensurePersistenceException(ioe, "Unable to close output stream for store " + sStore);
                    }
                }
            }
            this.recordEndTime();
        }
    }

    @Override
    protected void retrieveInternal(Snapshot snapshot, PersistenceManager<ReadBuffer> mgr) {
        String sSnapshotName = snapshot.getName();
        InputStream is = null;
        for (String sStore : snapshot.listStores()) {
            Logger.finer("Retrieving store " + sStore + " for snapshot " + sSnapshotName);
            this.recordStartTime();
            try {
                if (CachePersistenceHelper.isGlobalPartitioningSchemePID(GUIDHelper.getPartition(sStore)) && this.getMetadata(sSnapshotName) == null) {
                    throw new IllegalArgumentException("Cannot load properties file meta.properties for snapshot " + sSnapshotName);
                }
                File fileStore = new File(this.f_fileSharedDirectoryPath, sSnapshotName);
                if (!(fileStore = new File(fileStore, sStore)).exists()) {
                    throw new PersistenceException("Store " + fileStore + " does not exist. Unable to retrieve.");
                }
                is = new FileInputStream(fileStore);
                mgr.read(sStore, is);
                GuardSupport.heartbeat();
            }
            catch (IOException e) {
                throw CachePersistenceHelper.ensurePersistenceException(e, "Error reading store " + sStore);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        throw CachePersistenceHelper.ensurePersistenceException(ioe, "Unable to close input stream for store " + sStore);
                    }
                }
            }
            this.recordEndTime();
        }
    }

    @Override
    protected boolean removeInternal(String sSnapshot) {
        File fileSnapshot = null;
        try {
            fileSnapshot = new File(this.f_fileSharedDirectoryPath, FileHelper.toFilename(sSnapshot));
            if (!fileSnapshot.exists() || !fileSnapshot.isDirectory()) {
                throw new PersistenceException(fileSnapshot + " is not a directory");
            }
            FileHelper.deleteDir(fileSnapshot);
            return true;
        }
        catch (IOException ioe) {
            Logger.warn("Unable to delete directory " + fileSnapshot + " " + ioe.getMessage());
            return false;
        }
    }

    @Override
    protected String[] listStoresInternal(String sSnapshot) {
        String[] aStores;
        File fileSnapshot = new File(this.f_fileSharedDirectoryPath, sSnapshot);
        if (!(fileSnapshot.exists() && fileSnapshot.canRead() && fileSnapshot.canExecute())) {
            throw new IllegalArgumentException("Cannot open snapshot directory " + fileSnapshot);
        }
        File[] aSnapshotFiles = fileSnapshot.listFiles(file -> !file.getName().equals("meta.properties"));
        if (aSnapshotFiles != null) {
            aStores = new String[aSnapshotFiles.length];
            int i = 0;
            for (File storeFile : aSnapshotFiles) {
                if (!storeFile.isFile()) continue;
                aStores[i++] = storeFile.getName();
            }
        } else {
            aStores = new String[]{};
        }
        return aStores;
    }

    @Override
    protected Properties getMetadata(String sSnapshot) throws IOException {
        File fileSnapshot = new File(this.f_fileSharedDirectoryPath, sSnapshot);
        if (!(fileSnapshot.exists() && fileSnapshot.canRead() && fileSnapshot.canExecute())) {
            throw new IllegalArgumentException("Cannot open snapshot directory " + fileSnapshot);
        }
        return CachePersistenceHelper.readMetadata(fileSnapshot);
    }

    @Override
    public String toString() {
        return "DirectorySnapshotArchiver(SharedDirectoryPath=" + this.f_fileSharedDirectoryPath.getAbsolutePath() + ")";
    }

    public File getSharedDirectoryPath() {
        return this.f_fileSharedDirectoryPath;
    }
}

