/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.run.xml.SimpleAdapter;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlBean;
import com.tangosol.run.xml.XmlElement;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateFormatAdapter
extends SimpleAdapter.OldDateAdapter {
    private DateFormat m_formatter;

    public DateFormatAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
        super(infoBean, clzType, sName, sXml, xml);
        SimpleDateFormat formatter = null;
        String sPattern = xml.getSafeElement("pattern").getString();
        if (sPattern.length() == 0) {
            formatter = new SimpleDateFormat();
        } else {
            XmlElement xmlLocale = xml.getElement("locale");
            if (xmlLocale == null) {
                formatter = new SimpleDateFormat(sPattern);
            } else {
                String sLanguage = xmlLocale.getSafeElement("language").getString();
                String sCountry = xmlLocale.getSafeElement("country").getString();
                Locale locale = new Locale(sLanguage, sCountry);
                formatter = new SimpleDateFormat(sPattern, locale);
            }
        }
        formatter.setLenient(true);
        this.m_formatter = formatter;
    }

    @Override
    public Object fromXml(XmlElement xml) {
        String sDate = xml.getString(null);
        if (sDate == null) {
            return null;
        }
        try {
            return this.m_formatter.parse(sDate);
        }
        catch (ParseException e) {
            return new Date(0L);
        }
    }

    @Override
    public XmlElement toXml(Object o) {
        return o == null ? null : new SimpleElement(this.getXmlName(), this.m_formatter.format((Date)o));
    }
}

