/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.AbstractLongArray;
import com.tangosol.util.LongArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;

public abstract class AbstractSparseArray<V>
extends AbstractLongArray<V> {
    protected Node<V> m_head = null;
    protected int m_size = 0;

    @Override
    public V get(long lIndex) {
        Node<V> node = this.find(lIndex);
        return node == null ? null : (V)node.getValue();
    }

    @Override
    public long floorIndex(long lIndex) {
        Node<V> closest = null;
        Node<V> current = this.m_head;
        while (current != null) {
            long lCurrent = current.key;
            if (lIndex < lCurrent) {
                current = current.left;
                continue;
            }
            if (lIndex > lCurrent) {
                closest = current;
                current = current.right;
                continue;
            }
            return lCurrent;
        }
        return closest == null ? -1L : closest.key;
    }

    @Override
    public V floor(long lIndex) {
        Node<V> closest = null;
        Node<V> current = this.m_head;
        while (current != null) {
            long lCurrent = current.key;
            if (lIndex < lCurrent) {
                current = current.left;
                continue;
            }
            if (lIndex > lCurrent) {
                closest = current;
                current = current.right;
                continue;
            }
            return current.getValue();
        }
        return closest == null ? null : (V)closest.getValue();
    }

    @Override
    public long ceilingIndex(long lIndex) {
        Node<V> closest = null;
        Node<V> current = this.m_head;
        while (current != null) {
            long lCurrent = current.key;
            if (lIndex < lCurrent) {
                closest = current;
                current = current.left;
                continue;
            }
            if (lIndex > lCurrent) {
                current = current.right;
                continue;
            }
            return lCurrent;
        }
        return closest == null ? -1L : closest.key;
    }

    @Override
    public V ceiling(long lIndex) {
        Node<V> closest = null;
        Node<V> current = this.m_head;
        while (current != null) {
            long lCurrent = current.key;
            if (lIndex < lCurrent) {
                closest = current;
                current = current.left;
                continue;
            }
            if (lIndex > lCurrent) {
                current = current.right;
                continue;
            }
            return current.getValue();
        }
        return closest == null ? null : (V)closest.getValue();
    }

    @Override
    public V set(long lIndex, V oValue) {
        Node<V> node = this.findInsertionPoint(lIndex);
        if (node != null && node.key == lIndex) {
            return node.setValue(oValue);
        }
        this.balancedInsertion(node, this.instantiateNode(lIndex, oValue));
        return null;
    }

    @Override
    public boolean exists(long lIndex) {
        return this.find(lIndex) != null;
    }

    @Override
    public V remove(long lIndex) {
        Node<V> node = this.find(lIndex);
        if (node == null) {
            return null;
        }
        V oValue = node.getValue();
        this.remove(node);
        return oValue;
    }

    @Override
    public void remove(long lIndexFrom, long lIndexTo) {
        Node<V> closest = null;
        Node<V> current = this.m_head;
        while (current != null) {
            long lCurrent = current.key;
            if (lIndexFrom < lCurrent) {
                closest = current;
                current = current.left;
                continue;
            }
            if (lIndexFrom <= lCurrent) break;
            current = current.right;
        }
        if (current == null) {
            if (closest == null) {
                return;
            }
            current = closest;
        }
        int fromdir = 1;
        Node<V> nodeRemove = null;
        block6: while (true) {
            switch (fromdir) {
                case 0: {
                    if (current.left != null) {
                        current = current.left;
                        continue block6;
                    }
                }
                case 1: {
                    if (nodeRemove != null) {
                        this.remove(nodeRemove);
                    }
                    if (current == null || current.key >= lIndexTo) {
                        return;
                    }
                    nodeRemove = current;
                    if (current.right != null) {
                        fromdir = 0;
                        current = current.right;
                        continue block6;
                    }
                }
                case 3: {
                    if (current.parent != null) {
                        fromdir = current == current.parent.left ? 1 : 3;
                        current = current.parent;
                        continue block6;
                    }
                    this.remove(nodeRemove);
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException("invalid direction: " + fromdir);
    }

    @Override
    public void clear() {
        this.m_head = null;
        this.m_size = 0;
    }

    @Override
    public int getSize() {
        return this.m_size;
    }

    @Override
    public LongArray.Iterator<V> iterator() {
        return this.instantiateCrawler(this.m_head, 0, true);
    }

    @Override
    public LongArray.Iterator<V> iterator(long lIndex) {
        Node<V> closest = null;
        Node<V> current = this.m_head;
        while (current != null) {
            long lCurrent = current.key;
            if (lIndex < lCurrent) {
                closest = current;
                current = current.left;
                continue;
            }
            if (lIndex > lCurrent) {
                current = current.right;
                continue;
            }
            return this.instantiateCrawler(current, 1, true);
        }
        return this.instantiateCrawler(closest, 1, true);
    }

    @Override
    public LongArray.Iterator<V> reverseIterator() {
        return this.instantiateCrawler(this.m_head, 0, false);
    }

    @Override
    public LongArray.Iterator<V> reverseIterator(long lIndex) {
        Node<V> closest = null;
        Node<V> current = this.m_head;
        while (current != null) {
            long lCurrent = current.key;
            if (lIndex < lCurrent) {
                current = current.left;
                continue;
            }
            if (lIndex > lCurrent) {
                closest = current;
                current = current.right;
                continue;
            }
            return this.instantiateCrawler(current, 3, false);
        }
        return this.instantiateCrawler(closest, 3, false);
    }

    @Override
    public long getFirstIndex() {
        Node<V> nodeCur = this.m_head;
        if (nodeCur == null) {
            return -1L;
        }
        Node nodeNext = nodeCur.left;
        while (nodeNext != null) {
            nodeCur = nodeNext;
            nodeNext = nodeCur.left;
        }
        return nodeCur.key;
    }

    @Override
    public long getLastIndex() {
        Node<V> nodeCur = this.m_head;
        if (nodeCur == null) {
            return -1L;
        }
        Node nodeNext = nodeCur.right;
        while (nodeNext != null) {
            nodeCur = nodeNext;
            nodeNext = nodeCur.right;
        }
        return nodeCur.key;
    }

    @Override
    public AbstractSparseArray<V> clone() {
        AbstractSparseArray that = (AbstractSparseArray)super.clone();
        that.m_head = this.m_head == null ? null : this.m_head.clone();
        return that;
    }

    public void print() {
        if (this.m_head != null) {
            this.m_head.print();
        }
    }

    public void validate() {
        if (this.m_head == null) {
            assert (this.m_size == 0);
        } else {
            assert (this.m_head.parent == null);
            assert (this.m_head.validate() < Integer.numberOfLeadingZeros(this.m_size) * 2);
        }
    }

    protected Node<V> find(long lIndex) {
        Node<V> current = this.m_head;
        while (current != null) {
            long lCurrent = current.key;
            if (lIndex < lCurrent) {
                current = current.left;
                continue;
            }
            if (lIndex > lCurrent) {
                current = current.right;
                continue;
            }
            return current;
        }
        return null;
    }

    protected void remove(Node<V> node) {
        if (node.left == null || node.right == null) {
            Node child = node.left == null ? node.right : node.left;
            Node<V> parent = this.replace(node, child);
            if (parent != null) {
                this.balancePostRemove(parent, node.key < parent.key);
            }
        } else {
            Node heir = node.right;
            while (heir.left != null) {
                heir = heir.left;
            }
            heir.balance = node.balance;
            if (heir.parent == node) {
                heir.adopt(node.left, true);
                this.replace(node, heir);
                this.balancePostRemove(heir, false);
            } else {
                heir.parent.adopt(heir.right, true);
                heir.adopt(node.left, true);
                heir.adopt(node.right, false);
                Node pruned = heir.parent;
                this.replace(node, heir);
                this.balancePostRemove(pruned, true);
            }
        }
        node.left = null;
        node.right = null;
        node.parent = null;
        --this.m_size;
    }

    protected Node<V> replace(Node<V> nodeA, Node<V> nodeB) {
        Node parent = nodeA.parent;
        if (parent == null) {
            this.m_head = nodeB;
        } else if (parent.left == nodeA) {
            parent.left = nodeB;
        } else {
            parent.right = nodeB;
        }
        if (nodeB != null) {
            nodeB.parent = parent;
        }
        return parent;
    }

    protected Node<V> rotate(Node<V> node, boolean fLeft) {
        Node parent = node.parent;
        Node<V> child = fLeft ? node.right : node.left;
        this.replace(child, fLeft ? child.left : child.right);
        child.adopt(node, fLeft);
        node.parent = parent;
        this.replace(node, child);
        node.parent = child;
        return node.parent;
    }

    protected Node<V> doubleRotate(Node<V> node, boolean fLeft) {
        this.rotate(fLeft ? node.right : node.left, !fLeft);
        return this.rotate(node, fLeft);
    }

    protected void adjustDoubleBalance(Node<V> node, Node<V> child, int iBal) {
        Node grand;
        Node node2 = grand = child == node.left ? child.right : child.left;
        if (grand.balance == 0) {
            child.balance = 0;
            node.balance = 0;
        } else if (grand.balance == iBal) {
            node.balance = -iBal;
            child.balance = 0;
        } else {
            node.balance = 0;
            child.balance = iBal;
        }
        grand.balance = 0;
    }

    protected Node<V> findInsertionPoint(long lIndex) {
        Node<V> node = this.m_head;
        if (node == null) {
            return null;
        }
        while (true) {
            long lCurr;
            if (lIndex > (lCurr = node.key)) {
                if (node.right == null) {
                    return node;
                }
                node = node.right;
                continue;
            }
            if (lIndex >= lCurr) break;
            if (node.left == null) {
                return node;
            }
            node = node.left;
        }
        return node;
    }

    protected void balancedInsertion(Node<V> parent, Node<V> child) {
        if (parent == null) {
            this.m_head = child;
            this.m_size = 1;
            return;
        }
        if (child.key < parent.key) {
            parent.adopt(child, true);
            --parent.balance;
        } else {
            parent.adopt(child, false);
            ++parent.balance;
        }
        ++this.m_size;
        block5: while (true) {
            switch (parent.balance) {
                case 0: {
                    return;
                }
                case -1: 
                case 1: {
                    child = parent;
                    parent = child.parent;
                    if (parent == null) {
                        return;
                    }
                    parent.balance = parent.balance + (parent.left == child ? -1 : 1);
                    continue block5;
                }
                case -2: 
                case 2: {
                    int iBal;
                    boolean fLeftChild = parent.left == child;
                    int n = iBal = fLeftChild ? -1 : 1;
                    if (child.balance == iBal) {
                        child.balance = 0;
                        parent.balance = 0;
                        this.rotate(parent, !fLeftChild);
                    } else {
                        this.adjustDoubleBalance(parent, child, iBal);
                        this.doubleRotate(parent, !fLeftChild);
                    }
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void balancePostRemove(Node<V> pruned, boolean fPrunedLeft) {
        block5: while (true) {
            pruned.balance = pruned.balance + (fPrunedLeft ? 1 : -1);
            switch (pruned.balance) {
                case -1: 
                case 1: {
                    return;
                }
                case -2: 
                case 2: {
                    int iBal;
                    Node child;
                    if (fPrunedLeft) {
                        child = pruned.right;
                        iBal = -1;
                    } else {
                        child = pruned.left;
                        iBal = 1;
                    }
                    if (child.balance == -iBal) {
                        child.balance = 0;
                        pruned.balance = 0;
                        pruned = this.rotate(pruned, fPrunedLeft);
                    } else {
                        if (child.balance != iBal) {
                            pruned.balance = -iBal;
                            child.balance = iBal;
                            this.rotate(pruned, fPrunedLeft);
                            return;
                        }
                        this.adjustDoubleBalance(pruned, child, -iBal);
                        pruned = this.doubleRotate(pruned, fPrunedLeft);
                    }
                }
                case 0: {
                    if (pruned.parent == null) {
                        return;
                    }
                    fPrunedLeft = pruned.parent.left == pruned;
                    pruned = pruned.parent;
                    continue block5;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    protected abstract Node<V> instantiateNode(long var1, V var3);

    protected Crawler instantiateCrawler(Node<V> head, int fromdir, boolean fForward) {
        return new Crawler(head, fromdir, fForward);
    }

    protected class Crawler
    implements LongArray.Iterator<V>,
    Cloneable {
        protected static final int ABOVE = 0;
        protected static final int LEFT = 1;
        protected static final int SITTING = 2;
        protected static final int RIGHT = 3;
        protected Node<V> current;
        protected int fromdir;
        protected final boolean fForward;

        protected Crawler(Node<V> head, int fromdir, boolean fForward) {
            this.current = head;
            this.fromdir = fromdir;
            this.fForward = fForward;
        }

        @Override
        public boolean hasNext() {
            if (this.fForward) {
                this.crawlForwardToNext();
            } else {
                this.crawlReverseToNext();
            }
            return this.current != null;
        }

        private void crawlForwardToNext() {
            if (this.current == null) {
                return;
            }
            block6: while (true) {
                switch (this.fromdir) {
                    case 0: {
                        if (this.current.left != null) {
                            this.current = this.current.left;
                            continue block6;
                        }
                        this.fromdir = 1;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        if (this.current.right != null) {
                            this.fromdir = 0;
                            this.current = this.current.right;
                            continue block6;
                        }
                    }
                    case 3: {
                        if (this.current.parent != null) {
                            this.fromdir = this.current == this.current.parent.left ? 1 : 3;
                            this.current = this.current.parent;
                            continue block6;
                        }
                        this.current = null;
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException("invalid direction: " + this.fromdir);
        }

        private void crawlReverseToNext() {
            if (this.current == null) {
                return;
            }
            block6: while (true) {
                switch (this.fromdir) {
                    case 0: {
                        if (this.current.right != null) {
                            this.current = this.current.right;
                            continue block6;
                        }
                        this.fromdir = 3;
                    }
                    case 3: {
                        return;
                    }
                    case 2: {
                        if (this.current.left != null) {
                            this.fromdir = 0;
                            this.current = this.current.left;
                            continue block6;
                        }
                    }
                    case 1: {
                        if (this.current.parent != null) {
                            this.fromdir = this.current == this.current.parent.right ? 3 : 1;
                            this.current = this.current.parent;
                            continue block6;
                        }
                        this.current = null;
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException("invalid direction: " + this.fromdir);
        }

        @Override
        public V next() {
            return this.nextNode().getValue();
        }

        @Override
        public long getIndex() {
            return this.currentNode().key;
        }

        @Override
        public V getValue() {
            return this.currentNode().getValue();
        }

        @Override
        public V setValue(V oValue) {
            return this.currentNode().setValue(oValue);
        }

        @Override
        public void remove() {
            Node node = this.currentNode();
            if (this.hasNext()) {
                this.next();
                int n = this.fromdir = this.fForward ? 1 : 3;
            }
            if (!node.isLinked() && AbstractSparseArray.this.m_head != node) {
                throw new IllegalStateException("the node has already been removed");
            }
            AbstractSparseArray.this.remove(node);
        }

        public String toString() {
            String key = String.valueOf(this.current.key);
            switch (this.fromdir) {
                case 0: {
                    return "crawled into " + key;
                }
                case 1: {
                    return "returned to " + key + " from the left child";
                }
                case 2: {
                    return "sitting in " + key;
                }
                case 3: {
                    return "returned to " + key + " from the right child";
                }
            }
            throw new IllegalStateException("invalid direction: " + this.fromdir);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected Node<V> nextNode() {
            if (this.fForward) {
                this.crawlForwardToNext();
            } else {
                this.crawlReverseToNext();
            }
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            this.fromdir = 2;
            return this.current;
        }

        protected Node<V> currentNode() {
            Node node = this.current;
            if (node == null || this.fromdir != 2) {
                throw new IllegalStateException();
            }
            return node;
        }
    }

    protected static abstract class Node<V>
    implements Cloneable,
    Serializable {
        protected long key;
        protected Node<V> parent;
        protected Node<V> left;
        protected Node<V> right;
        protected int balance;

        protected Node() {
        }

        protected void adopt(Node<V> child, boolean fLeft) {
            if (fLeft) {
                this.left = child;
            } else {
                this.right = child;
            }
            if (child != null) {
                child.parent = this;
            }
        }

        public abstract V getValue();

        public abstract V setValue(V var1);

        public String toString() {
            return (this.left == null ? "" : this.left.toString() + ',') + this.key + (this.right == null ? "" : ',' + this.right.toString());
        }

        public Node<V> clone() {
            try {
                Object right;
                Node that = (Node)super.clone();
                that.key = this.key;
                that.balance = this.balance;
                that.setValue(this.getValue());
                Object left = this.left;
                if (left != null) {
                    that.left = left = ((Node)left).clone();
                    ((Node)left).parent = that;
                }
                if ((right = this.right) != null) {
                    that.right = right = ((Node)right).clone();
                    ((Node)right).parent = that;
                }
                return that;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeLong(this.key);
            out.writeByte(this.balance);
            out.writeObject(this.getValue());
            boolean fLeft = this.left != null;
            out.writeBoolean(fLeft);
            if (fLeft) {
                out.writeObject(this.left);
            }
            boolean fRight = this.right != null;
            out.writeBoolean(fRight);
            if (fRight) {
                out.writeObject(this.right);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.key = in.readLong();
            this.balance = in.readByte();
            this.setValue(in.readObject());
            if (in.readBoolean()) {
                this.left = (Node)in.readObject();
                this.left.parent = this;
            }
            if (in.readBoolean()) {
                this.right = (Node)in.readObject();
                this.right.parent = this;
            }
        }

        protected boolean isLeaf() {
            return this.left == null || this.right == null;
        }

        protected boolean isLinked() {
            return this.parent != null || this.left != null || this.right != null;
        }

        protected void print() {
            System.out.println(this.key + ", balance " + this.balance + ", left " + (this.left == null ? "-" : Long.toString(this.left.key)) + ", right " + (this.right == null ? "-" : Long.toString(this.right.key)) + ", parent " + (this.parent == null ? "-" : Long.toString(this.parent.key)));
            if (this.left != null) {
                this.left.print();
            }
            if (this.right != null) {
                this.right.print();
            }
        }

        protected int validate() {
            int nLeft = 0;
            if (this.left != null) {
                assert (this.left.parent == this);
                assert (this.left.key < this.key);
                nLeft = this.left.validate();
            }
            int nRight = 0;
            if (this.right != null) {
                assert (this.right.parent == this);
                assert (this.right.key > this.key);
                nRight = this.right.validate();
            }
            assert (nRight - nLeft == this.balance);
            assert (Math.abs(this.balance) <= 1);
            return Math.max(nRight, nLeft) + 1;
        }
    }
}

