/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.base.Notifier;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.base.Timeout;
import com.oracle.coherence.common.util.Duration;
import com.tangosol.net.FlowControl;
import com.tangosol.util.Base;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public abstract class AsynchronousAgent<T>
implements FlowControl,
Future<T> {
    protected FlowControl m_control;
    protected final int m_iOrderId;
    private volatile boolean m_fCompleted;
    private Supplier<T> m_supplier;
    private CompletableFuture<T> m_future;
    private final Notifier f_notifier = new SingleWaiterMultiNotifier();

    protected AsynchronousAgent(int iOrderId) {
        this.m_iOrderId = iOrderId;
    }

    public void bind(FlowControl control) {
        this.m_control = control;
    }

    @Override
    public void flush() {
        FlowControl control = this.m_control;
        if (control == null) {
            throw new IllegalStateException();
        }
        control.flush();
    }

    @Override
    public long drainBacklog(long cMillis) {
        FlowControl control = this.m_control;
        if (control == null) {
            throw new IllegalStateException();
        }
        return control.drainBacklog(cMillis);
    }

    @Override
    public boolean checkBacklog(Continuation<Void> continueNormal) {
        FlowControl control = this.m_control;
        if (control == null) {
            throw new IllegalStateException();
        }
        return control.checkBacklog(continueNormal);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.completeExceptionally(new CancellationException());
    }

    @Override
    public boolean isCancelled() {
        CompletableFuture<T> future;
        if (this.m_fCompleted && (future = this.m_future) != null) {
            return future.isCancelled();
        }
        return false;
    }

    @Override
    public boolean isDone() {
        return this.m_fCompleted;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T get(long cTimeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long ldtTimeout = Base.getLastSafeTimeMillis() + unit.toMillis(cTimeout);
        try (Timeout t2 = Timeout.after(cTimeout, unit);){
            while (!this.m_fCompleted) {
                this.f_notifier.await();
            }
            T t = this.getCompletableFuture().get();
            return t;
        }
        catch (InterruptedException e) {
            if (Base.getSafeTimeMillis() < ldtTimeout) throw e;
            throw new TimeoutException("Elapsed " + new Duration(unit.toNanos(cTimeout)));
        }
    }

    public int getUnitOfOrderId() {
        return this.m_iOrderId;
    }

    protected synchronized boolean complete(Supplier<T> supplier) {
        if (!this.m_fCompleted) {
            if (supplier == null) {
                throw new IllegalArgumentException("No supplier");
            }
            CompletableFuture<T> future = this.m_future;
            if (future == null || !future.isDone()) {
                if (future == null) {
                    this.m_supplier = supplier;
                } else {
                    future.complete(supplier.get());
                }
                this.m_fCompleted = true;
                this.f_notifier.signal();
                return true;
            }
        }
        return false;
    }

    protected synchronized boolean completeExceptionally(Throwable eReason) {
        if (!this.m_fCompleted) {
            if (eReason == null) {
                throw new IllegalArgumentException("No reason");
            }
            CompletableFuture<T> future = this.m_future;
            if (future == null || !future.isDone()) {
                if (future == null) {
                    this.m_future = new CompletableFuture();
                    future = this.m_future;
                }
                future.completeExceptionally(eReason);
                this.m_fCompleted = true;
                this.f_notifier.signal();
                return true;
            }
        }
        return false;
    }

    public T getResult() {
        try {
            return this.get();
        }
        catch (ExecutionException e) {
            throw Base.ensureRuntimeException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Throwable getException() {
        if (this.isCompletedExceptionally()) {
            try {
                this.get();
            }
            catch (ExecutionException e) {
                return e.getCause();
            }
            catch (InterruptedException e) {
                return e;
            }
        }
        return null;
    }

    public boolean isCompletedExceptionally() {
        CompletableFuture<T> future;
        if (this.m_fCompleted && (future = this.m_future) != null) {
            return future.isCompletedExceptionally();
        }
        return false;
    }

    public synchronized CompletableFuture<T> getCompletableFuture() {
        CompletableFuture<T> future = this.m_future;
        if (future == null) {
            this.m_future = new CompletableFuture();
            future = this.m_future;
            if (this.m_fCompleted) {
                assert (this.m_supplier != null);
                future.complete(this.m_supplier.get());
            }
        }
        return future;
    }
}

