/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.Assertions;
import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.base.Formatting;
import com.oracle.coherence.common.base.HashHelper;
import com.oracle.coherence.common.base.Hasher;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.base.Objects;
import com.oracle.coherence.common.base.Randoms;
import com.oracle.coherence.common.base.Reads;
import com.oracle.coherence.common.base.StackTrace;
import com.oracle.coherence.common.base.TimeHelper;
import com.oracle.coherence.common.util.CommonMonitor;
import com.tangosol.coherence.config.Config;
import com.tangosol.util.Binary;
import com.tangosol.util.ByteSequence;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ThreadFactory;
import com.tangosol.util.WrapperException;
import java.io.CharArrayWriter;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;

public abstract class Base {
    public static final int UNIT_NS = -1000000;
    public static final int UNIT_US = -1000;
    public static final int UNIT_MS = 1;
    public static final int UNIT_S = 1000;
    public static final int UNIT_M = 60000;
    public static final int UNIT_H = 3600000;
    public static final int UNIT_D = 86400000;
    public static final int POWER_0 = 0;
    public static final int POWER_K = 10;
    public static final int POWER_M = 20;
    public static final int POWER_G = 30;
    public static final int POWER_T = 40;
    public static final int LOG_MIN = 0;
    public static final int LOG_MAX = 9;
    public static final int LOG_ALWAYS = 0;
    public static final int LOG_ERR = 1;
    public static final int LOG_WARN = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_CONFIG = 4;
    public static final int LOG_DEBUG = 5;
    public static final int LOG_QUIET = 6;
    private static PrintWriter s_out = new PrintWriter(System.out, true);
    private static PrintWriter s_err = new PrintWriter(System.err, true);
    private static PrintWriter s_log = new PrintWriter(NullImplementation.getWriter(), true);
    private static boolean s_fEchoLog = true;
    private static final ThreadFactory s_threadFactory = Base.instantiateThreadFactory();

    public static void trace(boolean fVal) {
        Base.traceImpl(String.valueOf(fVal));
    }

    public static void trace(char chVal) {
        Base.traceImpl(String.valueOf(chVal));
    }

    public static void trace(int nVal) {
        Base.traceImpl(String.valueOf(nVal));
    }

    public static void trace(long lVal) {
        Base.traceImpl(String.valueOf(lVal));
    }

    public static void trace(float flVal) {
        Base.traceImpl(String.valueOf(flVal));
    }

    public static void trace(double dflVal) {
        Base.traceImpl(String.valueOf(dflVal));
    }

    public static void trace(byte[] ab) {
        if (ab == null) {
            Base.traceImpl(null);
        } else {
            Base.traceImpl("length=" + ab.length + ", binary=" + Base.toHexEscape(ab));
        }
    }

    public static void trace(String sVal) {
        Base.traceImpl(sVal == null ? "null" : Base.toQuotedStringEscape(sVal));
    }

    public static void trace(Object oVal) {
        Base.traceImpl(String.valueOf(oVal));
    }

    private static void traceImpl(String sVal) {
        String sExpr = StackTrace.getExpression("trace");
        Base.out((sExpr == null ? "?" : sExpr) + '=' + (sVal == null ? "null" : sVal));
    }

    public static RuntimeException azzert() {
        return Assertions.azzert();
    }

    public static void azzert(boolean f) {
        Assertions.azzert(f);
    }

    public static void azzert(boolean f, String s) {
        Assertions.azzert(f, s);
    }

    public static void azzertFailed(String sMsg) {
        Assertions.azzertFailed(sMsg);
    }

    public static RuntimeException ensureRuntimeException(Throwable e) {
        return Base.ensureRuntimeException(e, null);
    }

    public static RuntimeException ensureRuntimeException(Throwable e, String s) {
        if (e instanceof RuntimeException && s == null) {
            return (RuntimeException)e;
        }
        return new WrapperException(e, s);
    }

    public static Throwable getOriginalException(RuntimeException e) {
        Throwable t = e;
        while (true) {
            if (t instanceof WrapperException) {
                t = ((WrapperException)t).getOriginalException();
                continue;
            }
            if (t instanceof RemoteException) {
                t = ((RemoteException)t).detail;
                continue;
            }
            if (!t.getClass().getName().equals("javax.ejb.EJBException")) break;
            try {
                t = (Throwable)ClassHelper.invoke(t, "getCausedByException", ClassHelper.VOID);
            }
            catch (Exception x) {
                return t;
            }
        }
        return t;
    }

    public static void out() {
        s_out.println();
    }

    public static void out(Object o) {
        s_out.println(o);
    }

    public static void out(String s) {
        s_out.println(s);
    }

    public static void out(Class<?> clz) {
        s_out.println(Classes.toString(clz));
    }

    public static void out(Throwable e) {
        s_out.println(Base.printStackTrace(e));
    }

    public static void err() {
        s_err.println();
    }

    public static void err(Object o) {
        s_err.println(o);
    }

    public static void err(String s) {
        s_err.println(s);
    }

    public static void err(Class<?> clz) {
        s_err.println(Classes.toString(clz));
    }

    public static void err(Throwable e) {
        s_err.println(Base.printStackTrace(e));
    }

    public static void log() {
        s_log.println();
        if (s_fEchoLog) {
            s_out.println();
        }
    }

    public static void log(Object o) {
        Base.log(String.valueOf(o));
    }

    public static void log(String s) {
        s_log.println(s);
        if (s_fEchoLog) {
            s_out.println(s);
        }
    }

    public static void log(Class<?> clz) {
        Base.log(Classes.toString(clz));
    }

    public static void log(Throwable e) {
        String s = Base.printStackTrace(e);
        s_log.println(s);
        if (s_fEchoLog) {
            s_out.println(s);
        }
    }

    public static ClassLoader ensureClassLoader(ClassLoader loader) {
        return Classes.ensureClassLoader(loader);
    }

    public static ClassLoader getContextClassLoader() {
        return Classes.getContextClassLoader();
    }

    public static ClassLoader getContextClassLoader(Object o) {
        return Classes.getContextClassLoader(o);
    }

    public static StackTrace.StackFrame getCallerStackFrame() {
        return StackTrace.getCallerStackFrame();
    }

    public static StackTrace.StackFrame getStackFrame() {
        return StackTrace.getStackFrame();
    }

    public static StackTrace.StackFrame[] getStackFrames() {
        return StackTrace.getStackFrames();
    }

    public static String getStackTrace() {
        return StackTrace.getStackTrace();
    }

    public static String getStackTrace(Throwable e) {
        return StackTrace.getStackTrace(e);
    }

    public static String getDeepMessage(Throwable t, String sDelim) {
        return StackTrace.getDeepMessage(t, sDelim);
    }

    public static String printStackTrace(Throwable e) {
        return StackTrace.printStackTrace(e);
    }

    public static BigDecimal ensureBigDecimal(Number num) {
        return StackTrace.ensureBigDecimal(num);
    }

    public static Thread makeThread(ThreadGroup group, Runnable runnable, String sName) {
        ThreadFactory factory = s_threadFactory;
        if (factory == null) {
            return sName == null ? new Thread(group, runnable) : new Thread(group, runnable, sName);
        }
        return factory.makeThread(group, runnable, sName);
    }

    public static ThreadFactory getThreadFactory() {
        return s_threadFactory;
    }

    private static ThreadFactory instantiateThreadFactory() {
        String sFactory = AccessController.doPrivileged(() -> Config.getProperty("coherence.threadfactory"));
        if (sFactory == null) {
            return null;
        }
        try {
            return (ThreadFactory)Class.forName(sFactory).newInstance();
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public static void sleep(long cMillis) {
        try {
            while (cMillis > 0L) {
                long lStart = Base.getSafeTimeMillis();
                Blocking.sleep(cMillis);
                cMillis -= Base.getSafeTimeMillis() - lStart;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException(e);
        }
    }

    public static void wait(Object o, long cMillis) {
        try {
            Blocking.wait(o, cMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException(e);
        }
    }

    public static CommonMonitor getCommonMonitor(int i) {
        return CommonMonitor.getCommonMonitor(i);
    }

    public static CommonMonitor getCommonMonitor(long l) {
        return CommonMonitor.getCommonMonitor(l);
    }

    public static CommonMonitor getCommonMonitor(Object o) {
        return CommonMonitor.getCommonMonitor(o);
    }

    public static String toString(Class<?> clz) {
        return Classes.toString(clz);
    }

    public static boolean isDecimal(char ch) {
        return Formatting.isDecimal(ch);
    }

    public static int decimalValue(char ch) {
        return Formatting.decimalValue(ch);
    }

    public static int getMaxDecDigits(int n) {
        return Formatting.getMaxDecDigits(n);
    }

    public static String toDecString(int n, int cDigits) {
        return Formatting.toDecString(n, cDigits);
    }

    public static long pad(long lMin, long lMultiple) {
        return Formatting.pad(lMin, lMultiple);
    }

    public static boolean isOctal(char ch) {
        return Formatting.isOctal(ch);
    }

    public static int octalValue(char ch) {
        return Formatting.octalValue(ch);
    }

    public static boolean isHex(char ch) {
        return Formatting.isHex(ch);
    }

    public static int hexValue(char ch) {
        return Formatting.hexValue(ch);
    }

    public static int getMaxHexDigits(int n) {
        return Formatting.getMaxHexDigits(n);
    }

    public static String toHexString(int n, int cDigits) {
        return Formatting.toHexString(n, cDigits);
    }

    public static String toHex(int b) {
        return Formatting.toHex(b);
    }

    public static String toHex(byte[] ab) {
        return Formatting.toHex(ab);
    }

    public static String toHexEscape(byte b) {
        return Formatting.toHexEscape(b);
    }

    public static String toHexEscape(byte[] ab) {
        return Formatting.toHexEscape(ab);
    }

    public static String toHexEscape(byte[] ab, int of, int cb) {
        return Formatting.toHexEscape(ab, of, cb);
    }

    public static String toHexEscape(ByteSequence seq, int of, int cb) {
        return Formatting.toHexEscape(seq, of, cb);
    }

    public static String toHexDump(byte[] ab, int cBytesPerLine) {
        return Formatting.toHexDump(ab, cBytesPerLine);
    }

    public static byte[] parseHex(String s) {
        return Formatting.parseHex(s);
    }

    public static int parseHex(char ch) {
        return Formatting.parseHex(ch);
    }

    public static String toString(double dfl, int cMinDigits) {
        return Formatting.toString(dfl, cMinDigits);
    }

    public static String toUnicodeEscape(char ch) {
        return Formatting.toUnicodeEscape(ch);
    }

    public static String toCharEscape(char ch) {
        return Formatting.toCharEscape(ch);
    }

    public static String toQuotedCharEscape(char ch) {
        return Formatting.toQuotedCharEscape(ch);
    }

    public static String toStringEscape(String s) {
        return Formatting.toStringEscape(s);
    }

    public static String toQuotedStringEscape(String s) {
        return Formatting.toQuotedStringEscape(s);
    }

    public static int escape(char ch, char[] ach, int of) {
        return Formatting.escape(ch, ach, of);
    }

    public static String toSqlString(String s) {
        return Formatting.toSqlString(s);
    }

    public static String indentString(String sText, String sIndent) {
        return Formatting.indentString(sText, sIndent);
    }

    public static String indentString(String sText, String sIndent, boolean fFirstLine) {
        return Formatting.indentString(sText, sIndent, fFirstLine);
    }

    public static String breakLines(String sText, int nWidth, String sIndent) {
        return Formatting.breakLines(sText, nWidth, sIndent);
    }

    public static String breakLines(String sText, int nWidth, String sIndent, boolean fFirstLine) {
        return Formatting.breakLines(sText, nWidth, sIndent, fFirstLine);
    }

    public static String dup(char ch, int cch) {
        return Formatting.dup(ch, cch);
    }

    public static String dup(String s, int c) {
        return Formatting.dup(s, c);
    }

    public static String replace(String sText, String sFrom, String sTo) {
        return Formatting.replace(sText, sFrom, sTo);
    }

    public static String[] parseDelimitedString(String s, char chDelim) {
        return Formatting.parseDelimitedString(s, chDelim);
    }

    public static String toDelimitedString(int[] an, String sDelim) {
        return Formatting.toDelimitedString(an, sDelim);
    }

    public static String toDelimitedString(long[] al, String sDelim) {
        return Formatting.toDelimitedString(al, sDelim);
    }

    public static String toDelimitedString(Object[] ao, String sDelim) {
        return Formatting.toDelimitedString(ao, sDelim);
    }

    public static String toDelimitedString(Iterator<?> iter, String sDelim) {
        return Formatting.toDelimitedString(iter, sDelim);
    }

    public static String capitalize(String s) {
        return Formatting.capitalize(s);
    }

    public static String truncateString(String s, int cLimit) {
        return Formatting.truncateString(s, cLimit);
    }

    public static String truncateString(Collection<?> coll, int cLimit) {
        return Formatting.truncateString(coll, cLimit);
    }

    public static long parseBandwidth(String s) {
        return Formatting.parseBandwidth(s);
    }

    public static long parseBandwidth(String s, int nDefaultPower) {
        return Formatting.parseBandwidth(s, nDefaultPower);
    }

    public static String toBandwidthString(long cbps) {
        return Formatting.toBandwidthString(cbps);
    }

    public static String toBandwidthString(long cbps, boolean fExact) {
        return Formatting.toBandwidthString(cbps, fExact);
    }

    public static long parseMemorySize(String s) {
        return Formatting.parseMemorySize(s);
    }

    public static long parseMemorySize(String s, int nDefaultPower) {
        return Formatting.parseMemorySize(s, nDefaultPower);
    }

    public static String toMemorySizeString(long cb) {
        return Formatting.toMemorySizeString(cb);
    }

    public static String toMemorySizeString(long cb, boolean fExact) {
        return Formatting.toMemorySizeString(cb, fExact);
    }

    public static long parseTime(String s) {
        return Formatting.parseTime(s);
    }

    public static long parseTime(String s, int nDefaultUnit) {
        return Formatting.parseTime(s, nDefaultUnit);
    }

    public static long parseTimeNanos(String s) {
        return Formatting.parseTimeNanos(s);
    }

    public static long parseTimeNanos(String s, int nDefaultUnit) {
        return Formatting.parseTimeNanos(s, nDefaultUnit);
    }

    public static String formatDateTime(long ldt) {
        return Formatting.formatDateTime(ldt);
    }

    public static float parsePercentage(String s) {
        return Formatting.parsePercentage(s);
    }

    public static int hashCode(Object o) {
        return HashHelper.hashCode(o);
    }

    public static boolean equals(Object o1, Object o2) {
        return Objects.equals(o1, o2);
    }

    public static boolean equalsDeep(Object o1, Object o2) {
        return Objects.equalsDeep(o1, o2);
    }

    public static int toCrc(byte[] ab) {
        return Formatting.toCrc(ab);
    }

    public static int toCrc(byte[] ab, int of, int cb) {
        return Formatting.toCrc(ab, of, cb, -1);
    }

    public static int toCrc(byte[] ab, int of, int cb, int nCrc) {
        return Formatting.toCrc(ab, of, cb, nCrc);
    }

    public static int toCrc(ByteSequence seq) {
        return Formatting.toCrc(seq);
    }

    public static int toCrc(ByteSequence seq, int of, int cb, int nCrc) {
        return Formatting.toCrc(seq, of, cb, nCrc);
    }

    public static long getUpTimeMillis() {
        return TimeHelper.getUpTimeMillis();
    }

    public static long getSafeTimeMillis() {
        return TimeHelper.getSafeTimeMillis();
    }

    public static long getLastSafeTimeMillis() {
        return TimeHelper.getLastSafeTimeMillis();
    }

    public static long computeSafeWaitTime(long ldtTimeout) {
        return TimeHelper.computeSafeWaitTime(ldtTimeout);
    }

    public static TimeZone getTimeZone(String sId) {
        return TimeHelper.getTimeZone(sId);
    }

    @Deprecated
    public static Integer makeInteger(int n) {
        return n;
    }

    @Deprecated
    public static Long makeLong(long n) {
        return n;
    }

    public static int getProcessRandom() {
        return Randoms.getProcessRandom();
    }

    public static Random getRandom() {
        return Randoms.getRandom();
    }

    public static List randomize(Collection coll) {
        return Randoms.randomize(coll);
    }

    public static Object[] randomize(Object[] a) {
        return Randoms.randomize(a);
    }

    public static int[] randomize(int[] a) {
        return Randoms.randomize(a);
    }

    public static long[] randomize(long[] a) {
        return Randoms.randomize(a);
    }

    public static Binary getRandomBinary(int cbMin, int cbMax) {
        return Randoms.getRandomBinary(cbMin, cbMax);
    }

    public static Binary getRandomBinary(int cbMin, int cbMax, byte ... abHead) {
        return Randoms.getRandomBinary(cbMin, cbMax, abHead);
    }

    public static String getRandomString(int cchMin, int cchMax, boolean fAscii) {
        return Randoms.getRandomString(cchMin, cchMax, fAscii);
    }

    public static void checkRange(long lValue, long lFrom, long lTo, String sName) {
        if (lValue < lFrom || lValue > lTo) {
            throw new IllegalArgumentException(sName + " value out of range [" + lFrom + ", " + lTo + "]: " + lValue);
        }
    }

    public static <T> T checkNotNull(T o, String sName) {
        if (o == null) {
            throw new IllegalArgumentException(sName + " cannot be null");
        }
        return o;
    }

    public static void checkNotEmpty(String s, String sName) {
        Base.checkNotNull(s, sName);
        if (s.length() == 0) {
            throw new IllegalArgumentException(sName + " cannot be empty");
        }
    }

    public static int mod(int n, int m) {
        return Hasher.mod(n, m);
    }

    public static long mod(long n, long m) {
        return Hasher.mod(n, m);
    }

    public static PrintWriter getOut() {
        return s_out;
    }

    public static void setOut(PrintWriter writer) {
        s_out = writer == null ? new PrintWriter(NullImplementation.getWriter(), true) : writer;
    }

    public static PrintWriter getErr() {
        return s_err;
    }

    public static void setErr(PrintWriter writer) {
        s_err = writer == null ? new PrintWriter(NullImplementation.getWriter(), true) : writer;
    }

    public static PrintWriter getLog() {
        return s_log;
    }

    public static void setLog(PrintWriter writer) {
        s_log = writer == null ? new PrintWriter(NullImplementation.getWriter(), true) : writer;
    }

    public static boolean isLogEcho() {
        return s_fEchoLog;
    }

    public static void setLogEcho(boolean fEcho) {
        s_fEchoLog = fEcho;
    }

    public static int read(InputStream stream, byte[] ab) throws IOException {
        return Reads.read(stream, ab);
    }

    public static byte[] read(InputStream stream) throws IOException {
        return Reads.read(stream);
    }

    public static byte[] read(DataInput stream) throws IOException {
        return Reads.read(stream);
    }

    public static byte[] read(DataInputStream stream) throws IOException {
        return Reads.read(stream);
    }

    public static String read(Reader reader) throws IOException {
        return Reads.read(reader);
    }

    public static byte[] read(File file) throws IOException {
        return Reads.read(file);
    }

    public static byte[] read(URL url) throws IOException {
        return Reads.read(url);
    }

    static {
        Base.setOut(new LoggingWriter(0));
        Base.setErr(new LoggingWriter(1));
        Base.setLog(new LoggingWriter(3));
        Base.setLogEcho(false);
    }

    public static class LoggingWriter
    extends PrintWriter {
        private final int m_nSev;

        public LoggingWriter(int nSev) {
            super(new CharArrayWriter());
            this.m_nSev = nSev;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println() {
            CharArrayWriter out = (CharArrayWriter)this.out;
            Object object = this.lock;
            synchronized (object) {
                String s = out.toString();
                out.reset();
                Logger.log(s, this.m_nSev);
            }
        }
    }
}

