/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.cache.KeyAssociation;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.json.bind.annotation.JsonbProperty;

public class CompositeKey<P, S>
extends ExternalizableHelper
implements KeyAssociation<P>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="primary")
    private P m_primary;
    @JsonbProperty(value="secondary")
    private S m_secondary;
    private transient int m_nHash;

    public CompositeKey() {
    }

    public CompositeKey(P primary, S secondary) {
        if (primary == null || secondary == null) {
            throw new IllegalArgumentException();
        }
        this.m_primary = primary;
        this.m_secondary = secondary;
    }

    @Override
    public P getAssociatedKey() {
        return this.m_primary;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_primary = CompositeKey.readObject(in);
        this.m_secondary = CompositeKey.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        CompositeKey.writeObject(out, this.m_primary);
        CompositeKey.writeObject(out, this.m_secondary);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_primary = in.readObject(0);
        this.m_secondary = in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_primary);
        out.writeObject(1, this.m_secondary);
    }

    public int hashCode() {
        int nHash = this.m_nHash;
        if (nHash == 0) {
            nHash = this.m_nHash = this.m_primary.hashCode() ^ this.m_secondary.hashCode();
        }
        return nHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CompositeKey) {
            CompositeKey that = (CompositeKey)o;
            return this.m_primary.equals(that.m_primary) && this.m_secondary.equals(that.m_secondary);
        }
        return false;
    }

    public String toString() {
        return this.m_primary + ":" + this.m_secondary;
    }

    public P getPrimaryKey() {
        return this.m_primary;
    }

    public S getSecondaryKey() {
        return this.m_secondary;
    }
}

