/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.pof.reflect.PofNavigator;
import com.tangosol.io.pof.reflect.PofReflectionHelper;
import com.tangosol.io.pof.reflect.SimplePofPath;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.MultiExtractor;
import com.tangosol.util.extractor.PofExtractor;
import com.tangosol.util.extractor.ScriptValueExtractor;
import com.tangosol.util.extractor.UniversalExtractor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Extractors {
    public static <T> ValueExtractor<T, T> identity() {
        return IdentityExtractor.INSTANCE();
    }

    public static <T, E> ValueExtractor<T, E> extract(String from) {
        return new UniversalExtractor(from);
    }

    public static <T, E> ValueExtractor<T, E> extract(String from, Object ... aoParam) {
        if (!from.endsWith("()")) {
            from = from + "()";
        }
        return new UniversalExtractor(from, aoParam);
    }

    public static <T> ValueExtractor<T, List<?>> multi(String ... fields) {
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("The fields parameter cannot be null or empty");
        }
        ValueExtractor[] aExtractor = (ValueExtractor[])Arrays.stream(fields).filter(Objects::nonNull).map(xva$0 -> Extractors.chained(xva$0)).toArray(ValueExtractor[]::new);
        if (aExtractor.length == 0) {
            throw new IllegalArgumentException("The fields parameter must contain at least one non-null element");
        }
        return Extractors.multi(aExtractor);
    }

    public static <T> ValueExtractor<T, List<?>> multi(ValueExtractor<T, ?> ... extractors) {
        return new MultiExtractor(extractors);
    }

    public static <T, R> ValueExtractor<T, R> chained(String ... fields) {
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("The fields parameter cannot be null or empty");
        }
        ValueExtractor[] aExtractor = (ValueExtractor[])Arrays.stream(fields).filter(Objects::nonNull).map(s -> s.split("\\.")).flatMap(Arrays::stream).map(Extractors::extract).toArray(ValueExtractor[]::new);
        if (aExtractor.length == 0) {
            throw new IllegalArgumentException("The fields parameter must contain at least one non-null element");
        }
        if (aExtractor.length == 1) {
            return aExtractor[0];
        }
        return Extractors.chained(aExtractor);
    }

    public static <T, R> ValueExtractor<T, R> chained(ValueExtractor<?, ?> ... extractors) {
        if (extractors == null || extractors.length == 0) {
            throw new IllegalArgumentException("The extractors parameter cannot be null or empty");
        }
        if (extractors.length == 1) {
            return extractors[0];
        }
        return new ChainedExtractor(extractors);
    }

    public static <T, E> ValueExtractor<T, E> identityCast() {
        return IdentityExtractor.INSTANCE;
    }

    public static <T> ValueExtractor<T, ?> fromPof(int ... indexes) {
        return Extractors.fromPof(null, indexes);
    }

    public static <T, E> ValueExtractor<T, E> fromPof(Class<E> cls, int ... indexes) {
        return Extractors.fromPof(cls, new SimplePofPath(Objects.requireNonNull(indexes)));
    }

    public static <T, E> ValueExtractor<T, E> fromPof(Class<E> cls, String sPath) {
        return Extractors.fromPof(cls, PofReflectionHelper.getPofNavigator(cls, sPath));
    }

    public static <T, E> ValueExtractor<T, E> fromPof(Class<E> cls, PofNavigator navigator) {
        return new PofExtractor(cls, navigator);
    }

    public static <T, E> ValueExtractor<T, E> script(String sLanguage, String sScriptPath, Object ... aoArgs) {
        return new ScriptValueExtractor(sLanguage, sScriptPath, aoArgs);
    }
}

