/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.net.cache.CacheEvent;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.Listeners;
import com.tangosol.util.LiteMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapEventTransformer;
import com.tangosol.util.MapListener;
import com.tangosol.util.MultiplexingMapListener;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.filter.InKeySetFilter;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MapListenerSupport
extends Base {
    protected static final int PLAN_NONE = 0;
    protected static final int PLAN_NO_LISTENERS = 1;
    protected static final int PLAN_ALL_LISTENER = 2;
    protected static final int PLAN_KEY_LISTENER = 3;
    protected static final int PLAN_NO_OPTIMIZE = 4;
    protected final Listeners NO_LISTENERS = new Listeners();
    protected Map m_mapListeners;
    protected Map m_mapKeyListeners;
    protected Map m_mapStandardListeners;
    protected Map m_mapStandardKeyListeners;
    protected int m_nOptimizationPlan;
    protected Listeners m_listenersCached;

    public synchronized void addListener(MapListener listener, Filter filter, boolean fLite) {
        if (listener != null) {
            LiteMap mapListeners = this.m_mapListeners;
            if (mapListeners == null) {
                mapListeners = this.m_mapListeners = new LiteMap();
            }
            MapListenerSupport.addSafeListener((Map)mapListeners, filter, listener);
            LiteMap mapStandard = this.m_mapStandardListeners;
            if (mapStandard == null) {
                mapStandard = this.m_mapStandardListeners = new LiteMap();
            }
            MapListenerSupport.addListenerState(mapStandard, filter, listener, fLite);
            this.m_nOptimizationPlan = 0;
            this.m_listenersCached = null;
        }
    }

    public synchronized boolean addListenerWithCheck(MapListener listener, Filter filter, boolean fLite) {
        boolean fCovered = !this.isEmpty(filter) && (fLite || this.containsStandardListeners(filter));
        this.addListener(listener, filter, fLite);
        return !fCovered;
    }

    public synchronized void addListener(MapListener listener, Object oKey, boolean fLite) {
        if (listener != null) {
            EventListener[] alistener;
            HashMap mapListeners = this.m_mapKeyListeners;
            if (mapListeners == null) {
                mapListeners = this.m_mapKeyListeners = new HashMap();
            }
            MapListenerSupport.addSafeListener((Map)mapListeners, oKey, listener);
            LiteMap mapStandard = this.m_mapStandardKeyListeners;
            if (mapStandard == null) {
                mapStandard = this.m_mapStandardKeyListeners = new LiteMap();
            }
            MapListenerSupport.addListenerState(mapStandard, oKey, listener, fLite);
            boolean fKeepPlan = false;
            if (this.m_nOptimizationPlan == 3 && (alistener = this.m_listenersCached.listeners()) != null && alistener.length == 1 && alistener[0] == listener) {
                fKeepPlan = true;
            }
            if (!fKeepPlan) {
                this.m_nOptimizationPlan = 0;
                this.m_listenersCached = null;
            }
        }
    }

    public synchronized boolean addListenerWithCheck(MapListener listener, Object oKey, boolean fLite) {
        boolean fCovered = !this.isEmpty(oKey) && (fLite || this.containsStandardListeners(oKey));
        this.addListener(listener, oKey, fLite);
        return !fCovered;
    }

    public synchronized void addListener(MapListener listener, Set setKey, boolean fLite) {
        for (Object oKey : setKey) {
            this.addListener(listener, oKey, fLite);
        }
    }

    public synchronized void addListenerWithCheck(MapListener listener, Set setKey, boolean fLite) {
        Iterator iter = setKey.iterator();
        while (iter.hasNext()) {
            Object oKey = iter.next();
            if (this.addListenerWithCheck(listener, oKey, fLite)) continue;
            iter.remove();
        }
    }

    public synchronized void removeListener(MapListener listener, Filter filter) {
        if (listener != null) {
            Map mapListeners = this.m_mapListeners;
            if (mapListeners != null) {
                Map mapStandard;
                MapListenerSupport.removeSafeListener(mapListeners, filter, listener);
                if (mapListeners.isEmpty()) {
                    this.m_mapListeners = null;
                }
                if ((mapStandard = this.m_mapStandardListeners) != null) {
                    MapListenerSupport.removeListenerState(mapStandard, filter, listener);
                    if (mapStandard.isEmpty()) {
                        this.m_mapStandardListeners = null;
                    }
                }
            }
            this.m_nOptimizationPlan = 0;
            this.m_listenersCached = null;
        }
    }

    public synchronized boolean removeListenerWithCheck(MapListener listener, Filter filter) {
        this.removeListener(listener, filter);
        return this.isEmpty(filter);
    }

    public synchronized void removeListener(MapListener listener, Object oKey) {
        if (listener != null) {
            EventListener[] alistener;
            Map mapListeners = this.m_mapKeyListeners;
            if (mapListeners != null) {
                Map mapStandard;
                MapListenerSupport.removeSafeListener(mapListeners, oKey, listener);
                if (mapListeners.isEmpty()) {
                    this.m_mapKeyListeners = null;
                }
                if ((mapStandard = this.m_mapStandardKeyListeners) != null) {
                    MapListenerSupport.removeListenerState(mapStandard, oKey, listener);
                    if (mapStandard.isEmpty()) {
                        this.m_mapStandardKeyListeners = null;
                    }
                }
            }
            boolean fKeepPlan = false;
            if (this.m_nOptimizationPlan == 3 && (alistener = this.m_listenersCached.listeners()) != null && alistener.length == 1 && alistener[0] == listener) {
                boolean bl = fKeepPlan = this.m_mapKeyListeners != null;
            }
            if (!fKeepPlan) {
                this.m_nOptimizationPlan = 0;
                this.m_listenersCached = null;
            }
        }
    }

    public synchronized boolean removeListenerWithCheck(MapListener listener, Object oKey) {
        this.removeListener(listener, oKey);
        return this.isEmpty(oKey);
    }

    public synchronized void removeListener(MapListener listener, Set setKey) {
        for (Object oKey : setKey) {
            this.removeListener(listener, oKey);
        }
    }

    public synchronized void removeListenerWithCheck(MapListener listener, Set setKey) {
        Iterator iter = setKey.iterator();
        while (iter.hasNext()) {
            if (this.removeListenerWithCheck(listener, iter.next())) continue;
            iter.remove();
        }
    }

    public synchronized void clear() {
        this.m_mapListeners = null;
        this.m_mapKeyListeners = null;
        this.m_mapStandardListeners = null;
        this.m_mapStandardKeyListeners = null;
        this.m_nOptimizationPlan = 1;
        this.m_listenersCached = null;
    }

    public boolean isEmpty() {
        return this.m_mapListeners == null && this.m_mapKeyListeners == null;
    }

    public int getListenerCount() {
        Map map;
        int cListener = 0;
        if (this.m_mapListeners != null) {
            map = this.m_mapListeners;
            cListener += map.values().stream().mapToInt(Listeners::getListenerCount).sum();
        }
        if (this.m_mapKeyListeners != null) {
            map = this.m_mapKeyListeners;
            cListener += map.values().stream().mapToInt(Listeners::getListenerCount).sum();
        }
        return cListener;
    }

    public boolean isEmpty(Filter filter) {
        Map mapListeners = this.m_mapListeners;
        return mapListeners == null || !mapListeners.containsKey(filter);
    }

    public boolean isEmpty(Object oKey) {
        Map mapListeners = this.m_mapKeyListeners;
        return mapListeners == null || !mapListeners.containsKey(oKey);
    }

    public boolean containsStandardListeners(Filter filter) {
        Map mapStandard = this.m_mapStandardListeners;
        if (mapStandard == null) {
            return false;
        }
        Set setStandard = (Set)mapStandard.get(filter);
        return setStandard != null && !setStandard.isEmpty();
    }

    public boolean containsStandardListeners(Object oKey) {
        Map mapStandard = this.m_mapStandardKeyListeners;
        if (mapStandard == null) {
            return false;
        }
        Set setStandard = (Set)mapStandard.get(oKey);
        return setStandard != null && !setStandard.isEmpty();
    }

    public Set getFilterSet() {
        Map mapListeners = this.m_mapListeners;
        return mapListeners == null ? NullImplementation.getSet() : mapListeners.keySet();
    }

    public Set getKeySet() {
        Map mapListeners = this.m_mapKeyListeners;
        return mapListeners == null ? NullImplementation.getSet() : mapListeners.keySet();
    }

    public synchronized Listeners getListeners(Filter filter) {
        Map mapListeners = this.m_mapListeners;
        return mapListeners == null ? null : (Listeners)mapListeners.get(filter);
    }

    public synchronized Listeners getListeners(Object oKey) {
        Map mapListeners = this.m_mapKeyListeners;
        return mapListeners == null ? null : (Listeners)mapListeners.get(oKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Listeners collectListeners(MapEvent event) {
        var2_2 = this;
        synchronized (var2_2) {
            switch (this.m_nOptimizationPlan) {
                default: {
                    mapAllListeners = this.m_mapListeners;
                    mapKeyListeners = this.m_mapKeyListeners;
                    if (mapAllListeners != null && !mapAllListeners.isEmpty()) ** GOTO lbl33
                    if (mapKeyListeners != null && !mapKeyListeners.isEmpty()) ** GOTO lbl13
                    this.m_nOptimizationPlan = 1;
                    this.m_listenersCached = null;
                    ** GOTO lbl38
lbl13:
                    // 1 sources

                    alistenerPrev = null;
                    for (Listeners listeners : mapKeyListeners.values()) {
                        if (alistenerPrev == null) {
                            this.m_nOptimizationPlan = 3;
                            this.m_listenersCached = listeners;
                            alistenerPrev = listeners.listeners();
                            continue;
                        }
                        alistenerCur = listeners.listeners();
                        cListenersCur = alistenerCur.length;
                        v0 = fOptimize = cListenersCur == (cListenersPrev = alistenerPrev.length);
                        if (fOptimize) {
                            for (i = 0; i < cListenersCur; ++i) {
                                if (alistenerCur[i] == alistenerPrev[i]) continue;
                                fOptimize = false;
                                break;
                            }
                        }
                        if (fOptimize) continue;
                        this.m_nOptimizationPlan = 4;
                        this.m_listenersCached = null;
                        ** GOTO lbl38
                    }
                    ** GOTO lbl38
lbl33:
                    // 1 sources

                    this.m_nOptimizationPlan = 4;
                    this.m_listenersCached = null;
                    if ((mapKeyListeners == null || mapKeyListeners.isEmpty()) && mapAllListeners.size() == 1 && (listeners = (Listeners)mapAllListeners.get(null)) != null) {
                        this.m_nOptimizationPlan = 2;
                        this.m_listenersCached = listeners;
                    }
lbl38:
                    // 6 sources

                    MapListenerSupport.azzert(this.m_nOptimizationPlan != 0);
                    return this.collectListeners(event);
                }
                case 1: {
                    return this.NO_LISTENERS;
                }
                case 2: {
                    return this.m_listenersCached;
                }
                case 3: {
                    return this.m_mapKeyListeners.containsKey(event.getKey()) != false ? this.m_listenersCached : this.NO_LISTENERS;
                }
                case 4: 
            }
        }
        listeners = new Listeners();
        mapListeners = this.m_mapListeners;
        if (mapListeners != null) {
            evt = MapListenerSupport.unwrapEvent(event);
            if (evt instanceof FilterEvent) {
                evtFilter = (FilterEvent)evt;
                aFilter = evtFilter.getFilter();
                listeners.setFilters(aFilter);
            }
            if ((aFilters = listeners.getFilters()) == null) {
                listeners = this;
                synchronized (listeners) {
                    aEntry = mapListeners.entrySet().toArray();
                }
                listFilters = null;
                for (Object o : aEntry) {
                    entry = (Map.Entry)o;
                    filter = (Filter)entry.getKey();
                    if (filter != null && !this.evaluateEvent(filter, event)) continue;
                    listeners.addAll((Listeners)entry.getValue());
                    if (filter == null) continue;
                    if (listFilters == null) {
                        listFilters = new ArrayList<Filter>();
                    }
                    listFilters.add(filter);
                }
                if (listFilters != null) {
                    listeners.setFilters(listFilters.toArray(new Filter[listFilters.size()]));
                }
            } else {
                var6_11 = this;
                synchronized (var6_11) {
                    for (Filter filter : aFilters) {
                        listeners.addAll((Listeners)mapListeners.get(filter));
                    }
                }
            }
        }
        if ((mapKeyListeners = this.m_mapKeyListeners) != null && !this.isTransformedEvent(event) && (lsnrs = (Listeners)mapKeyListeners.get(event.getKey())) != null) {
            listeners.addAll(lsnrs);
        }
        return listeners;
    }

    public void fireEvent(MapEvent event, boolean fStrict) {
        Listeners listeners = this.collectListeners(event);
        MapListenerSupport.enrichEvent(event, listeners).dispatch(listeners, fStrict);
    }

    public static MapEvent convertEvent(MapEvent event, ObservableMap mapConv, Converter convKey, Converter convVal) {
        if (convKey == null) {
            convKey = NullImplementation.getConverter();
        }
        if (convVal == null) {
            convVal = NullImplementation.getConverter();
        }
        return ConverterCollections.getMapEvent(mapConv, event, convKey, convVal);
    }

    public static MapEvent enrichEvent(MapEvent event, Listeners listeners) {
        Filter[] aFilters;
        if (!(event instanceof FilterEvent) && (aFilters = listeners.getFilters()) != null) {
            event = new FilterEvent(event, aFilters);
        }
        return event;
    }

    public static MapEvent unwrapEvent(MapEvent evt) {
        while (evt instanceof ConverterCollections.ConverterMapEvent) {
            evt = ((ConverterCollections.ConverterMapEvent)evt).getMapEvent();
        }
        return evt;
    }

    public static boolean isPrimingListener(MapListener listener) {
        while (true) {
            if (listener instanceof PrimingListener) {
                return true;
            }
            if (!(listener instanceof WrapperListener)) break;
            listener = ((WrapperListener)listener).getMapListener();
        }
        return false;
    }

    protected boolean evaluateEvent(Filter filter, MapEvent event) {
        if (event instanceof CacheEvent && ((CacheEvent)event).getTransformationState() == CacheEvent.TransformationState.NON_TRANSFORMABLE && filter instanceof MapEventTransformer) {
            return false;
        }
        if (filter instanceof InKeySetFilter) {
            return ((InKeySetFilter)filter).getKeys().contains(event.getKey());
        }
        return filter.evaluate(event);
    }

    protected boolean isTransformedEvent(MapEvent event) {
        return event instanceof CacheEvent && ((CacheEvent)event).getTransformationState() == CacheEvent.TransformationState.TRANSFORMED;
    }

    protected static void addSafeListener(Map mapListeners, Object anyKey, MapListener listener) {
        Listeners listeners = (Listeners)mapListeners.get(anyKey);
        if (listeners == null) {
            listeners = new Listeners();
            mapListeners.put(anyKey, listeners);
        }
        listeners.add(listener);
    }

    protected static void addSafeListener(Map mapListeners, Filter anyFilter, MapListener listener) {
        Listeners listeners = (Listeners)mapListeners.get(anyFilter);
        if (listeners == null) {
            listeners = new Listeners();
            if (anyFilter != null) {
                listeners.setFilters(new Filter[]{anyFilter});
            }
            mapListeners.put(anyFilter, listeners);
        }
        listeners.add(listener);
    }

    protected static void removeSafeListener(Map mapListeners, Object anyKey, MapListener listener) {
        Listeners listeners = (Listeners)mapListeners.get(anyKey);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                mapListeners.remove(anyKey);
            }
        }
    }

    protected static void addListenerState(Map mapStandardListeners, Object anyKey, MapListener listener, boolean fLite) {
        LiteSet<MapListener> setStandard = (LiteSet<MapListener>)mapStandardListeners.get(anyKey);
        if (fLite) {
            if (setStandard != null) {
                setStandard.remove(listener);
            }
        } else {
            if (setStandard == null) {
                setStandard = new LiteSet<MapListener>();
                mapStandardListeners.put(anyKey, setStandard);
            }
            setStandard.add(listener);
        }
    }

    protected static void removeListenerState(Map mapStandardListeners, Object anyKey, MapListener listener) {
        Set setStandard = (Set)mapStandardListeners.get(anyKey);
        if (setStandard != null) {
            setStandard.remove(listener);
            if (setStandard.isEmpty()) {
                mapStandardListeners.remove(anyKey);
            }
        }
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Global listeners:");
        if (this.m_mapListeners == null) {
            sb.append(" none");
        } else {
            for (Filter filter : this.m_mapListeners.keySet()) {
                sb.append("\n  Filter=").append(filter).append("; lite=").append(!this.containsStandardListeners(filter));
            }
        }
        sb.append("\nKey listeners:");
        if (this.m_mapKeyListeners == null) {
            sb.append(" none");
        } else {
            for (Object oKey : this.m_mapKeyListeners.keySet()) {
                sb.append("\n  Key=").append(oKey).append("; lite=").append(!this.containsStandardListeners(oKey));
            }
        }
        return sb.toString();
    }

    public static class WrapperPrimingListener
    extends WrapperSynchronousListener
    implements PrimingListener {
        public WrapperPrimingListener(MapListener listener) {
            super(listener);
        }

        @Override
        protected void onMapEvent(MapEvent evt) {
            int nId = evt.getId();
            switch (nId) {
                case 1: {
                    this.getMapListener().entryInserted(evt);
                    break;
                }
                case 2: {
                    this.getMapListener().entryUpdated(evt);
                    break;
                }
                case 3: {
                    this.getMapListener().entryDeleted(evt);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown map event id: " + nId);
                }
            }
        }
    }

    public static class WrapperSynchronousListener<K, V>
    extends WrapperListener<K, V>
    implements SynchronousListener<K, V> {
        public WrapperSynchronousListener(MapListener<K, V> listener) {
            super(listener);
        }
    }

    public static abstract class WrapperListener<K, V>
    extends MultiplexingMapListener<K, V> {
        private final MapListener<K, V> f_listener;

        public WrapperListener(MapListener<K, V> listener) {
            WrapperListener.azzert(listener != null);
            this.f_listener = listener;
        }

        @Override
        protected void onMapEvent(MapEvent<K, V> evt) {
            evt.dispatch(this.f_listener);
        }

        public MapListener<K, V> getMapListener() {
            return this.f_listener;
        }

        public int hashCode() {
            return this.f_listener.hashCode();
        }

        public boolean equals(Object o) {
            if (o != null && o.getClass() == this.getClass()) {
                WrapperListener that = (WrapperListener)o;
                return this.f_listener.equals(that.f_listener);
            }
            return false;
        }

        public String toString() {
            return ClassHelper.getSimpleName(this.getClass()) + "{listener=" + this.f_listener + "}";
        }
    }

    public static interface PrimingListener<K, V>
    extends SynchronousListener<K, V> {
    }

    public static interface SynchronousListener<K, V>
    extends com.tangosol.util.SynchronousListener<K, V>,
    MapListener<K, V> {
    }

    public static class FilterEvent
    extends CacheEvent {
        protected final Filter[] f_aFilter;
        protected final MapEvent f_event;

        public FilterEvent(ObservableMap map, int nId, Object oKey, boolean fSynthetic, Filter[] aFilter) {
            this(map, nId, oKey, null, null, fSynthetic, false, aFilter);
        }

        public FilterEvent(ObservableMap map, int nId, Object oKey, boolean fSynthetic, boolean fPriming, Filter[] aFilter) {
            this(map, nId, oKey, null, null, fSynthetic, fPriming, aFilter);
        }

        public FilterEvent(ObservableMap map, int nId, Object oKey, Object oValueOld, Object oValueNew, boolean fSynthetic, boolean fPriming, Filter[] aFilter) {
            this(map, nId, oKey, oValueOld, oValueNew, fSynthetic, CacheEvent.TransformationState.TRANSFORMABLE, fPriming, aFilter);
        }

        public FilterEvent(ObservableMap map, int nId, Object oKey, Object oValueOld, Object oValueNew, boolean fSynthetic, CacheEvent.TransformationState transformState, Filter[] aFilter) {
            super(map, nId, oKey, oValueOld, oValueNew, fSynthetic, transformState, false);
            Base.azzert(aFilter != null);
            this.f_aFilter = aFilter;
            this.f_event = null;
        }

        public FilterEvent(ObservableMap map, int nId, Object oKey, Object oValueOld, Object oValueNew, boolean fSynthetic, CacheEvent.TransformationState transformState, boolean fPriming, Filter[] aFilter) {
            super(map, nId, oKey, oValueOld, oValueNew, fSynthetic, transformState, fPriming);
            Base.azzert(aFilter != null);
            this.f_aFilter = aFilter;
            this.f_event = null;
        }

        public FilterEvent(MapEvent event, Filter[] aFilter) {
            super(event.getMap(), event.getId(), null, null, null, event instanceof CacheEvent && ((CacheEvent)event).isSynthetic(), event instanceof CacheEvent ? ((CacheEvent)event).getTransformationState() : CacheEvent.TransformationState.TRANSFORMABLE, event instanceof CacheEvent && ((CacheEvent)event).isPriming());
            Base.azzert(aFilter != null);
            this.f_aFilter = aFilter;
            this.f_event = event;
        }

        public Filter[] getFilter() {
            return this.f_aFilter;
        }

        public MapEvent getMapEvent() {
            return this.f_event;
        }

        @Override
        protected String getDescription() {
            return super.getDescription() + ", filters=" + new ImmutableArrayList(this.f_aFilter);
        }

        @Override
        public Object getKey() {
            return this.f_event == null ? super.getKey() : this.f_event.getKey();
        }

        @Override
        public Object getOldValue() {
            return this.f_event == null ? super.getOldValue() : this.f_event.getOldValue();
        }

        @Override
        public Object getNewValue() {
            return this.f_event == null ? super.getNewValue() : this.f_event.getNewValue();
        }
    }
}

